<?php 
 $GLOBALS["dictionary"]["OPS_dossier"]=array (
  'table' => 'ops_dossier',
  'delete' => false,
  'audited' => false,
  'inline_edit' => false,
  'duplicate_merge' => false,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
      'inline_edit' => false,
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_NAME',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'required' => true,
      'importable' => 'required',
      'duplicate_merge' => 'enabled',
      'merge_filter' => 'selected',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'ops_dossier_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'ops_dossier_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'massupdate' => '0',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'ops_dossier_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'SecurityGroups' => 
    array (
      'name' => 'SecurityGroups',
      'type' => 'link',
      'relationship' => 'securitygroups_ops_dossier',
      'module' => 'SecurityGroups',
      'bean_name' => 'SecurityGroup',
      'source' => 'non-db',
      'vname' => 'LBL_SECURITYGROUPS',
    ),
    'cloture' => 
    array (
      'required' => false,
      'name' => 'cloture',
      'vname' => 'LBL_CLOTURE',
      'type' => 'bool',
      'massupdate' => '1',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'canal' => 
    array (
      'required' => false,
      'name' => 'canal',
      'vname' => 'LBL_CANAL',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => 'crm',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_canal_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'soutien_elus' => 
    array (
      'required' => false,
      'name' => 'soutien_elus',
      'vname' => 'LBL_SOUTIEN_ELUS',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'elus' => 
    array (
      'required' => false,
      'name' => 'elus',
      'vname' => 'LBL_ELUS',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => false,
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
    ),
    'reunions' => 
    array (
      'required' => false,
      'name' => 'reunions',
      'vname' => 'LBL_REUNIONS',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => false,
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
    ),
    'sous_territoires' => 
    array (
      'required' => false,
      'name' => 'sous_territoires',
      'vname' => 'LBL_SOUS_TERRITOIRES',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => false,
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
    ),
    'decision_commission' => 
    array (
      'required' => false,
      'name' => 'decision_commission',
      'vname' => 'LBL_DECISION_COMMISSION',
      'type' => 'enum',
      'massupdate' => '1',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_decision_commission_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'commissions' => 
    array (
      'required' => false,
      'name' => 'commissions',
      'vname' => 'LBL_COMMISSIONS',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => false,
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
    ),
    'commentaire_decision' => 
    array (
      'required' => false,
      'name' => 'commentaire_decision',
      'vname' => 'LBL_COMMENTAIRE_DECISION',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
    ),
    'motif_decision' => 
    array (
      'required' => false,
      'name' => 'motif_decision',
      'vname' => 'LBL_MOTIF_DECISION',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
    ),
    'ops_etape_id' => 
    array (
      'name' => 'ops_etape_id',
      'vname' => 'LBL_ETAPE_OPS_ETAPE_ID',
      'type' => 'id',
      'required' => false,
      'reportable' => true,
      'audited' => true,
      'comment' => '',
    ),
    'etape' => 
    array (
      'required' => false,
      'name' => 'ops_etape',
      'rname' => 'name',
      'id_name' => 'ops_etape_id',
      'vname' => 'LBL_ETAPE',
      'type' => 'relate',
      'isnull' => 'true',
      'module' => 'OPS_etape',
      'table' => 'ops_etape',
      'massupdate' => false,
      'source' => 'non-db',
      'len' => 36,
      'link' => 'ops_etape_link',
      'unified_search' => true,
      'importable' => 'true',
      'studio' => 'visible',
    ),
    'ops_etape_link' => 
    array (
      'name' => 'ops_etape_link',
      'type' => 'link',
      'relationship' => 'etape_relationship',
      'module' => 'OPS_etape',
      'bean_name' => 'ops_etape',
      'link_type' => 'one',
      'source' => 'non-db',
      'vname' => 'LBL_etape',
      'side' => 'right',
    ),
    'ops_statut_id' => 
    array (
      'name' => 'ops_statut_id',
      'vname' => 'LBL_STATUT_OPS_STATUT_ID',
      'type' => 'id',
      'required' => false,
      'reportable' => true,
      'audited' => true,
      'comment' => '',
    ),
    'statut' => 
    array (
      'required' => false,
      'name' => 'ops_statut',
      'rname' => 'name',
      'id_name' => 'ops_statut_id',
      'vname' => 'LBL_STATUT',
      'type' => 'relate',
      'isnull' => 'true',
      'module' => 'OPS_statut',
      'table' => 'ops_statut',
      'massupdate' => false,
      'source' => 'non-db',
      'len' => 36,
      'link' => 'ops_statut_link',
      'unified_search' => true,
      'importable' => 'true',
      'studio' => 'visible',
    ),
    'ops_statut_link' => 
    array (
      'name' => 'ops_statut_link',
      'type' => 'link',
      'relationship' => 'statut_relationship',
      'module' => 'OPS_statut',
      'bean_name' => 'ops_statut',
      'link_type' => 'one',
      'source' => 'non-db',
      'vname' => 'LBL_STATUT',
      'side' => 'right',
    ),
    'date_avancement' => 
    array (
      'required' => false,
      'name' => 'date_avancement',
      'vname' => 'LBL_DATE_AVANCEMENT',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'demandeur' => 
    array (
      'required' => false,
      'name' => 'demandeur',
      'vname' => 'LBL_DEMANDEUR',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'type_tiers' => 
    array (
      'required' => false,
      'name' => 'type_tiers',
      'vname' => 'LBL_TYPE_TIERS',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'num_dossier' => 
    array (
      'required' => false,
      'name' => 'num_dossier',
      'vname' => 'LBL_NUM_DOSSIER',
      'type' => 'int',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '1',
      'auto_increment' => true,
      'min' => 0,
      'max' => false,
      'validation' => 
      array (
        'type' => 'range',
        'min' => 0,
        'max' => false,
      ),
    ),
    'date_are' => 
    array (
      'required' => false,
      'name' => 'date_are',
      'vname' => 'LBL_DATE_ARE',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'date_demande' => 
    array (
      'required' => false,
      'name' => 'date_demande',
      'vname' => 'LBL_DATE_DEMANDE',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'date_notification' => 
    array (
      'required' => false,
      'name' => 'date_notification',
      'vname' => 'LBL_DATE_NOTIFICATION',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'libelle_dossier' => 
    array (
      'required' => false,
      'name' => 'libelle_dossier',
      'vname' => 'LBL_LIBELLE_DOSSIER',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'libelle_compl' => 
    array (
      'required' => false,
      'name' => 'libelle_compl',
      'vname' => 'LBL_LIBELLE_COMPL',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'thematique' => 
    array (
      'required' => false,
      'name' => 'thematique',
      'vname' => 'LBL_THEMATIQUE',
      'type' => 'enum',
      'massupdate' => '1',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_thematique_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'champs_custom' => 
    array (
      'required' => false,
      'name' => 'champs_custom',
      'vname' => 'LBL_CHAMPS_CUSTOM',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'dbtype' => 'longblob',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '200',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
    ),
    'latitude' => 
    array (
      'required' => false,
      'name' => 'latitude',
      'vname' => 'LBL_LATITUDE',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '200',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
    ),
    'longitude' => 
    array (
      'required' => false,
      'name' => 'longitude',
      'vname' => 'LBL_LONGITUDE',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '200',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
    ),
    'statut_geoloc' => 
    array (
      'required' => false,
      'name' => 'statut_geoloc',
      'vname' => 'LBL_STATUT_GEOLOC',
      'type' => 'enum',
      'massupdate' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'false',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_statut_geoloc_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'citycode' => 
    array (
      'required' => false,
      'name' => 'citycode',
      'vname' => 'LBL_CITYCODE',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '200',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
    ),
    'brouillon' => 
    array (
      'required' => false,
      'name' => 'brouillon',
      'vname' => 'LBL_BROUILLON',
      'type' => 'enum',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_brouillon_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'ordre_onglet' => 
    array (
      'required' => false,
      'name' => 'ordre_onglet',
      'vname' => 'LBL_ORDRE_ONGLET',
      'type' => 'int',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
    ),
    'doublon' => 
    array (
      'required' => false,
      'name' => 'doublon',
      'vname' => 'LBL_DOUBLON',
      'type' => 'enum',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_doublon_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'email' => 
    array (
      'required' => false,
      'name' => 'email',
      'vname' => 'LBL_LIBELLE_EMAIL',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'email_cc' => 
    array (
      'required' => false,
      'name' => 'email_cc',
      'vname' => 'LBL_EMAIL_CC',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'email_cci' => 
    array (
      'required' => false,
      'name' => 'email_cci',
      'vname' => 'LBL_EMAIL_CCI',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'ops_personne_morale' => 
    array (
      'required' => false,
      'name' => 'ops_personne_morale',
      'vname' => 'LBL_OPS_PERSONNE_MORALE',
      'type' => 'id',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => true,
      'inline_edit' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 36,
      'size' => '20',
    ),
    'personne_morale' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'personne_morale',
      'vname' => 'LBL_OPS_PERSONNE_MORALE',
      'type' => 'relate',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'ops_personne_morale',
      'ext2' => 'OPS_personne_morale',
      'module' => 'OPS_personne_morale',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'beneficiaire_id' => 
    array (
      'required' => false,
      'name' => 'beneficiaire_id',
      'vname' => 'LBL_BENEFICIAIRE_ID',
      'type' => 'id',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => true,
      'inline_edit' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 36,
      'size' => '20',
    ),
    'beneficiaire' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'beneficiaire',
      'vname' => 'LBL_BENEFICIAIRE',
      'type' => 'relate',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'beneficiaire_id',
      'ext2' => 'OPS_individu',
      'module' => 'OPS_individu',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'incomplet' => 
    array (
      'required' => false,
      'name' => 'incomplet',
      'vname' => 'LBL_INCOMPLET',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'justificatif_incomplet' => 
    array (
      'required' => false,
      'name' => 'justificatif_incomplet',
      'vname' => 'LBL_JUSTIFICATIF_INCOMPLET',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'date_transmission' => 
    array (
      'required' => false,
      'name' => 'date_transmission',
      'vname' => 'LBL_DATE_TRASMISSION',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'lien_demande_cde' => 
    array (
      'required' => false,
      'name' => 'lien_demande_cde',
      'vname' => 'LBL_LIEN_DEMANDE_CDE',
      'type' => 'url',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'false',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'dbType' => 'varchar',
      'gen' => '',
      'link_target' => '_blank',
    ),
    'commentaire' => 
    array (
      'required' => false,
      'name' => 'commentaire',
      'vname' => 'LBL_COMMENTAIRE',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
    ),
    'date_import' => 
    array (
      'required' => false,
      'name' => 'date_import',
      'vname' => 'LBL_DATE_IMPORT',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'motif_rejet' => 
    array (
      'required' => false,
      'name' => 'motif_rejet',
      'vname' => 'LBL_MOTIF_REJET',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
    ),
    'duplication_id' => 
    array (
      'required' => false,
      'name' => 'duplication_id',
      'vname' => 'LBL_DUPLICATION_ID',
      'type' => 'id',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => true,
      'inline_edit' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 36,
      'size' => '20',
    ),
    'duplication' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'duplication',
      'vname' => 'LBL_DUPLICATION',
      'type' => 'relate',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'duplication_id',
      'ext2' => 'OPS_dossier',
      'module' => 'OPS_dossier',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'flag_suppression' => 
    array (
      'required' => false,
      'name' => 'flag_suppression',
      'vname' => 'LBL_FLAG_SUPPRESSION',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'flag_justificatif_etude' => 
    array (
      'required' => false,
      'name' => 'flag_justificatif_etude',
      'vname' => 'LBL_FLAG_JUSTIFICATIF_ETUDE',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'flag_justificatif_reetude' => 
    array (
      'required' => false,
      'name' => 'flag_justificatif_reetude',
      'vname' => 'LBL_FLAG_JUSTIFICATIF_REETUDE',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'code_suivi' => 
    array (
      'required' => false,
      'name' => 'code_suivi',
      'vname' => 'LBL_CODE_SUIVI',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'code_validation' => 
    array (
      'required' => false,
      'name' => 'code_validation',
      'vname' => 'LBL_CODE_VALIDATION',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'date_expiration_code_validation' => 
    array (
      'required' => false,
      'name' => 'date_expiration_code_validation',
      'vname' => 'LBL_DATE_EXPIRATION_CODE_VALIDATION',
      'type' => 'datetime',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'ops_individu_template_id' => 
    array (
      'required' => false,
      'name' => 'ops_individu_template_id',
      'vname' => 'LBL_INDIVIDU_TEMLPLATE_ID',
      'type' => 'id',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => true,
      'inline_edit' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 36,
      'size' => '20',
    ),
    'dossier_personne_individu_fonction' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'dossier_personne_individu_fonction',
      'vname' => 'LBL_DOSSIER_PERSONNE_INDIVIDU_FONCTION',
      'type' => 'relate',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'ops_individu_template_id',
      'ext2' => 'OPS_individu',
      'module' => 'OPS_individu',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'flag_partenaire' => 
    array (
      'required' => false,
      'name' => 'flag_partenaire',
      'vname' => 'LBL_FLAG_PARTENAIRE',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'dossier_prioritaire' => 
    array (
      'required' => false,
      'name' => 'dossier_prioritaire',
      'vname' => 'LBL_DOSSIER_PRIORITAIRE',
      'type' => 'bool',
      'massupdate' => '1',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'dossier_urgent' => 
    array (
      'required' => false,
      'name' => 'dossier_urgent',
      'vname' => 'LBL_DOSSIER_URGENT',
      'type' => 'bool',
      'massupdate' => '1',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'dossier_signale' => 
    array (
      'required' => false,
      'name' => 'dossier_signale',
      'vname' => 'LBL_DOSSIER_SIGNALE',
      'type' => 'bool',
      'massupdate' => '1',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'flag_anonymise' => 
    array (
      'required' => false,
      'name' => 'flag_anonymise',
      'vname' => 'LBL_FLAG_ANONYMISE',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'conversation_statut' => 
    array (
      'required' => false,
      'name' => 'conversation_statut',
      'vname' => 'LBL_CONVERSATION_STATUT',
      'type' => 'enum',
      'options' => 'conversation_statut_list',
      'massupdate' => 1,
      'default' => 'fermee',
      'no_default' => false,
      'value' => 'fermee',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'conversation_origin' => 
    array (
      'required' => false,
      'name' => 'conversation_origin',
      'vname' => 'LBL_CONVERSATION_ORIGIN',
      'type' => 'enum',
      'options' => 'conversation_origin_list',
      'massupdate' => 0,
      'no_default' => false,
      'value' => '',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 10,
      'size' => '20',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'delai' => 
    array (
      'required' => false,
      'name' => 'delai',
      'vname' => 'LBL_DELAI',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_delai_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'flag_correction_delai' => 
    array (
      'required' => false,
      'name' => 'flag_correction_delai',
      'vname' => 'LBL_FLAG_CORRECTION_DELAI',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'isnull' => 'true',
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'ops_referentiel_id_1' => 
    array (
      'required' => false,
      'name' => 'ops_referentiel_id_1',
      'vname' => 'LBL_OPS_REFERENTIEL_ID_1',
      'type' => 'id',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'inline_edit' => true,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 36,
      'size' => '20',
    ),
    'ops_referentiel_1' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'ops_referentiel_1',
      'vname' => 'LBL_OPS_REFERENTIEL_1',
      'type' => 'relate',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'ops_referentiel_id_1',
      'ext2' => 'OPS_liste_valeur',
      'module' => 'OPS_liste_valeur',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'ops_referentiel_id_2' => 
    array (
      'required' => false,
      'name' => 'ops_referentiel_id_2',
      'vname' => 'LBL_OPS_REFERENTIEL_ID_2',
      'type' => 'id',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'inline_edit' => true,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 36,
      'size' => '20',
    ),
    'ops_referentiel_2' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'ops_referentiel_2',
      'vname' => 'LBL_OPS_REFERENTIEL_2',
      'type' => 'relate',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'ops_referentiel_id_2',
      'ext2' => 'OPS_liste_valeur',
      'module' => 'OPS_liste_valeur',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'ops_referentiel_id_3' => 
    array (
      'required' => false,
      'name' => 'ops_referentiel_id_3',
      'vname' => 'LBL_OPS_REFERENTIEL_ID_3',
      'type' => 'id',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'inline_edit' => true,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 36,
      'size' => '20',
    ),
    'ops_referentiel_3' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'ops_referentiel_3',
      'vname' => 'LBL_OPS_REFERENTIEL_3',
      'type' => 'relate',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'ops_referentiel_id_3',
      'ext2' => 'OPS_liste_valeur',
      'module' => 'OPS_liste_valeur',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      0 => 'studio',
    ),
    'ops_elu_ops_dossier' => 
    array (
      'name' => 'ops_elu_ops_dossier',
      'type' => 'link',
      'relationship' => 'ops_elu_ops_dossier',
      'source' => 'non-db',
      'module' => 'OPS_elu',
      'bean_name' => 'OPS_elu',
      'vname' => 'LBL_OPS_ELU_OPS_DOSSIER_FROM_OPS_ELU_TITLE',
      'id_name' => 'ops_elu_id',
    ),
    'ops_elu_ops_dossier_name' => 
    array (
      'name' => 'ops_elu_ops_dossier_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_OPS_ELU_OPS_DOSSIER_FROM_OPS_ELU_TITLE',
      'save' => true,
      'id_name' => 'ops_elu_id',
      'link' => 'ops_elu_ops_dossier',
      'table' => 'ops_elu',
      'module' => 'OPS_elu',
      'rname' => 'name',
      'inline_edit' => false,
    ),
    'ops_elu_id' => 
    array (
      'name' => 'ops_elu_id',
      'type' => 'link',
      'relationship' => 'ops_elu_ops_dossier',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_OPS_ELU_OPS_DOSSIER_FROM_OPS_ELU_TITLE',
    ),
    'ops_reunion_ops_dossier' => 
    array (
      'name' => 'ops_reunion_ops_dossier',
      'type' => 'link',
      'relationship' => 'ops_reunion_ops_dossier',
      'source' => 'non-db',
      'module' => 'OPS_reunion',
      'bean_name' => 'OPS_reunion',
      'vname' => 'LBL_OPS_REUNION_OPS_DOSSIER_FROM_OPS_REUNION_TITLE',
      'id_name' => 'ops_reunion_ops_dossierops_reunion_ida',
    ),
    'ops_reunion_ops_dossier_name' => 
    array (
      'name' => 'ops_reunion_ops_dossier_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_OPS_REUNION_OPS_DOSSIER_FROM_OPS_REUNION_TITLE',
      'save' => true,
      'id_name' => 'ops_reunion_id',
      'link' => 'ops_reunion_ops_dossier',
      'table' => 'ops_reunion',
      'module' => 'OPS_reunion',
      'rname' => 'name',
    ),
    'ops_reunion_id' => 
    array (
      'name' => 'ops_reunion_id',
      'type' => 'link',
      'relationship' => 'ops_reunion_ops_dossier',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_OPS_REUNION_OPS_DOSSIER_FROM_OPS_DOSSIER_TITLE',
    ),
    'ops_commission_ops_dossier' => 
    array (
      'name' => 'ops_commission_ops_dossier',
      'type' => 'link',
      'relationship' => 'ops_commission_ops_dossier',
      'source' => 'non-db',
      'module' => 'OPS_commission',
      'bean_name' => 'OPS_commission',
      'vname' => 'LBL_OPS_COMMISSION_OPS_DOSSIER_FROM_OPS_COMMISSION_TITLE',
      'id_name' => 'ops_commission_ops_dossierops_commission_ida',
    ),
    'ops_commission_ops_dossier_name' => 
    array (
      'name' => 'ops_commission_ops_dossier_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_OPS_COMMISSION_OPS_DOSSIER_FROM_OPS_COMMISSION_TITLE',
      'save' => true,
      'id_name' => 'ops_commission_id',
      'link' => 'ops_commission_ops_dossier',
      'table' => 'ops_commission',
      'module' => 'OPS_commission',
      'rname' => 'name',
    ),
    'ops_commission_id' => 
    array (
      'name' => 'ops_commission_id',
      'type' => 'link',
      'relationship' => 'ops_commission_ops_dossier',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_OPS_COMMISSION_OPS_DOSSIER_FROM_OPS_DOSSIER_TITLE',
    ),
    'ops_dossier_documents' => 
    array (
      'name' => 'ops_dossier_documents',
      'type' => 'link',
      'relationship' => 'ops_dossier_documents',
      'source' => 'non-db',
      'module' => 'Documents',
      'bean_name' => 'Document',
      'side' => 'right',
      'vname' => 'LBL_OPS_DOSSIER_DOCUMENTS_FROM_DOCUMENTS_TITLE',
    ),
    'ops_dossier_ops_justificatif' => 
    array (
      'name' => 'ops_dossier_ops_justificatif',
      'type' => 'link',
      'relationship' => 'ops_dossier_ops_justificatif',
      'source' => 'non-db',
      'module' => 'OPS_justificatif',
      'bean_name' => 'OPS_justificatif',
      'side' => 'right',
      'vname' => 'LBL_OPS_DOSSIER_OPS_JUSTIFICATIFS_FROM_OPS_JUSTIFICATIFS_TITLE',
    ),
    'ops_dossier_activities_calls' => 
    array (
      'name' => 'ops_dossier_activities_calls',
      'type' => 'link',
      'relationship' => 'ops_dossier_activities_calls',
      'source' => 'non-db',
      'module' => 'Calls',
      'bean_name' => 'Call',
      'vname' => 'LBL_OPS_DOSSIER_ACTIVITIES_CALLS_FROM_CALLS_TITLE',
    ),
    'ops_dossier_activities_meetings' => 
    array (
      'name' => 'ops_dossier_activities_meetings',
      'type' => 'link',
      'relationship' => 'ops_dossier_activities_meetings',
      'source' => 'non-db',
      'module' => 'Meetings',
      'bean_name' => 'Meeting',
      'vname' => 'LBL_OPS_DOSSIER_ACTIVITIES_MEETINGS_FROM_MEETINGS_TITLE',
    ),
    'ops_dossier_activities_notes' => 
    array (
      'name' => 'ops_dossier_activities_notes',
      'type' => 'link',
      'relationship' => 'ops_dossier_activities_notes',
      'source' => 'non-db',
      'module' => 'Notes',
      'bean_name' => 'Note',
      'vname' => 'LBL_OPS_DOSSIER_ACTIVITIES_NOTES_FROM_NOTES_TITLE',
    ),
    'ops_dossier_activities_tasks' => 
    array (
      'name' => 'ops_dossier_activities_tasks',
      'type' => 'link',
      'relationship' => 'ops_dossier_activities_tasks',
      'source' => 'non-db',
      'module' => 'Tasks',
      'bean_name' => 'Task',
      'vname' => 'LBL_OPS_DOSSIER_ACTIVITIES_TASKS_FROM_TASKS_TITLE',
    ),
    'ops_dossier_activities_emails' => 
    array (
      'name' => 'ops_dossier_activities_emails',
      'type' => 'link',
      'relationship' => 'ops_dossier_activities_emails',
      'source' => 'non-db',
      'module' => 'Emails',
      'bean_name' => 'Email',
      'vname' => 'LBL_OPS_DOSSIER_ACTIVITIES_EMAILS_FROM_EMAILS_TITLE',
    ),
    'ops_dossier_notes' => 
    array (
      'name' => 'ops_dossier_notes',
      'type' => 'link',
      'relationship' => 'ops_dossier_notes',
      'source' => 'non-db',
      'module' => 'Notes',
      'bean_name' => 'Note',
      'side' => 'right',
      'vname' => 'LBL_OPS_DOSSIER_NOTES_FROM_NOTES_TITLE',
    ),
    'ops_dispositif_ops_dossier' => 
    array (
      'name' => 'ops_dispositif_ops_dossier',
      'type' => 'link',
      'relationship' => 'ops_dispositif_ops_dossier',
      'source' => 'non-db',
      'module' => 'OPS_dispositif',
      'bean_name' => 'OPS_dispositif',
      'vname' => 'LBL_OPS_DISPOSITIF_OPS_DOSSIER_FROM_OPS_DISPOSITIF_TITLE',
      'id_name' => 'ops_dispositif_id',
    ),
    'ops_dispositif_ops_dossier_name' => 
    array (
      'name' => 'ops_dispositif_ops_dossier_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_OPS_DISPOSITIF_OPS_DOSSIER_FROM_OPS_DISPOSITIF_TITLE',
      'save' => true,
      'id_name' => 'ops_dispositif_id',
      'link' => 'ops_dispositif_ops_dossier',
      'table' => 'ops_dispositif',
      'module' => 'OPS_dispositif',
      'rname' => 'name',
      'inline_edit' => false,
    ),
    'ops_dispositif_id' => 
    array (
      'name' => 'ops_dispositif_id',
      'type' => 'link',
      'relationship' => 'ops_dispositif_ops_dossier',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_OPS_DISPOSITIF_OPS_DOSSIER_FROM_OPS_DOSSIER_TITLE',
    ),
    'ops_individu_ops_dossier' => 
    array (
      'name' => 'ops_individu_ops_dossier',
      'type' => 'link',
      'relationship' => 'ops_individu_ops_dossier',
      'source' => 'non-db',
      'module' => 'OPS_individu',
      'bean_name' => 'OPS_individu',
      'vname' => 'LBL_OPS_INDIVIDU_OPS_DOSSIER_FROM_OPS_INDIVIDU_TITLE',
      'id_name' => 'ops_individu_id',
    ),
    'ops_individu_ops_dossier_name' => 
    array (
      'name' => 'ops_individu_ops_dossier_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_OPS_INDIVIDU_OPS_DOSSIER_FROM_OPS_INDIVIDU_TITLE',
      'save' => true,
      'id_name' => 'ops_individu_id',
      'link' => 'ops_individu_ops_dossier',
      'table' => 'ops_individu',
      'module' => 'OPS_individu',
      'rname' => 'name',
      'db_concat_fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
    ),
    'ops_individu_id' => 
    array (
      'name' => 'ops_individu_id',
      'type' => 'link',
      'relationship' => 'ops_individu_ops_dossier',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_OPS_INDIVIDU_OPS_DOSSIER_FROM_OPS_DOSSIER_TITLE',
    ),
    'ops_dossier_ops_appairage' => 
    array (
      'name' => 'ops_dossier_ops_appairage',
      'type' => 'link',
      'relationship' => 'ops_dossier_ops_appairage',
      'source' => 'non-db',
      'module' => 'OPS_appairage',
      'bean_name' => false,
      'vname' => 'LBL_OPS_DOSSIER_OPS_APPAIRAGE_FROM_OPS_APPAIRAGE_TITLE',
    ),
    'ops_historisation_ops_dossier' => 
    array (
      'name' => 'ops_historisation_ops_dossier',
      'type' => 'link',
      'relationship' => 'ops_historisation_ops_dossier',
      'source' => 'non-db',
      'module' => 'OPS_historisation',
      'bean_name' => false,
      'side' => 'right',
      'vname' => 'LBL_OPS_HISTORISATION_OPS_DOSSIER_FROM_OPS_HISTORISATION_TITLE',
    ),
    'ops_dossier_ops_journal' => 
    array (
      'name' => 'ops_dossier_ops_journal',
      'type' => 'link',
      'relationship' => 'ops_dossier_ops_journal',
      'source' => 'non-db',
      'module' => 'OPS_journal',
      'bean_name' => false,
      'vname' => 'LBL_OPS_DOSSIER_OPS_JOURNAL_FROM_OPS_JOURNAL_TITLE',
    ),
    'ops_sous_territoire_ops_dossier' => 
    array (
      'name' => 'ops_sous_territoire_ops_dossier',
      'type' => 'link',
      'relationship' => 'ops_sous_territoire_ops_dossier',
      'source' => 'non-db',
      'module' => 'OPS_sous_territoire',
      'bean_name' => 'OPS_sous_territoire',
      'vname' => 'LBL_OPS_SOUS_TERRITOIRE_OPS_DOSSIER_FROM_OPS_SOUS_TERRITOIRE_TITLE',
      'id_name' => 'ops_sous_territoire_id',
    ),
    'ops_sous_territoire_ops_dossier_name' => 
    array (
      'name' => 'ops_sous_territoire_ops_dossier_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_OPS_SOUS_TERRITOIRE_OPS_DOSSIER_FROM_OPS_SOUS_TERRITOIRE_TITLE',
      'save' => true,
      'id_name' => 'ops_sous_territoire_id',
      'link' => 'ops_sous_territoire_ops_dossier',
      'table' => 'ops_sous_territoire',
      'module' => 'OPS_sous_territoire',
      'rname' => 'name',
    ),
    'ops_sous_territoire_id' => 
    array (
      'name' => 'ops_sous_territoire_id',
      'type' => 'link',
      'relationship' => 'ops_sous_territoire_ops_dossier',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_OPS_SOUS_TERRITOIRE_OPS_DOSSIER_FROM_OPS_DOSSIER_TITLE',
    ),
    'ops_dossier_ops_suivi_dossier' => 
    array (
      'name' => 'ops_dossier_ops_suivi_dossier',
      'type' => 'link',
      'relationship' => 'ops_dossier_ops_suivi_dossier',
      'source' => 'non-db',
      'module' => 'OPS_suivi_dossier',
      'bean_name' => 'OPS_suivi_dossier',
      'side' => 'right',
      'vname' => 'LBL_OPS_DOSSIER_OPS_SUIVI_DOSSIER_FROM_OPS_SUIVI_DOSSIER_TITLE',
    ),
    'ops_dossier_ops_dossier' => 
    array (
      'name' => 'ops_dossier_ops_dossier',
      'type' => 'link',
      'relationship' => 'ops_dossier_ops_dossier',
      'source' => 'non-db',
      'module' => 'OPS_dossier',
      'bean_name' => false,
      'side' => 'right',
      'vname' => 'LBL_OPS_DOSSIER_TITLE',
    ),
    'ops_dossier_ops_dossier_name' => 
    array (
      'name' => 'ops_dossier_ops_dossier_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_OPS_DOSSIER_TITLE',
      'save' => true,
      'id_name' => 'ops_dossier_id2',
      'link' => 'ops_dossier_ops_dossier',
      'table' => 'ops_dossier',
      'module' => 'OPS_dossier',
      'rname' => 'name',
    ),
    'ops_dossier_id2' => 
    array (
      'name' => 'ops_dossier_id2',
      'type' => 'link',
      'relationship' => 'ops_dossier_ops_dossier',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_OPS_DOSSIER_TITLE',
    ),
    'ops_classement_ops_dossier' => 
    array (
      'name' => 'ops_classement_ops_dossier',
      'type' => 'link',
      'relationship' => 'ops_classement_ops_dossier',
      'source' => 'non-db',
      'module' => 'OPS_classement',
      'bean_name' => false,
      'side' => 'right',
      'vname' => 'LBL_OPS_CLASSEMENT_OPS_DOSSIER_FROM_OPS_CLASSEMENT_TITLE',
    ),
    'test_date_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'test_date_c',
      'vname' => 'LBL_TEST_DATE',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'OPS_dossiertest_date_c',
      'custom_module' => 'OPS_dossier',
    ),
    'test_chaine_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'test_chaine_c',
      'vname' => 'LBL_TEST_CHAINE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'OPS_dossiertest_chaine_c',
      'custom_module' => 'OPS_dossier',
    ),
  ),
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'ops_dossierpk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
    0 => 
    array (
      'name' => 'idx_ops_dossier_id_del',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'id',
        1 => 'deleted',
      ),
    ),
    1 => 
    array (
      'name' => 'idx_ops_dossier_name_del',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'name',
        1 => 'deleted',
      ),
    ),
    2 => 
    array (
      'name' => 'idx_ops_dossier_num_dossier',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'num_dossier',
      ),
    ),
  ),
  'relationships' => 
  array (
    'ops_dossier_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_dossier',
      'rhs_table' => 'ops_dossier',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'ops_dossier_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_dossier',
      'rhs_table' => 'ops_dossier',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'ops_dossier_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_dossier',
      'rhs_table' => 'ops_dossier',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'securitygroups_ops_dossier' => 
    array (
      'lhs_module' => 'SecurityGroups',
      'lhs_table' => 'securitygroups',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_dossier',
      'rhs_table' => 'ops_dossier',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'securitygroups_records',
      'join_key_lhs' => 'securitygroup_id',
      'join_key_rhs' => 'record_id',
      'relationship_role_column' => 'module',
      'relationship_role_column_value' => 'OPS_dossier',
    ),
    'statut_relationship' => 
    array (
      'lhs_module' => 'OPS_statut',
      'lhs_table' => 'ops_statut',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_dossier',
      'rhs_table' => 'ops_dossier',
      'rhs_key' => 'ops_statut_id',
      'relationship_type' => 'one-to-many',
    ),
    'etape_relationship' => 
    array (
      'lhs_module' => 'OPS_etape',
      'lhs_table' => 'ops_etape',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_dossier',
      'rhs_table' => 'ops_dossier',
      'rhs_key' => 'ops_etape_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'optimistic_locking' => true,
  'unified_search' => true,
  'templates' => 
  array (
    'security_groups' => 'security_groups',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);