<?php 
 $GLOBALS["dictionary"]["OPS_personne_morale"]=array (
  'table' => 'ops_personne_morale',
  'audited' => true,
  'inline_edit' => true,
  'duplicate_merge' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
      'inline_edit' => false,
    ),
    'name' => 
    array (
      'name' => 'name',
      'type' => 'name',
      'dbType' => 'varchar',
      'vname' => 'LBL_NAME',
      'len' => '255',
      'comment' => 'Name of the Company',
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'audited' => true,
      'required' => true,
      'importable' => 'required',
      'merge_filter' => 'disabled',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => 'Name of the Company',
      'help' => '',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'inline_edit' => true,
      'reportable' => true,
      'size' => '20',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'massupdate' => false,
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => false,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'enabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'SecurityGroups' => 
    array (
      'name' => 'SecurityGroups',
      'type' => 'link',
      'relationship' => 'securitygroups_ops_personne_morale',
      'module' => 'SecurityGroups',
      'bean_name' => 'SecurityGroup',
      'source' => 'non-db',
      'vname' => 'LBL_SECURITYGROUPS',
    ),
    'ops_personne_morale_type' => 
    array (
      'name' => 'ops_personne_morale_type',
      'vname' => 'LBL_TYPE',
      'type' => 'enum',
      'options' => 'ops_personne_morale_type_dom',
      'len' => 50,
      'comment' => 'The Company is of this type',
      'massupdate' => false,
    ),
    'industry' => 
    array (
      'name' => 'industry',
      'vname' => 'LBL_INDUSTRY',
      'type' => 'enum',
      'options' => 'industry_dom',
      'len' => 50,
      'comment' => 'The company belongs in this industry',
      'merge_filter' => 'enabled',
      'massupdate' => false,
    ),
    'annual_revenue' => 
    array (
      'name' => 'annual_revenue',
      'vname' => 'LBL_ANNUAL_REVENUE',
      'type' => 'varchar',
      'len' => 100,
      'comment' => 'Annual revenue for this company',
      'merge_filter' => 'enabled',
    ),
    'phone_fax' => 
    array (
      'name' => 'phone_fax',
      'vname' => 'LBL_FAX',
      'type' => 'phone',
      'dbType' => 'varchar',
      'len' => 100,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'comment' => 'The fax phone number of this company',
    ),
    'billing_address_street' => 
    array (
      'name' => 'billing_address_street',
      'vname' => 'LBL_BILLING_ADDRESS_STREET',
      'type' => 'varchar',
      'len' => '200',
      'group' => 'billing_address',
      'merge_filter' => 'enabled',
      'audited' => true,
    ),
    'billing_address_street_2' => 
    array (
      'name' => 'billing_address_street_2',
      'vname' => 'LBL_BILLING_ADDRESS_STREET_2',
      'type' => 'varchar',
      'len' => '150',
      'source' => 'non-db',
    ),
    'billing_address_street_3' => 
    array (
      'name' => 'billing_address_street_3',
      'vname' => 'LBL_BILLING_ADDRESS_STREET_3',
      'type' => 'varchar',
      'len' => '150',
      'source' => 'non-db',
    ),
    'billing_address_street_4' => 
    array (
      'name' => 'billing_address_street_4',
      'vname' => 'LBL_BILLING_ADDRESS_STREET_4',
      'type' => 'varchar',
      'len' => '150',
      'source' => 'non-db',
    ),
    'billing_address_city' => 
    array (
      'name' => 'billing_address_city',
      'vname' => 'LBL_BILLING_ADDRESS_CITY',
      'type' => 'varchar',
      'len' => '255',
      'group' => 'billing_address',
      'merge_filter' => 'enabled',
      'audited' => true,
      'massupdate' => true,
    ),
    'billing_address_state' => 
    array (
      'name' => 'billing_address_state',
      'vname' => 'LBL_BILLING_ADDRESS_STATE',
      'type' => 'varchar',
      'len' => '100',
      'group' => 'billing_address',
      'merge_filter' => 'enabled',
    ),
    'billing_address_postalcode' => 
    array (
      'name' => 'billing_address_postalcode',
      'vname' => 'LBL_BILLING_ADDRESS_POSTALCODE',
      'type' => 'varchar',
      'len' => '10',
      'group' => 'billing_address',
      'merge_filter' => 'enabled',
      'audited' => true,
      'massupdate' => true,
    ),
    'billing_address_country' => 
    array (
      'name' => 'billing_address_country',
      'vname' => 'LBL_BILLING_ADDRESS_COUNTRY',
      'type' => 'varchar',
      'group' => 'billing_address',
      'merge_filter' => 'enabled',
      'audited' => false,
      'len' => '100',
    ),
    'rating' => 
    array (
      'name' => 'rating',
      'vname' => 'LBL_RATING',
      'type' => 'varchar',
      'len' => 100,
      'comment' => 'An arbitrary rating for this company for use in comparisons with others',
    ),
    'phone_office' => 
    array (
      'name' => 'phone_office',
      'vname' => 'LBL_PHONE_OFFICE',
      'type' => 'phone',
      'dbType' => 'varchar',
      'len' => 100,
      'audited' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'comment' => 'The office phone number',
      'merge_filter' => 'enabled',
    ),
    'phone_alternate' => 
    array (
      'name' => 'phone_alternate',
      'vname' => 'LBL_PHONE_ALT',
      'type' => 'phone',
      'group' => 'phone_office',
      'dbType' => 'varchar',
      'len' => 100,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'comment' => 'An alternate phone number',
      'merge_filter' => 'enabled',
    ),
    'website' => 
    array (
      'name' => 'website',
      'vname' => 'LBL_WEBSITE',
      'type' => 'url',
      'dbType' => 'varchar',
      'len' => 255,
      'comment' => 'URL of website for the company',
      'audited' => true,
    ),
    'ownership' => 
    array (
      'name' => 'ownership',
      'vname' => 'LBL_OWNERSHIP',
      'type' => 'varchar',
      'len' => 100,
      'comment' => '',
    ),
    'employees' => 
    array (
      'name' => 'employees',
      'vname' => 'LBL_EMPLOYEES',
      'type' => 'varchar',
      'len' => 10,
      'comment' => 'Number of employees, varchar to accomodate for both number (100) or range (50-100)',
    ),
    'ticker_symbol' => 
    array (
      'name' => 'ticker_symbol',
      'vname' => 'LBL_TICKER_SYMBOL',
      'type' => 'varchar',
      'len' => 10,
      'comment' => 'The stock trading (ticker) symbol for the company',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_street' => 
    array (
      'name' => 'shipping_address_street',
      'vname' => 'LBL_SHIPPING_ADDRESS_STREET',
      'type' => 'varchar',
      'len' => 150,
      'group' => 'shipping_address',
      'comment' => 'The street address used for for shipping purposes',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_street_2' => 
    array (
      'name' => 'shipping_address_street_2',
      'vname' => 'LBL_SHIPPING_ADDRESS_STREET_2',
      'type' => 'varchar',
      'len' => 150,
      'source' => 'non-db',
    ),
    'shipping_address_street_3' => 
    array (
      'name' => 'shipping_address_street_3',
      'vname' => 'LBL_SHIPPING_ADDRESS_STREET_3',
      'type' => 'varchar',
      'len' => 150,
      'source' => 'non-db',
    ),
    'shipping_address_street_4' => 
    array (
      'name' => 'shipping_address_street_4',
      'vname' => 'LBL_SHIPPING_ADDRESS_STREET_4',
      'type' => 'varchar',
      'len' => 150,
      'source' => 'non-db',
    ),
    'shipping_address_city' => 
    array (
      'name' => 'shipping_address_city',
      'vname' => 'LBL_SHIPPING_ADDRESS_CITY',
      'type' => 'varchar',
      'len' => 100,
      'group' => 'shipping_address',
      'comment' => 'The city used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_state' => 
    array (
      'name' => 'shipping_address_state',
      'vname' => 'LBL_SHIPPING_ADDRESS_STATE',
      'type' => 'varchar',
      'len' => 100,
      'group' => 'shipping_address',
      'comment' => 'The state used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_postalcode' => 
    array (
      'name' => 'shipping_address_postalcode',
      'vname' => 'LBL_SHIPPING_ADDRESS_POSTALCODE',
      'type' => 'varchar',
      'len' => 20,
      'group' => 'shipping_address',
      'comment' => 'The zip code used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'shipping_address_country' => 
    array (
      'name' => 'shipping_address_country',
      'vname' => 'LBL_SHIPPING_ADDRESS_COUNTRY',
      'type' => 'varchar',
      'group' => 'shipping_address',
      'comment' => 'The country used for the shipping address',
      'merge_filter' => 'enabled',
    ),
    'email1' => 
    array (
      'name' => 'email1',
      'vname' => 'LBL_EMAIL_ADDRESS',
      'type' => 'varchar',
      'unified_search' => true,
      'function' => 
      array (
        'name' => 'getEmailAddressWidget',
        'returns' => 'html',
      ),
      'merge_filter' => 'enabled',
      'duplicate_merge' => 'enabled',
      'source' => 'non-db',
      'group' => 'email1',
      'full_text_search' => 
      array (
        'boost' => 3,
        'analyzer' => 'whitespace',
      ),
      'audited' => true,
    ),
    'email_addresses_primary' => 
    array (
      'name' => 'email_addresses_primary',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_email_addresses_primary',
      'source' => 'non-db',
      'vname' => 'LBL_EMAIL_ADDRESS_PRIMARY',
      'duplicate_merge' => 'disabled',
    ),
    'email_addresses' => 
    array (
      'name' => 'email_addresses',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_email_addresses',
      'module' => 'EmailAddress',
      'source' => 'non-db',
      'vname' => 'LBL_EMAIL_ADDRESSES',
      'reportable' => false,
      'unified_search' => true,
      'rel_fields' => 
      array (
        'primary_address' => 
        array (
          'type' => 'bool',
        ),
      ),
    ),
    'email_addresses_non_primary' => 
    array (
      'name' => 'email_addresses_non_primary',
      'type' => 'email',
      'source' => 'non-db',
      'vname' => 'LBL_EMAIL_NON_PRIMARY',
      'studio' => false,
      'reportable' => false,
      'massupdate' => false,
    ),
    'sigle' => 
    array (
      'required' => false,
      'name' => 'sigle',
      'vname' => 'LBL_SIGLE',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'logo' => 
    array (
      'required' => false,
      'name' => 'logo',
      'vname' => 'LBL_LOGO',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'tiers_appaire' => 
    array (
      'required' => false,
      'name' => 'tiers_appaire',
      'vname' => 'LBL_TIERS_APPAIRE',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => 'N',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_pm_tiers_appaire_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'financeur' => 
    array (
      'required' => false,
      'name' => 'financeur',
      'vname' => 'LBL_FINANCEUR',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'bon_msa' => 
    array (
      'required' => false,
      'name' => 'bon_msa',
      'vname' => 'LBL_BON_MSA',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'num_tahiti' => 
    array (
      'required' => false,
      'name' => 'num_tahiti',
      'vname' => 'LBL_NUM_TAHITI',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'len' => '17',
      'size' => '20',
    ),
    'siret' => 
    array (
      'required' => false,
      'name' => 'siret',
      'vname' => 'LBL_SIRET',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'len' => '17',
      'size' => '20',
    ),
    'reference' => 
    array (
      'required' => false,
      'name' => 'reference',
      'vname' => 'LBL_REFERENCE',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'numero_rna' => 
    array (
      'required' => false,
      'name' => 'numero_rna',
      'vname' => 'LBL_NUMERO_RNA',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'numero_rne' => 
    array (
      'required' => false,
      'name' => 'numero_rne',
      'vname' => 'LBL_NUMERO_RNE',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'date_declaration' => 
    array (
      'required' => false,
      'name' => 'date_declaration',
      'vname' => 'LBL_DATE_DECLARATION',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'ops_formule_id' => 
    array (
      'required' => false,
      'name' => 'ops_formule_id',
      'vname' => 'LBL_FORMULE_APPEL_OPS_FORMULE_ID',
      'type' => 'id',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'inline_edit' => true,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 36,
      'size' => '20',
    ),
    'formule_appel_courrier' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'formule_appel_courrier',
      'vname' => 'LBL_FORMULE_APPEL_COURRIER',
      'type' => 'relate',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'ops_formule_id',
      'ext2' => 'OPS_formule',
      'module' => 'OPS_formule',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'ops_formule1_id' => 
    array (
      'required' => false,
      'name' => 'ops_formule1_id',
      'vname' => 'LBL_FORMULE_POLITESSE_OPS_FORMULE_ID',
      'type' => 'id',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'inline_edit' => true,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 36,
      'size' => '20',
    ),
    'formule_politesse_courrier' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'formule_politesse_courrier',
      'vname' => 'LBL_FORMULE_POLITESSE_COURRIER',
      'type' => 'relate',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'ops_formule1_id',
      'ext2' => 'OPS_formule',
      'module' => 'OPS_formule',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'ops_formule2_id' => 
    array (
      'required' => false,
      'name' => 'ops_formule2_id',
      'vname' => 'LBL_FORMULE_APPEL_OPS_FORMULE_ID',
      'type' => 'id',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'inline_edit' => true,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 36,
      'size' => '20',
    ),
    'formule_appel_email' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'formule_appel_email',
      'vname' => 'LBL_FORMULE_APPEL_EMAIL',
      'type' => 'relate',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'ops_formule2_id',
      'ext2' => 'OPS_formule',
      'module' => 'OPS_formule',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'ops_formule3_id' => 
    array (
      'required' => false,
      'name' => 'ops_formule3_id',
      'vname' => 'LBL_FORMULE_POLITESSE_OPS_FORMULE_ID',
      'type' => 'id',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'inline_edit' => true,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 36,
      'size' => '20',
    ),
    'formule_politesse_email' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'formule_politesse_email',
      'vname' => 'LBL_FORMULE_POLITESSE_EMAIL',
      'type' => 'relate',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'ops_formule3_id',
      'ext2' => 'OPS_formule',
      'module' => 'OPS_formule',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'num_tiers' => 
    array (
      'required' => false,
      'name' => 'num_tiers',
      'vname' => 'LBL_NUM_TIERS',
      'type' => 'int',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '5',
      'size' => '20',
      'enable_range_search' => false,
      'disable_num_format' => '',
      'min' => false,
      'max' => false,
    ),
    'statut' => 
    array (
      'required' => false,
      'name' => 'statut',
      'vname' => 'LBL_STATUT',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => 'n_bloque',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_statut_pm_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'ops_individu_id' => 
    array (
      'required' => false,
      'name' => 'ops_individu_id',
      'vname' => 'LBL_PERSONNE_INDIVIDU_OPS_INDIVIDU_ID',
      'type' => 'id',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'inline_edit' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 36,
      'size' => '20',
    ),
    'personne_individu' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'personne_individu',
      'vname' => 'LBL_PERSONNE_INDIVIDU',
      'type' => 'relate',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'ops_individu_id',
      'ext2' => 'OPS_individu',
      'module' => 'OPS_individu',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'ops_individu1_id' => 
    array (
      'required' => false,
      'name' => 'ops_individu1_id',
      'vname' => 'LBL_INTERVENANT_MANDATAIRE_MOR_OPS_INDIVIDU_ID',
      'type' => 'id',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'inline_edit' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 36,
      'size' => '20',
    ),
    'intervenant_mandataire_mor' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'intervenant_mandataire_mor',
      'vname' => 'LBL_INTERVENANT_MANDATAIRE_MOR',
      'type' => 'relate',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'ops_individu1_id',
      'ext2' => 'OPS_personne_morale',
      'module' => 'OPS_personne_morale',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'email' => 
    array (
      'name' => 'email',
      'type' => 'email',
      'query_type' => 'default',
      'source' => 'non-db',
      'operator' => 'subquery',
      'subquery' => 'SELECT eabr.bean_id FROM email_addr_bean_rel eabr JOIN email_addresses ea ON (ea.id = eabr.email_address_id) WHERE eabr.deleted=0 AND ea.email_address LIKE',
      'db_field' => 
      array (
        0 => 'id',
      ),
      'vname' => 'LBL_ANY_EMAIL',
      'studio' => 
      array (
        'visible' => false,
        'searchview' => true,
      ),
      'importable' => false,
    ),
    'shipping_address_number' => 
    array (
      'name' => 'shipping_address_number',
      'vname' => 'LBL_SHIPPING_ADDRESS_NUMBER',
      'type' => 'varchar',
      'len' => '200',
      'merge_filter' => 'enabled',
      'audited' => false,
    ),
    'shipping_address_complement' => 
    array (
      'name' => 'shipping_address_complement',
      'vname' => 'LBL_SHIPPING_ADDRESS_COMPLEMENT',
      'type' => 'varchar',
      'len' => '200',
      'merge_filter' => 'enabled',
      'audited' => false,
    ),
    'shipping_address_complement_lieu' => 
    array (
      'name' => 'shipping_address_complement_lieu',
      'vname' => 'LBL_SHIPPING_ADDRESS_COMPLEMENT_LIEU',
      'type' => 'varchar',
      'len' => '200',
      'merge_filter' => 'enabled',
      'audited' => false,
    ),
    'shipping_address_coordonnees_x' => 
    array (
      'name' => 'shipping_address_coordonnees_x',
      'vname' => 'LBL_SHIPPING_ADDRESS_COORDONNEES_X',
      'type' => 'varchar',
      'len' => '200',
      'merge_filter' => 'enabled',
      'audited' => false,
    ),
    'shipping_address_coordonnees_y' => 
    array (
      'name' => 'shipping_address_coordonnees_y',
      'vname' => 'LBL_SHIPPING_ADDRESS_COORDONNEES_Y',
      'type' => 'varchar',
      'len' => '200',
      'merge_filter' => 'enabled',
      'audited' => false,
    ),
    'billing_address_number' => 
    array (
      'name' => 'billing_address_number',
      'vname' => 'LBL_BILLING_ADDRESS_NUMBER',
      'type' => 'varchar',
      'len' => '200',
      'group' => 'billing_address',
      'merge_filter' => 'enabled',
      'audited' => true,
    ),
    'billing_address_street_1' => 
    array (
      'name' => 'billing_address_street_1',
      'vname' => 'LBL_BILLING_ADDRESS_STREET_1',
      'type' => 'varchar',
      'len' => '38',
      'source' => 'non-db',
    ),
    'billing_address_complement' => 
    array (
      'name' => 'billing_address_complement',
      'vname' => 'LBL_BILLING_ADDRESS_COMPLEMENT',
      'type' => 'varchar',
      'len' => '38',
      'merge_filter' => 'enabled',
      'audited' => false,
    ),
    'billing_address_complement_lieu' => 
    array (
      'name' => 'billing_address_complement_lieu',
      'vname' => 'LBL_BILLING_ADDRESS_COMPLEMENT_LIEU',
      'type' => 'varchar',
      'len' => '38',
      'merge_filter' => 'enabled',
      'audited' => false,
    ),
    'billing_id_adresse' => 
    array (
      'name' => 'billing_id_adresse',
      'vname' => 'LBL_ID_ADRESSE',
      'type' => 'varchar',
      'group' => 'billing_address',
      'merge_filter' => 'enabled',
      'audited' => false,
      'len' => '100',
    ),
    'billing_code_insee' => 
    array (
      'name' => 'billing_code_insee',
      'vname' => 'LBL_CODE_INSEE',
      'type' => 'varchar',
      'group' => 'billing_address',
      'merge_filter' => 'enabled',
      'audited' => false,
      'len' => '100',
    ),
    'billing_coordonnees_y' => 
    array (
      'required' => false,
      'name' => 'billing_coordonnees_y',
      'vname' => 'LBL_COORDONNEES_Y',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'billing_coordonnees_x' => 
    array (
      'required' => false,
      'name' => 'billing_coordonnees_x',
      'vname' => 'LBL_COORDONNEES_X',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'code_ape' => 
    array (
      'required' => false,
      'name' => 'code_ape',
      'vname' => 'LBL_CODE_APE',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => true,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'forme_juridique' => 
    array (
      'required' => false,
      'name' => 'forme_juridique',
      'vname' => 'LBL_FORME_JURIDIQUE',
      'type' => 'enum',
      'massupdate' => true,
      'default' => '',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_forme_juridique_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'effectif' => 
    array (
      'required' => false,
      'name' => 'effectif',
      'vname' => 'LBL_EFFECTIF',
      'type' => 'enum',
      'massupdate' => true,
      'default' => '',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_type_profil_effectif_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'secteur_activite' => 
    array (
      'required' => false,
      'name' => 'secteur_activite',
      'vname' => 'LBL_SECTEUR_ACTIVITE',
      'type' => 'enum',
      'massupdate' => true,
      'default' => '',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_profil_secteur_activite_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'objet_social' => 
    array (
      'required' => false,
      'name' => 'objet_social',
      'vname' => 'LBL_OBJET_SOCIAL',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'canal' => 
    array (
      'required' => false,
      'name' => 'canal',
      'vname' => 'LBL_CANAL',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => 'crm',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_canal_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'numero_fiscale' => 
    array (
      'required' => false,
      'name' => 'numero_fiscale',
      'vname' => 'LBL_NUMERO_FISCALE',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'regime_allocataire' => 
    array (
      'required' => false,
      'name' => 'regime_allocataire',
      'vname' => 'LBL_REGIME_ALLOCATAIRE',
      'type' => 'enum',
      'massupdate' => true,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_regime_allocataire_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'numero_allocataire' => 
    array (
      'required' => false,
      'name' => 'numero_allocataire',
      'vname' => 'LBL_NUMERO_ALLOCATAIRE',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'qf_caf_actuel' => 
    array (
      'required' => false,
      'name' => 'qf_caf_actuel',
      'vname' => 'LBL_QF_CAF_ACTUEL',
      'type' => 'decimal',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '18',
      'size' => '20',
      'enable_range_search' => '1',
      'precision' => '2',
      'options' => 'numeric_range_search_dom',
    ),
    'qf_ville_actuel' => 
    array (
      'required' => false,
      'name' => 'qf_ville_actuel',
      'vname' => 'LBL_QF_VILLE_ACTUEL',
      'type' => 'decimal',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '18',
      'size' => '20',
      'enable_range_search' => '1',
      'precision' => '2',
      'options' => 'numeric_range_search_dom',
    ),
    'date_application' => 
    array (
      'required' => false,
      'name' => 'date_application',
      'vname' => 'LBL_DATE_APPLICATION',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'situation_handicap' => 
    array (
      'required' => false,
      'name' => 'situation_handicap',
      'vname' => 'LBL_SITUATION_HANDICAP',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'adresse_date_validite' => 
    array (
      'required' => false,
      'name' => 'adresse_date_validite',
      'vname' => 'LBL_ADRESSE_DATE_VALIDITE',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'adresse_hors_commune' => 
    array (
      'required' => false,
      'name' => 'adresse_hors_commune',
      'vname' => 'LBL_ADRESSE_HORS_COMMUNE',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'agrement_administratif' => 
    array (
      'required' => false,
      'name' => 'agrement_administratif',
      'vname' => 'LBL_AGREMENT_ADMINISTRATIF',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'utilite_publique' => 
    array (
      'required' => false,
      'name' => 'utilite_publique',
      'vname' => 'LBL_UTILITE_PUBLIQUE',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'affiliee_reseau' => 
    array (
      'required' => false,
      'name' => 'affiliee_reseau',
      'vname' => 'LBL_AFFILIEE_RESEAU',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'detail_agrement' => 
    array (
      'required' => false,
      'name' => 'detail_agrement',
      'vname' => 'LBL_DETAIL_AGREMENT',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '6',
      'cols' => '80',
    ),
    'date_utilite_publique' => 
    array (
      'required' => false,
      'name' => 'date_utilite_publique',
      'vname' => 'LBL_DATE_UTILITE_PUBLIQUE',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'detail_affiliation' => 
    array (
      'required' => false,
      'name' => 'detail_affiliation',
      'vname' => 'LBL_DETAIL_AFFILIATION',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '6',
      'cols' => '80',
    ),
    'ops_individu_template_id' => 
    array (
      'required' => false,
      'name' => 'ops_individu_template_id',
      'vname' => 'LBL_INDIVIDU_TEMLPLATE_ID',
      'type' => 'id',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => true,
      'inline_edit' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 36,
      'size' => '20',
    ),
    'dossier_personne_individu_fonction' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'dossier_personne_individu_fonction',
      'vname' => 'LBL_DOSSIER_PERSONNE_INDIVIDU_FONCTION',
      'type' => 'relate',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'ops_individu_template_id',
      'ext2' => 'OPS_individu',
      'module' => 'OPS_individu',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'flag_partenaire' => 
    array (
      'required' => false,
      'name' => 'flag_partenaire',
      'vname' => 'LBL_FLAG_PARTENAIRE',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'publie' => 
    array (
      'required' => false,
      'name' => 'publie',
      'vname' => 'LBL_PUBLIE',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'thematique' => 
    array (
      'required' => false,
      'name' => 'thematique',
      'vname' => 'LBL_THEMATIQUE',
      'type' => 'multienum',
      'massupdate' => 0,
      'default' => 'N',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_thematique_profil_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'accroche' => 
    array (
      'required' => false,
      'name' => 'accroche',
      'vname' => 'LBL_ACCROCHE',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
    ),
    'description_annuaire' => 
    array (
      'required' => false,
      'name' => 'description_annuaire',
      'vname' => 'LBL_DESCRIPTION_ANNUAIRE',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
    ),
    'activites' => 
    array (
      'required' => false,
      'name' => 'activites',
      'vname' => 'LBL_ACTIVITES',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
    ),
    'tarifs' => 
    array (
      'required' => false,
      'name' => 'tarifs',
      'vname' => 'LBL_TARIFS',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
    ),
    'public_beneficiaire' => 
    array (
      'required' => false,
      'name' => 'public_beneficiaire',
      'vname' => 'LBL_PUBLIC_BENEFICIAIRE',
      'type' => 'text',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
    ),
    'image' => 
    array (
      'required' => false,
      'name' => 'image',
      'vname' => 'LBL_IMAGE',
      'type' => 'image',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => false,
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'dbType' => 'varchar',
    ),
    'nature' => 
    array (
      'required' => false,
      'name' => 'nature',
      'vname' => 'LBL_NATURE',
      'type' => 'enum',
      'massupdate' => true,
      'default' => '',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'ops_type_profil_nature_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'ops_personne_morale_ops_justificatif' => 
    array (
      'name' => 'ops_personne_morale_ops_justificatif',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_ops_justificatif',
      'source' => 'non-db',
      'module' => 'OPS_justificatif',
      'bean_name' => 'OPS_justificatif',
      'side' => 'right',
      'vname' => 'LBL_OPS_PERSONNE_MORALE_OPS_JUSTIFICATIFS_FROM_OPS_JUSTIFICATIFS_TITLE',
    ),
    'ops_personne_morale_notes' => 
    array (
      'name' => 'ops_personne_morale_notes',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_notes',
      'source' => 'non-db',
      'module' => 'Notes',
      'bean_name' => 'Note',
      'side' => 'right',
      'vname' => 'LBL_OPS_PERSONNE_MORALE_NOTES_FROM_NOTES_TITLE',
    ),
    'ops_sous_territoire_ops_personne_morale' => 
    array (
      'name' => 'ops_sous_territoire_ops_personne_morale',
      'type' => 'link',
      'relationship' => 'ops_sous_territoire_ops_personne_morale',
      'source' => 'non-db',
      'module' => 'OPS_sous_territoire',
      'bean_name' => 'OPS_sous_territoire',
      'vname' => 'LBL_OPS_SOUS_TERRITOIRE_OPS_PERSONNE_MORALE_FROM_OPS_SOUS_TERRITOIRE_TITLE',
    ),
    'ops_personne_morale_activities_calls' => 
    array (
      'name' => 'ops_personne_morale_activities_calls',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_activities_calls',
      'source' => 'non-db',
      'module' => 'Calls',
      'bean_name' => 'Call',
      'vname' => 'LBL_OPS_PERSONNE_MORALE_ACTIVITIES_CALLS_FROM_CALLS_TITLE',
    ),
    'ops_personne_morale_activities_emails' => 
    array (
      'name' => 'ops_personne_morale_activities_emails',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_activities_emails',
      'source' => 'non-db',
      'module' => 'Emails',
      'bean_name' => 'Email',
      'vname' => 'LBL_OPS_PERSONNE_MORALE_ACTIVITIES_EMAILS_FROM_EMAILS_TITLE',
    ),
    'ops_personne_morale_activities_meetings' => 
    array (
      'name' => 'ops_personne_morale_activities_meetings',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_activities_meetings',
      'source' => 'non-db',
      'module' => 'Meetings',
      'bean_name' => 'Meeting',
      'vname' => 'LBL_OPS_PERSONNE_MORALE_ACTIVITIES_MEETINGS_FROM_MEETINGS_TITLE',
    ),
    'ops_personne_morale_activities_notes' => 
    array (
      'name' => 'ops_personne_morale_activities_notes',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_activities_notes',
      'source' => 'non-db',
      'module' => 'Notes',
      'bean_name' => 'Note',
      'vname' => 'LBL_OPS_PERSONNE_MORALE_ACTIVITIES_NOTES_FROM_NOTES_TITLE',
    ),
    'ops_personne_morale_activities_tasks' => 
    array (
      'name' => 'ops_personne_morale_activities_tasks',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_activities_tasks',
      'source' => 'non-db',
      'module' => 'Tasks',
      'bean_name' => 'Task',
      'vname' => 'LBL_OPS_PERSONNE_MORALE_ACTIVITIES_TASKS_FROM_TASKS_TITLE',
    ),
    'ops_personne_morale_documents' => 
    array (
      'name' => 'ops_personne_morale_documents',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_documents',
      'source' => 'non-db',
      'module' => 'Documents',
      'bean_name' => 'Document',
      'side' => 'right',
      'vname' => 'LBL_OPS_PERSONNE_MORALE_DOCUMENTS_FROM_DOCUMENTS_TITLE',
    ),
    'ops_personne_morale_ops_appairage' => 
    array (
      'name' => 'ops_personne_morale_ops_appairage',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_ops_appairage',
      'source' => 'non-db',
      'module' => 'OPS_appairage',
      'bean_name' => false,
      'vname' => 'LBL_OPS_PERSONNE_MORALE_OPS_APPAIRAGE_FROM_OPS_APPAIRAGE_TITLE',
    ),
    'ops_personne_morale_ops_journal' => 
    array (
      'name' => 'ops_personne_morale_ops_journal',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_ops_journal',
      'source' => 'non-db',
      'module' => 'OPS_journal',
      'bean_name' => false,
      'vname' => 'LBL_OPS_PERSONNE_MORALE_OPS_JOURNAL_FROM_OPS_JOURNAL_TITLE',
    ),
    'ops_type_personne_ops_personne_morale' => 
    array (
      'name' => 'ops_type_personne_ops_personne_morale',
      'type' => 'link',
      'relationship' => 'ops_type_personne_ops_personne_morale',
      'source' => 'non-db',
      'module' => 'OPS_type_personne',
      'bean_name' => false,
      'vname' => 'LBL_OPS_TYPE_PERSONNE_OPS_PERSONNE_MORALE_FROM_OPS_TYPE_PERSONNE_TITLE',
      'id_name' => 'ops_type_personne_id',
      'massupdate' => 1,
    ),
    'ops_type_personne_ops_personne_morale_name' => 
    array (
      'name' => 'ops_type_personne_ops_personne_morale_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_OPS_TYPE_PERSONNE_OPS_PERSONNE_MORALE_FROM_OPS_TYPE_PERSONNE_TITLE',
      'save' => true,
      'id_name' => 'ops_type_personne_id',
      'link' => 'ops_type_personne_ops_personne_morale',
      'table' => 'ops_type_personne',
      'module' => 'OPS_type_personne',
      'rname' => 'name',
      'massupdate' => 1,
    ),
    'ops_type_personne_id' => 
    array (
      'name' => 'ops_type_personne_id',
      'type' => 'link',
      'relationship' => 'ops_type_personne_ops_personne_morale',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_OPS_TYPE_PERSONNE_OPS_PERSONNE_MORALE_FROM_OPS_PERSONNE_MORALE_TITLE',
      'massupdate' => 1,
    ),
    'ops_personne_morale_ops_personne_morale_individu' => 
    array (
      'name' => 'ops_personne_morale_ops_personne_morale_individu',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_ops_personne_morale_individu',
      'source' => 'non-db',
      'module' => 'OPS_personne_morale_individu',
      'bean_name' => 'OPS_personne_morale_individu',
      'side' => 'right',
      'vname' => 'LBL_OPS_PERSONNE_MORALE_OPS_PERSONNE_MORALE_INDIVIDU_FROM_OPS_PERSONNE_MORALE_INDIVIDU_TITLE',
    ),
    'ops_personne_morale_ops_information_fiscale' => 
    array (
      'name' => 'ops_personne_morale_ops_information_fiscale',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_ops_information_fiscale',
      'source' => 'non-db',
      'module' => 'OPS_information_fiscale',
      'bean_name' => 'OPS_information_fiscale',
      'side' => 'right',
      'vname' => 'LBL_OPS_PERSONNE_MORALE_OPS_INFORMATION_FISCALE_FROM_OPS_INFORMATION_FISCALE_TITLE',
    ),
    'ops_personne_morale_ops_historique_adresse' => 
    array (
      'name' => 'ops_personne_morale_ops_historique_adresse',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_ops_historique_adresse',
      'source' => 'non-db',
      'module' => 'OPS_historique_adresse',
      'bean_name' => 'OPS_historique_adresse',
      'side' => 'right',
      'vname' => 'LBL_OPS_PERSONNE_MORALE_OPS_HISTORIQUE_ADRESSE_FROM_OPS_HISTORIQUE_ADRESSE_TITLE',
    ),
    'ops_personne_morale_ops_domiciliation' => 
    array (
      'name' => 'ops_personne_morale_ops_domiciliation',
      'type' => 'link',
      'relationship' => 'ops_personne_morale_ops_domiciliation',
      'source' => 'non-db',
      'module' => 'OPS_domiciliation',
      'bean_name' => 'OPS_domiciliation',
      'side' => 'right',
      'vname' => 'LBL_OPS_PERSONNE_MORALE_OPS_DOMICILIATION_FROM_OPS_DOMICILIATION_TITLE',
    ),
  ),
  'relationships' => 
  array (
    'ops_personne_morale_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_personne_morale',
      'rhs_table' => 'ops_personne_morale',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'ops_personne_morale_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_personne_morale',
      'rhs_table' => 'ops_personne_morale',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'ops_personne_morale_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_personne_morale',
      'rhs_table' => 'ops_personne_morale',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'securitygroups_ops_personne_morale' => 
    array (
      'lhs_module' => 'SecurityGroups',
      'lhs_table' => 'securitygroups',
      'lhs_key' => 'id',
      'rhs_module' => 'OPS_personne_morale',
      'rhs_table' => 'ops_personne_morale',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'securitygroups_records',
      'join_key_lhs' => 'securitygroup_id',
      'join_key_rhs' => 'record_id',
      'relationship_role_column' => 'module',
      'relationship_role_column_value' => 'OPS_personne_morale',
    ),
    'ops_personne_morale_email_addresses' => 
    array (
      'lhs_module' => 'OPS_personne_morale',
      'lhs_table' => 'ops_personne_morale',
      'lhs_key' => 'id',
      'rhs_module' => 'EmailAddresses',
      'rhs_table' => 'email_addresses',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'email_addr_bean_rel',
      'join_key_lhs' => 'bean_id',
      'join_key_rhs' => 'email_address_id',
      'relationship_role_column' => 'bean_module',
      'relationship_role_column_value' => 'OPS_personne_morale',
    ),
    'ops_personne_morale_email_addresses_primary' => 
    array (
      'lhs_module' => 'OPS_personne_morale',
      'lhs_table' => 'ops_personne_morale',
      'lhs_key' => 'id',
      'rhs_module' => 'EmailAddresses',
      'rhs_table' => 'email_addresses',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'email_addr_bean_rel',
      'join_key_lhs' => 'bean_id',
      'join_key_rhs' => 'email_address_id',
      'relationship_role_column' => 'primary_address',
      'relationship_role_column_value' => '1',
    ),
  ),
  'optimistic_locking' => true,
  'unified_search' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'ops_personne_moralepk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
  ),
  'templates' => 
  array (
    'company' => 'company',
    'security_groups' => 'security_groups',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => false,
);