<?php
namespace ODE_API\Core\Config;

class ApiConfig
{
    // we still support 5.5.9
    private static $slimSettings = [
        'ODE_API/Core/Config/slim.php',
    ];

    private static $containers = [
        'ODE_API/V8/Config/services.php',
    ];

    private static $routes = [
        'ODE_API/V8/Config/routes.php',
    ];

    const OAUTH2_PRIVATE_KEY = 'ODE_API/V8/OAuth2/private.key';
    const OAUTH2_PUBLIC_KEY = 'ODE_API/V8/OAuth2/public.key';
    
    /**
     *
     * @var boolean
     */
    private static $debugExceptions = false;
    
    /**
     *
     * @return boolean
     */
    public static function getDebugExceptions()
    {
        return self::$debugExceptions;
    }

    /**
     * @return array
     */
    public static function getSlimSettings()
    {
        return self::$slimSettings;
    }

    /**
     * @return array
     */
    public static function getContainers()
    {
        return self::$containers;
    }

    /**
     * @return array
     */
    public static function getRoutes()
    {
        return self::$routes;
    }
}
