<?php
namespace ODE_API\V8\Controller;

use ODE_API\V8\Service\DispositifService;
use ODE_API\V8\Param\FormulaireListParams;
use ODE_API\V8\Param\DispositifParams;

use Slim\Http\Request;
use Slim\Http\Response;

/**
* DispositifController
*/
class DispositifController extends BaseController
{


    /**
    * @var DispositifController
    */
    protected $dispositifService;

    /**
    * @param DispositifService $dispositifService
    */
    public function __construct(DispositifService $dispositifService)
    {
        $this->dispositifService = $dispositifService;
    }

        /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DispositifParams $params
     *
     * @return Response
     */
    public function getDetailDispositif(Request $request, Response $response, array $args, DispositifParams $params)
    {
        try {
            $jsonResponse = $this->dispositifService->getDetailDispositif($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    
    /**
    * @param Request $request
    * @param Response $response
    * @param ListeDispositifParams $params
    *
    * @return Response
    */
    public function getListDispositif(Request $request, Response $response)
    {
        try {
            $jsonResponse = $this->dispositifService->getListDispositif($request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }  

    
    /**
    * @param Request $request
    * @param Response $response
    * @param array $args
    * @param FormulaireListParams $params
    *
    * @return Response
    */
    public function getNewFormulaire(Request $request, Response $response, array $args, FormulaireListParams $params)
    {
        try {

            $jsonResponse = $this->dispositifService->getNewFormulaire($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    } 

}

