<?php

namespace ODE_API\V8\Controller;

use ODE_API\V8\Service\DossierService;

use ODE_API\V8\Param\DossierListParams;
use ODE_API\V8\Param\DossierSetParams;
use ODE_API\V8\Param\DossierNumParam;
use ODE_API\V8\Param\DossierSuiviParams;
use ODE_API\V8\Param\DossierGetParams;


use Slim\Http\Request;
use Slim\Http\Response;

/**
 * DossierController
 */
class DossierController extends BaseController
{
    /**
     * @var DossierController
     */
    protected $dossierService;

    /**
     * @param DossierService $dossierService
     */
    public function __construct(DossierService $dossierService)
    {
        $this->dossierService = $dossierService;
    }


    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierListParams $params
     *
     * @return Response
     */
    public function getListDossier(Request $request, Response $response, array $args, DossierListParams $params)
    {
        try {
            $jsonResponse = $this->dossierService->getListDossier($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }






    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierSetParams $params
     *
     * @return Response
     */
    public function createDossier(Request $request, Response $response, array $args, DossierSetParams $params)
    {
        try {
            $jsonResponse = $this->dossierService->createDossier($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierSetParams $params
     *
     * @return Response
     */
    public function createDossierByEtape(Request $request, Response $response, array $args, DossierSetParams $params)
    {
        try {
            $jsonResponse = $this->dossierService->createDossierByEtape($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierSetParams $params
     *
     * @return Response
     */
    public function updateDossier(Request $request, Response $response, array $args, DossierSetParams $params)
    {
        try {
            $jsonResponse = $this->dossierService->updateDossier($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierSetParams $params
     *
     * @return Response
     */
    public function updateDossierByEtape(Request $request, Response $response, array $args, DossierSetParams $params)
    {
        try {
            $jsonResponse = $this->dossierService->updateDossierByEtape($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierListParams $params
     *
     * @return Response
     */
    public function getDossierById(Request $request, Response $response, array $args, DossierListParams $params)
    {
        try {
            $jsonResponse = $this->dossierService->getDossierById($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierNumParam $params
     *
     * @return Response
     */
    public function getDossierByNum(Request $request, Response $response, array $args, DossierNumParam $params)
    {
        try {
            $jsonResponse = $this->dossierService->getDossierByNum($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierListParams $params
     *
     * @return Response
     */
    public function deleteDossier(Request $request, Response $response, array $args, DossierListParams $params)
    {
        try {
            $jsonResponse = $this->dossierService->deleteDossier($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierSetParams $params
     *
     * @return Response
     */
    public function getFormByEtape(Request $request, Response $response, array $args, DossierSetParams $params)
    {
        try {
            $jsonResponse = $this->dossierService->getFormByEtape($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierListParams $params
     *
     * @return Response
     */
    public function getDossierFormatPdf(Request $request, Response $response, array $args, DossierListParams $params)
    {
        try {
            $jsonResponse = $this->dossierService->getDossierFormatPdf($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierSetParams $params
     *
     * @return Response
     */
    public function getListDossierByDemandeur(Request $request, Response $response, array $args, DossierSetParams $params)
    {
        try {
            $jsonResponse = $this->dossierService->getListDossierByDemandeur($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }
	
	
	/**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierSuiviParams $params
     *
     * @return Response
     */
    public function getDossiersuivi(Request $request, Response $response, array $args, DossierSuiviParams $params)
    {
        try {
            $jsonResponse = $this->dossierService->getDossiersuivi($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }


    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierGetParams $params
     *
     * @return Response
     */
    public function getDossier(Request $request, Response $response, array $args, DossierGetParams $params)
    {
        try {
            $jsonResponse = $this->dossierService->getDossier($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }
	
}
