<?php
namespace ODE_API\V8\Controller;

use ODE_API\V8\Service\NotificationService;
use ODE_API\V8\Param\NotificationListParams;

use Slim\Http\Request;
use Slim\Http\Response;

/**
* NotificationController
*/
class NotificationController extends BaseController
{


    /**
    * @var NotificationService
    */
    protected $NotificationService;

    /**
    * @param NotificationService $notificationService
    */
    public function __construct(NotificationService $notificationService)
    {
        $this->notificationService = $notificationService;
    }



    /**
    * @param Request $request
    * @param Response $response
    * @param array $args
    * @param NotificationListParams $params
    *
    * @return Response
    */
    public function getListNotifications(Request $request, Response $response, array $args, NotificationListParams $params)
    {
        try {

            $jsonResponse = $this->notificationService->getListNotifications($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    } 
	   
    /**
    * @param Request $request
    * @param Response $response
    * @param array $args
    * @param NotificationListParams $params
    *
    * @return Response
    */
    public function getListIndicateurs(Request $request, Response $response, array $args, NotificationListParams $params)
    {
        try {

            $jsonResponse = $this->notificationService->getListIndicateurs($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    } 
	
}

