<?php
namespace ODE_API\V8\Controller;

use ODE_API\V8\Controller\BaseController;

use ODE_API\V8\Service\RepertoireEntrepriseService;
use ODE_API\V8\Param\RepertoireEntrepriseParams;

use Slim\Http\Request;
use Slim\Http\Response;

class RepertoireEntrepriseController extends BaseController
{
    /**
     * @var RepertoireEntrepriseService
     */
    private $repertoireEntrepriseService;

    /**
     * @param RepertoireEntrepriseService $repertoireEntrepriseService
     */
    public function __construct(RepertoireEntrepriseService $repertoireEntrepriseService)
    {
        $this->repertoireEntrepriseService = $repertoireEntrepriseService;
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     *
     * @return Response
     */
    public function getEntreprise(Request $request, Response $response, array $args, RepertoireEntrepriseParams $params)
    {
        try {
            $jsonResponse = $this->repertoireEntrepriseService->getEntreprise($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }
}
