<?php

namespace ODE_API\V8\Controller;

use ODE_API\V8\Service\tiersService;

use ODE_API\V8\Param\TiersListParams;
use ODE_API\V8\Param\TiersEditionParams;
use ODE_API\V8\Param\TiersTypeInfosParams;
use ODE_API\V8\Param\TiersDetailParams;
use ODE_API\V8\Param\TiersListIndividusParams;
use ODE_API\V8\Param\TiersIndividuDetailParams;
use ODE_API\V8\Param\TiersIndividuEditionParams;
use ODE_API\V8\Param\TiersPartageDeleteParams;
use ODE_API\V8\Param\TiersRoleUpdateParams;
use Slim\Http\Request;
use Slim\Http\Response;

/**
 * TiersController
 */
class TiersController extends BaseController
{
    /**
     * @var TiersController
     */
    protected $tiersService;

    /**
     * @param tiersService $tiersService
     */
    public function __construct(tiersService $tiersService)
    {
        $this->tiersService = $tiersService;
    }


    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     *
     * @return Response
     */
    public function getTypeTiers(Request $request, Response $response)
    {
        try {
            $jsonResponse = $this->tiersService->getTypeTiers($request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }


    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     *
     * @return Response
     */
    public function getRoleTiers(Request $request, Response $response)
    {
        try {
            $jsonResponse = $this->tiersService->getRoleTiers($request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }


    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param TiersTypeInfosParams $params
     *
     * @return Response
     */
    public function getTypeTiersInfos(Request $request, Response $response, array $args, TiersTypeInfosParams $params)
    {
        try {
            $jsonResponse = $this->tiersService->getTypeTiersInfos($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param TiersListParams $params
     *
     * @return Response
     */
    public function getListTiers(Request $request, Response $response, array $args, TiersListParams $params)
    {
        try {
            $jsonResponse = $this->tiersService->getListTiers($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }


    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param getDetailTiers $params
     *
     * @return Response
     */
    public function getDetailTiers(Request $request, Response $response, array $args, TiersDetailParams $params)
    {
        try {
            $jsonResponse = $this->tiersService->getDetailTiers($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param TiersListIndividusParams $params
     *
     * @return Response
     */
    public function setTiers(Request $request, Response $response, array $args, TiersEditionParams $params)
    {
        try {
            $jsonResponse = $this->tiersService->setTiers($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }


    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param TiersListIndividusParams $params
     *
     * @return Response
     */
    public function getListIndividuByTiers(Request $request, Response $response, array $args, TiersListIndividusParams $params)
    {
        try {
            $jsonResponse = $this->tiersService->getListIndividuByTiers($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

        /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param TiersIndividuDetailParams $params
     *
     * @return Response
     */
    public function getIndividu(Request $request, Response $response, array $args, TiersIndividuDetailParams $params)
    {
        try {
            $jsonResponse = $this->tiersService->getIndividu($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }


    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param TiersIndividuEditionParams $params
     *
     * @return Response
     */
    public function setIndividu(Request $request, Response $response, array $args, TiersIndividuEditionParams $params)
    {
        try {
            $jsonResponse = $this->tiersService->setIndividu($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }


    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param TiersIndividuEditionParams $params
     *
     * @return Response
     */
    public function setCode(Request $request, Response $response, array $args, TiersIndividuEditionParams $params)
    {
        try {
            $jsonResponse = $this->tiersService->setCode($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }

        /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param TiersIndividuEditionParams $params
     *
     * @return Response
     */
    public function rattacherProfil(Request $request, Response $response, array $args, TiersIndividuEditionParams $params)
    {
        try {
            $jsonResponse = $this->tiersService->rattacherProfil($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }


    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param TiersPartageDeleteParams $params
     *
     * @return Response
     */
    public function deleteCode(Request $request, Response $response, array $args, TiersPartageDeleteParams $params)
    {
        try {
            $jsonResponse = $this->tiersService->deleteCode($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }


    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param TiersListIndividusParams $params
     *
     * @return Response
     */
    public function getCodes(Request $request, Response $response, array $args, TiersListIndividusParams $params)
    {
        try {
            $jsonResponse = $this->tiersService->getCodes($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }


    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param TiersIndividuEditionParams $params
     *
     * @return Response
     */
    public function UpdateRoleTier(Request $request, Response $response, array $args, TiersRoleUpdateParams $params)
    {
        try {
            $jsonResponse = $this->tiersService->UpdateRoleTier($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }
    
}
