<?php
namespace ODE_API\V8\OAuth2\Repository;

use ODE_API\V8\BeanDecorator\BeanManager;
use ODE_API\V8\OAuth2\Entity\ClientEntity;
use League\OAuth2\Server\Repositories\ClientRepositoryInterface;

class ClientRepository implements ClientRepositoryInterface
{
    /**
     * @var ClientEntity
     */
    private $clientEntity;

    /**
     * @var BeanManager
     */
    private $beanManager;

    /**
     * @param ClientEntity $clientEntity
     * @param BeanManager $beanManager
     */
    public function __construct(ClientEntity $clientEntity, BeanManager $beanManager)
    {
        $this->clientEntity = $clientEntity;
        $this->beanManager = $beanManager;
    }

    /**
     * @inheritdoc
     */
    public function getClientEntity($clientIdentifier, $grantType = null, $clientSecret = null, $mustValidateSecret = true)
    {
        /** @var \OAuth2Clients $client */
        $client = $this->beanManager->getBeanSafe(\OAuth2Clients::class, $clientIdentifier);

        $this->clientEntity->setIdentifier($clientIdentifier);
        $this->clientEntity->setName($client->name);
        $this->clientEntity->setRedirectUri($client->redirect_uri ?? '');
        $this->clientEntity->setIsConfidential($client->is_confidential ?? false);

        return $this->clientEntity;
    }

    public function validateClient($clientIdentifier, $clientSecret, $grantType) {
        $client = $this->beanManager->getBeanSafe(\OAuth2Clients::class, $clientIdentifier);
        return hash('sha256', $clientSecret) === $client->secret && $grantType === $client->allowed_grant_type;
    }
}
