<?php
namespace ODE_API\V8\Param;

use ODE_API\V8\Param\Options as ParamOption;
use Symfony\Component\OptionsResolver\Options;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints as Assert;

class AjaxPointsParams extends BaseParam
{
    
    /**
     * @return objet
     */
    public function getNumeroFiscal()
    {
        return $this->parameters['numeroFiscal'];
    }

    /**
     * @return id
     */
    public function getReferenceAvis()
    {
        return $this->parameters['referenceAvis'];
    }

   
    /**
     * @inheritdoc
     */
    protected function configureParameters(OptionsResolver $resolver)
    {
        $this->setOptions(
            $resolver,
            [
                ParamOption\NumeroFiscal::class,
                ParamOption\ReferenceAvis::class
            ]
        );
    }
}
