<?php

namespace ODE_API\V8\Param;

use ODE_API\V8\Param\Options as ParamOption;
use Symfony\Component\OptionsResolver\Options;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints as Assert;

class DossierSetParams extends BaseParam
{

    /**
     * @return CreateModuleDataParams
     */
    public function getData()
    {
        return $this->parameters['data'];
    }

    /**
     * @return array  
     * 
     */
    protected function configureParameters(OptionsResolver $resolver)
    {
        $resolver
            ->setRequired('data')
            ->setAllowedTypes('data', 'array')
            ->setNormalizer('data', function (Options $options, $values) {
                $dataParams = $values;
                return $dataParams;
            });
    }
}
