<?php
namespace ODE_API\V8\Param;

use ODE_API\V8\Param\Options as ParamOption;
use Symfony\Component\OptionsResolver\Options;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints as Assert;

class FormulaireListParams extends BaseParam
{
    
    /**
     * @return objet
     */
    public function getModuleName()
    {
        return $this->parameters['moduleName'];
    }

    /**
     * @return entite
     */
    public function getEntite()
    {
        return $this->parameters['entite'];
    }


    /**
     * @return DemandeurId
     */
    public function getDemandeurId()
    {
        return  $this->parameters['demandeurId'];
    }

    /**
     * @return DipositifId
     */
    public function getDispositifId()
    {
        return  $this->parameters['dispositifId'];
    }

   
    /**
     * @inheritdoc
     */
    protected function configureParameters(OptionsResolver $resolver)
    {
        $this->setOptions(
            $resolver,
            [
                ParamOption\Entite::class,
                ParamOption\DemandeurId::class,
                ParamOption\DispositifId::class,
                
            ]
        );
    }
}
