<?php
namespace ODE_API\V8\Param;

use ODE_API\V8\Param\Options as ParamOption;
use Symfony\Component\OptionsResolver\OptionsResolver;

class GetOAuthIdentityParams extends BaseParam
{
    /**
     * @return string
     */
    public function getEmail()
    {
        return isset($this->parameters['email']) ? $this->parameters['email'] : null;
    }

    /**
     * @inheritdoc
     */
    protected function configureParameters(OptionsResolver $resolver)
    {
        $this->setOptions(
            $resolver,
            [
                ParamOption\Email::class,
            ]
        );
    }
}
