<?php
namespace ODE_API\V8\Param;

use ODE_API\V8\Param\Options as ParamOption;
use Symfony\Component\OptionsResolver\Options;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints as Assert;

class IndividuMessageDetailParams extends BaseParam
{
    
    /**
     * @return objet
     */
    public function getMessageId()
    {
        return isset($this->parameters['messageId']) ? $this->parameters['messageId'] : '';
    }

    /**
     * @return id
     */
    public function getId()
    {
        return isset($this->parameters['id']) ? $this->parameters['id'] : '';
    }

   
    /**
     * @inheritdoc
     */
    protected function configureParameters(OptionsResolver $resolver)
    {
        $this->setOptions(
            $resolver,
            [
                ParamOption\MessageId::class,
                ParamOption\Id::class
            ]
        );
    }
}
