<?php
namespace ODE_API\V8\Param\Options;

use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints as Assert;

class Objet extends BaseOption
{
    /**
     * @inheritdoc
     */
    public function add(OptionsResolver $resolver)
    {
        $resolver
            ->setRequired('objet')
            ->setAllowedTypes('objet', 'string')
            ->setAllowedValues('objet', $this->validatorFactory->createClosure([
                new Assert\NotBlank(),
                new Assert\Regex([
                    'pattern' => ModuleName::REGEX_MODULE_NAME_PATTERN,
                    'match' => false,
                ]),
            ]));
    }
}
