<?php
namespace ODE_API\V8\Service;

use ODE_API\V8\BeanDecorator\BeanManager;
use ODE_API\V8\JsonApi\Helper\AttributeObjectHelper;
use ODE_API\V8\JsonApi\Helper\PaginationObjectHelper;
use ODE_API\V8\JsonApi\Helper\RelationshipObjectHelper;
use ODE_API\V8\JsonApi\Response\DossierResponse;
use ODE_API\V8\Param\ListeConversationParams;
use ODE\Model\DossierModel;
use ODE\Helper\OdePdfHelper;
use ODE\Notification\OdeNotification;
use OPS_dossier;
use BeanFactory;
use DateTime;
use Exception;
use Slim\Http\Request;

class ConversationService
{
    /**
     * @var BeanManager
     */
    private $beanManager;

    /**
     * @var AttributeObjectHelper
     */
    private $attributeHelper;

    /**
     * @var RelationshipObjectHelper
     */
    private $relationshipHelper;

    /**
     * @var PaginationObjectHelper
     */
    private $paginationHelper;

    /**
     * @param BeanManager $beanManager
     * @param AttributeObjectHelper $attributeHelper
     * @param RelationshipObjectHelper $relationshipHelper
     * @param PaginationObjectHelper $paginationHelper
     */
    public function __construct(
        BeanManager $beanManager,
        AttributeObjectHelper $attributeHelper,
        RelationshipObjectHelper $relationshipHelper,
        PaginationObjectHelper $paginationHelper
    ) {
        $this->beanManager = $beanManager;
        $this->attributeHelper = $attributeHelper;
        $this->relationshipHelper = $relationshipHelper;
        $this->paginationHelper = $paginationHelper;
    }




    /**
     * accessConversation
     *
     * Retourne .
     * Ce point d'accès nécessite un certain niveau de sécurité, on passe au crible une éventuelle faille.
     *
     * @param Params $params
     * @param Request $request
     *
     * @return DossierResponse
     */
    public function accessConversation(ListeConversationParams $params, Request $request)
    {

        // On récupere les données
        $donnees = $params->getData();

        // On vérifie que les données ne sont pas vide 
        if (!is_array($donnees) || count($donnees) === 0) {
            throw new Exception('Données vide', 401);
        }

        // IndividuId was passed throw the route in a param « individuId » slug.
        $id_usager = $params->getIndividuId(); // Required !


        try {
            $obj_individu = $this->beanManager->getBeanSafe("OPS_individu", $id_usager);
        } catch (\Exception $exception) {
            throw new Exception("L'id du demandeur est obligatoire", 401);
        }


        // On vérifie que certaines données ne sont pas vides.
        if (!isset($donnees['id']) || empty($donnees['id'])) {
            throw new Exception('Paramètre incorrect !', 401);
        }

        $id     = $donnees['id']; // Dossier ID
        $dossier = BeanFactory::getBean('OPS_dossier', $id);

        
        # Récupération de l'accessibilité au dossier.
        $data_AccessDossier = $this->isDossierAccessible( $id_usager, $dossier);
        $AccessDossier = (object)$data_AccessDossier->getData();

        return $AccessDossier;

    }


    /**
     * fetchConversationState
     *
     * Retourne .
     * Ce point d'accès nécessite un certain niveau de sécurité, on passe au crible une éventuelle faille.
     *
     * @param Params $params
     * @param Request $request
     *
     * @return DossierResponse
     */
    public function fetchConversationState(ListeConversationParams $params, Request $request)
    {

        // On récupere les données
        $donnees = $params->getData();

        // On vérifie que les données ne sont pas vide 
        if (!is_array($donnees) || count($donnees) === 0) {
            throw new Exception('Données vide', 401);
        }

        // IndividuId was passed throw the route in a param « individuId » slug.
        $id_usager = $params->getIndividuId(); // Required !


        try {
            $obj_individu = $this->beanManager->getBeanSafe("OPS_individu", $id_usager);
        } catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }


        // On vérifie que certaines données ne sont pas vides.
        if (!isset($donnees['id']) || empty($donnees['id'])) {
            throw new Exception('Paramètre incorrect !', 401);
        }
        if (!isset($donnees['origin_module']) || empty($donnees['origin_module'])) {
            throw new Exception('Paramètre incorrect !', 401);
        }

        $id     = $donnees['id'];
        $module = $donnees['origin_module'];


        // Récupération des données relatives aux paramètres disponibles en référence.
        $bean_name = 'OPS_conversation';
        //$Conversation = $this->beanManager->getBean("OPS_conversation", null);
        $Conversation = \BeanFactory::getBean($bean_name, null); // Retrieve OPS_conversation bean class.

        $data = $Conversation->fetchConversationState($id, $module);


        $response = new DossierResponse();
        $response->setData($data);
        return $response;
    }

    /**
     * fetchMessages
     *
     * Retourne .
     * Ce point d'accès nécessite un certain niveau de sécurité, on passe au crible une éventuelle faille.
     *
     * @param Params $params
     * @param Request $request
     *
     * @return DossierResponse
     */
    public function fetchMessages(ListeConversationParams $params, Request $request)
    {

        // On récupere les données
        $donnees = $params->getData();

        // On vérifie que les données ne sont pas vide 
        if (!is_array($donnees) || count($donnees) === 0) {
            throw new Exception('Données vide', 401);
        }

        // IndividuId was passed throw the route in a param « individuId » slug.
        $id_usager = $params->getIndividuId(); // Required !


        try {
            $obj_individu = $this->beanManager->getBeanSafe("OPS_individu", $id_usager);
        } catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }


        // On vérifie que certaines données ne sont pas vides.
        if (!isset($donnees['id']) || empty($donnees['id'])) {
            throw new Exception('Paramètre incorrect !', 401);
        }
        if (!isset($donnees['origin_module']) || empty($donnees['origin_module'])) {
            throw new Exception('Paramètre incorrect !', 401);
        }

        $id     = $donnees['id'];
        $module = $donnees['origin_module'];


        // Récupération des données relatives aux paramètres disponibles en référence.
        $bean_name = 'OPS_conversation';
        //$Conversation = $this->beanManager->getBean("OPS_conversation", null);
        $Conversation = BeanFactory::getBean($bean_name, null); // Retrieve OPS_conversation bean class.

        $data = $Conversation->fetchMessages($id, $module);

        $response = new DossierResponse();
        $response->setData($data);
        return $response;
    }

    /**
     * sendMessage
     *
     * Retourne .
     * Ce point d'accès nécessite un certain niveau de sécurité, on passe au crible une éventuelle faille.
     *
     * @param Params $params
     * @param Request $request
     *
     * @return DossierResponse
     */
    public function sendMessage(ListeConversationParams $params, Request $request)
    {

        // On récupere les données
        $donnees = $params->getData();

        // On vérifie que les données ne sont pas vide 
        if (!is_array($donnees) || count($donnees) === 0) {
            throw new Exception('Données vide', 401);
        }

        // IndividuId was passed throw the route in a param « individuId » slug.
        $id_usager = $params->getIndividuId(); // Required !


        try {
            $obj_individu = $this->beanManager->getBeanSafe("OPS_individu", $id_usager);
        } catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }


        // On vérifie que certaines données ne sont pas vides.
        if (!isset($donnees['id']) || empty($donnees['id'])) {
            throw new Exception('Paramètre incorrect !', 401);
        }
        if (!isset($donnees['origin_module']) || empty($donnees['origin_module'])) {
            throw new Exception('Paramètre incorrect !', 401);
        }


        $id     = $donnees['id'];
        $module = $donnees['origin_module'];
        $b64_message  = $donnees['b64_message'];
        $objAuthor    = (object)$donnees['objAuthor'];


        // Récupération des données relatives aux paramètres disponibles en référence.
        $bean_name = 'OPS_conversation';
        //$Conversation = $this->beanManager->getBean("OPS_conversation", null);
        $Conversation = BeanFactory::getBean($bean_name, null); // Retrieve OPS_conversation bean class.

        $data = (object) $Conversation->addMessage($id, $module, $b64_message, $objAuthor);


        $response = new DossierResponse();
        $response->setData($data);
        return $response;
    }

    /**
     * setMessageStatut
     *
     * Retourne .
     * Ce point d'accès nécessite un certain niveau de sécurité, on passe au crible une éventuelle faille.
     *
     * @param Params $params
     * @param Request $request
     *
     * @return DossierResponse
     */
    public function setMessageStatut(ListeConversationParams $params, Request $request)
    {

        // On récupere les données
        $donnees = $params->getData();

        // On vérifie que les données ne sont pas vide 
        if (!is_array($donnees) || count($donnees) === 0) {
            throw new Exception('Données vide', 401);
        }

        // IndividuId was passed throw the route in a param « individuId » slug.
        $id_usager = $params->getIndividuId(); // Required !


        try {
            $obj_individu = $this->beanManager->getBeanSafe("OPS_individu", $id_usager);
        } catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }


        // On vérifie que certaines données ne sont pas vides.
        if (!isset($donnees['id']) || empty($donnees['id'])) {
            throw new Exception('Paramètre incorrect !', 401);
        }
        if (!isset($donnees['origin_module']) || empty($donnees['origin_module'])) {
            throw new Exception('Paramètre incorrect !', 401);
        }


        $id     = $donnees['id'];
        $module = $donnees['origin_module'];
        $message_id  = $donnees['message_id'];
        $message_statut = $donnees['message_statut'];


        // Récupération des données relatives aux paramètres disponibles en référence.
        $bean_name = 'OPS_conversation';
        //$Conversation = $this->beanManager->getBean("OPS_conversation", null);
        $Conversation = BeanFactory::getBean($bean_name, null); // Retrieve OPS_conversation bean class.

        $data = (object) $Conversation->setMessageStatut($id, $module, $message_id, $message_statut);


        $response = new DossierResponse();
        $response->setData($data);
        return $response;
    }





    /**
     * isDossierAccessible
     *
     * Retourne .
     * Ce point d'accès nécessite un certain niveau de sécurité, on passe au crible une éventuelle faille.
     *
     * @param UUID $id_usager
     * @param Bean OPS_dossier $Dossier
     *
     * @return DossierResponse
     */
    public function isDossierAccessible( $id_usager, $Dossier)
    {
        // Vérification que l'usager connecté a le droit de d'accès sur le dossier
        // Si l'usager connecté n'est pas le demandeur => On vérifie s'il est lié au profil
        if ($id_usager != $Dossier->ops_individu_id) {
            if (!ConversationService::verif_liaison_profil($id_usager, $Dossier->ops_personne_morale)) {
                // Vérification par le profil
                $response = new DossierResponse();
                $response->setData(["erreur" => "Vous n'avez pas accès à ce dossier"]);
                return $response;
            }else{
                $response = new DossierResponse();
                $response->setData(["result" => "ok"]);
                return $response;
            }
        }else{
            $response = new DossierResponse();
            $response->setData(["result" => "ok"]);
            return $response;
        }
    }

    public static function verif_liaison_profil($id_usager, $id_profil)
    {
        global $db;

        $requete = $db->query(
            "
            SELECT ops_personne_morale.id,
                   ops_personne_morale_individu.responsable
            FROM ops_personne_morale, ops_individu_ops_personne_morale_individu , ops_personne_morale_ops_personne_morale_individu ,ops_personne_morale_individu, ops_type_personne_ops_personne_morale, ops_type_personne
            WHERE ops_personne_morale.id = ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_id 
            AND ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id 
            AND ops_individu_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id 
            AND ops_individu_ops_personne_morale_individu.ops_individu_id =  '" . $id_usager . "'
            AND ops_personne_morale.id =  '" . $id_profil . "'
            AND ops_type_personne_ops_personne_morale.ops_personne_morale_id = ops_personne_morale.id
            AND ops_type_personne_ops_personne_morale.ops_type_personne_id = ops_type_personne.id
            AND ops_personne_morale.deleted = 0
            AND ops_individu_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_individu.deleted = 0
            AND ops_type_personne_ops_personne_morale.deleted = 0
            AND ops_type_personne.deleted = 0
            AND ops_type_personne.visible_usager = 1
            ORDER BY `ops_personne_morale`.`name` DESC "
        );

        $rowResults = array();
        while ($row = $db->fetchRow($requete)) {
            return true;
        }

        return false;
    } 





}
