<?php
namespace ODE_API\V8\Service;

use ODE_API\V8\BeanDecorator\BeanManager;
use ODE_API\V8\JsonApi\Helper\AttributeObjectHelper;
use ODE_API\V8\JsonApi\Helper\PaginationObjectHelper;
use ODE_API\V8\JsonApi\Helper\RelationshipObjectHelper;
use ODE_API\V8\JsonApi\Response\LinksResponse;
use ODE_API\V8\JsonApi\Response\DataResponse;
use ODE_API\V8\JsonApi\Response\DossierResponse;
use ODE_API\V8\JsonApi\Response\MetaResponse;

use ODE_API\V8\Param\DossierListParams;
use ODE_API\V8\Param\DossierSetParams;
use ODE_API\V8\Param\DossierNumParam;
use ODE_API\V8\Param\DossierSuiviParams;
use ODE_API\V8\Param\DossierGetParams;

use ODE\Generateur\Factory\OdeFormFactory;
use ODE\Generateur\Factory\OdeViewFactory;

use ODE\Model\DossierModel;
use ODE\Model\DemandeurModel;
use ODE\Model\DispositifModel;
use ODE\Model\GenerateurFormulaireModel;

use ODE\Helper\OdePdfHelper;
use ODE\Mailer\OdeEmail;
use ODE\Mailer\OdeMailer;
use OPS_dossier;
use BeanFactory;

use Exception;
use Slim\Http\Request;

use UploadFile;

use Datetime;
use DateTimeZone;

class DossierService
{
    /**
     * @var BeanManager
     */
    protected $beanManager;

    /**
     * @var AttributeObjectHelper
     */
    protected $attributeHelper;

    /**
     * @var RelationshipObjectHelper
     */
    protected $relationshipHelper;

    /**
     * @var PaginationObjectHelper
     */
    protected $paginationHelper;

    /**
     * @param BeanManager $beanManager
     * @param AttributeObjectHelper $attributeHelper
     * @param RelationshipObjectHelper $relationshipHelper
     * @param PaginationObjectHelper $paginationHelper
     */
    public function __construct(BeanManager $beanManager, AttributeObjectHelper $attributeHelper, RelationshipObjectHelper $relationshipHelper, PaginationObjectHelper $paginationHelper)
    {
        $this->beanManager = $beanManager;
        $this->attributeHelper = $attributeHelper;
        $this->relationshipHelper = $relationshipHelper;
        $this->paginationHelper = $paginationHelper;
    }

    ////////////////////////////////    PORTAIL API /////////////////////////////////////////////////////////

    /**
     * getListDossier
     * @param DossierListParams $params
     * @param $path
     * @return DossierResponse
     * @throws AccessDeniedException
     */
    public function getListDossier(DossierListParams $params, Request $request)
    {
        global $beanFiles, $db, $sugar_config;

        $objet = 'OPS_individu';
        $id_objet = $params->getId();

        try {
            $obj_module = $this->beanManager->getBeanSafe($objet, $id_objet);
        } catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }

        // Récupération des dossiers de l'individu en tant que Particulier 

        $tab_dossiers = $obj_module->get_linked_beans(
            'ops_individu_ops_dossier',
            'ops_dossier',
            'num_dossier DESC',
            0,
            -1,
            0,
            ' (ops_dossier.ops_personne_morale IS NULL OR ops_dossier.ops_personne_morale = "") && ops_dossier.name != "TEMP" '
        );

        $retour_dossiers = array();

        foreach ($tab_dossiers as $key => $un_dossier) {
            $module_dispositif = 'OPS_dispositif';
            $id_dispositif = $un_dossier->ops_dispositif_id;

            if (!empty($un_dossier->ops_dispositif_id) && $un_dossier->cloture == false) {
                $obj_dispositif = $this->beanManager->getBeanSafe($module_dispositif, $id_dispositif);

                // Les dispositifs non visible internet ne doivent pas s'afficher sur le portail 
                if ($obj_dispositif->visible_usager == true) {

                    $instruction = $this->getDossierInstruction($un_dossier);

                    // Vérification si le dossier est modifiable soit par la complétude soit par le statut
                    $modifiable = $un_dossier->incomplet;
                    if (!empty($un_dossier->ops_statut_id) && !$modifiable && !empty($instruction['statut_id'])) {
                        $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $un_dossier->ops_statut_id);
                        $modifiable = $obj_statut->modifiable_usager;
                        $retour_dossiers['filtres']['notifications'][$un_dossier->brouillon]['incomplet']['nombre'] += 1; 
                    }

                    $retour_dossiers['filtres']['dispositifs'][$un_dossier->brouillon][$obj_dispositif->id]['name'] = $obj_dispositif->name; 
                    $retour_dossiers['filtres']['dispositifs'][$un_dossier->brouillon][$obj_dispositif->id]['nombre'] += 1;

                    if( $un_dossier->justificatif_incomplet ){
                        $retour_dossiers['filtres']['notifications'][$un_dossier->brouillon]['justificatif']['nombre'] += 1;
                    }

                    if( $un_dossier->brouillon == "oui" ){
                        $retour_dossiers['filtres']['notifications'][$un_dossier->brouillon]['brouillon']['nombre'] += 1;
                    }
                    
                    $retour_dossiers['filtres']['nums_dossier'][$un_dossier->brouillon][] = $un_dossier->num_dossier;


                    $retour_dossiers['filtres']['profils'][$un_dossier->brouillon]["particulier"]['name'] = "Particulier"; 
                    $retour_dossiers['filtres']['profils'][$un_dossier->brouillon]["particulier"]['nombre'] += 1;
                    
                    #Vérification si le dossier est en attente sur la conversation
                    $SQL_Notification = "SELECT COUNT(`id`) AS `nouveaux_messages` FROM `ops_conversation` WHERE `parent_id` = '".$un_dossier->id."' AND `origin` ='agent' AND `statut` = 'nouveau' AND deleted=0;";

                    try {
                        $result_messages = $db->query($SQL_Notification);
                        while ($row_messages = $db->fetchByAssoc($result_messages)) {
                            $Message = (object) $row_messages;
                            if( $Message->nouveaux_messages > 0 ){
                                $retour_dossiers['filtres']['notifications'][$un_dossier->brouillon]['message']['nombre'] += 1;
                                $message_en_attente = $Message->nouveaux_messages;
                                break;
                            }
                        }

                    } catch (Exception $e) {}


                    $retour_dossiers['dossiers'][$un_dossier->num_dossier] = [

                        'id' => $un_dossier->id,
                        'numero' => $un_dossier->num_dossier,
                        'name' => $un_dossier->name,
                        'libelle' => $un_dossier->libelle,
                        'canal' => $un_dossier->canal,
                        'nom_demande' => $un_dossier->fetched_rel_row['ops_dispositif_ops_dossier_name'],
                        'date_creation' => $un_dossier->date_entered,
                        'date_transmission' => $un_dossier->date_transmission,
                        'demandeur' => !empty($un_dossier->ops_individu_id) ? DemandeurModel::getName($un_dossier->ops_individu_id, "OPS_individu") : "",
                        'beneficiaire' => !empty($un_dossier->beneficiaire_id) ? DemandeurModel::getName($un_dossier->beneficiaire_id, "OPS_individu") : "",
                        'beneficiaire_id' => $un_dossier->beneficiaire_id,
                        'profil' => $un_dossier->type_tiers,
                        'id_profil' => 'particulier',
                        'name_profil' => 'Particulier',
                        'entite' => 'particulier',
                        'etape' => $instruction['etape'],
                        'statut' => $instruction['statut'],
                        'couleur' => $instruction['couleur'],
                        'brouillon' => $un_dossier->brouillon,
                        'discussion' => '1',
                        'duplication' => '0',
                        'thematique' => $obj_dispositif->thematique,
                        'modifiable' => $modifiable,
                        'messages' => $message_en_attente,
                        'dispositif_id' => $id_dispositif

                    ];
                }
            }
        }


        // Récupération de tous  les profils liés à l'individu connecté 
        $obj_personne_morale = \BeanFactory::newBean("OPS_personne_morale");
        $liste_tiers = $obj_personne_morale->get_profil_by_individu($id_objet);



        // On boucle sur tous les profils pour récupérer les dossiers 
        foreach ($liste_tiers as $id => $profil) {

            $obj_dossier = \BeanFactory::newBean("OPS_dossier");
            $liste_dossiers = $obj_dossier->get_full_list('num_dossier', "ops_dossier.ops_personne_morale = '" . $id . "' && ops_dossier.name != 'TEMP' ");

            foreach ($liste_dossiers as $key => $un_dossier) {
                $un_dossier = $this->beanManager->getBeanSafe("OPS_dossier", $un_dossier->id);

                $module_dispositif = 'OPS_dispositif';
                $id_dispositif = $un_dossier->ops_dispositif_id;

                if (!empty($un_dossier->ops_dispositif_id) && $un_dossier->cloture == false) {
                    $obj_dispositif = BeanFactory::getBean($module_dispositif, $id_dispositif);

                    // Les dispositifs non visible internet ne doivent pas s'afficher sur le portail 
                    if ($obj_dispositif->visible_usager == true) {
                        // Récupération du demandeur 
                        $demandeur = $un_dossier->get_linked_beans('ops_individu_ops_dossier', 'ops_individu');

                        $beneficiaire = "";
                        // Récupération du bénéficiaire
                        if (!empty($un_dossier->beneficiaire_id) && $un_dossier->beneficiaire_id != 'undefined') {
                            $obj_indi = $this->beanManager->getBeanSafe("OPS_individu", $un_dossier->beneficiaire_id);
                            $beneficiaire = $obj_indi->full_name;
                        }

                        $instruction = $this->getDossierInstruction($un_dossier);

                        // Vérification si le dossier est modifiable soit par la complétude soit par le statut
                        $modifiable = $un_dossier->incomplet;
                        if (!empty($un_dossier->ops_statut_id) && !$modifiable && !empty($instruction['statut_id'])) {
                            $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $un_dossier->ops_statut_id);
                            $modifiable = $obj_statut->modifiable_usager;
                            $retour_dossiers['filtres']['notifications'][$un_dossier->brouillon]['incomplet']['nombre'] += 1; 
                        }

                        $retour_dossiers['filtres']['dispositifs'][$un_dossier->brouillon][$obj_dispositif->id]['name'] = $obj_dispositif->name; 
                        $retour_dossiers['filtres']['dispositifs'][$un_dossier->brouillon][$obj_dispositif->id]['nombre'] += 1;

                        $retour_dossiers['filtres']['profils'][$un_dossier->brouillon][$id]['name'] = $profil['name']; 
                        $retour_dossiers['filtres']['profils'][$un_dossier->brouillon][$id]['nombre'] += 1;

                        $retour_dossiers['filtres']['nums_dossier'][$un_dossier->brouillon][] = $un_dossier->num_dossier;
                        
                        if( $un_dossier->brouillon == "oui" ){
                            $retour_dossiers['filtres']['notifications'][$un_dossier->brouillon]['brouillon']['nombre'] += 1;
                        }

                        if( $un_dossier->justificatif_incomplet ){
                            $retour_dossiers['filtres']['notifications'][$un_dossier->brouillon]['justificatif']['nombre'] += 1;
                        }

                        #Vérification si le dossier est en attente sur la conversation
                        $SQL_Notification = "SELECT COUNT(`id`) AS `nouveaux_messages` FROM `ops_conversation` WHERE `parent_id` = '".$un_dossier->id."' AND `origin` ='agent' AND `statut` = 'nouveau';";

                        try {
                            $result_messages = $db->query($SQL_Notification);
                            while ($row_messages = $db->fetchByAssoc($result_messages)) {
                                $Message = (object) $row_messages;
                                if( $Message->nouveaux_messages > 0 ){
                                    $retour_dossiers['filtres']['notifications'][$un_dossier->brouillon]['message']['nombre'] += 1;
                                    $message_en_attente = $Message->nouveaux_messages;
                                    break;
                                }
                            }

                        } catch (Exception $e) {}

                        $retour_dossiers['dossiers'][$un_dossier->num_dossier] = [
                            'id' => $un_dossier->id,
                            'numero' => $un_dossier->num_dossier,
                            'libelle' => $un_dossier->libelle,
                            'canal' => $un_dossier->canal,
                            'nom_demande' => $un_dossier->fetched_rel_row['ops_dispositif_ops_dossier_name'],
                            'date_creation' => $un_dossier->date_entered,
                            'demandeur' => !empty($un_dossier->ops_individu_id) ? DemandeurModel::getName($un_dossier->ops_individu_id, "OPS_individu") : "",
                            'beneficiaire' => !empty($un_dossier->beneficiaire_id) ? DemandeurModel::getName($un_dossier->beneficiaire_id, "OPS_individu") : "",
                            'beneficiaire_id' => $un_dossier->beneficiaire_id,
                            'profil' => $profil['libelle_usager'],
                            'id_profil' => $id,
                            'name_profil' => $profil['name'],
                            'entite' => $profil['id_type'],
                            'etape' => $instruction['etape'],
                            'statut' => $instruction['statut'],
                            'couleur' => $instruction['couleur'],
                            'brouillon' => $un_dossier->brouillon,
                            'discussion' => '1',
                            'duplication' => '0',
                            'thematique' => $obj_dispositif->thematique,
                            'modifiable' => $modifiable,
                            'dispositif_id' => $id_dispositif
                        ];
                    }
                }
            }
        }

        krsort($retour_dossiers['dossiers']);

        // On retourne l'id du dossier
        $response = new DossierResponse();
        $response->setData($retour_dossiers);
        return $response;
    }

    /**
     * getDossiersuivi
     * @param DossierSuiviParams $params
     * @param $path
     * @return DossierResponse
     * @throws AccessDeniedException
     */
    public function getDossiersuivi(DossierSuiviParams $params, Request $request)
    {
        global $beanFiles, $db, $sugar_config;

        // On récupere les données
        $id_demandeur = $params->getId();
        $id_dossier = $params->getIdDossier();

        // On vérifie que l'id du demandeur n'est pas vide
        if (empty($id_demandeur)) {
            throw new Exception("L'id du demandeur est obligatoire", 401);
        }

        $dossier = BeanFactory::getBean('OPS_dossier', $id_dossier);

        // Vérification que l'usager connecté a le droit de d'accès sur le dossier
        // On regarde d'abord si la personne connectée est le demandeur ou le partenaire
        $vue = 'usager';

        if ($id_demandeur != $dossier->ops_individu_id) {
            if (DossierService::verif_liaison_avis($id_demandeur, $dossier->id)) {

                $vue = 'partenaire';

            } else if (!DossierService::verif_liaison_profil($id_demandeur, $dossier->ops_personne_morale)) {
                // Vérification par le profil
                $response = new JustificatifResponse();
                $response->setData(["erreur" => "Vous n'avez pas accès à ce dossier"]);
                return $response;
            }
        } else if ($dossier->flag_partenaire) {
            $vue = 'partenaire';
        }

        // Récupération du dispositif lié au dossier pour récupérer le guide d'instruction
        $dispositifs = $dossier->get_linked_beans('ops_dispositif_ops_dossier', 'OPS_dispositif');
        $dispositif = (is_array($dispositifs) && count($dispositifs) == 1) ? $dispositifs[0] : false;

        // Récupération du guide d'instruction
        $guide_instructions = ($dispositif !== false) ? $dispositif->get_linked_beans('ops_guide_instruction_ops_dispositif', 'OPS_guide_instruction') : array();
        $guide_instruction = (is_array($guide_instructions) && count($guide_instructions) == 1) ? $guide_instructions[0] : false;

        // Récupération de la liste des étapes du guide d'instruction
        $visible_usager = true;  // Récupération uniquement des étapes visibles par l'usager 
        $liste_des_etapes = ($guide_instruction !== false) ? $guide_instruction->liste_etapes($visible_usager, $vue) : array();

        // Récupération de l'étape courante pour ne pas afficher les étapes suivantes ou on aurait pu revenir en arrière
        $instruction = $this->getDossierInstruction($dossier, $vue);
        $etape_courante = BeanFactory::getBean('OPS_etape', $instruction['etape_id']);

        // Récupération des status passés 
        $tab_historiques = $dossier->get_linked_beans('ops_historisation_ops_dossier', 'OPS_historisation', 'date_modified', 0, -1, 0, "flag_retour = '1'");
        $tabhisto = array("Tableau historisation");

        $str_workflow = ""; // Init HTML Workflow code.

        $OPS_dossier_history = array();
        $dossier_tab_history = $tab_historiques;

        foreach ($dossier_tab_history as $key => $historisation) {

            // Si l'étape n'est pas visible on boucle 
            $obj_etape = $this->beanManager->getBeanSafe("OPS_etape", $historisation->ops_etape_id);

            if ($vue == 'usager') {
                if ($obj_etape->visible_usager == true) {
                    $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $historisation->ops_statut_id);

                    // Si le statut est visible usager => on retourne le statut et l'étape courant 
                    if ($obj_statut->visible_usager == true) {
                        $_history = array(
                            'id' => $historisation->id,
                            'date_entered' => $historisation->date_entered,
                            'date_modified' => $historisation->date_modified,
                            'ops_statut_id' => $historisation->ops_statut_id,
                            'statut' => $historisation->statut,
                            'ops_etape_id' => $historisation->ops_etape_id,
                            'etape' => $historisation->etape
                        );

                        $step_pointer = $historisation->ops_etape_id;
                        $OPS_dossier_history[$step_pointer] = $_history;
                    }
                }
            } else if ($vue == 'partenaire') {
                if ($obj_etape->visible_partenaire == true) {
                    $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $historisation->ops_statut_id);

                    // Si le statut est visible partenaire => on retourne le statut et l'étape courant 
                    if ($obj_statut->visible_partenaire == true) {
                        $_history = array(
                            'id' => $historisation->id,
                            'date_entered' => $historisation->date_entered,
                            'date_modified' => $historisation->date_modified,
                            'ops_statut_id' => $historisation->ops_statut_id,
                            'statut' => $historisation->statut,
                            'ops_etape_id' => $historisation->ops_etape_id,
                            'etape' => $historisation->etape
                        );

                        $step_pointer = $historisation->ops_etape_id;
                        $OPS_dossier_history[$step_pointer] = $_history;
                    }
                }
            }
        }

        $str_workflow .= '<div class="align-items-center d-flex justify-content-between" role="dossier-workflow">';

        $total_steps = count($liste_des_etapes);
        $focused_step = 0;
        $has_picto = false;
        $finished = false;
        $completed = false;
        $decorate = true;

        //Pour les actions de statut où on saute des étapes
        if (count($OPS_dossier_history) > 1) {
            $last_before_current = current(array_slice($OPS_dossier_history, -2, 1));

            foreach ($liste_des_etapes as $k => $value) {
                if ($value['id'] == $etape_courante->id) {
                    $my_key = $k;
                }
                if ($value['id'] == $last_before_current['ops_etape_id']) {
                    $last_key = $k;
                }
            }

            for ($i = $my_key + 1; $i <= count($liste_des_etapes); $i++) {
                foreach ($OPS_dossier_history as $k => $value) {
                    if ($value['ops_etape_id'] == $liste_des_etapes[$i]['id']) {
                        unset($OPS_dossier_history[$k]);
                    }
                }
            }

            $last_id = $liste_des_etapes[$last_key]['id'];

            for ($j = $last_key + 1; $j < $my_key; $j++) {
                $_history = array(
                    'by_pass' => true,
                    'ops_statut_id' => $OPS_dossier_history[$last_id]['ops_statut_id'],
                    'ops_etape_id' => $liste_des_etapes[$j]['id'],
                    'etape' => $liste_des_etapes[$j]['name']
                );

                $step_pointer = $liste_des_etapes[$j]['id'];
                $OPS_dossier_history[$step_pointer] = $_history;
            }
        }

        $dossiers_history = $OPS_dossier_history;
        if (is_array($OPS_dossier_history) && count($OPS_dossier_history) > 1) {
            $dossiers_history = array_values($dossiers_history);
            $pres_value = $dossiers_history[0];

            $OPS_dossier_history_new = $OPS_dossier_history;

            for ($i = 1; $i < count($dossiers_history); ++$i) {
                $dossier_history = $dossiers_history[$i];

                if (!isset($dossier_history['ops_etape_id']) || empty($dossier_history['ops_etape_id'])) {
                    continue;
                }

                $obj_etape = BeanFactory::getBean('OPS_etape', $dossier_history['ops_etape_id']);
                if (empty($obj_etape->ops_etape_id)) {
                    continue;
                }

                $obj_etape_pres = BeanFactory::getBean('OPS_etape', $obj_etape->ops_etape_id);

                $count = $i - 1;
                $ops_statut_id = $pres_value['ops_statut_id'];
                while (($obj_etape_pres->id != $dossiers_history[$i - 1]['ops_etape_id']) || empty($obj_etape_pres->id) || $count < 0) {
                    if (!array_key_exists($obj_etape_pres->id, $OPS_dossier_history_new)) {
                        $_history = array(
                            'by_pass' => true,
                            'ops_statut_id' => $ops_statut_id,
                            'ops_etape_id' => $obj_etape_pres->id,
                            'etape' => $obj_etape_pres->name,
                        );

                        $OPS_dossier_history_new[$obj_etape_pres->id] = $_history;

                        $obj_etape = $obj_etape_pres;

                        if (empty($obj_etape_pres->ops_etape_id)) {
                            break;
                        }
                        $obj_etape_pres = BeanFactory::getBean('OPS_etape', $obj_etape_pres->ops_etape_id);

                        $count = $count - 1;
                    } else {
                        break;
                    }

                }

                if (!empty($dossier_history['ops_statut_id'])) {
                    $pres_value = $dossier_history;
                }
            }

            $last_etape = array_search($my_key, array_keys($liste_des_etapes)) + 1;
            $etapes_non_passer = array_slice($liste_des_etapes, $last_etape, count($liste_des_etapes) - $last_etape);

            foreach ($etapes_non_passer as $etape) {
                if (array_key_exists($etape['id'], $OPS_dossier_history_new)) {
                    unset($OPS_dossier_history_new[$etape['id']]);
                }
            }

            $OPS_dossier_history = $OPS_dossier_history_new;
        }


        foreach ($liste_des_etapes as $k => $value) {

            $extra = '';

            $obj_statut = BeanFactory::getBean('OPS_statut', $dossier->ops_statut_id);

            $current_step = ($value['id'] == $dossier->ops_etape_id) ? true : false;

            $step_status_name = $OPS_dossier_history[$value['id']]['statut'];

            $step_statut_id = $OPS_dossier_history[$value['id']]['ops_statut_id'];
            $step_obj_statut = BeanFactory::getBean('OPS_statut', $step_statut_id);
            $step_code_couleur = (!empty($step_obj_statut->id)) ? $step_obj_statut->code_couleur : 'rgba(0, 0, 0, 0.1)';
            $phase_code_couleur = (!empty($step_obj_statut->id)) ? $step_obj_statut->code_couleur : 'rgba(0, 0, 0, 0.05)';

            $step_date_modified = $OPS_dossier_history[$value['id']]['date_modified'];

            if ($OPS_dossier_history[$value['id']]['by_pass']) {
                $step_coloration = ' style="background-color:' . $step_code_couleur . ';" ';
                $phase_coloration = ' style="background: repeating-linear-gradient(45deg, transparent, transparent 10px, rgba(255, 255, 255, 0.15) 10px, rgba(255, 255, 255, 0.15) 20px); background-color:' . $phase_code_couleur . '"';
            } else {
                $step_coloration = ' style="background-color:' . $step_code_couleur . ';" ';
                $phase_coloration = ' style="background-color:' . $phase_code_couleur . ';" ';
            }

            // TODO ! Do not decorate phase until step is not effective passed.
            #   $dossier->ops_etape_id
            #   $dossier->ops_statut_id

            if ($decorate) {
                /* Allows CSS coloration and Label status  */
            } else {
                /* no longer labelized */
                $step_coloration = '';
                $step_status_name = '';
            }

            $labelClass = '';


            if ($current_step /*current step ?*/) {

                if ($has_picto) {
                    $labelClass .= 'class="label-current"';
                    $extra .= ' current fa fa-archive ';
                    $has_picto = false;
                    $decorate = false;
                    $phase_coloration = '';
                } else {

                    if ($obj_statut->avancement == 'suivant') {
                        $has_picto = true;
                        $decorate = false;
                    } elseif ($obj_statut->avancement == 'courant') {
                        $has_picto = false;
                        $labelClass .= 'class="label-current"';
                        $extra .= ' current fa fa-archive ';
                        $decorate = false;
                        $phase_coloration = '';
                    } else { // 'termine'
                        $has_picto = false;
                        $labelClass .= 'class="label-current"';
                        $extra .= ' current  fa fa-archive ';
                        $finished = true;
                        $decorate = false;
                        if ($focused_step >= $total_steps - 1) {
                            $extra .= ' successful ';
                        } else {
                            $extra .= ' premature ';
                            $phase_coloration = '';
                        }
                    }
                }
            } else {
                if ($has_picto) {
                    $labelClass .= 'class="label-current"';
                    $extra .= ' current fa fa-archive ';
                    $has_picto = false;
                    $decorate = false;
                    $phase_coloration = '';
                }
            }

            //Si le dossier est terminé
            if ($k == end(array_keys($liste_des_etapes)) && $obj_statut->avancement == 'termine') {
                $extra = ' fa fa-times ';
                $extra .= ' failed ';
                $extra .= ' current ';
            }

            $str_workflow .= '<div class="step-label" ><label ' . $labelClass . '>' . $value['libelle_usager'] . '</label>';
            $str_workflow .= '<div class="step-circle ' . $extra . '" ' . $step_coloration . ' data-step-id="' . $value['id'] . '" ><span>' . $value['libelle_usager'] . '</span></div></div>';
            if (array_key_last($liste_des_etapes) != $k) {
                $str_workflow .= '<div class="flex-grow step-phase" data-step-name="' . $value['libelle_usager'] . '" ' . $phase_coloration . ' ></div>';
            }
        }

        // / [role="dossier-workflow"]
        $str_workflow .= '</div>';

        //récupération du suivi
        $suivi = $dossier->get_linked_beans('ops_dossier_ops_suivi_dossier', 'OPS_suivi_dossier', "num_ordre ASC");

        $liste_suivi = array();

        foreach ($suivi as $key => $valeur) {
            $tab_suivi = array();
            $tab_suivi = [
                'id' => $valeur->id,
                'num_ordre' => $valeur->db->priority,
                'name' => $valeur->name,
                'description' => $valeur->description,
                'visible_front' => $valeur->fetched_row['visible_front'],
                'icone' => $valeur->fetched_row['icone']

            ];

            $liste_suivi[] = $tab_suivi;
        }

        // Récupération de la sollicitation dans le cas d'un dossier partenaire
        if ($vue == 'partenaire') {

            $requete = $db->query(
                "
            SELECT distinct ops_dossier_ops_avis.ops_avis_id as id
            FROM ops_dossier_ops_avis, ops_avis, ops_dossier
            WHERE ops_avis.individu_id = '" . $id_demandeur . "'
            AND ops_avis.id = ops_dossier_ops_avis.ops_avis_id
            AND ops_dossier.id = ops_dossier_ops_avis.ops_dossier_id
            AND ops_dossier.id = '" . $dossier->id . "'
            AND ops_avis.deleted = 0
            AND ops_dossier_ops_avis.deleted = 0
            ORDER BY ops_avis.date_entered DESC"
            );

            $tab_avis_id = [];

            while ($row = $db->fetchRow($requete)) {
                $tab_avis_id[] = $row['id'];
            }

            if (!empty($tab_avis_id)) {
                try {
                    $obj_avis = $this->beanManager->getBeanSafe("OPS_avis", $tab_avis_id[0]);
                } catch (\Exception $exception) {
                    throw new Exception('erreur dans la réucpération de l\'avis', 401);
                }

                $sollicitation = $obj_avis->sollicitation;
            } else if ($id_demandeur == $dossier->ops_individu_id && $dossier->flag_partenaire) {

                $sollicitation = 'complement';
            }

        } else {

            $sollicitation = '';
        }

        // Vérification si le dossier est modifiable soit par la complétude soit par le statut
        $modifiable = $dossier->incomplet;
        if (!empty($dossier->ops_statut_id) && !$modifiable) {
            $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $dossier->ops_statut_id, array(), 0);
            if ($vue == 'partenaire') {
                if ($sollicitation == 'complement' || $sollicitation == 'avis_complement')
                    $modifiable = $obj_statut->modifiable_partenaire;
            } else {
                $modifiable = $obj_statut->modifiable_usager;
            }
        }

        $informations_dossier = array();
        $informations_dossier = [
            'dossier_id' => $dossier->id,
            'dispositif_id' => $dossier->ops_dispositif_id,
            'statut' => $instruction['statut'],
            'brouillon' => $dossier->brouillon,
            'dossier_name' => $dossier->name,
            'brouillon' => $dossier->brouillon,
            'etape' => $instruction['etape'],
            'dispositif_name' => $dossier->ops_dispositif_ops_dossier_name,
            'profil_name' => !empty($dossier->ops_personne_morale) ? DemandeurModel::getName($dossier->ops_personne_morale, "OPS_personne_morale") : "",
            'beneficiaire_name' => !empty($dossier->beneficiaire_id) ? DemandeurModel::getName($dossier->beneficiaire_id, "OPS_individu") : "",
            'demandeur_name' => !empty($dossier->ops_individu_id) ? DemandeurModel::getName($dossier->ops_individu_id, "OPS_individu") : "",
            'modifiable' => $modifiable,
            'type_tiers' => $dossier->type_tiers,
            'nom_entite' => $dossier->type_tiers,
            'num_dossier' => $dossier->num_dossier,
            'html' => $str_workflow,
            'sollicitation' => $sollicitation,
            'suivi' => $liste_suivi,
            'liste_etape' => $liste_des_etapes
        ];

        // Un récupère les valeurs des champs liés au bénéficiaire dans le cas d'un dossier partenaire
        if ($vue == 'partenaire') {
            $beneficiaire_name = '';
            $champs = json_decode(base64_decode($dossier->champs_custom));

            if (!empty($champs->raison_sociale_beneficiaire))
                $beneficiaire_name .= $champs->raison_sociale_beneficiaire;
            if (!empty($champs->nom_beneficiaire) || !empty($champs->prenom_beneficiaire))
                $beneficiaire_name .= ' : ';
            if (!empty($champs->nom_beneficiaire))
                $beneficiaire_name .= $champs->nom_beneficiaire;
            if (!empty($champs->nom_beneficiaire) && !empty($champs->prenom_beneficiaire))
                $beneficiaire_name .= ' ';
            if (!empty($champs->prenom_beneficiaire))
                $beneficiaire_name .= $champs->prenom_beneficiaire;

            if ($beneficiaire_name == '')
                $beneficiaire_name = !empty($dossier->ops_individu_id) ? DemandeurModel::getName($dossier->beneficiaire_id, "OPS_individu") : '';

            $informations_dossier['beneficiaire_name'] = $beneficiaire_name;
        } else {
            $informations_dossier['beneficiaire_name'] = !empty($dossier->beneficiaire_id) ? DemandeurModel::getName($dossier->beneficiaire_id, "OPS_individu") : "";
        }


        # Complement Implémentation #2526 Onglet [Suivi]
        $dispositif = $this->beanManager->getBeanSafe("OPS_dispositif", $dossier->ops_dispositif_id);

        $informations_dossier["flag_valeur_1"] = $dispositif->flag_valeur_1;
        $informations_dossier["flag_valeur_2"] = $dispositif->flag_valeur_2;
        $informations_dossier["flag_valeur_3"] = $dispositif->flag_valeur_3;


        return $informations_dossier;
    }

    /**
     * getFormByEtape
     * @param DossierSetParams $params
     * @param $path
     * @return DossierResponse
     * @throws AccessDeniedException
     */
    public function getFormByEtape(DossierSetParams $params, Request $request)
    {
        global $db, $sugar_config;
        // On récupere les données
        $donnees = $params->getData();

        // On vérifie que "form_type" n'est pas vide 
        if (empty($donnees["form_type"])) {
            throw new Exception("Le parametre 'form_type' est obligatoire", 401);
        }

        // On vérifie que "form_type" est égal à creation ou edition ou detail
        if (!in_array($donnees["form_type"], ["creation", "edition", "detail"])) {
            throw new Exception("Le parametre 'form_type' doit etre égal à une des valeurs : 'creation', 'edition' ou 'detail' ", 401);
        }

        // On récupére le type de formulaire à retourner et on le supprime du tableau de données
        $form_type = $donnees["form_type"];
        unset($donnees["form_type"]);

        // On vérifie que l'id dossier n'est pas vide si il s'agit d'une vue de type "edition" ou "detail"
        if ($form_type !== "creation" && empty($donnees["dossier_id"])) {
            $response = new DossierResponse();
            $response->setData(["erreur" => "Les paramètres sont incorrects"]);
            return $response;
        }

        // On vérifie que le dossier existe si il s'agit d'une vue de type "edition" ou "detail"
        $obj_dossier = (!empty($donnees["dossier_id"])) ? BeanFactory::getBean('OPS_dossier', $donnees["dossier_id"]) : false;
        if ($form_type !== "creation" && empty($obj_dossier->id)) {
            // Vérification par le profil
            $response = new DossierResponse();
            $response->setData(["erreur" => "Le dossier n'existe pas"]);
            return $response;
        }

        $dispositif = $this->beanManager->getBeanSafe("OPS_dispositif", $donnees["dispositif_id"]);

        // Vérification d'accès au dispositif dans le cadre d'une édition ( vérif saison )
        if ($form_type == "creation") {

            $is_ouvert = $this->verif_saison($dispositif);

            if (!$is_ouvert) {
                // Vérification par le profil
                $response = new DossierResponse();
                $response->setData(["erreur" => "Ce dispositif est temporairement désactivé ou n'est pas disponible pour le moment."]);
                return $response;
            }
        }

        if ($form_type == "edition") {

            $dispositif = $this->beanManager->getBeanSafe("OPS_dispositif", $donnees["dispositif_id"]);

            $is_ouvert = $this->verif_saison($dispositif);

            if (!$is_ouvert && $obj_dossier->incomplet == false) {
                // Vérification par le profil
                $response = new DossierResponse();
                $response->setData(["erreur" => "Vous ne pouvez plus modifier ce brouillon car le formulaire correspondant n'est plus disponible"]);
                return $response;
            }
        }



                // Vérification que l'usager connecté a le droit de modification sur le dossier 
        // Si l'usager connecté à une vue partenaire, on regarde si le dossier est accessible. S'il n'est pas le demandeur => on vérifie si il est lié au profil 
        //$GLOBALS['log']->fatal('$obj_dossier ' . print_r($obj_dossier, true));

        if (array_key_exists('vue', $donnees) && $donnees['vue'] == 'partenaire') {
            if (isset($donnees['pere_id']) && !empty($donnees['pere_id'])) {
                $obj_dossier->load_relationship('ops_dossier_ops_dossier_paiement');
                $dossier_pere_paiement = $obj_dossier->ops_dossier_ops_dossier_paiement->get();

                if (!in_array($donnees["pere_id"], $dossier_pere_paiement)) {
                    $response = new DossierResponse();
                    $response->setData(["erreur" => "Vous n'avez pas accès à ce dossier"]);
                    return $response;
                }

                $dossier_pere = $this->beanManager->getBeanSafe("OPS_dossier", $donnees["pere_id"]);

                // Vérification s'il est lié à une sollicitation ou flag partenaire
                if ((!DossierService::verif_liaison_avis($donnees['partenaire_id'], $dossier_pere->id)) && !($donnees['partenaire_id'] == $dossier_pere->ops_individu_id && $dossier_pere->flag_partenaire)) {
                    $response = new DossierResponse();
                    $response->setData(["erreur" => "Vous n'avez pas accès à ce dossier"]);
                    return $response;
                }
            } else {
                // Vérification s'il est lié à une sollicitation ou flag partenaire
                if ((!DossierService::verif_liaison_avis($donnees['partenaire_id'], $obj_dossier->id)) && !($donnees['partenaire_id'] == $obj_dossier->ops_individu_id && $obj_dossier->flag_partenaire)) {
                    $response = new DossierResponse();
                    $response->setData(["erreur" => "Vous n'avez pas accès à ce dossier"]);
                    return $response;
                }
            }


            //On vérifie si c'est un dossier partenaire que le staut est visible
            $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $obj_dossier->ops_statut_id);
            if ($obj_statut->visible_partenaire == 0) {
                $response = new DossierResponse();
                $response->setData(["erreur" => "Le dossier est actuellement sur un statut auquel vous n'avez pas accès"]);
                return $response;
            }

            $donnees['demandeur_id'] = $obj_dossier->ops_individu_id;
        } else if ($donnees['demandeur_id'] != $obj_dossier->ops_individu_id && $form_type !== "creation") {
            if (!DossierService::verif_liaison_profil($donnees['demandeur_id'], $obj_dossier->ops_personne_morale)) {
                // Vérification par le profil
                $response = new DossierResponse();
                $response->setData(["erreur" => "Vous n'avez pas accès à ce dossier"]);
                return $response;
            }
        }

        // Vérification que le dossier soit en brouillon 
        if ($obj_dossier->brouillon == "non" && $obj_dossier->incomplet == false && $form_type != "detail") {
            $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $obj_dossier->ops_statut_id);
            if ((array_key_exists('vue', $donnees) && $donnees['vue'] == 'partenaire')) {
                if (!$obj_statut->modifiable_partenaire) {
                    $response = new DossierResponse();
                    $response->setData(["erreur" => "Le dossier est en cours de traitement par nos services."]);
                    return $response;
                }
            } else if (!$obj_statut->modifiable_usager) {
                $response = new DossierResponse();
                $response->setData(["erreur" => "Le dossier est en cours de traitement par nos services."]);
                return $response;
            }
        }

        // On vérifie les données recus 
        $verification_donnees = $this->getDataFormByEtape($donnees);
        if ($verification_donnees["statut"] === "err") {
            throw new Exception('Données invalides : ' . $verification_donnees["data"], 401);
        }

        // On récupere les données formatées et on ajoute le parametre "création"
        $donnees_formated = $verification_donnees["data"];
        $donnees_formated["vue"]["creation"] = ($form_type === "creation") ? "true" : "false";

        $donnees_formated["dispositif"]["canal"] = $donnees['canal'];
        $editable = true;

        // On initilise OdeFormFactory selon le type de form
        if ($form_type === "creation") {
            // Ajout du bénéficiaire et PM 
            $donnees_formated['ops_personne_morale'] = $donnees['ops_personne_morale'];
            $donnees_formated['brouillon'] = true;
            $donnees_formated['beneficiaire_id'] = $donnees['beneficiaire_id'];

            // On récupere l'id du dossier 
            if (empty($obj_dossier->id)) {
                $dossier_id = OPS_dossier::createDossierByEtape($donnees_formated);
                $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);

                // #3172 : num_dossier non récupéré - Impossible via un bean à cause de l'auto incremente
                $requete = $db->query("SELECT id, num_dossier from ops_dossier where id='" . $obj_dossier->id . "' ");
                $rowResults = array();
                while ($row = $db->fetchRow($requete)) {
                    $num_dossier = $row['num_dossier'];
                }
                $obj_dossier->num_dossier = $num_dossier;
            }
        } else if ($form_type === "edition") {
            $donnees_formated['ops_personne_morale'] = $obj_dossier->ops_personne_morale;
            $donnees_formated['brouillon'] = $obj_dossier->brouillon;
            $donnees_formated['beneficiaire_id'] = $obj_dossier->beneficiaire_id;
        } else if ($form_type === "detail") {
            $donnees_formated['ops_personne_morale'] = $obj_dossier->ops_personne_morale;
            $donnees_formated['beneficiaire_id'] = $obj_dossier->beneficiaire_id;
            $donnees_formated['brouillon'] = $obj_dossier->brouillon;
            $donnees["demandeur"]["id"] = $obj_dossier->ops_individu_id;
            $editable = false;
        }

        $formFactory = new OdeFormFactory($obj_dossier, $editable, $donnees_formated);

        // On récupere les etapes ( On parle d'onglet coté générateur )
        $vue = ($donnees['vue'] == '') ? 'usager' : $donnees['vue'];
        $etapes = $formFactory->getEtapes($vue);
        // Vérification des conditions
        if (isset($etapes[$donnees_formated["etape_ordre"]])) {
            $ordre = $donnees_formated["etape_ordre"];
        } else {
            $ordre = $donnees_formated["etape_ordre"];
            $fin = true;
            foreach ($etapes as $key => $etape) {
                $ordre = $ordre + 1;
                if (!isset($etapes[$ordre])) {
                    continue;
                } else {
                    $fin = false;
                    break;
                }
            }
        }
        // On réécrit le construct pour la gestion de la modification 
        if ($etapes[$ordre]['modifiable'] == false) {
            $formFactory = new OdeFormFactory($obj_dossier, false, $donnees_formated);
        }

        $etape_html = $formFactory->getEtapeHtml($etapes[$ordre]['ordre']);



        // On récupere certaines données complementaires
        $infos = $this->getDataCompltFormByEtape($obj_dossier, $etapes, $dossier_id, $donnees);


        # Complement Implémentation #2526 Onglet [response]
        if ($form_type === "detail") {

            $infos["flag_valeur_1"] = $dispositif->flag_valeur_1;
            $infos["flag_valeur_2"] = $dispositif->flag_valeur_2;
            $infos["flag_valeur_3"] = $dispositif->flag_valeur_3;
        }

        // Gestion de la fin du formulaire si conditionné 
        if ($fin === true) {

            $brouillon = $obj_dossier->brouillon;

            $obj_dossier->name = (!empty($obj_dossier->libelle_dossier)) ? $obj_dossier->num_dossier . " - " . $obj_dossier->libelle_dossier : $obj_dossier->num_dossier;
            $obj_dossier->brouillon = "non";
            $obj_dossier->save();

            // Récupération du dispositif lié au dossier pour récupérer le guide d'instruction
            $dispositifs = $obj_dossier->get_linked_beans('ops_dispositif_ops_dossier', 'OPS_dispositif');
            $dispositif = (is_array($dispositifs) && count($dispositifs) == 1) ? $dispositifs[0] : false;

            $obj_statut = BeanFactory::getBean('OPS_statut', $obj_dossier->ops_statut_id);

            // Gestion d'un dossier incomplet  && existe un statut de complétude mise à jour du dossier 
            if ( /* $obj_dossier->incomplet == true &&*/$brouillon == 'non' && !empty($obj_statut->ops_statut_completude_id)) {

                $template = $sugar_config['opensocle']['notif_usager_dossier_modification'];
                if (isset($template) && !empty($template)) {

                    $obj_individu = $this->beanManager->getBeanSafe("OPS_individu", $obj_dossier->ops_individu_id);

                    # On initialise le mailer 
                    $mailer = new OdeMailer();

                    # On initialise l'email 
                    $ode_email = new OdeEmail([
                        'bean_source_id' => $obj_dossier->id,
                        'bean_source_name' => 'OPS_dossier',
                        'bean_historisation_id' => $obj_dossier->ops_individu_id,
                        'bean_historisation_name' => 'OPS_individu',
                        'email_template_id' => $template,
                        'dest_to' => $obj_individu->email1,
                    ]);

                    # On déclenche l'envoie
                    $mailer->send($ode_email);
                } else {
                    $GLOBALS['log']->fatal("OPS_dossier - sendNotification : Pas te template mail associé à la création d'un dossier");
                }


                $obj_dossier->updateStatut($obj_statut->ops_statut_completude_id);
                $obj_dossier->save();

                // Notification dans la cloche à l'agent 
                $user_id = $obj_dossier->assigned_user_id;
                $obj_user = BeanFactory::getBean('Users', $user_id);

                $alert = BeanFactory::newBean('Alerts');
                $alert->name = 'Dossier complété';
                $alert->description = 'Dossier numéro :' . $obj_dossier->num_dossier;
                $alert->url_redirect = 'index.php?module=OPS_dossier&action=DetailView&record=' . $obj_dossier->id;
                $alert->assigned_user_id = $obj_user->id;
                $alert->type = 'info';
                $alert->is_read = 0;
                $alert->save();

            } elseif (empty($obj_dossier->ops_statut_id)) {

                // Initialisation du statut et de l'étape du dossier
                $obj_dossier = OPS_dossier::initStatutEtapeDossier($obj_dossier, $dispositif->id);
                $obj_dossier->save();

                $template = $sugar_config['opensocle']['notif_usager_dossier_creation'];
                if (isset($template) && !empty($template)) {
                    $obj_individu = $this->beanManager->getBeanSafe("OPS_individu", $obj_dossier->ops_individu_id);

                    # On initialise le mailer 
                    $mailer = new OdeMailer();

                    # On initialise l'email 
                    $ode_email = new OdeEmail([
                        'bean_source_id' => $obj_dossier->id,
                        'bean_source_name' => 'OPS_dossier',
                        'bean_historisation_id' => $obj_dossier->ops_individu_id,
                        'bean_historisation_name' => 'OPS_individu',
                        'email_template_id' => $template,
                        'dest_to' => $obj_individu->email1,
                    ]);

                    # On déclenche l'envoie
                    $mailer->send($ode_email);

                } else {
                    $GLOBALS['log']->fatal("OPS_dossier - sendNotification : Pas te template mail associé à la création d'un dossier");
                }

            }

        }




        $response = new DossierResponse();
        $response->setData(["infos" => $infos, "etapes" => $etapes, "etape_html" => base64_encode($etape_html), "fin" => $fin]);

        return $response;
    }

    private function getDataCompltFormByEtape($obj_dossier, $etapes, $dossier_id, $donnees)
    {
        $obj_dispositif = BeanFactory::getBean('OPS_dispositif', $donnees["dispositif_id"]);


        // Récupération du type de profil associé au dossier             
        $id_type = "";
        if (!empty($obj_dossier->ops_personne_morale)) {
            $obj_personne = $this->beanManager->getBeanSafe('OPS_personne_morale', $obj_dossier->ops_personne_morale);
            if (!empty($obj_personne->id)) {
                $id_type = $obj_personne->ops_type_personne_id;
            }
        }

        // Récupération de la sollicitation dans le cas d'un dossier partenaire
        if (array_key_exists('vue', $donnees) && $donnees['vue'] == 'partenaire') {
            if (isset($donnees['pere_id']) && !empty($donnees['pere_id'])) {
                $obj_dossier->load_relationship('ops_dossier_ops_dossier_paiement');
                $dossier_pere_paiement = $obj_dossier->ops_dossier_ops_dossier_paiement->get();

                if (!in_array($donnees["pere_id"], $dossier_pere_paiement)) {
                    $response = new DossierResponse();
                    $response->setData(["erreur" => "Vous n'avez pas accès à ce dossier"]);
                    return $response;
                }

                $dossier_pere = $this->beanManager->getBeanSafe("OPS_dossier", $donnees["pere_id"]);

                // Vérification s'il est lié à une sollicitation ou flag partenaire
                if ((!DossierService::verif_liaison_avis($donnees['partenaire_id'], $dossier_pere->id)) && !($donnees['partenaire_id'] == $dossier_pere->ops_individu_id && $dossier_pere->flag_partenaire)) {
                    $response = new DossierResponse();
                    $response->setData(["erreur" => "Vous n'avez pas accès à ce dossier"]);
                    return $response;
                }
            } else {
                // Vérification s'il est lié à une sollicitation ou flag partenaire
                if ((!DossierService::verif_liaison_avis($donnees['partenaire_id'], $obj_dossier->id)) && !($donnees['partenaire_id'] == $obj_dossier->ops_individu_id && $obj_dossier->flag_partenaire)) {
                    $response = new DossierResponse();
                    $response->setData(["erreur" => "Vous n'avez pas accès à ce dossier"]);
                    return $response;
                }
            }

            try {
                $obj_avis = $this->beanManager->getBeanSafe("OPS_avis", $donnees['avis_id']);
            } catch (\Exception $exception) {
                throw new Exception('erreur dans la réucpération de l\'avis', 401);
            }

            $sollicitation = $obj_avis->sollicitation;
        } else {
            $sollicitation = '';
        }

        // Vérification si le dossier est modifiable soit par la complétude soit par le statut
        $modifiable = $obj_dossier->incomplet;

        if (!empty($obj_dossier->ops_statut_id) && !$modifiable) {
            $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $obj_dossier->ops_statut_id, array(), 0);
            if (array_key_exists('vue', $donnees) && $donnees['vue'] == 'partenaire') {
                if ($sollicitation == 'complement' || $sollicitation == 'avis_complement')
                    $modifiable = $obj_statut->modifiable_partenaire;
            } else {
                $modifiable = $obj_statut->modifiable_usager;
            }
        }

        $tab = [
            'dossier_id' => $obj_dossier->id,
            'dossier_num' => $obj_dossier->num_dossier,
            'demandeur_id' => $obj_dossier->ops_individu_id,
            'demandeur_nom' => !empty($obj_dossier->ops_individu_id) ? DemandeurModel::getName($obj_dossier->ops_individu_id, "OPS_individu") : "",
            'ops_personne_morale' => $obj_dossier->ops_personne_morale,
            'profil_type_id' => $id_type,
            'beneficiaire_id' => $obj_dossier->beneficiaire_id,
            'demandeur_type' => $obj_dossier->type_tiers,
            'dispositif_id' => $donnees["dispositif_id"],
            'dispositif_nom' => $obj_dispositif->name,
            'etape_nb' => count($etapes),
            'etape_numero' => $donnees["etape_ordre"],
            'modifiable' => $modifiable,
            'sollicitation' => $sollicitation,
            'brouillon' => $obj_dossier->brouillon,
            'etape_description' => (is_array($etapes[$donnees["etape_ordre"]]) && !empty($etapes[$donnees["etape_ordre"]]["description"])) ? $etapes[$donnees["etape_ordre"]]["description"] : "",
        ];

        $tab['profil_name'] = !empty($obj_dossier->ops_personne_morale) ? DemandeurModel::getName($obj_dossier->ops_personne_morale, "OPS_personne_morale") : "";

        // Un récupère les valeurs des champs liés au bénéficiaire dans le cas d'un dossier partenaire
        if (array_key_exists('vue', $donnees) && $donnees['vue'] == 'partenaire') {
            $beneficiaire_name = '';
            $champs = json_decode(base64_decode($obj_dossier->champs_custom));

            if (!empty($champs->raison_sociale_beneficiaire))
                $beneficiaire_name .= $champs->raison_sociale_beneficiaire;
            if (!empty($champs->nom_beneficiaire) || !empty($champs->prenom_beneficiaire))
                $beneficiaire_name .= ' : ';
            if (!empty($champs->nom_beneficiaire))
                $beneficiaire_name .= $champs->nom_beneficiaire;
            if (!empty($champs->nom_beneficiaire) && !empty($champs->prenom_beneficiaire))
                $beneficiaire_name .= ' ';
            if (!empty($champs->prenom_beneficiaire))
                $beneficiaire_name .= $champs->prenom_beneficiaire;

            if ($beneficiaire_name == '')
                $beneficiaire_name = !empty($obj_dossier->ops_individu_id) ? DemandeurModel::getName($obj_dossier->beneficiaire_id, "OPS_individu") : '';

            $tab['beneficiaire_name'] = $beneficiaire_name;
        } else {
            $tab['beneficiaire_name'] = !empty($obj_dossier->beneficiaire_id) ? DemandeurModel::getName($obj_dossier->beneficiaire_id, "OPS_individu") : "";
        }

        return $tab;
    }

    private function getDataFormByEtape($donnees)
    {
        $donnees_formated = [];
        $libelle_erreur = "";

        do {
            if (empty($donnees["demandeur_id"])) {
                $libelle_erreur = "L'id du demandeur est vide";
                break;
            } else {
                $donnees_formated["demandeur"]["id"] = $donnees["demandeur_id"];
            }

            if (empty($donnees["demandeur_type"])) {
                $libelle_erreur = "Le type de demandeur est vide";
                break;
            } else {
                $donnees_formated["demandeur"]["type"] = $donnees["demandeur_type"];
            }

            if (empty($donnees["dispositif_id"])) {
                $libelle_erreur = "L'id du dispositif est vide";
                break;
            }

            // On récupere l'objet dispositif
            $obj_dispositif = BeanFactory::getBean('OPS_dispositif', $donnees["dispositif_id"]);
            if (empty($obj_dispositif->id)) {
                $libelle_erreur = "Le dispositif n'a pas pu etre récupéré";
                break;
            } else {
                $donnees_formated["dispositif"] = ["id" => $obj_dispositif->id, "name" => $obj_dispositif->name];
            }

            // On récupere la vue usager/partenaire du formulaire associé au dispositif
            $liste_formulaire = $obj_dispositif->get_linked_beans('ops_generateur_formulaire_ops_dispositif', 'OPS_generateur_formulaire');
            $obj_formulaire = (is_array($liste_formulaire) && count($liste_formulaire) > 0) ? $liste_formulaire[0] : false;

            if (array_key_exists('vue', $donnees) && $donnees['vue'] == 'partenaire') {
                $partenaire_vue_id = ($obj_formulaire !== false && !empty($obj_formulaire->partenaire_vue_id)) ? $obj_formulaire->partenaire_vue_id : "";
                $obj_vue = BeanFactory::getBean('OPS_generateur_vue', $partenaire_vue_id);
                if (empty($obj_vue->id)) {
                    $libelle_erreur = "La vue partenaire est introuvable";
                    break;
                } else {
                    $donnees_formated["vue"] = ["id" => $obj_vue->id, "type" => "partenaire"];
                }
            } else {
                $usager_vue_id = ($obj_formulaire !== false && !empty($obj_formulaire->usager_vue_id)) ? $obj_formulaire->usager_vue_id : "";
                $obj_vue = BeanFactory::getBean('OPS_generateur_vue', $usager_vue_id);
                if (empty($obj_vue->id)) {
                    $libelle_erreur = "La vue usager est introuvable";
                    break;
                } else {
                    $donnees_formated["vue"] = ["id" => $obj_vue->id, "type" => "usager"];
                }
            }

            $donnees_formated["etape_ordre"] = (empty($donnees["etape_ordre"])) ? 1 : $donnees["etape_ordre"];
        } while (0);

        return (empty($libelle_erreur)) ? ["statut" => "ok", "data" => $donnees_formated] : ["statut" => "err", "data" => $libelle_erreur];
    }

    public static function verif_liaison_profil($id_usager, $id_profil)
    {
        global $db;

        $requete = $db->query(
            "
            SELECT ops_personne_morale.id,
                   ops_personne_morale_individu.responsable
            FROM ops_personne_morale, ops_individu_ops_personne_morale_individu , ops_personne_morale_ops_personne_morale_individu ,ops_personne_morale_individu, ops_type_personne_ops_personne_morale, ops_type_personne
            WHERE ops_personne_morale.id = ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_id 
            AND ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id 
            AND ops_individu_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id 
            AND ops_individu_ops_personne_morale_individu.ops_individu_id =  '" . $id_usager . "'
            AND ops_personne_morale.id =  '" . $id_profil . "'
            AND ops_type_personne_ops_personne_morale.ops_personne_morale_id = ops_personne_morale.id
            AND ops_type_personne_ops_personne_morale.ops_type_personne_id = ops_type_personne.id
            AND ops_personne_morale.deleted = 0
            AND ops_individu_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_individu.deleted = 0
            AND ops_type_personne_ops_personne_morale.deleted = 0
            AND ops_type_personne.deleted = 0
            AND ops_type_personne.visible_usager = 1
            ORDER BY `ops_personne_morale`.`name` DESC "
        );

        $rowResults = array();
        while ($row = $db->fetchRow($requete)) {
            return true;
        }

        return false;
    }

    public static function verif_liaison_avis($id_usager, $id_dossier)
    {
        global $db;

        $objAvis = BeanFactory::newBean('OPS_avis');
        if(!empty($objAvis)){
            // On récupère les profils accessibles à l'usager
            $objet_profil = BeanFactory::newBean('OPS_personne_morale');
            $list_profils_indi = $objet_profil->get_profil_by_individu($id_usager);        
            if (!empty ($list_profils_indi)) {
                $list_ids_profils = array();
                foreach ($list_profils_indi as $id => $profil) {
                    $list_ids_profils[] = $id;
                }

                // Récupération des dossiers partenaires de l'individu et de ses différents profils
                $query = "SELECT ops_avis.id
                        FROM ops_avis, ops_dossier_ops_avis
                        WHERE ops_dossier_ops_avis.ops_dossier_id  = '" . $id_dossier . "' 
                        AND ops_dossier_ops_avis.ops_avis_id   = ops_avis.id
                        AND (
                            (ops_avis.nature = 'externe' AND ops_avis.individu_id = '" . $id_usager . "') 
                            OR (
                                ops_avis.nature = 'externe_profil' 
                                AND ops_avis.profil_id IN (" . "'" . implode("','", $list_ids_profils) . "'" . ")
                                AND ops_avis.statut_cle = 'utilise'
                            ) 
                        )
                        AND ops_avis.deleted = 0
                        AND ops_dossier_ops_avis.deleted = 0";
            } else {
                // Récupération des dossiers partenaires de l'individu
                $query = "SELECT ops_avis.id
                        FROM ops_avis, ops_dossier_ops_avis
                        WHERE ops_dossier_ops_avis.ops_dossier_id  = '" . $id_dossier . "' 
                        AND ops_dossier_ops_avis.ops_avis_id   = ops_avis.id
                        AND ops_avis.individu_id = '" . $id_usager . "'
                        AND ops_avis.deleted = 0
                        AND ops_dossier_ops_avis.deleted = 0";
            }

            $requete = $db->query($query);

            while ($db->fetchRow($requete)) {
                return true;
            }
        }

        return false;
    }

    // Récupération uniquement des libellés visibles usager sur l'instruction 
    private function getDossierInstruction($obj_dossier, $vue = 'usager')
    {

        if (!empty($obj_dossier->ops_statut_id) && !empty($obj_dossier->ops_etape_id)) {


            // Tester le statut courant => bug dde la modification du statut dans le guide d'instruction
            $obj_etape = $this->beanManager->getBeanSafe("OPS_etape", $obj_dossier->ops_etape_id);
            $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $obj_dossier->ops_statut_id);

            if ($vue == 'usager') {
                if ($obj_statut->visible_usager == true && $obj_etape->visible_usager == true) {

                    $retour['statut'] = (!empty($obj_statut->libelle_usager)) ? $obj_statut->libelle_usager : $obj_statut->name;
                    $retour['statut_id'] = $obj_statut->id;
                    $retour['etape'] = (!empty($obj_etape->libelle_usager)) ? $obj_etape->libelle_usager : $obj_etape->name;
                    $retour['etape_id'] = $obj_etape->id;
                    $retour['couleur'] = $obj_statut->code_couleur;

                    return $retour;
                }
            } else if ($vue == 'partenaire') {
                if ($obj_statut->visible_partenaire == true && $obj_etape->visible_partenaire == true) {

                    $retour['statut'] = (!empty($obj_statut->libelle_partenaire)) ? $obj_statut->libelle_partenaire : $obj_statut->name;
                    $retour['statut_id'] = $obj_statut->id;
                    $retour['etape'] = (!empty($obj_etape->libelle_partenaire)) ? $obj_etape->libelle_partenaire : $obj_etape->name;
                    $retour['etape_id'] = $obj_etape->id;
                    $retour['couleur'] = $obj_statut->code_couleur;

                    return $retour;
                }
            }

        }


        $retour = array();
        // Récupération des status passés 
        $tab_historiques = $obj_dossier->get_linked_beans('ops_historisation_ops_dossier', 'OPS_historisation', 'date_modified', 0, -1, 0, "flag_retour = '1'");
        foreach ($tab_historiques as $key => $historisation) {
            // Si l'étape n'est pas visible on boucle 
            $empty = array();
            $obj_etape = $this->beanManager->getBeanSafe("OPS_etape", $historisation->ops_etape_id, $empty, false);

            if ($obj_etape->visible_usager == true && $obj_etape->deleted == 0) {
                $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $historisation->ops_statut_id);

                if ($vue == 'usager') {
                    if ($obj_statut->visible_usager == true && $obj_etape->visible_usager == true) {

                        $retour['statut'] = (!empty($obj_statut->libelle_usager)) ? $obj_statut->libelle_usager : $obj_statut->name;
                        $retour['statut_id'] = $obj_statut->id;
                        $retour['etape'] = (!empty($obj_etape->libelle_usager)) ? $obj_etape->libelle_usager : $obj_etape->name;
                        $retour['etape_id'] = $obj_etape->id;
                        $retour['couleur'] = $obj_statut->code_couleur;

                    }
                } else if ($vue == 'partenaire') {
                    if ($obj_statut->visible_partenaire == true && $obj_etape->visible_partenaire == true) {

                        $retour['statut'] = (!empty($obj_statut->libelle_partenaire)) ? $obj_statut->libelle_partenaire : $obj_statut->name;
                        $retour['statut_id'] = $obj_statut->id;
                        $retour['etape'] = (!empty($obj_etape->libelle_partenaire)) ? $obj_etape->libelle_partenaire : $obj_etape->name;
                        $retour['etape_id'] = $obj_etape->id;
                        $retour['couleur'] = $obj_statut->code_couleur;
                    }
                }
            }
        }

        if (empty($retour)) {
            $retour['statut'] = "Dossier en cours";
            $retour['statut_id'] = "";
            $retour['etape'] = "Instruction";
            $retour['etape_id'] = "";
        }

        return $retour;
    }

    /**
     * updateDossier
     * @param DossierSetParams $params
     * @param $path
     * @return DossierResponse
     * @throws AccessDeniedException
     */
    public function updateDossier(DossierSetParams $params, Request $request)
    {
        // On récupere les données
        $donnees = $params->getData();

        // On vérifie que les données ne sont pas vide 
        if (!is_array($donnees) || count($donnees) === 0) {
            throw new Exception('Données vide', 401);
        }

        // On vérifie que l'id du demandeur n'est pas vide
        if (empty($donnees["demandeur_id"])) {
            throw new Exception("L'id du demandeur est obligatoire", 401);
        } else {
            $donnees["demandeur"] = $donnees["demandeur_id"];
            unset($donnees["demandeur_id"]);
        }

        // On vérifie que l'id du dispositif n'est pas vide
        if (empty($donnees["dispositif_id"])) {
            throw new Exception("L'id du dispositif est obligatoire", 401);
        } else {
            $donnees["dispositif"] = $donnees["dispositif_id"];
            unset($donnees["dispositif_id"]);
        }

        // On vérifie que l'id du dossier a modifié n'est pas vide
        if (empty($donnees["dossier_id"])) {
            throw new Exception("L'id du dossier est obligatoire", 401);
        } else {
            $dossier_id = $donnees["dossier_id"];
            unset($donnees["dossier_id"]);
        }

        // Si l'id du dossier est vide => On crée le dossier sinon on le met à jour
        $dossier_id = OPS_dossier::updateDossier($donnees, $dossier_id);

        // Si l'id est vide on retourne une erreur
        if (empty($dossier_id)) {
            throw new Exception('Erreur de création du dossier', 401);
        }

        // On retourne l'id du dossier
        $response = new DossierResponse();
        $response->setData(["dossier_id" => $dossier_id]);

        return $response;
    }

    /**
     * updateDossierByEtape
     * @param DossierSetParams $params
     * @param $path
     * @return DossierResponse
     * @throws AccessDeniedException
     */
    public function updateDossierByEtape(DossierSetParams $params, Request $request)
    {
        global $sugar_config;
        // On récupere les données
        $donnees = $params->getData();
        $donneesFormated = $this->getDataFormByEtape($donnees);

        // On vérifie que les données ne sont pas vide 
        if (!is_array($donnees) || count($donnees) === 0) {
            throw new Exception('Données vide', 401);
        }

        // On vérifie que l'id du demandeur n'est pas vide
        if (empty($donnees["demandeur_id"])) {
            throw new Exception("L'id du demandeur est obligatoire", 401);
        } else {
            $donnees["demandeur"] = $donnees["demandeur_id"];
            unset($donnees["demandeur_id"]);
        }

        // On vérifie que l'id du dispositif n'est pas vide
        if (empty($donnees["dispositif_id"])) {
            throw new Exception("L'id du dispositif est obligatoire", 401);
        } else {
            $donnees["dispositif"] = $donnees["dispositif_id"];
            unset($donnees["dispositif_id"]);
        }

        // On vérifie que canal n'est pas vide
        if (empty($donnees["canal"]) && !isset($donnees["canal"])) {
            $donnees["canal"] = 'guichet';
        }

        // On vérifie que l'id du dossier a modifié n'est pas vide
        if (empty($donnees["dossier_id"])) {
            throw new Exception("L'id du dossier est obligatoire", 401);
        } else {
            $dossier_id = $donnees["dossier_id"];
            unset($donnees["dossier_id"]);
        }

        $brouillon = $donnees["save_brouillon"];
        unset($donnees["save_brouillon"]);

        // On récupere l'etape du dossier et on le supprime des données du formulaire
        if (isset($donnees["etape_ordre"])) {
            $etape_ordre = $donnees["etape_ordre"];
            unset($donnees["etape_ordre"]);
        } else {
            $etape_ordre = "1";
        }

        $vue = ($donnees['vue'] == '') ? 'usager' : $donnees['vue'];
        $obj_dossier = $this->beanManager->getBeanSafe("OPS_dossier", $dossier_id);

        $dossier_brouillon = $obj_dossier->brouillon;

        $formFactory = new OdeFormFactory($obj_dossier, false, $donneesFormated['data']);
        $etapes = $formFactory->getEtapes($vue);

        // Si l'id du dossier est vide => On crée le dossier sinon on le met à jour
        $dossier_id = OPS_dossier::upDateDossierByEtape($dossier_id, $donnees, $etapes[$etape_ordre]['ordre'], $brouillon);

        $obj_dossier = $this->beanManager->getBeanSafe("OPS_dossier", $dossier_id);

        //Mettre à jour le statut si c est la vue partenaire
        if (array_key_exists('vue', $donnees) && $donnees['vue'] == 'partenaire' && $donnees['terminer'] == true) {
            $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $obj_dossier->ops_statut_id);
            if (!empty($obj_statut->ops_statut_completude_partenaire_id)) {
                $obj_dossier->updateStatut($obj_statut->ops_statut_completude_partenaire_id);
            }
        }
        // Gestion d'un dossier incomplet 
        if ($donnees['form_type'] == "completude" && $donnees['terminer'] == true && $dossier_brouillon == 'non') {

            // Récupération du dispositif lié au dossier pour récupérer le guide d'instruction
            $dispositifs = $obj_dossier->get_linked_beans('ops_dispositif_ops_dossier', 'OPS_dispositif');
            $dispositif = (is_array($dispositifs) && count($dispositifs) == 1) ? $dispositifs[0] : false;

            // Récupération du guide d'instruction
            $guide_instructions = ($dispositif !== false) ? $dispositif->get_linked_beans('ops_guide_instruction_ops_dispositif', 'OPS_guide_instruction') : array();
            $guide_instruction = (is_array($guide_instructions) && count($guide_instructions) == 1) ? $guide_instructions[0] : false;

            $obj_statut = BeanFactory::getBean('OPS_statut', $obj_dossier->ops_statut_id);

            // S'il existe un statut de complétude mise à jour du dossier 
            if (!empty($obj_statut->ops_statut_completude_id)) {
                $obj_dossier->updateStatut($obj_statut->ops_statut_completude_id);

                // Notification dans la cloche à l'agent 
                $user_id = $obj_dossier->assigned_user_id;
                $obj_user = BeanFactory::getBean('Users', $user_id);

                $alert = BeanFactory::newBean('Alerts');
                $alert->name = 'Dossier complété';
                $alert->description = 'Dossier numéro :' . $obj_dossier->num_dossier;
                $alert->url_redirect = 'index.php?module=OPS_dossier&action=DetailView&record=' . $obj_dossier->id;
                $alert->assigned_user_id = $obj_user->id;
                $alert->type = 'info';
                $alert->is_read = 0;
                $alert->save();

            }

            $template = $sugar_config['opensocle']['notif_usager_dossier_modification'];

            if (isset($template) && !empty($template)) {
                $obj_individu = $this->beanManager->getBeanSafe("OPS_individu", $obj_dossier->ops_individu_id);

                # On initialise le mailer 
                $mailer = new OdeMailer();

                # On initialise l'email 
                $ode_email = new OdeEmail([
                    'bean_source_id' => $obj_dossier->id,
                    'bean_source_name' => 'OPS_dossier',
                    'bean_historisation_id' => $obj_dossier->ops_individu_id,
                    'bean_historisation_name' => 'OPS_individu',
                    'email_template_id' => $template,
                    'dest_to' => $obj_individu->email1,
                ]);

                # On déclenche l'envoie
                $mailer->send($ode_email);
            } else {
                $GLOBALS['log']->fatal("DossiersService - sendNotification : Pas te template mail associé à la complétude d'un dossier");
            }
        }


        // Si l'id est vide on retourne une erreur
        if (empty($dossier_id)) {
            throw new Exception('Erreur de création du dossier', 401);
        }

        // On retourne l'id du dossier
        $response = new DossierResponse();
        $response->setData(["dossier_id" => $dossier_id]);

        return $response;
    }

    /**
     * getDossierFormatPdf
     * @param DossierListParams $params
     * @param $path
     * @return DossierResponse
     * @throws AccessDeniedException
     */
    public function getDossierFormatPdf(DossierListParams $params, Request $request)
    {
        // On récupere l'id du dossier 
        $dossier_id = $params->getId();
        $id_demandeur = $params->getIdIndividu();

        // on vérifie que le dossier existe bien 
        try {
            $dossier = $this->beanManager->getBeanSafe("OPS_dossier", $dossier_id);
        } catch (\Exception $exception) {
            throw new Exception('Dossier inconnu', 401);
        }

        // Vérification que l'usager connecté a le droit de d'accès sur le dossier
        // Si l'usager connecté n'est pas le demandeur => On vérifie s'il est partenaire => On vérifie s'il est lié au profil
        $usager = 'demandeur';

        if (DossierService::verif_liaison_avis($id_demandeur, $dossier->id) || ($id_demandeur == $dossier->ops_individu_id && $dossier->flag_partenaire)) {
            $usager = 'partenaire';
            $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $dossier->ops_statut_id);
            if ($obj_statut->visible_partenaire == 0) {
                $response = new DossierResponse();
                $response->setData(["erreur" => "Le dossier est actuellement sur un statut auquel vous n'avez pas accès"]);
                return $response;
            }
        } else if ($id_demandeur != $dossier->ops_individu_id) {

            if (!DossierService::verif_liaison_profil($id_demandeur, $dossier->ops_personne_morale)) {
                // Vérification par le profil
                $response = new DossierResponse();
                $response->setData(["erreur" => "Vous n'avez pas accès à ce dossier"]);
                return $response;
            }
        }

        $data = [
            'statut' => false,
            'base64' => '',
        ];
        if ($usager == 'partenaire') {
            $OdePdf = new OdePdfHelper($dossier_id, 'partenaire', 'base64');
        } else {
            $OdePdf = new OdePdfHelper($dossier_id, 'usager', 'base64');
        }

        $ode_pdf = $OdePdf->generer();

        if (isset($ode_pdf['statut']) && $ode_pdf['statut'] && isset($ode_pdf['data'])) {
            if (isset($ode_pdf['data']['base64']) && !empty(trim($ode_pdf['data']['base64']))) {
                $data['statut'] = true;
                $data['base64'] = trim($ode_pdf['data']['base64']);
            }
        }

        $response = new DossierResponse();
        $response->setData($data);
        return $response;
    }


    private function verif_saison($dispositif)
    {

        $retour = true;

        // Gestion des saisons 
        if ($dispositif->saison == true) {

            $dateTime = new DateTime('NOW');
            $today = $dateTime->format('Y-m-d');

            $saison_date_debut = $dispositif->saison_date_debut;
            $saison_date_fin = $dispositif->saison_date_fin;

            $date = date_create_from_format('d/m/Y', $saison_date_debut);
            $saison_date_debut = date_format($date, 'Y-m-d');


            $date_fin = date_create_from_format('d/m/Y', $saison_date_fin);
            $saison_date_fin = date_format($date_fin, 'Y-m-d');

            $retour = false;

            // Dispositif ouvert ? 
            if ($saison_date_debut <= $today && $today <= $saison_date_fin) {
                $retour = true;
            }

        }

        return $retour;
    }

    //// FIN API PORTAIL //// 

    /**
     * createDossier
     * @param DossierSetParams $params
     * @param $path
     * @return DossierResponse
     * @throws AccessDeniedException
     */
    public function createDossier(DossierSetParams $params, Request $request)
    {
        $GLOBALS['log']->fatal("createDossier UTILE ?   ");

        // On récupere les données
        $donnees = $params->getData();

        // On vérifie que les données ne sont pas vide 
        if (!is_array($donnees) || count($donnees) === 0) {
            throw new Exception('Données vide', 401);
        }

        // On vérifie que l'id du demandeur n'est pas vide
        if (empty($donnees["demandeur_id"])) {
            throw new Exception("L'id du demandeur est obligatoire", 401);
        } else {
            $donnees["demandeur"] = $donnees["demandeur_id"];
            unset($donnees["demandeur_id"]);
        }

        // On vérifie que le type de demandeur n'est pas vide
        if (empty($donnees["demandeur_type"])) {
            throw new Exception("Le type du demandeur est obligatoire", 401);
        } else {
            $donnees["type_tiers"] = $donnees["demandeur_type"];
            unset($donnees["demandeur_type"]);
        }

        // On vérifie que l'id du demandeur n'est pas vide
        if (empty($donnees["dispositif_id"])) {
            throw new Exception("L'id du dispositif est obligatoire", 401);
        } else {
            $donnees["dispositif"] = $donnees["dispositif_id"];
            unset($donnees["dispositif_id"]);
        }

        // Si l'id du dossier est vide => On crée le dossier sinon on le met à jour
        $dossier_id = OPS_dossier::createDossier($donnees);

        // Si l'id est vide on retourne une erreur
        if (empty($dossier_id)) {
            throw new Exception('Erreur de création du dossier', 401);
        }

        // On retourne l'id du dossier
        $response = new DossierResponse();
        $response->setData(["dossier_id" => $dossier_id]);

        return $response;
    }

    /**
     * createDossierByEtape
     * @param DossierSetParams $params
     * @param $path
     * @return DossierResponse
     * @throws AccessDeniedException
     */
    public function createDossierByEtape(DossierSetParams $params, Request $request)
    {
        $GLOBALS['log']->fatal("createDossierByEtape UTILE ?   ");


        // On récupere les données
        $donnees = $params->getData();

        // On vérifie que les données ne sont pas vide 
        if (!is_array($donnees) || count($donnees) === 0) {
            throw new Exception('Données vide', 401);
        }

        // On vérifie que l'id du demandeur n'est pas vide
        if (empty($donnees["demandeur_id"])) {
            throw new Exception("L'id du demandeur est obligatoire", 401);
        } else {
            $donnees["demandeur"] = $donnees["demandeur_id"];
            unset($donnees["demandeur_id"]);
        }

        // On vérifie que le type de demandeur n'est pas vide
        if (empty($donnees["demandeur_type"])) {
            throw new Exception("Le type du demandeur est obligatoire", 401);
        } else {
            $donnees["type_tiers"] = $donnees["demandeur_type"];
            unset($donnees["demandeur_type"]);
        }

        // On vérifie que l'id du demandeur n'est pas vide
        if (empty($donnees["dispositif_id"])) {
            throw new Exception("L'id du dispositif est obligatoire", 401);
        } else {
            $donnees["dispositif"] = $donnees["dispositif_id"];
            unset($donnees["dispositif_id"]);
        }

        // Si l'id du dossier est vide => On crée le dossier sinon on le met à jour
        $dossier_id = OPS_dossier::createDossierByEtape($donnees);

        // Si l'id est vide on retourne une erreur
        if (empty($dossier_id)) {
            throw new Exception('Erreur de création du dossier', 401);
        }

        // On retourne l'id du dossier
        $response = new DossierResponse();
        $response->setData(["dossier_id" => $dossier_id]);

        return $response;
    }

    /**
     * getDossierById
     * @param DossierListParams $params
     * @param $path
     * @return DossierResponse
     * @throws AccessDeniedException
     */
    public function getDossierById(DossierListParams $params, Request $request)
    {
        $GLOBALS['log']->fatal("getDossierById UTILE ?   ");
        // On récupere l'id du dossier 
        $dossier_id = $params->getId();

        // on vérifie que le dossier existe bien 
        $dossierModel = new DossierModel($dossier_id);
        $dossier = $dossierModel->getBean();
        if (!is_array($dossier) || count($dossier) === 0) {
            throw new Exception("Aucun dossier avec l'id = " . $dossier_id, 401);
        }

        // On supprime le champ du dossier
        if (isset($dossier["champs_custom"])) {
            unset($dossier["champs_custom"]);
        }

        // On recupere les champs custom decodé
        $champs_custom = $dossierModel->getCustomChamps();
        if (is_array($champs_custom) && count($champs_custom) > 0) {
            $dossier = array_merge($dossier, $champs_custom);
        }

        $response = new DossierResponse();
        $response->setData($dossier);
        return $response;
    }

    /**
     * getDossierByNum
     * @param DossierNumParam $params
     * @param $path
     * @return DossierResponse
     * @throws AccessDeniedException
     */
    public function getDossierByNum(DossierNumParam $params, Request $request)
    {
        $GLOBALS['log']->fatal("getDossierByNum UTILE ?   ");
        // On récupere les données
        $dossier_num = $params->getNum();

        // On retrouve l'id du dossier à partir du numéro
        $dossier_id = DossierModel::getDossierIdByNum($dossier_num);
        if (empty($dossier_id)) {
            throw new Exception("Aucun dossier avec le numéro = " . $dossier_num, 401);
        }

        // on vérifie que le dossier existe bien 
        $dossierModel = new DossierModel($dossier_id);
        $dossier = $dossierModel->getBean();
        if (!is_array($dossier) || count($dossier) === 0) {
            throw new Exception("Aucun dossier avec l'id = " . $dossier_id, 401);
        }

        // On supprime le champ du dossier
        if (isset($dossier["champs_custom"])) {
            unset($dossier["champs_custom"]);
        }

        // On recupere les champs custom decodé
        $champs_custom = $dossierModel->getCustomChamps();
        if (is_array($champs_custom) && count($champs_custom) > 0) {
            $dossier = array_merge($dossier, $champs_custom);
        }

        $response = new DossierResponse();
        $response->setData($dossier);
        return $response;
    }

    /**
     * deleteDossier
     * @param DossierListParams $params
     * @param $path
     * @return DossierResponse
     * @throws AccessDeniedException
     */
    public function deleteDossier(DossierListParams $params, Request $request)
    {
        global $sugar_config;
        // On récupere l'id du dossier 
        $dossier_id = $params->getId();
        $id_demandeur = $params->getIdIndividu();

        try {
            $dossier = $this->beanManager->getBeanSafe("OPS_dossier", $dossier_id);
        } catch (\Exception $exception) {
            throw new Exception('Dossier inconnu', 401);
        }

        // Vérification que l'usager connecté a le droit de d'accès sur le dossier
        // Si l'usager connecté n'est pas le demandeur => On vérifie s'il est lié au profil
        if ($id_demandeur != $dossier->ops_individu_id) {
            if (!DossierService::verif_liaison_profil($id_demandeur, $dossier->ops_personne_morale)) {
                // Vérification par le profil
                $response = new DossierResponse();
                $response->setData(["erreur" => "Vous n'avez pas accès à ce dossier"]);
                return $response;
            }
        }


        // Il y a un hook qui envoie automatiquement un mail
        /*
        $template = $sugar_config['opensocle']['notif_usager_dossier_suppression'];

        if( isset($template) && !empty($template) ){
            $obj_dossier = $this->beanManager->getBeanSafe("OPS_dossier", $dossier_id );
            $obj_individu = $this->beanManager->getBeanSafe("OPS_individu", $obj_dossier->ops_individu_id );
            # On initialise le mailer 
            $mailer = new OdeMailer();

            # On initialise l'email 
            $ode_email = new OdeEmail([
                'bean_source_id' => $obj_dossier->id,
                'bean_source_name' => 'OPS_dossier',
                'bean_historisation_id' => $obj_dossier->ops_individu_id,
                'bean_historisation_name' => 'OPS_individu',
                'email_template_id' => $template,
                'dest_to' => $obj_individu->email1,
            ]);

            # On déclenche l'envoie
            $mailer->send($ode_email);
        }else{
            $GLOBALS['log']->fatal( "DossiersService - sendNotification : Pas te template mail associé à la suppression d'un dossier" );
        }
        */

        $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
        $obj_dossier->mark_deleted($obj_dossier->id);

        $response = new DossierResponse();
        $response->setData(["dossier_id" => $dossier_id]);
        return $response;
    }



    /**
     * getListDossierByDemandeur
     * @param DossierSetParams $params
     * @param $path
     * @return DossierResponse
     * @throws AccessDeniedException
     */
    public function getListDossierByDemandeur(DossierSetParams $params, Request $request)
    {
        $GLOBALS['log']->fatal("getListDossierByDemandeur UTILE ?   ");
        // On récupere les données
        $donnees = $params->getData();

        // On vérifie que l'id du demandeur n'est pas vide
        if (empty($donnees["demandeur_id"])) {
            throw new Exception("L'id du demandeur est obligatoire", 401);
        }

        // On vérifie que le type de demandeur n'est pas vide
        if (empty($donnees["demandeur_type"])) {
            throw new Exception("Le type du demandeur est obligatoire", 401);
        }

        $dossiers = DemandeurModel::getDossiers($donnees["demandeur_id"], $donnees["demandeur_type"]);

        $response = new DossierResponse();
        $response->setData($dossiers);
        return $response;
    }


    /**
     * getDossier
     * @param DossierGetParams $params
     * @param $path
     * @return DossierResponse
     * @throws AccessDeniedException
     */
    public function getDossier(DossierGetParams $params, Request $request)
    {

        global $beanFiles, $db, $sugar_config;

        // On récupere les données
        $id_dossier = $params->getId();
        //$GLOBALS['log']->fatal("params  id_dossier  " . print_r($id_dossier , true));
        // On vérifie que l'id du dossier n'est pas vide
        if (empty($id_dossier)) {
            throw new Exception("L'id du dossier est obligatoire", 401);
        }

        $obj_dossier = BeanFactory::getBean('OPS_dossier', $id_dossier);
        // Récupération du dispositif lié au dossier pour récupérer le guide d'instruction
        $dispositif = $obj_dossier->get_linked_beans('ops_dispositif_ops_dossier', 'OPS_dispositif');
        $entite_id = str_replace('^', '', $dispositif[0]->fetched_row['type_tier']);
        $type_tiers = str_replace('^', '', $dispositif[0]->fetched_row['type_beneficiaire']);
        if ($type_tiers == 'individu') {
            $type_tier = 'OPS_individu';
        } else {
            $type_tier = 'OPS_personne_morale';
        }

        $profil_name = !empty($obj_dossier->ops_personne_morale) ? DemandeurModel::getName($obj_dossier->ops_personne_morale, "OPS_personne_morale") : "";

        // Vérification si le dossier est modifiable soit par la complétude soit par le statut
        $instruction = $this->getDossierInstruction($obj_dossier);
        $modifiable = $obj_dossier->incomplet;
        if (!empty($obj_dossier->ops_statut_id) && !$modifiable && !empty($instruction['statut_id'])) {
            $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $obj_dossier->ops_statut_id);
            $modifiable = $obj_statut->modifiable_usager;
        }


         //récupération des infos individu (demandeur)
         //$obj_individu = $this->beanManager->getBeanSafe("OPS_individu", $obj_dossier->ops_individu_id);
         //$GLOBALS['log']->fatal("salutation : ". print_r($obj_individu->salutation, true));

        $informations_dossier = array();
        $informations_dossier = [
            'dossier_id' => $obj_dossier->id,
            'dossier_canal' => $obj_dossier->canal,
            'dossier_date_creation' => $obj_dossier->date_entered,
            'dossier_brouillon' => $obj_dossier->brouillon,
            'champ_information' => $obj_dossier->name,
            'modifiable' => $modifiable,
            //'dossier_name' => $obj_dossier->fetched_rel_row['ops_dispositif_ops_dossier_name'],
            'dossier_num' => $obj_dossier->num_dossier,
            'dispositif_id' => $obj_dossier->ops_dispositif_id,
            'dispositif_name' => $obj_dossier->ops_dispositif_ops_dossier_name,
            'profil_id' => $obj_dossier->ops_personne_morale,
            'profil_name' => $profil_name,
            'beneficiaire_id' => $obj_dossier->beneficiaire_id,
            'beneficiaire_name' => !empty($obj_dossier->beneficiaire_id) ? DemandeurModel::getName($obj_dossier->beneficiaire_id, "OPS_individu") : "",
            'demandeur_id' => $obj_dossier->ops_individu_id,
            'demandeur_name' => !empty($obj_dossier->ops_individu_id) ? DemandeurModel::getName($obj_dossier->ops_individu_id, "OPS_individu") : "",
            //'demandeur_salutation' => $obj_individu->salutation,
            'type_tiers' => $type_tier
        ];

        # Complement Implémentation #2526 Onglet [Suivi]
        $dispositif = $this->beanManager->getBeanSafe("OPS_dispositif", $obj_dossier->ops_dispositif_id);
       

       


        $informations_dossier["flag_valeur_1"] = $dispositif->flag_valeur_1;
        $informations_dossier["flag_valeur_2"] = $dispositif->flag_valeur_2;
        $informations_dossier["flag_valeur_3"] = $dispositif->flag_valeur_3;
        $informations_dossier["guide_instruction"] = $instruction;


        return $informations_dossier;

    }
}
