<?php
namespace ODE_API\V8\Service;

use ODE_API\V8\BeanDecorator\BeanManager;
use ODE_API\V8\JsonApi\Helper\AttributeObjectHelper;
use ODE_API\V8\JsonApi\Helper\PaginationObjectHelper;
use ODE_API\V8\JsonApi\Helper\RelationshipObjectHelper;
use ODE_API\V8\JsonApi\Response\LinksResponse;
use ODE_API\V8\JsonApi\Response\DataResponse;
use ODE_API\V8\JsonApi\Response\JustificatifResponse;
use ODE_API\V8\JsonApi\Response\MetaResponse;


use ODE_API\V8\Param\JustificatifListeParams;
use ODE_API\V8\Param\JustificatifUpdateParams;
use ODE_API\V8\Param\JustificatifTelechargerParams;


use ODE\Generateur\Factory\OdeFormFactory;
use ODE\Generateur\Factory\OdeViewFactory;

use ODE\Helper\OdePdfHelper;

use OPS_justificatif;
use OPS_dossier;
use BeanFactory;

use ODE\Model\DossierModel;
use ODE\Model\DemandeurModel;
use ODE\Model\DispositifModel;

use Exception;
use Slim\Http\Request;

use Datetime;
use DateTimeZone;
use UploadFile;

use SuiteCRM\Exception\MalwareFoundException;
use SuiteCRM\Utility\AntiMalware\AntiMalwareTrait;

class JustificatifService
{
    use AntiMalwareTrait;

    /**
     * @var BeanManager
     */
    protected $beanManager;

    /**
     * @var AttributeObjectHelper
     */
    protected $attributeHelper;

    /**
     * @var RelationshipObjectHelper
     */
    protected $relationshipHelper;

    /**
     * @var PaginationObjectHelper
     */
    protected $paginationHelper;

    /**
     * @param BeanManager $beanManager
     * @param AttributeObjectHelper $attributeHelper
     * @param RelationshipObjectHelper $relationshipHelper
     * @param PaginationObjectHelper $paginationHelper
     */
    public function __construct(BeanManager $beanManager, AttributeObjectHelper $attributeHelper, RelationshipObjectHelper $relationshipHelper, PaginationObjectHelper $paginationHelper)
    {
        $this->beanManager = $beanManager;
        $this->attributeHelper = $attributeHelper;
        $this->relationshipHelper = $relationshipHelper;
        $this->paginationHelper = $paginationHelper;
    }
    //$GLOBALS['log']->fatal("ICI tableau_justificatifs" . print_r($tableau_justificatifs, true));


    /**
     * getListeJustificatifs
     * @param JustificatifListeParams $params
     * @param $path
     * @return JustificatifResponse
     * @throws AccessDeniedException
     */
    public function getListeJustificatifs(JustificatifListeParams $params, Request $request)
    {
        global $beanFiles, $db, $sugar_config, $app_list_strings;

        $objet = $params->getEntite();
        $id_entite = $params->getIdDossier();
        $id_individu = $params->getId();

        // On vérifie que l'id du demandeur n'est pas vide
        if (empty($id_individu)) {
            throw new Exception("L'id du demandeur est obligatoire", 401);
        }

        $list_statut = $app_list_strings['ops_statut_j_list'];

        try {
            $obj_module = $this->beanManager->getBeanSafe($objet, $id_entite);
        } catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }

        $vue = 'usager';

        if ($objet == 'OPS_dossier') {
            // Vérification que l'usager connecté a le droit de d'accès sur le dossier
            // Si l'usager connecté n'est pas le demandeur => On vérifie s'il est lié au profil
            if ($id_individu != $obj_module->ops_individu_id) {
                // Vérification si la sollicitation est liée au dossier
                if (DossierService::verif_liaison_avis($id_individu, $obj_module->id)) {

                    $vue = 'partenaire';

                    //On vérifie si c'est un dossier partenaire que le staut est visible
                    $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $obj_module->ops_statut_id);

                    if ($obj_statut->visible_partenaire == 0) {
                        $response = new DossierResponse();
                        $response->setData(["erreur" => "Le dossier est actuellement sur un statut auquel vous n'avez pas accès"]);
                        return $response;
                    }
                } else if (!DossierService::verif_liaison_profil($id_individu, $obj_module->ops_personne_morale)) {
                    // Vérification par le profil
                    $response = new JustificatifResponse();
                    $response->setData(["erreur" => "Vous n'avez pas accès à ce dossier"]);
                    return $response;
                }
            } else if ($obj_module->flag_partenaire) {
                $vue = 'partenaire';

                //On vérifie si c'est un dossier partenaire que le staut est visible
                $obj_statut = $this->beanManager->getBeanSafe("OPS_statut", $obj_module->ops_statut_id);

                if ($obj_statut->visible_partenaire == 0) {
                    $response = new DossierResponse();
                    $response->setData(["erreur" => "Le dossier est actuellement sur un statut auquel vous n'avez pas accès"]);
                    return $response;
                }
            }

            $tab_justificatif = $obj_module->get_linked_beans(field_name: 'ops_dossier_ops_justificatif', bean_name: 'ops_justificatif', order_by: 'depot ASC, date_entered DESC');

        } elseif ($objet == 'OPS_personne_morale') {
            $tab_justificatif = $obj_module->get_linked_beans(field_name: 'ops_personne_morale_ops_justificatif', bean_name: 'ops_justificatif', order_by: 'depot ASC, date_entered DESC');

        }
        $justificatifs = array();
        $justificatifs_to_upload = array();
        $tab_justificatifs = array();
        $justificatif_individu = array();

        foreach ($tab_justificatif as $key => $un_justificatif) {
            $module_justificatif = 'OPS_justificatif';
            $id_justificatif = $un_justificatif->id;

            $obj_justificatif = $this->beanManager->getBeanSafe($module_justificatif, $id_justificatif);
            if ($vue == 'partenaire') {
                $tab_type_document = $obj_justificatif->get_linked_beans(
                    'ops_type_document_ops_justificatif',
                    'ops_type_document',
                    '',
                    0,
                    -1,
                    0,
                    'visible_partenaire = 1'
                );
            } else {
                $tab_type_document = $obj_justificatif->get_linked_beans(
                    'ops_type_document_ops_justificatif',
                    'ops_type_document',
                    '',
                    0,
                    -1,
                    0,
                    'visible_internet = 1'
                );
            }

            // On ajoute le justificatif si il est visible par rapprt à la vue
            if (($vue == 'usager' && $obj_justificatif->visible_internet) || ($vue == 'partenaire' && $obj_justificatif->visible_partenaire)) {

                $tab_type_document = $obj_justificatif->get_linked_beans('ops_type_document_ops_justificatif', 'ops_type_document');

                foreach ($tab_type_document as $key => $un_type_document) {

                    foreach ($list_statut as $key => $le_statut) {

                        if ($un_justificatif->statut == $key) {
                            $statut_pj = $le_statut;
                        }
                    }

                    $accept = str_replace('^', '', $un_type_document->format);

                    $mo = 5;
                    if (!empty($un_type_document->taille_limite)) {
                        $mo = intval($un_type_document->taille_limite);
                    }
                    $max_size = $mo * pow(1024, 2);

                    // On regroupe les justificatifs rejetés ou non fournis par l'utilisateur pour les mettre en haut du tableau global
                    if ($un_justificatif->statut == "rejete" || $un_justificatif->statut == "non_fourni") {
                        $justificatifs_to_upload[$un_justificatif->id] = [
                            'id_justificatif' => $un_justificatif->id,
                            'date_depot' => $un_justificatif->date_entered,
                            'document_name' => $un_justificatif->document_name,
                            'filename' => $un_justificatif->filename,
                            'file_ext' => $un_justificatif->file_ext,
                            'max_file_size' => $max_size,
                            'file_mime_type' => $accept,
                            'depot' => $un_justificatif->depot,
                            'obligatoire' => $un_justificatif->obligatoire,
                            'commentaire' => $un_justificatif->description,
                            'commentaire_usager' => $un_justificatif->commentaire_usager,
                            'statut' => $statut_pj,
                            'id_type_document' => $un_type_document->id,
                            'multi_fichiers' => $un_type_document->multi_fichier,
                            'name_type_document' => $un_type_document->name
                        ];

                        // On trie sur les statuts et le type de document les justificatifs rejetés et non fournis
                        array_multisort(array_column($justificatifs_to_upload, 'name_type_document'), SORT_ASC, array_column($justificatifs_to_upload, 'statut'), SORT_ASC, $justificatifs_to_upload);
                    } else {
                        $justificatifs[$un_justificatif->id] = [
                            'id_justificatif' => $un_justificatif->id,
                            'date_depot' => $un_justificatif->date_entered,
                            'document_name' => $un_justificatif->document_name,
                            'filename' => $un_justificatif->filename,
                            'file_ext' => $un_justificatif->file_ext,
                            'max_file_size' => $max_size,
                            'file_mime_type' => $accept,
                            'depot' => $un_justificatif->depot,
                            'obligatoire' => $un_justificatif->obligatoire,
                            'commentaire' => $un_justificatif->description,
                            'commentaire_usager' => $un_justificatif->commentaire_usager,
                            'statut' => $statut_pj,
                            'id_type_document' => $un_type_document->id,
                            'multi_fichiers' => $un_type_document->multi_fichier,
                            'name_type_document' => $un_type_document->name

                        ];

                        // On trie sur le type de document tout les autres justificatifs
                        array_multisort(array_column($justificatifs, 'name_type_document'), SORT_ASC, $justificatifs);
                    }
                }

                $tab_justificatifs['pieces_justificatives'] = $justificatifs_to_upload + $justificatifs;
            }
        }

        return $tab_justificatifs;
    }


    /**
     * updateJustificatifs
     * @param JustificatifUpdateParams $params
     * @param $path
     * @return JustificatifResponse
     * @throws AccessDeniedException
     */
    public function updateJustificatifs(JustificatifUpdateParams $params, Request $request)
    {
        global $beanFiles, $db, $sugar_config, $app_list_strings;

        $data = $params->getData();
        $result = false;
        $processing_fault = []; //array_pad([], sizeof($data['piece_justificative']), false);

        foreach ($data['piece_justificative'] as $uuid => $files) {

            $id_justificatif = $uuid;


            $piece_justificative_pdf_files = [];

            // Fetch the PJ Type name.
            $module_justificatif = 'OPS_justificatif';
            $obj_justificatif = $this->beanManager->getBeanSafe($module_justificatif, $uuid);
            $tab_type_document = $obj_justificatif->get_linked_beans('ops_type_document_ops_justificatif', 'ops_type_document');

            
            foreach ($files as $pj_id => $justificatif) {

                // Before conversion, we store physically the file.
                $tmp_name = $uuid . '_' . md5($justificatif['name']) . date('YmdHis');

                $chemin_source = $sugar_config['upload_dir'] . $tmp_name;

                if (file_put_contents($chemin_source, base64_decode($justificatif['base64']))) {

                    $chemin_verif = $_SERVER['DOCUMENT_ROOT'] . '/' . $chemin_source;
                    $ret = $this->scanPathForMalware($chemin_verif);

                    // Must convert this file ?
                    if (strtolower($justificatif['type']) === 'application/pdf' || strtolower($justificatif['type']) === 'application/vnd.ms-excel') {
                        // Preserve as is, this a PDf file, just renam as pdf properly!

                        switch (strtolower($justificatif['type'])) {
                            case 'application/pdf':
                                 $ext = ".pdf";
                                break;
                            case 'application/vnd.ms-excel':
                                 $ext = ".csv";
                                break;
                            default:
                                break;
                        }
                        rename($sugar_config['upload_dir'] . $tmp_name, $sugar_config['upload_dir'] . $tmp_name .$ext);

                        $piece_justificative_pdf_files[] = $sugar_config['upload_dir'] . $tmp_name . $ext;

                    } else {

                        switch (strtolower($justificatif['type'])) {
                            case 'image/jpeg':
                                shell_exec('convert ' . $sugar_config['upload_dir'] . $tmp_name . ' ' . $sugar_config['upload_dir'] . $tmp_name . '.png');
                                shell_exec('convert ' . $sugar_config['upload_dir'] . $tmp_name . '.png ' . $sugar_config['upload_dir'] . $tmp_name . '.pdf');
                                if (file_exists($sugar_config['upload_dir'] . $tmp_name . '.png')) {
                                    unlink($sugar_config['upload_dir'] . $tmp_name . '.png');
                                }
                                break;

                            case 'image/png':
                                shell_exec('convert ' . $sugar_config['upload_dir'] . $tmp_name . ' ' . $sugar_config['upload_dir'] . $tmp_name . '.pdf');
                                break;

                            default:
                                break;
                        }

                        // Is conversion success?
                        if (file_exists($sugar_config['upload_dir'] . $tmp_name . '.pdf')) {

                            $piece_justificative_pdf_files[] = $sugar_config['upload_dir'] . $tmp_name . '.pdf';

                        } else {
                            $GLOBALS['log']->fatal("Erreur a la conversion de l'image en PDF " . $file_name);
                        }

                        // Remove the image(s) from 'upload_dir' used for conversion.
                        if (file_exists($sugar_config['upload_dir'] . $tmp_name)) {
                            unlink($sugar_config['upload_dir'] . $tmp_name);
                        }

                    }

                } else {
                    // Otherwise writing the file <$justificatif['name']> ($tmp_filename) failed.
                }

            } // ./ End of loop for temp storing and pdf conversion. 
            
            $final_pj_name = $data['piece_justificative'][$id_justificatif][0]['name'];

            // Is any files to concat in a single PDF file ?
            if (sizeof($piece_justificative_pdf_files) > 0) {
                
                $final_file_name = strtolower($uuid);
                // Potentially ops_justificatif__chemin has no trailing slash !
                $final_file_path = (substr($sugar_config['ops_justificatif']['chemin'], -1) == '/') ? $sugar_config['ops_justificatif']['chemin'] : $sugar_config['ops_justificatif']['chemin'] . '/';

                // 
                if ($data['entite_type'] == 'OPS_dossier') {
                    $final_file_path .= strtolower($data['dossier_id']) . '/';
                } elseif ($data['entite_type'] == 'OPS_personne_morale') {
                    $final_file_path .= strtolower($data['entite_id']) . '/';
                }

                @mkdir($final_file_path, 0755);
                if (!is_dir($final_file_path)) {
                    $GLOBALS['log']->fatal("Erreur de création ou d'accès du répertoire cible « " . $final_file_path . " ».\n Ce répertoire concerne les PJ [" . $data['entite_type'] . "]");
                } else {

                    $final_file_path_history = $final_file_path . "historique";

                    // creation du dossier historique
                    if(!is_dir($final_file_path_history)){
                        @mkdir($final_file_path_history, 0755);
                    }

                    // s'il existe deja une version du document on va en faire une copy avec le meme id du justificatif avec un suffixe qu'on modifiera lorsque on aura creer le bean historisation
                    if(file_exists($final_file_path . $final_file_name)){
                        copy($final_file_path . $final_file_name, $final_file_path_history . "/" . $final_file_name . "_ID_BEAN_HISTORIQUE"); 
                    }

                    if (count( $data['piece_justificative'][$id_justificatif] ) > 1) {
                        // Ensure if only one file provided the final name is welle a PDF extension 
                        $final_pj_name = (sizeof($files) > 1) ? $tab_type_document[0]->name . '.pdf' : ((array) pathinfo($files[0]['name']))['filename'] . '.pdf';
                        $final_pdf_list = join(" ", $piece_justificative_pdf_files);
                        $shell_exec_cmd = "gs -dPDFA -dBATCH -dNOPAUSE -dUseCIEColor -sProcessColorModel=DeviceCMYK -sDEVICE=pdfwrite -sPDFACompatibilityPolicy=1  -r300 -dDetectDuplicateImages -sOutputFile=" . $final_file_path . $final_file_name . " " . $final_pdf_list;
                        $shell_exec_result = shell_exec($shell_exec_cmd);
                    } else {
                        // Ensure if only one file provided the final name is welle a PDF extension 
                        $final_pj_name = $data['piece_justificative'][$id_justificatif][0]['name'];
                        file_put_contents($final_file_path . $final_file_name, file_get_contents(implode('', $piece_justificative_pdf_files)));
                    }

                    if (file_exists($final_file_path . $final_file_name)) {

                        $date_modification_format = new DateTime();

                        $statut = ($obj_justificatif->statut == 'rejete') ? 'reetude' : 'etude';

                        $beanHistorisation = $this->beanManager->newBeanSafe('OPS_justificatif_historisation');
                        $beanJustificatif = $this->beanManager->getBeanSafe('OPS_justificatif', $uuid);

                        $extention = "pdf";
                        $type_mime_ext = 'application/pdf';
                        if (strtolower($justificatif['type']) == 'application/vnd.ms-excel') {
                            $extention = "csv";
                            $type_mime_ext = 'application/vnd.ms-excel';
                        }

                        
                        // Build SQL Query based on the 'entite_type'...
                        if ($data['entite_type'] == 'OPS_dossier') {
                            
                            #SQL OPS_dossier :
                            $sql = 'UPDATE ops_justificatif as justi, ops_dossier as dossier
                                        SET justi.document_name         = "' . $final_pj_name . '",
                                        justi.filename                  = "' . $final_pj_name . '",
                                        justi.file_ext                  = "' . $extention . '",
                                        justi.file_mime_type            = "' . $type_mime_ext . '",
                                        justi.date_modified             = "' . $date_modification_format->format("Y-m-d H:i:s") . '", 
                                        justi.active_date               = "' . $date_modification_format->format("Y-m-d") . '",
                                        justi.statut                    = "' . $statut . '",
                                        justi.commentaire_usager        = "' . $justificatif['commentaire'] . '",
                                        dossier.justificatif_incomplet  = 0
                                        WHERE justi.id                  = "' . $uuid . '"
                                        AND dossier.id                  = "' . $data["dossier_id"] . '"';           


                        } elseif ($data['entite_type'] == 'OPS_personne_morale') {

                            #SQL OPS_personne_morale :
                            $sql = 'UPDATE ops_justificatif as justi
                                        SET justi.document_name         = "' . $final_pj_name . '",
                                        justi.filename                  = "' . $final_pj_name . '",
                                        justi.file_ext                  = "' . $extention . '",
                                        justi.file_mime_type            = "' .  $type_mime_ext . '",
                                        justi.date_modified             = "' . $date_modification_format->format("Y-m-d H:i:s") . '", 
                                        justi.active_date               = "' . $date_modification_format->format("Y-m-d") . '",
                                        justi.statut                    = "' . $statut . '",
                                        justi.commentaire_usager        = "' . $justificatif['commentaire'] . '"
                                        WHERE justi.id                  = "' . $uuid . '"';

                        }

                        $sql_query = $db->query($sql);

                        if ($sql_query == 1) {
                            $processing_fault[] = true; // This PJ success.
                            // historisation du bean justificatif 
                            if(!empty($beanJustificatif->name)){
                                $beanHistorisation->document_name = $beanJustificatif->document_name;
                                $beanHistorisation->filename = $beanJustificatif->filename;
                                $beanHistorisation->file_ext = $beanJustificatif->file_ext;
                                $beanHistorisation->file_mime_type = $beanJustificatif->file_mime_type;
                                $beanHistorisation->depot = $beanJustificatif->depot;
                                $beanHistorisation->date_modified = $beanJustificatif->date_modified;
                                $beanHistorisation->active_date = $beanJustificatif->active_date;
                                $beanHistorisation->obligatoire = $beanJustificatif->obligatoire;
                                $beanHistorisation->statut = $beanJustificatif->statut;
                                $beanHistorisation->commentaire_usager = $beanJustificatif->commentaire_usager;
                                $beanHistorisation->description = $beanJustificatif->description;
                                $beanHistorisation->ops_type_document_id = $beanJustificatif->ops_type_document_id;
                                $beanHistorisation->ops_justificatif_id = $beanJustificatif->id;
                                $beanHistorisation->save();
                                // rename le fichier d'historique avec id_justificatif_id_justificatif_historisation
                                rename($final_file_path_history . "/" . $final_file_name . "_ID_BEAN_HISTORIQUE", $final_file_path_history . "/" . $final_file_name . "_" . $beanHistorisation->id);
                            }    
                        } else {
                            $processing_fault[] = false; // This PJ failed.
                        }

                        if ($data['entite_type'] == 'OPS_dossier') {
                            $module_dossier = 'OPS_dossier';
                            $obj_dossier = $this->beanManager->getBeanSafe($module_dossier, $data["dossier_id"]);


                            if ($statut == 'etude' && $obj_dossier->flag_justificatif_etude != 1) {
                                $obj_dossier->flag_justificatif_etude = 1;
                                $obj_dossier->save();
                            }

                            if ($statut == 'reetude' && $obj_dossier->flag_justificatif_reetude != 1) {
                                $obj_dossier->flag_justificatif_reetude = 1;
                                $obj_dossier->save();
                            }
                        }
                    }
                }

                // Cleanup the store generated (temp) PDF.
                foreach ($piece_justificative_pdf_files as $key => $tmp_file) {
                    unlink($tmp_file);
                }


            }


        }

        // Build a simili bool algreba computing
        $satisfy = array_merge([true], $processing_fault);
        $result = !in_array(false, $satisfy, true);

        if (!$result) {
            $GLOBALS['log']->fatal("Erreur lors du traitement des pieces justificatives");
        }

        return $result;

    }

    /**
     * telechargerJustificatif
     * @param JustificatifTelechargerParams $params
     * @param $path
     * @return JustificatifResponse
     * @throws AccessDeniedException
     */
    public function telechargerJustificatif(JustificatifTelechargerParams $params, Request $request)
    {

        global $beanFiles, $db, $sugar_config;


        // On récupere des informations du dossier 
        $justificatif_id = $params->getId();
        $objet = $params->getEntite();
        $id_objet = $params->getIdDossier();
        $id_individu = $params->getIdIndividu();

        try {
            $obj_module = $this->beanManager->getBeanSafe($objet, $id_objet);
        } catch (\Exception $exception) {
            throw new Exception('Usager inconnu', 401);
        }

        $vue = 'usager';

        // Vérification que l'usager connecté a le droit de d'accès sur le dossier
        if ($objet == 'OPS_dossier') {
            // Si l'usager connecté n'est pas le demandeur => On vérifie s'il est lié au profil
            if ($id_individu != $obj_module->ops_individu_id) {
                if (DossierService::verif_liaison_avis($id_individu, $obj_module->id)) {
                    $vue = 'partenaire';
                } else if (!DossierService::verif_liaison_profil($id_individu, $obj_module->ops_personne_morale)) {
                    // Vérification par le profil
                    $response = new JustificatifResponse();
                    $response->setData(["erreur" => "Vous n'avez pas accès à cette PJ"]);
                    return $response;
                }
            } else if ($obj_module->flag_partenaire) {
                $vue = 'partenaire';
            }

        } elseif ($objet == 'OPS_personne_morale') {

            if (!DossierService::verif_liaison_profil($id_individu, $id_objet)) {
                // Vérification par le profil
                $response = new JustificatifResponse();
                $response->setData(["erreur" => "Vous n'avez pas accès à cette PJ"]);
                return $response;
            }

        }

        try {
            $obj_justificatif = $this->beanManager->getBeanSafe('OPS_justificatif', $justificatif_id);
        } catch (\Exception $exception) {
            throw new Exception('Justificatif inconnu', 401);
        }

        if (!($vue == 'usager' && $obj_justificatif->visible_internet) && !($vue == 'partenaire' && $obj_justificatif->visible_partenaire)) {
            $response = new JustificatifResponse();
            $response->setData(["erreur" => "Vous n'avez pas accès à à cette PJ"]);
            return $response;
        }

        $data = [
            'statut' => false,
            'base64' => '',
        ];

        $root = $sugar_config['ops_justificatif']['chemin'] . "/" . $id_objet . "/" . $justificatif_id;
        $content_file = base64_encode(file_get_contents($root));

        if (isset($content_file) && !empty($content_file)) {
            $data['statut'] = true;
            $data['base64'] = $content_file;
        }

        $response = new JustificatifResponse();
        $response->setData($data);

        return $response;
    }

}
