<?php

if (!defined('sugarEntry') || !sugarEntry)
    die('Not A Valid Entry Point');

use ODE\Mailer\OdeEmail;
use ODE\Mailer\OdeMailer;


class OPS_conversationController extends SugarController
{

    /**
     * @uses Bean OPS_conversation (class)
     * @method fetchConversationState
     */
    public function action_fetchConversationState( )
    {
        global $app_list_strings;

        $data_statut = false;

        // Récupération des propriétés de la conversation sur le dossier/profil/...
        if( isset( $_REQUEST['id'] ) && !empty($_REQUEST['id'])  ){

            $id = trim( $_REQUEST['id'] );
            $module = trim( $_REQUEST['origin_module'] );

            $bean_name = 'OPS_conversation';
            $Conversation = BeanFactory::getBean($bean_name, null); // Retrieve OPS_conversation bean class.

            $data_statut = $Conversation->fetchConversationState($id, $module);

        }

        ob_clean();
        echo json_encode($data_statut);
        sugar_cleanup(true);
    }


    /**
     * @uses Bean OPS_conversation (class)
     * @method setConversationStates
     */
    public function action_setConversationState( )
    {
        global $app_list_strings;

        $data = false;

        // Défini le statut de la conversation sur le dossier/profil/...
        if( isset( $_REQUEST['id'] ) && !empty($_REQUEST['id']) 
         && isset( $_REQUEST['conversation_statut'] ) && !empty($_REQUEST['conversation_statut']) 
        ){

            $id = trim( $_REQUEST['id'] );
            $module = trim( $_REQUEST['origin_module'] );

            $conversation_statut = $_REQUEST['conversation_statut'];


            $bean_name = 'OPS_conversation';
            $Conversation = BeanFactory::getBean($bean_name, null); // Retrieve OPS_conversation bean class.

            $data_statut = (object) $Conversation->setConversationState($id, $module, $conversation_statut);

            $data = array(
                'id' => $data_statut->id,
                'conversation_statut' => $data_statut->conversation_statut,
                'conversation_label'  => $data_statut->conversation_label,
            );

        }

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }




    /**
     * @uses Bean OPS_conversation (class)
     * @method sendMessage
     */
    public function action_sendMessage( )
    {
        global $app_list_strings;
        global $current_user;

        $data = false;

        // Poste un message dans la conversation du dossier/profil/...
        if( isset( $_REQUEST['id'] ) && !empty($_REQUEST['id']) 
         && isset( $_REQUEST['conversation_statut'] ) && !empty($_REQUEST['conversation_statut']) 
        ){

            $id = trim( $_REQUEST['id'] );
            $module = trim( $_REQUEST['origin_module'] );

            $conversation_statut = $_REQUEST['conversation_statut'];
            $conversation_origin = $_REQUEST['conversation_origin'];
            $b64_message = trim( $_REQUEST['b64_message'] );

            // Passe le statut de la conversation à ouverte par principe dès qu'un message est envoyé.

            $bean_name = 'OPS_conversation';
            $Conversation = BeanFactory::getBean($bean_name, null); // Retrieve OPS_conversation bean class.

            $data_statut = (object) $Conversation->setConversationState($id, $module, $conversation_statut);

            $data = array(
                'id' => $data_statut->id,
                'conversation_statut' => $data_statut->conversation_statut,
                'conversation_label'  => $data_statut->conversation_label,
            );

            // On prédétermine les informations de l'auteur qui poste le message.
            $objAuthor = new \stdClass();
            $objAuthor->prenom    = $current_user->first_name;
            $objAuthor->nom       = $current_user->last_name;
            $objAuthor->source_id = $current_user->id;
            $objAuthor->origin    = 'agent';

            // On poste un message dans la conversation.
            $data_message = (object) $Conversation->addMessage($id, $module, $b64_message, $objAuthor);
            $data['message_id']     = $data_message->message_id;
            $data['message_statut'] = $data_message->message_statut;
            $data['message_label']  = $data_message->message_label;
            $data['message_origin']  = $data_message->message_origin;
            $data['message_stamp']  = $data_message->message_stamp;
            $data['message_sender']  = $data_message->message_sender;


        }

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }



    /**
     * @uses Bean OPS_conversation (class)
     * @method fetchMessages
     */
    public function action_fetchMessages( )
    {
        global $app_list_strings;

        $data = false;

        // Récupération des messages d'une conversation du dossier/profil/...
        if( isset( $_REQUEST['id'] ) && !empty($_REQUEST['id'])  ){

            $id = trim( $_REQUEST['id'] );
            $module = trim( $_REQUEST['origin_module'] );
            $bean_name = 'OPS_conversation';

            $Conversation = BeanFactory::getBean($bean_name, null); // Retrieve OPS_conversation bean class.
            $data = $Conversation->fetchMessages($id, $module);

        }

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }



    /**
     * @uses Bean OPS_conversation (class)
     * @method setMessageStatut
     */
    public function action_setMessageStatut( )
    {
        global $app_list_strings;

        $data = false;

        // Récupération des messages d'une conversation du dossier/profil/...
        if( isset( $_REQUEST['id'] ) && !empty($_REQUEST['id']) 
         && isset( $_REQUEST['message_id'] ) && !empty($_REQUEST['message_id']) 
        ){

            $id = trim( $_REQUEST['id'] );
            $module = trim( $_REQUEST['origin_module'] );
            $bean_name = 'OPS_conversation';

            $message_id = trim( $_REQUEST['message_id'] );
            $message_statut = trim( $_REQUEST['message_statut'] );

            $Conversation = BeanFactory::getBean($bean_name, null); // Retrieve OPS_conversation bean class.
            $data = $Conversation->setMessageStatut($id, $module, $message_id, $message_statut);

        }

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }



    /**
     * @uses Bean OPS_conversation (class)
     * @method getLastMessage
     */
    public function action_getLastMessage( )
    {
        global $app_list_strings;

        $data = false;

        // Récupération des messages d'une conversation du dossier/profil/...
        if( isset( $_REQUEST['id'] ) && !empty($_REQUEST['id']) 
        ){

            $id = trim( $_REQUEST['id'] );
            $module = trim( $_REQUEST['origin_module'] );
            $bean_name = 'OPS_conversation';

            $Conversation = BeanFactory::getBean($bean_name, null); // Retrieve OPS_conversation bean class.
            $data = $Conversation->getLastMessage($id, $module);

        }

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }




    // Trace les erreurs de traitement ou de génération sur le document.
    static private function _trace_error( $class_name, $error_line, $error ){

        $GLOBALS['log']->fatal("« Conversation » [". $class_name ." (L.".$error_line.")]\n" . print_r([
            "statut" => $error['statut'],
            "data"   => $error['data'],
        ], true));

    }



}