<?php
if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

require_once('modules/OPS_dashlet/views/view.detail.php');

/** 
 * Classe appelée par le view.detail.php du module Dashlet permettant la récupération d'informations liés à l'objet "OPS_dossier"
 */
class OPS_dossierDetail
{
    public $ss; // Variable du smarty actuel
    public $bean; // Variable du bean actuel

    public function __construct($objet)
    {
        $this->ss = $objet->ss;
        $this->bean = $objet->bean;
    }

    /**
     * Fonction d'assignation Smarty des variables contenant les valeurs des filtres du Dashlet
     *
     * @param array $filtres
     * @return void
     */
    public function assignValeursFiltres($filtres)
    {
        global $app_list_strings;

        $liste_dispositifs = array();
        $liste_statuts = array();
        $liste_thematiques = array();
        $liste_canaux = array();

        if (isset($filtres['ops_dispositif_ops_dossier_name'])) { // Filtre dispositifs
            foreach ($filtres['ops_dispositif_ops_dossier_name'] as $dispositif) {
                if ($dispositif != "") {
                    $un_dispositif = BeanFactory::getBean('OPS_dispositif', $dispositif);
                    $liste_dispositifs[$dispositif] = $un_dispositif->name;
                }
            }
        }
        $this->ss->assign("LISTE_DISPOSITIFS_AFFICHES", $liste_dispositifs);

        if (isset($filtres['statut'])) { // Filtre statuts de workflow
            foreach ($filtres['statut'] as $statut) {
                if ($statut != "") {
                    $bean_statut = BeanFactory::getBean('OPS_statut', $statut);
                    $etape = $bean_statut->get_linked_beans('ops_etape_ops_statut', 'OPS_etape');
                    $guide = $etape[0]->get_linked_beans('ops_guide_instruction_ops_etape', 'OPS_guide_instruction');

                    $liste_statuts[$guide[0]->name][$statut] = $etape[0]->name . ": " . $bean_statut->name;
                }
            }
        }
        $this->ss->assign("LISTE_STATUTS_AFFICHES", $liste_statuts);

        if ($filtres['thematique']) {
            for ($i = 0; $i < count($filtres['thematique']); $i++) { // Filtre sur la thématique
                if ($filtres['thematique'][$i] != "") {
                    $key = $filtres['thematique'][$i];
                    $liste_thematiques[$i] = $app_list_strings['ops_thematique_list'][$key];
                }
            }
        }
        $this->ss->assign('LISTE_THEMATIQUES_AFFICHEES', $liste_thematiques);

        if ($filtres['canal']) {
            for ($i = 0; $i < count($filtres['canal']); $i++) { // Filtre sur le canal
                if ($filtres['canal'][$i] != "") {
                    $key = $filtres['canal'][$i];
                    $liste_canaux[$i] = $app_list_strings['ops_canal_list'][$key];
                }
            }
        }
        $this->ss->assign("LISTE_CANAUX_AFFICHES", $liste_canaux);

        if ($filtres['territoire']) {
            foreach ($filtres['territoire'] as $territoire) {
                if ($territoire != "") {
                    $bean_territoire = BeanFactory::getBean('OPS_territoire', $territoire);
                    $type_territoire = $bean_territoire->get_linked_beans('ops_territoire_ops_type_territoire', 'OPS_type_territoire');

                    $liste_territoires[$type_territoire[0]->name][$territoire] = $bean_territoire->name;
                }
            }
        }
        $this->ss->assign("LISTE_TERRITOIRES_AFFICHES", $liste_territoires);

        if (isset($this->bean->filtre_metadonnees) && !empty($this->bean->filtre_metadonnees)) { // Filtre sur les métadonnées du dossier (Nom, Numéro, Segment, ...)
            $array_value_metadata = explode("\n", $this->bean->filtre_metadonnees);
            foreach ($array_value_metadata as $value) {
                $key = explode(';', $value)[0];
                $array_values_metadata[$key] = explode(';', $value)[1];
            }
        }
        $this->ss->assign('FILTRE_VALEURS_METADATA', $array_values_metadata);
        
        $this->ss->assign('FILTRE_JUSTIFICATIFS_ETUDE', $filtres['flag_justificatif_etude']);
        $this->ss->assign('FILTRE_JUSTIFICATIFS_REETUDE', $filtres['flag_justificatif_reetude']);
    }
}
