String.prototype.isEmpty = function() {
    return (this.length === 0 || !this.trim() );
};


String.prototype.b64ToUtf8 = function() {
    return decodeURIComponent(escape(window.atob( this )));
};

String.prototype.utf8ToB64 = function() {
    return window.btoa(unescape(encodeURIComponent( this )));
};

var OdeFields = {};
var URLS = URL;
var OdeDossier = (function ( $, OdeValidator, OdeQueries, OdeAjax ) {

    return {

        /**
         * Fonction qui 
         * 
         * @return {void} 
         */
        start: function() {  

            OdeValidator.clean();
            OdeCondition.init();
            if ( typeof OdeFields === 'object' && $(OdeFields).length > 0 ) {
                $.each( OdeFields, function( field_type , OdeField ) {
                    if ( typeof OdeField.initialisation === "function" ) OdeField.initialisation();
                });
            }
            this.initNavigationOnglet();
            this.initExecuterBtn();

            this.initSaveDossier();

            this.setClickDeleteDossier();
            this.setClickEditStatut();
            this.setClickDuplicateDossier();

            this.checkElu();
        },

        /**
         * Affiche l'onglet du dossier en fonction des paramètres dans l'url
         * 
         * @return {void} 
        */
        initNavigationOnglet: function() {

            const self = this;

            // Initialisation de la vue => on affiche le premier onglet et on cache les autres
            var params = (new URLS(document.location)).searchParams;

            var action = params.get('action');
            var no_onglet = params.get('onglet');
            var onglet = $('#onglet-boutons li a:visible')[0];
            $('#onglet-boutons li a').removeClass("active");
            $(onglet).addClass("active");
            $("#onglet-content").find($(".onglet-layout")).hide();

            if(onglet != '' && no_onglet !== null && no_onglet > 0 && $('#onglet-boutons li a:visible').length >= no_onglet)
            {
                var onglet_selected = $('#onglet-boutons li a:visible')[no_onglet - 2];
                $('#onglet-boutons li a').removeClass("active");
                $(onglet_selected).addClass("active");
                $(onglet_selected).show();

                var id = $(onglet_selected).attr('id').split("_");
                $('#onglet_'+id[1]).show();

                if(action == "EditView" || action == "create")
                {
                    $($('#btn_annuler_generateur_vue')[0]).attr('onclick', "location.href='" + this.urlRedirection() + "'");
                }
                else if(action == "DetailView")
                {
                    $($('input[value=Modifier]')[0]).attr('onclick', "location.href='" + this.urlRedirection() + "'");
                }
            }
            else if(action == "EditView" || action == "create")
            {
                var id = $(onglet).attr('id').split("_");
                $('#onglet_'+id[1]).show();
            }
            else
            {
                $("#onglet-content").find(".onglet-layout:hidden").first().show();
            }

            // Affiche l'onglet sélectionné et change la redirection des bouttons MODIFIER / ANNULER / SAUVEGARDER
            $('#onglet-boutons li').click(function() {

                var bouton_index = $(this).index();
                $('#onglet-boutons li a').removeClass("active");
                $(this).find('a').addClass("active");
                $("#onglet-content").find($(".onglet-layout")).each(function(layout_index) {
                    ( layout_index === bouton_index ) ?  $(this).fadeIn() : $(this).hide();
                });

                var action = params.get('action');

                if(action == "DetailView")
                {
                    $($('input[value=Modifier]')[0]).attr('onclick', "location.href='" + self.urlRedirection() + "'");
                }
                else if (action == 'EditView')
                {
                    $($('#btn_annuler_generateur_vue')[0]).attr('onclick', "location.href='" + self.urlRedirection() + "'");
                }
            });
        },

        /**
         * Génère l'url de redirection en fonction de l'onglet actif
         * 
         * @return string - Url de redirection
        */
        urlRedirection: function() {
            var onglets = $('#onglet-boutons li');

            var params = (new URLS(document.location)).searchParams;

            var action = params.get('action');
            var record = params.get('record');
            var onglet = params.get('onglet');

            var option = '';
            
            var list = $('#onglet-boutons li a');
            var currentA = $('#onglet-boutons li a.active');
            var currentAIndex = list.index(currentA);

            currentAIndex = currentAIndex + 2;

            if(action == "DetailView")
            {
                action = 'EditView';

                if (currentAIndex > 1)
                {
                    currentAIndex = currentAIndex - 2;
                    option = "&onglet=" + currentAIndex;
                }
            }
            else if (action == 'EditView')
            {
                action = 'DetailView';

                if (currentAIndex > 0)
                {
                    currentAIndex = currentAIndex + 1;
                    option = "&onglet=" + currentAIndex;
                }
            }
            else
            {
                return '';
            }
            return "index.php?module=OPS_dossier&action=" + action + "&record=" + record + option;
        },

        /**
         * Récupère les bouttons spécifique pour les déplacer dans le boutton Exécuter
         */
        initExecuterBtn: function() {
            // Les bouttons recherchés sont avec la classe "execute_button"
            var btn_liste = $('.execute_button');

            // Création d'un tableau avec pour clef le name du boutton
            var btn_liste_with_key = {};
            $(btn_liste).each(function(){
                btn_liste_with_key[$(this).attr('name')] = $(this);
            });

            // Trie le tableau sur les clefs afin d'avoir une ordre alphabétique dans les bouttons
            const sorted = Object.keys(btn_liste_with_key)
              .sort()
              .reduce((accumulator, key) => {
                accumulator[key] = btn_liste_with_key[key];

                return accumulator;
            }, {});

            // Déplace les bouttons dans le menu déroulant
            for(key in sorted)
            {
                $('#dropdown_executer_dossier').append( sorted[key] );
            }
            
            // Affiche les bouttons en liste
            $('.execute_button').css('display', 'block');
        },

        /**
         * Fonction qui récupère l'adresse
         * 
         * @return {adresse} 
         */
         getAdresse: function(id){
            if($("#"+id+" [data-name=name_rue]").val() != '' && $("#"+id+" [data-name=name_rue]").val().length >= 4
            && (($("#"+id+" [data-name=name_code_postal]").val() != '' && $("#"+id+" [data-name=name_code_postal]").val().length >= 4)
                || $("#"+id+" [data-name=name_ville]").val() != '' && $("#"+id+" [data-name=name_ville]").val().length >= 4) ){
                var adresse = $("#"+id+" [data-name=name_numero]").val() + " " + $("#"+id+" [data-name=name_rue]").val() + " " + $("#"+id+" [data-name=name_code_postal]").val() + " " + $("#"+id+" [data-name=name_ville]").val();
                $.ajax({
                    url: "https://api-adresse.data.gouv.fr/search/?q="+adresse,
                    dataType:"json",
                    success: function(data){
                        if(data.features.length == 1){
                            var rue = (data.features[0].properties.type == 'street')?data.features[0].properties.name:data.features[0].properties.street;
                            var numero = (data.features[0].properties.housenumber != undefined)?data.features[0].properties.housenumber:$("#"+id+" [data-name=name_numero]").val();
                            $("#"+id+" [data-name=name_numero]").val(numero);
                            $("#"+id+" [data-name=name_rue]").val(rue);
                            $("#"+id+" [data-name=name_code_postal]").val(data.features[0].properties.postcode);
                            $("#"+id+" [data-name=name_ville]").val(data.features[0].properties.city);
                            $("#"+id+" [data-name=name_latitude]").val(data.features[0].geometry.coordinates[1]);
                            $("#"+id+" [data-name=name_longitude]").val(data.features[0].geometry.coordinates[0]);
                            var adresse = new Array();
                            adresse['id'] = data.features[0].properties.id;
                            adresse['numero'] = numero;
                            adresse['rue'] = rue;
                            adresse['city'] = data.features[0].properties.city;
                            adresse['postcode'] = data.features[0].properties.postcode;
                            adresse['citycode'] = data.features[0].properties.citycode;
                            adresse['coordonnees_x'] = data.features[0].geometry.coordinates[1];
                            adresse['coordonnees_y'] = data.features[0].geometry.coordinates[0];
                            adresse['complement_batiment'] = $("#"+id+" [data-name=name_complement_batiment]").val();
                            adresse['complement_lieu'] = $("#"+id+" [data-name=name_complement_lieu]").val();
                            var adresse = btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, adresse)) ) ) );
                            $("#"+id+"_value").val(adresse);
                            if($('#'+id).attr('data-type') == 'adresse_geoloc'){
                                MARKER[id].setLatLng(new L.LatLng(data.features[0].geometry.coordinates[1], data.features[0].geometry.coordinates[0],{draggable:'true'}));
                                MAP[id].panTo(new L.LatLng(data.features[0].geometry.coordinates[1], data.features[0].geometry.coordinates[0]));
                            }
                        }else if(data.features.length > 1){
                            $('#'+id+'-modal-adresse-body').empty();
                            $.each(data.features, function( index, value ) {
                                var rue = (value.properties.type == 'street')?value.properties.name:value.properties.street;
                                var numero = (value.properties.housenumber != undefined)?value.properties.housenumber:$("#"+id+" [data-name=name_numero]").val();
                                var radioBtn = $('<div onclick="OdeDossier.setAdresse(\''+ id + '\',\'' +value.properties.id+'\')"><input type="radio" id="'+value.properties.id+'" name="adresse_trouve" /><label for="'+value.properties.id+'">'+value.properties.label+'</label></div>');
                                radioBtn.append($('<input type="hidden" id="'+value.properties.id+'housenumber" value="'+numero+'">'));
                                radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_name" value="'+rue+'">'));
                                radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_city" value="'+value.properties.city+'">'));
                                radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_postcode" value="'+value.properties.postcode+'">'));
                                radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_citycode" value="'+value.properties.citycode+'">'));
                                radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_coordonnees_x" value="'+value.geometry.coordinates[1]+'">'));
                                radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_coordonnees_y" value="'+value.geometry.coordinates[0]+'">'));
                                radioBtn.appendTo('#'+id+'-modal-adresse-body');
                            });
                            $('#'+id+'-titre_modal_trouve').empty();
                            $('#'+id+'-titre_modal_trouve').append(data.features.length + ' adresses trouvées');
                            $('#'+id+'-modal-adresse').modal();
                        }
                    }
                });
            }
         },

        /**
         * Fonction qui 
         * 
         * @return {void} 
        */
        initSaveDossier: async function() {
            const self = this;
            $("#btn_save_dossier").click(function() {
                var data = {};
                var is_valid = true;
                OdeCondition.executeConditionsChamp();
                $("#onglet-boutons a").css("color", "#fff");
                $("[role=champ-formulaire]").each( async function() {
                    if( ($(this).attr("data-visible") !== 'masque' && $(this).attr('disabled') !== 'disabled') || $(this).attr('data-type-field') === 'calcul' || $(this).attr('data-type-field') === 'fonction'  || $(this).attr("data-defaut") === 'defaut') {
                        var field_type = $(this).attr("data-type-field");
                        if ( OdeValidator.isValid($(this)) === false ) is_valid = false;
                        if ( field_type !== undefined && OdeFields !== undefined && OdeFields.hasOwnProperty(field_type) ){
                            data[$(this).attr("data-name")] = OdeFields[field_type].getValue($(this));
                        }
                    }
                });
                data['ops_personne_morale'] = $('#ops_personne_morale').val();
                data['beneficiaire_id'] = $('#beneficiaire_id').val();
                data['demandeur'] = $('#demandeur').val();
                data['dispositif'] = $('#dispositif').val();
                if ( is_valid ) {
                    (self.getFromUrl("record") !== "") ? self.updateDossier( data , self.getFromUrl("record") ) : self.createDossier( data );
                }
            });
        },

        escapeHTML: function(value){
            var entityMap = {
                '&': '&amp;',
                '<': '&lt;',
                '>': '&gt;',
                '"': '&quot;',
                "'": '&#39;',
                '/': '&#x2F;',
                '`': '&#x60;',
                '=': '&#x3D;',
                '\\': '\\\\',
                '\t': '      '
            };

            return String(value).replace(/[&<>"'`=\/\\\t]/g, function(s){
                return entityMap[s];
            });
        },

        updateDossier: function( data , dossier_id ) { 
            const self = this;
            
            console.log("updateDossier::data  : ", data );
            console.log("updateDossier::dossier_id  : ", dossier_id );

            data["dossier_id"] = dossier_id;

            loading = function(){
                OdeLoadingHelper.addSpinner();
            };
            callBack = function(){
                console.log("updateDossier::callBack  : ", this );

                if ( typeof this.result === "string" && this.result !== "" ){

                    var redirect = self.urlRedirection();
                    window.location.replace(redirect);
                } else {
                    alert("Erreur création de dossier");
                    OdeLoadingHelper.removeSpinner();
                }
            
            };

            var query = OdeQueries.getAjaxActionQuery();
            query.setModule('OPS_dossier');
            query.setAction("updateDossier");
            query.setPostData(data);
            OdeAjax.getByAction( query, loading, callBack );
        },

       /**
         * Fonction qui 
         * 
         * @return {string} 
         */
        createDossier: function( data ) { 

            data["type_tiers"] = this.getFromUrl("demandeur_type");

            loading = function(){
                OdeLoadingHelper.addSpinner();
            };
            callBack = function(){
                if ( this.statut  ){
                    var redirect = "/index.php?module=OPS_dossier&action=DetailView&record=" +this.result ;
                    window.location.replace(redirect);
                } else {
                    alert("Erreur création de dossier : " + this.result );
                    OdeLoadingHelper.removeSpinner();
                }
            };

            var query = OdeQueries.getAjaxActionQuery();
            query.setModule('OPS_dossier');
            query.setAction("createDossier");
            query.setPostData(data);
            OdeAjax.getByAction( query, loading, callBack );

        },
  
        /**
         * Fonction qui 
         * 
         * @return {void} 
         */
         setClickDeleteDossier: function() { 
            const self = this;
            $("#delete_dossier_btn").click(function() {
                $('#modal-supprimer-dossier').modal();
            });
            $("#supprimer_dossier_bouton").click(function() {
                $('#modal-supprimer-dossier').modal('hide');
                loading = function(){
                    OdeLoadingHelper.addSpinner();
                };
                callBack = function(){
                    OdeLoadingHelper.removeSpinner();
                    var redirect = "/index.php?module=OPS_dossier";
                    window.location.replace(redirect);
                };
                var query = OdeQueries.getAjaxActionQuery();
                query.setModule('OPS_dossier');
                query.setAction("deleteDossier");
                query.setPostData({dossier_id: self.getFromUrl("record")});
                OdeAjax.getByAction( query, loading, callBack );
            });
        },

        /**
         * Fonction qui 
         * 
         * @return {void} 
         */
        setClickDuplicateDossier: function() { 
            const self = this;
            $("#dupliquer_dossier_btn").click(function() {
                loading = function(){
                    OdeLoadingHelper.addSpinner();
                };
                callBack = function(){
                    OdeLoadingHelper.removeSpinner();
                    if ( this.statut === true) {
                        var redirect = "index.php?module=OPS_dossier&action=DetailView&record="+ this.result.id;
                        window.location.replace(redirect);
                    }
                };
                $('#modal-dupliquer').modal('hide');

                var is_dossier_lie = false;
                if( $('#dupliquer_dossier_checkbox').length != 0 && $('#dupliquer_dossier_checkbox').is(':checked') )
                {
                    is_dossier_lie = true;
                }

                var query = OdeQueries.getAjaxActionQuery();
                query.setModule('OPS_dossier');
                query.setAction("duplicateDossier");
                query.setPostData({dossier_id: self.getFromUrl("record"), is_dossier_lie: is_dossier_lie});
                OdeAjax.getByAction( query, loading, callBack );
            });
        },
        
        
        /**
         * Fonction qui 
         * 
         * @return {void} 
         */
         setClickEditStatut: function() { 
            const self = this;
            $("#select_statut_btn").click(function() {
                loading = function(){
                    OdeLoadingHelper.addSpinner();
                };
                callBack = function(){
                    // On redirige vers la vue détail du dossier pour recharger la ligne du workflow
                    location.reload();
                };
                var data = {
                    dossier_id: self.getFromUrl("record"), 
                    statut_id: $("#select_statut option:selected").val()
                };
                if ( !data.statut_id.isEmpty() && data.statut_id !== "disabled") {
                    $("#select_statut_btn").off();
                    var query = OdeQueries.getAjaxActionQuery();
                    query.setModule('OPS_dossier');
                    query.setAction("editStatut");
                    query.setPostData(data);
                    OdeAjax.getByAction( query, loading, callBack );
                } else {
                    $("#select_statut").css("border","1px solid red");
                }
            });
            $("#select_statut").click(function() {
                $("#select_statut").css("border","");
            });
        },

        /**
         * Fonction qui 
         * 
         * @return {string} 
         */
        getFromUrl: function( name ) { 
            var vars = {};
            window.location.href.replace(location.hash, '').replace(
                /[?&]+([^=&]+)=?([^&]*)?/gi, // regexp
                function(m, key, value) { // callback
                    vars[key] = value !== undefined ? value.replace(/#/i, '') : "";
                }
            );
            if (name) {
                return vars[name] ? vars[name].replace(/#/i, '') : "";
            }
            return "";
        },
    

        /**
         * Fonction qui 
         * 
         * @return {void} 
         */
        /*
        start: function() { 

        },
        */


        

        /**
         * Fonction qui cache tous les messages d'erreur 
         * 
         * @return {void} 
         */
        clean: function() { 
            $("[role=message-champ]").each(function() {
                $(this).hide();
            });
        },

        addLigneRelation: function( _champ_name, _module_name, _type, _unique, _condition, id ){
            $(`#${id}`).parent().parent().removeClass('d-flex');
            var nombre_ligne = $(`#${id}`).parent().parent().children().length;
            if ( nombre_ligne < 5 ) {
                var id_champ = 'display_value_champ_'+_champ_name+'_' + nombre_ligne;
                var ligne_html = '<div style="margin: 1% 0% 1% 33.4%;" class="col-md-8">';
                ligne_html +=       '<div class="col-md-8">';
                ligne_html +=           '<input type="text" role="display-relation" data-id="" id="'+id_champ+'" disabled="" style="width: 100%; height: 47px; border: 1px solid #b8daef;background: #c3e7fd;" value="">';
                ligne_html +=       '</div>';
                ligne_html +=    '<div class="col-md-3" style="text-align: center;">';
                ligne_html +=        '<span class="id-ff multiple">';
                ligne_html +=            '<button type="button" id="'+id_champ+'_add_btn" title="Sélectionner" class="button firstChild" value="Sélectionner">';
                ligne_html +=                '<img src="themes/SuiteP/images/id-ff-select.png?v=9PUULME3DHwNvxEgZrpwig">';
                ligne_html +=            '</button>';
                ligne_html +=            '<button type="button" id="'+id_champ+'_clr_btn" title="Clear Selection" class="button lastChild" value="Supprimer la selection">';
                ligne_html +=                '<img src="themes/SuiteP/images/id-ff-clear.png?v=9PUULME3DHwNvxEgZrpwig">';
                ligne_html +=            '</button>';
                ligne_html +=        '</span>';
                ligne_html +=    '</div>';
                ligne_html +='</div>';
                $(`#${id}`).parent().parent().append(ligne_html);

                var champ_formulaire = $(`#${id}`).parent().parent().find('[role=champ-formulaire]');
                $(`#${id_champ}_add_btn`).click(function() { 
                    var json_data = {
                        "call_back_function": "callBackSelectRelation",
                        "form_name":{
                            "display_id": id_champ,
                            "champ_id": champ_formulaire[0].id,
                            "module_name": _champ_name,
                            "unique": _unique
                        },
                        "field_to_name_array":{"id":"id","name":"name"}
                    };
                    open_popup(_module_name, 600, 400, "", true, true, json_data , "", true );
                });

                $(`#${id_champ}_clr_btn`).click(function() {
                    var input_display = $(`#${id_champ}`);
                    const values = champ_formulaire.val().split("|").filter(item => item !== input_display.attr("data-id") );
                    champ_formulaire.val(values.join("|"));
                    input_display.attr("data-id","");
                    input_display.val("");
                });
            }
        },

        checkElu: function(){
            if($('[data-name=elus]').attr('data-unique') == 'multi'){
                var elus = $('[data-name=elus]');
                elus.parent().removeClass('d-flex');
            }
        },
    }
  
})( jQuery, OdeValidator, OdeQueries, OdeAjax );


// On définie la fonction de callBack, elle se déclenche à la séléction d'un element sur la popup
function callBackSelectRelation(data){

    // On récupere les informations du champ en question 
    var champ_id = data.form_name.champ_id;
    var display_id = data.form_name.display_id;
    var module_name = data.form_name.module_name;
    var unique = data.form_name.unique;

    // On récupere les valeurs de l'enregistrement séléctionné
    var value_id = data.name_to_value_array.id;
    var value_name = data.name_to_value_array.name;

    if ( value_id !== undefined && value_name !== undefined ) {
        if ( unique === "unique" ) {
            // Si le champ est unique => on insert l'id séléctionné dans l'input du champ et le libellé dans l'input display
            $(`#${champ_id}`).val(value_id);
            $(`#${display_id}`).val(value_name);
            $(`#${display_id}`).attr("data-id",value_id);
        } else {
            // Si le champ est multi => on vérifie si l'id existe dans l'input du champ
            var values = $(`#${champ_id}`).val().split("|");
            // Si non on insert l'id séléctionné dans l'input du champ et le libellé dans l'input display
            if ( values.includes(value_id) === false ){
                values.push(value_id);
                // On vérifie que le champ est vide, si non on enleve l'id de l'input du champ
                if ( $(`#${display_id}`).attr("data-id") !== "" ){
                    values.filter( function(item) {
                        return item !== $(`#${display_id}`).attr("data-id")
                    });
                }
                $(`#${champ_id}`).val(values.join("|"));
                $(`#${display_id}`).val(value_name);
                $(`#${display_id}`).attr("data-id",value_id);
            }
        }
    }
}

var myCustomOnChangeHandler = function(inst) {
    var cont = String(inst.getContent());
    $("#"+inst.editorId).val( cont.trim() );
}