var OdeValidator = (function ($) {

  return {

    /**
     * Fonction qui cache tous les messages d'erreur 
     * 
     * @return {void} 
    */
    clean: function() { 
      $("[role=message-champ]").each(function() {
          $(this).hide();
      });
    },

    /**
     * Fonction qui vérifie si le champ est valide 
     * 
     * @param {object} field Le champ à vérifier : input / select / textearea / datepicker
     * @return {boolean} 
    */
    isValid: function(field) { 
      return this.checkRequired(field) && this.checkCustomFields(field) ;
    },

    checkCustomFields: function( field ) {
      var field_type = field.attr("data-type-field");
      if ( OdeFields === undefined || field_type === undefined || !OdeFields.hasOwnProperty(field_type) ) return true;
      return typeof OdeFields[field_type].isValid === "function" ? OdeFields[field_type].isValid($(field)) : true;
    },

    /**
     * Fonction qui 
     * 
     * @return {void} 
    */
    checkRequired: function( field ) {
      if ( $(field).attr('data-visible') == "masque" || (field.attr("required") === undefined
        || ( (field.attr("type") != 'radio' && field.attr("type") != 'checkbox') && field.attr("required") !== undefined && this.getValue(field) !== "" ) 
        || ( field.attr("type") == 'file' && field.next().length == 1 && field.next().get(0).tagName == 'SPAN' ) 
        || ( field.attr("type") == 'checkbox' && field[0].checked === true ) 
        || ( field.attr("type") == 'checkboxmulti' && this.getValue(field) !== undefined ) 
        || ( field.attr("type") == 'radio' && field.attr("required") !== undefined && this.getValue(field) !== undefined && this.getValue(field) !== '')) ) {
        this.hideErreur( field );
        return true;
      } else {
        this.showOngletErreur(field);
        if( field.attr("data-type-field") == 'checkboxmulti')
        {
          this.showErreur( field , "Vous devez sélectionner au moins 1 choix");
        }
        else
        {
          this.showErreur( field , "Le champ est obligatoire");
        }
        return false;
      }
    },

    showOngletErreur: function(field){
      var onglet = $(field.parents('[id^="onglet_"]')).prop('id').replace(/onglet_/g, "");
        if (onglet && onglet.length > 0) {
          $("#bouton_"+onglet).attr("style", "color:red !important;"); 
          if(field.attr('type') == 'hidden')
          {
            $(field.parent().find('input')).each(function() {
              $(this).removeAttr('data-visible', 'masque');
              $(this).css('background-color','red');
              var multi = this;
              setTimeout(function(){
                $(multi).css('transition','background-color 1s ease, color 1s ease');
                $(multi).css('background-color','');
              }, 2000);
            });
          }else{
            $(field).removeClass("custom-transition");
            $(field).addClass('custom-background');
            setTimeout(function() {
              $(field).removeClass("custom-background");
                $(field).addClass('custom-transition');
            }, 2000);
          }
        }
    },

    /**
     * Fonction qui 
     * 
     * @return {void} 
    */
    getValue: function( field ) {

        var field_type = $(field).attr("data-type-field");
        if ( field_type !== undefined && OdeFields !== undefined && OdeFields.hasOwnProperty(field_type) ){
            field_value = OdeFields[field_type].getValue($(field));
        }
        
        return field_value;
      },

    /**
     * Fonction qui vérifie si le champ est valide 
     * 
     * @param {object} field Le champ à vérifier : input / select / textearea / datepicker
     * @return {boolean} 
    */
    hideErreur: function(field) { 
      var span = this.getSpanErreur(field);
      if ( span !== false ) span.hide();
    },

    getSpanErreur: function(field) { 
      var span = $(field).parent().parent().find($("[role=message-champ]"));
      if ( span.length === 1 ) {
        return span;
      } 
      if ( span.length > 1 ) {
        span = $(field).parent().find($("[role=message-champ]"));
        if ( span.length === 1 ) {
          return span;
        }
      }
      if(field.attr("type") == 'radio'){
        span = $(field).parent().parent().parent().find($("[role=message-champ]"));
        if ( span.length === 1 ) {
          return span;
        }
      }
      return false;
    },

    /**
     * Fonction qui vérifie si le champ est valide 
     * 
     * @param {object} field Le champ à vérifier : input / select / textearea / datepicker
     * @return {boolean} 
    */
    showErreur: function(field , message) {
      var span = this.getSpanErreur(field);
      if ( span !== false ) span.text(message).show();
    },
  }

})(jQuery);