<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

use ODE\Generateur\Factory\OdeFieldFactory;
use ODE\Generateur\Factory\OdeViewFactory;
use ODE\Model\DossierModel;
use ODE\Model\DispositifModel;
use ODE\Model\GenerateurFormulaireModel;
use ODE\ActionStatut\OdeActionStatut;
use ODE\Model\GenerateurVueModel;

class OPS_dossierViewEdit extends ViewEdit
{

    public function __construct()
    {
        parent::__construct();
        //$this->useForSubpanel = true;
    }

    function display()
    {

        global $app_list_strings,$current_user;

        if (empty($this->bean->id)) {
            sugar_die($app_strings['ERROR_NO_RECORD']);
        }

        $donnees = [];
        $smarty = new Sugar_Smarty();
        $current_template = "custom/include/helpers/erreurs/erreur.tpl";

        do {

            if (empty($this->bean->id)) {
                $GLOBALS['log']->fatal(" view.edit.php :: display => Le dossier n'a pas pu être récupéré. ");
                break;
            } else {
                $smarty->assign("dossier_id", $this->bean->id);
                $smarty->assign("dossier_offset", intval($_GET['offset']));
                $smarty->assign("dossier_name",   $this->bean->name);
            }


            // Vérification d'accès à la modification
            $instruction_etape = false ; 
            $habilitation_dispositif = $_SESSION['habilitation_dispositif'];
            if( isset( $habilitation_dispositif[$this->bean->ops_dispositif_id]['edition'] ) ){
                $instruction = $habilitation_dispositif[$this->bean->ops_dispositif_id]['edition'];
               $instruction_etape = $habilitation_dispositif[$this->bean->ops_dispositif_id]['etapes'][$this->bean->ops_etape_id]['edition'];
            }

            if ( ( !$instruction && !$instruction_etape )  && !$current_user->isAdmin() ) {
                SugarApplication::appendErrorMessage("Vous n'avez pas accès à cette zone " );
                SugarApplication::redirect('index.php');
            }

            $DossierModel = new DossierModel($this->bean->id);
            $dispositif_id = $DossierModel->getDispositifId();
            $demandeur_id = $DossierModel->getDemandeurId();
            $demandeur_type = $DossierModel->getDemandeurType();
            if (empty($demandeur_id) || empty($demandeur_type)) {
                $GLOBALS['log']->fatal(" view.edit.php :: display => Le demandeur associé au dossier id = " . $this->bean->id . " est introuvable");
                break;
            } else {
                $donnees["demandeur"] = ["id" => $demandeur_id, "type" => $demandeur_type];
            }

            $DispositifModel = new DispositifModel($dispositif_id);
            $dispositif = $DispositifModel->getBean();
            if (!is_array($dispositif) || count($dispositif) === 0) {
                $GLOBALS['log']->fatal(" view.edit.php :: display => Le dispositif id = " . $dispositif_id . " est introuvable");
                break;
            } else {
                $donnees["dispositif"] = ["id" => $dispositif["id"], "name" => $dispositif["name"]];
            }

            // On récupere la vue agent du formulaire associé au dispositif
            $formulaire_id = $DispositifModel->getFormulaireId();
            $GenerateurFormulaireModel = new GenerateurFormulaireModel($formulaire_id);
            $agent_vue_id = $GenerateurFormulaireModel->getVueAgentId();
            if (empty($agent_vue_id)) {
                $GLOBALS['log']->fatal(" view.edit.php :: display => La vue agent associé formulaire id = " . $formulaire_id . " est introuvable");
                break;
            } else {
                $donnees["vue"] = ["id" => $agent_vue_id, "type" => "agent"];
                $generateurVueModel = new GenerateurVueModel($agent_vue_id);
                $conditions = $generateurVueModel->getChampsConditions();
            }

            $typeProfil = '';
            if(!empty($this->bean->ops_personne_morale)){
                $personneMoralObj = BeanFactory::getBean('OPS_personne_morale',$this->bean->ops_personne_morale);
                $typeProfil = $personneMoralObj->ops_type_personne_id;
            }
            
            $params_html = '<input type="hidden" id="ops_personne_morale" name="ops_personne_morale" value="'.$this->bean->ops_personne_morale.'"/>
                            <input type="hidden" id="dispositif" name="dispositif" value="'.$dispositif_id.'"/>
                            <input type="hidden" id="demandeur" name="demandeur" value="'.$this->bean->ops_individu_id.'"/>
                            <input type="hidden" id="beneficiaire_id" name="beneficiaire_id" value="'.$this->bean->beneficiaire_id.'"/>
                            <input type="hidden" id="ops_type_personne" name="ops_type_personne" value="' . $typeProfil . '"/>
                            <input type="hidden" id="conditions" name="conditions" value="'.$conditions.'"/>';

            $this->displayTMCE();

            $contenu = $this->actionStatutOnglet($this->bean->ops_statut_id);

            $smarty->assign('contenu', $contenu);

            // On récupere le html de la vue de création 
            $viewFactory = new OdeViewFactory($this->bean, true, $donnees);
            $vue_html = $viewFactory->getHtml();
            $smarty->assign('vue_html', $vue_html);
            $smarty->assign('params_html', $params_html);

            $current_template = "modules/OPS_dossier/tpls/edit.tpl";
        } while (0);

        $smarty->display($current_template);
    }

    function displayTMCE()
    {
        require_once("include/SugarTinyMCE.php");
        global $locale;

        $tiny = new SugarTinyMCE();
        $tinyMCE = $tiny->getConfig();

        $css = <<<CSS
        
        <style type="text/css">
        
        textarea[role="champ-formulaire"][data-name][rel="wysiwyg"] ~ span[id][role="application"]{
            display: flex;width: 95%;margin-left: 12px;
        } 
        </style>

CSS;



        $js = '<script src="include/javascript/tiny_mce/tiny_mce.js"></script>';
        $js .= <<<JS
        <script language="javascript" type="text/javascript">
        function wysiwyg(id_textarea,is_readonly){

        $tinyMCE
        var df = '{$locale->getPrecedentPreference('default_date_format')}';

        tinyMCE.init({
            theme : "advanced",
            theme_advanced_toolbar_align : "left",
            mode: "exact",
            onchange_callback : "myCustomOnChangeHandler",
            elements : id_textarea,
            theme_advanced_toolbar_location : "top",
            theme_advanced_buttons1: "code,help,separator,bold,italic,underline,strikethrough,separator,justifyleft,justifycenter,justifyright,justifyfull,separator,forecolor,backcolor,separator,styleprops,styleselect,formatselect,fontselect,fontsizeselect",
            theme_advanced_buttons2: "cut,copy,paste,pastetext,pasteword,selectall,separator,search,replace,separator,bullist,numlist,separator,outdent,indent,separator,ltr,rtl,separator,undo,redo,separator, link,unlink,anchor,separator,sub,sup,separator,charmap,visualaid",
            theme_advanced_buttons3: "tablecontrols,separator,advhr,hr,removeformat,separator,insertdate,pagebreak",
            theme_advanced_fonts:"Andale Mono=andale mono,times;Arial=arial,helvetica,sans-serif;Arial Black=arial black,avant garde;Book Antiqua=book antiqua,palatino;Comic Sans MS=comic sans ms,sans-serif;Courier New=courier new,courier;Georgia=georgia,palatino;Helvetica=helvetica;Helvetica Neu=helveticaneue,sans-serif;Impact=impact,chicago;Symbol=symbol;Tahoma=tahoma,arial,helvetica,sans-serif;Terminal=terminal,monaco;Times New Roman=times new roman,times;Trebuchet MS=trebuchet ms,geneva;Verdana=verdana,geneva;Webdings=webdings;Wingdings=wingdings,zapf dingbats",
            plugins : "advhr,insertdatetime,table,paste,searchreplace,directionality,style,pagebreak",
            height:"auto",
            width: "100%",
            inline_styles : true,
            directionality : "ltr",
            remove_redundant_brs : true,
            entity_encoding: 'raw',
            cleanup_on_startup : true,
            strict_loading_mode : true,
            convert_urls : false,
            plugin_insertdate_dateFormat : '{DATE '+df+'}',
            pagebreak_separator : "<pagebreak />",
            extended_valid_elements : "textblock",
            custom_elements: "textblock",
            readonly: parseInt(is_readonly),
        });
    }
        </script>

JS;
        echo $js;
        echo $css;

    }

    public function actionStatutOnglet($statut_id){

        $contenu = '<div id="action_statut_onglet" style="display:none;">';

        $statutBean = BeanFactory::getBean('OPS_statut', $statut_id);

        $statutBean->load_relationship('ops_action_statut_ops_statut');

        $listeActions = $statutBean->ops_action_statut_ops_statut->get();

        foreach ($listeActions as $action) {
            $actionBean = BeanFactory::getBean('OPS_action_statut', $action);
            if($actionBean->active == 1 && $actionBean->ext_valeur_2 == "modif_onglet"){

                $this->bean->load_relationship('ops_dispositif_ops_dossier');
                $dispositif = $this->bean->ops_dispositif_ops_dossier->get();

                $dispositifBean = BeanFactory::getBean('OPS_dispositif',$dispositif[0]);
                $dispositifBean->load_relationship('ops_generateur_formulaire_ops_dispositif');

                $formulaire = $dispositifBean->ops_generateur_formulaire_ops_dispositif->get();
                $action_statut = new OdeActionStatut($actionBean, null);
                $donnees = $action_statut->getExtValeurText('rendrevisiblemodifiableongletaction');
                
                if(str_contains($donnees['modele_dossier'] , $formulaire[0] )){
                    $contenu .= '<input type="hidden" value="'.$donnees['onglet_crm'].'" data-visible="'.$donnees['visible_crm'].'" data-modifiable="'.$donnees['modifiable_crm'].'">';
                }
            }
        }
        $contenu .= '</div>';
        return $contenu;
    }
}