<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once('include/MVC/View/views/view.list.php');

class OPS_dossierViewList extends ViewList
{
    public function __construct()
    {
        parent::__construct();
    }

    public function preDisplay() 
    { 
        if(empty($_REQUEST['orderBy'])) { 

            $_REQUEST['orderBy'] = strtoupper('num_dossier');            
            $_REQUEST['sortOrder'] = 'DESC'; 
         } 
         parent::preDisplay(); 
    }

    /**
     * Display View
     */
    public function display()
    {
        global $current_user; 
        
        // Vérification si 'l'utilisateur a accès a la liste de dossiers 
        $req_where = $_SESSION['ops_requete_dossier'];

        if ( !$current_user->isAdmin() && $req_where == false ) 
        {
            SugarApplication::appendErrorMessage("Vous n'avez pas accès à cette zone, veuillez contacter votre administrateur");
            SugarApplication::redirect('index.php');

        }
        else
        {
            $this->lv->quickViewLinks = false;
            $this->listViewPrepare();
            $this->listViewProcess();

            echo '<script type="text/javascript" src="modules/OPS_dossier/js/quicksearch.js"></script>'; 
        }
    }
}