<?php
class Filtre_ConversationViewUtils {

    private $smarty;
    private $template;
    private $type = "basique";


    public function __construct(){
        $this->smarty = new Sugar_Smarty();
        $this->template = "modules/OPS_dossier/tpls/gestion_dossier/generic/MenuDeroulantChoixMultipleCheckbox.tpl";
    }

    public function fetch(){
        $this->setData();
        return $this->smarty->fetch($this->template);
    }

    private function setData(){

        global $app_list_strings;

        $options = $app_list_strings['conversation_statut_list'];

        $infosFiltre = OPS_dossier::getParamRequestToArray(("gestion_dossier"))['filtres_simples']['conversation_statut'] ?? array();
        $valeur = isset($infosFiltre['valeurs']) ? $infosFiltre['valeurs'] : "";

        $this->smarty->assign("NOM_LISTE", "Conversation");
        $this->smarty->assign("ICON", "fas fa-comment-alt");
        $this->smarty->assign("NOM_CHAMP", "conversation_statut");
        $this->smarty->assign("VALEURS_SELECT", strval($valeur));
        $this->smarty->assign("NOM_TABLE", "ops_dossier");
        $this->smarty->assign("TYPE_CHAMPS", $this->type);
        $this->smarty->assign("OPTIONS", $options);
        
    }

    public function getOrdre(){
        return 2;
    }
}