<?php
class Filtre_DispositifViewUtils {

    private $smarty;
    private $template;
    private $type = "basique";


    public function __construct(){
        $this->smarty = new Sugar_Smarty();
        $this->template = "modules/OPS_dossier/tpls/gestion_dossier/generic/MenuDeroulantChoixMultipleCheckbox.tpl";

    }

    public function fetch(){
        $this->setData();
        return $this->smarty->fetch($this->template);

        

    }


    private function setData(){
        global $db, $current_user;
        $tab_dispositif = $_SESSION['habilitation_dispositif'];



        $idsDispo = [];
        foreach ($tab_dispositif as $id => $dispo){
            if(empty($id) || $dispo['visualisation'] != 1 ) continue;
            $idsDispo[] = $id;
        }   

        $query = "SELECT ID, NAME FROM ops_dispositif WHERE DELETED ='0' order by name ASC";
        $query = $db->query($query);

        $options = [];
        
        while($row = $db->fetchRow($query)){
            if(!$current_user->isAdmin() && !in_array($row['ID'], $idsDispo)) continue;
            $options[$row['ID']] = $row['NAME'];
        }

        $infosFiltre = OPS_dossier::getParamRequestToArray("gestion_dossier")['filtres_simples']['ops_dispositif_id'] ?? array();
        $valeur = $infosFiltre['valeurs'] ?? "";

        $this->smarty->assign("PLACEHOLDER", "Aucun");
        $this->smarty->assign("PLACEHOLDER", "Aucun");
        $this->smarty->assign("NOM_CHAMP", "ops_dispositif_id");
        $this->smarty->assign("NOM_TABLE", "");
        $this->smarty->assign("VALEURS_SELECT", $valeur);
        $this->smarty->assign("TYPE_CHAMPS", $this->type);
        $this->smarty->assign("OPTIONS", $options);
        $this->smarty->assign("NOM_LISTE", "Selectionner un dispositif");
        $this->smarty->assign("TYPE_INPUT", "radio");
        $this->smarty->assign("ID_ELEMENT", "select_dispositif");

        // $this->smarty->assign("ICON", "far fa-calendar");
        // $this->smarty->assign("NOM_TABLE", "ops_dossier");
        // $this->smarty->assign("TYPE_CHAMPS", $this->type);
        // $this->smarty->assign("OPTIONS", $options);
        
    }

    public function getOrdre(){
        return 1;
    }
}