<?php

use ODE\Helper\OdeArrayHelper;

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');


class ViewGenerer extends SugarView
{

    public function __construct($bean = null, $view_object_map = array())
    {
        parent::__construct($bean, $view_object_map);
    }

    public function preDisplay()
    {
        if (!$this->bean->ACLAccess('edit')) {
            ACLController::displayNoAccess();
            sugar_die('Access Denied Generateur vue');
        }
    }

    /**
     * @see SugarView::display()
     */
    public function display()
    {
        global $app_list_strings;
        $smarty = new Sugar_Smarty();

        $current_template = "modules/OPS_generateur_vue/tpls/generer_vue.tpl";
        $erreur_template = "custom/include/helpers/erreur.tpl";

        // Initialisation de la vue séléctionnée
        $obj_generateur_vue = BeanFactory::getBean('OPS_generateur_vue', $_REQUEST['id_generateur_vue']);
        if (!empty($obj_generateur_vue->id)) {

            $vue_id = $obj_generateur_vue->id;
            $vue_name = $obj_generateur_vue->name;

            // On récupere les champs du réferentiel et les champs de la vue 
            $champs_referentiel = OPS_generateur_referentiel::getListReferentiel();

            $champs_vue = $obj_generateur_vue->getChampsVue();

            // Initialisation des champs du panel Standards 
            $panel_standards = (is_array($champs_referentiel) && is_array($champs_vue)) ? $this->getInitPanelStandards($champs_referentiel, $champs_vue) : "";

            // On récupere les onglets de la vue 
            $onglets = $obj_generateur_vue->getListOnglets();

            // Initialisation des boutons et des layouts onglets 
            $onglets_boutons = ($onglets !== false) ? $this->getInitBoutonsOnglets($onglets) : "";
            $onglets_layouts = ($onglets !== false) ? $this->getInitLayoutsOnglets($onglets) : "";

            // Initialisation des options et du message affiché lors de la sauvegarde de la version
            $version_options = OPS_generateur_version::getVersionOptions($obj_generateur_vue->id);
            $version_message = OPS_generateur_version::getVersionMessage($obj_generateur_vue->id);

            $listes = $app_list_strings;
            // Cette liste pose probleme au niveau du decode_json. 
            $listes['import_enclosure_options'] = array();

            $smarty->assign('listes_dossier', base64_encode(json_encode($listes)));
            $smarty->assign("vue_id", $vue_id);
            $smarty->assign("vue_name", $vue_name);
            $smarty->assign("panel_standards", $panel_standards);
            $smarty->assign("onglets_boutons", $onglets_boutons);
            $smarty->assign("onglets_layouts", $onglets_layouts);
            $smarty->assign("version_options", $version_options);
            $smarty->assign("version_message", $version_message);

            $smarty->display($current_template);
        } else {

            $smarty->assign("erreur_libelle", "erreur_libelle");
            $smarty->assign("erreur_id", "erreur_id");

            $smarty->display($erreur_template);
        }
    }

    /**
     * @access private
     * @name getInitPanelStandards()
     * Fonction qui génere les différents champs du panel standards , uniquement ceux qui ne sont aps déja présent dans la vue
     * 
     *  @param array            $champs_referentiel: la liste des champs du référentiel
     *  @param array            $champs_vue: la liste des champs de la vue
     *  @return string          $initialisation_html : code html avec une div par champ sinon une ligne d'erreur
     */
    private function getInitPanelStandards($champs_referentiel, $champs_vue)
    {

        $initialisation_html = "";
        if ($champs_referentiel !== false) {
            // Les champs sont triés par ordre alphabétique
            $champs_referentiel = OdeArrayHelper::array_orderby($champs_referentiel, 'libelle', SORT_ASC, 'name', SORT_ASC);
            foreach ($champs_referentiel as $champ) {
                if (!in_array($champ['name'], $champs_vue)) {
                    $initialisation_html .= $this->getInitChamp($champ, false);
                }
            }
        } else {
            // Je genere une ligne d'erreur
            $initialisation_html = '<div id="erreur_panel_standards">Aucun champ dans le réferentiel</div>';
        }
        return $initialisation_html;
    }

    /**
     * @access private
     * @name getInitChamp()
     * Fonction qui génére les boutons d'onglets 
     * 
     *  @param array            $champ : tableau des propriété du champ
     *  @return boolean         $in_vue : true si le champ est présent dans la vue, false sinon 
     */
    private function getInitChamp($champ, $in_vue)
    {

        global $app_list_strings;

        // On récupere le libelle du type
        $type = "Inconnu";
        if (array_key_exists('ops_generateur_champ_type_list', $app_list_strings) && is_array($app_list_strings['ops_generateur_champ_type_list']) && count($app_list_strings['ops_generateur_champ_type_list']) > 0) {
            if (!empty($app_list_strings['ops_generateur_champ_type_list'][$champ['type']])) {
                $type = $app_list_strings['ops_generateur_champ_type_list'][$champ['type']];
            } else {
                if ($champ['type'] == "liste_choix_simple") {
                    $type = "Liste";
                }
            }
        }

        $display_obligatoire = ($champ['obligatoire'] === '1' || $champ['obligatoire'] === 1) ? "display:inline-block;" : "display:none;";
        $champ_html = '<div 
                        id="champ_' . $champ['name'] . '" class="champ_referentiel champ_panel" draggable="true" title="' . $champ['libelle'] . '"
                        ondragstart="onDragStart(event)" ondragend="onDragEnd(event)" onclick="openEditChamp(this)"
                        data-name="' . $champ['name'] . '"   data-libelle="' . $champ['libelle'] . '"   data-obligatoire="' . $champ['obligatoire'] . '"
                        data-ineditable="' . $champ['ineditable'] . '"  data-aide="' . $champ['aide'] . '"   data-defaut="' . $champ['defaut'] . '"  data-description="' . $champ['description'] . '"
                        data-type="' . $champ['type'] . '"  data-modifiable="' . $champ['modifiable'] . '"   data-params="' . $champ['params'] . '" 
                    >
                        <div id="titre_champ_' . $champ['name'] . '" class="align-items-center d-flex"';
        $champ_html .=  ($in_vue === false) ? 'style="width: 100%;">' : 'style="width: 50%;">';
        $champ_html .=           ($this->isModifiable($champ['name'])) ? '' : '<i class="fas fa-lock" style="color: #d4af37;margin-right: 3px;"></i> ';
        $champ_html .=           '<div style="white-space: nowrap; overflow: hidden; text-overflow: ellipsis;max-width: 70%;">' . $champ['libelle'] . '</div>';
        $champ_html .=           '<span role="obligatoire" style="color: red; font-weight: bold;' . $display_obligatoire . '">&nbsp; *</span>';
        $champ_html .=           '<span style="font-size: x-small; font-style: oblique; color: #35b3c5; margin-left: 3px;"> (' . $type . ') </span>';
        $champ_html .=  '</div>';
        $champ_html .=       ($in_vue === false) ? '<div class="ode_input_hidden"></div>' :  '<div class="ode_input_hidden" style="display:block;"></div>';
        $champ_html .=   '</div>';

        return $champ_html;
    }

    /**
     * @access private
     * @name getInitBoutonsOnglets()
     * Fonction qui génére les boutons d'onglets 
     * 
     *  @param array            $onglets : la liste des onglets rattaché à la vue
     *  @return string          $btn_onglets_html : code html , les boutons sont groupés dans une div
     */
    private function getInitBoutonsOnglets($onglets)
    {

        $btn_onglets_html = "";
        $count = 0;
        foreach ($onglets as $ordre => $onglet) {
            $btn_onglets_html .= '<div class="div_button_onglet" >';
            $btn_onglets_html .=    '<div role="onglet" id="btn_onglet_' . $onglet['id'] . '" title="' . $onglet['libelle'] . '" data-id="' . $onglet['id'] . '" data-libelle="' . $onglet['libelle'] . '" data-cle="' . $onglet['cle'] . '" onclick="displayOnglet(\'' . $onglet['id'] . '\')" ';
            $btn_onglets_html .=    ($count == 0) ? 'class="btn_onglet btn_onglet_selected" data-selected="1" >' : 'class="btn_onglet btn_onglet_not_selected" data-selected="0" >';
            $btn_onglets_html .=        '<div class="div_libelle_button_onglet" id="titre_onglet_' . $onglet['id'] . '">';
            $btn_onglets_html .=          $onglet['libelle'];
            $btn_onglets_html .=        '</div>';
            $btn_onglets_html .=        '<span id="span_' . $onglet['id'] . '" class="glyphicon glyphicon-pencil span_edit_onglet" onclick="openEditOnglet(event)"';
            $btn_onglets_html .=        ($count == 0) ?  '></span>' : 'style="display:none;" ></span>';
            $btn_onglets_html .=    '</div>';
            $btn_onglets_html .= '</div>';
            $count++;
        }
        return $btn_onglets_html;
    }

    /**
     * @access private
     * @name getInitLayoutsOnglets()
     * Fonction qui génére les layouts d'onglets, en d'autre terme le container qui contient les lignes  
     * 
     *  @param array            $onglets : la liste des onglets rattaché à la vue
     *  @return string          $layout_onglets_html : code html , une div par layout, le premier est affiché par défaut
     */
    private function getInitLayoutsOnglets($onglets)
    {

        $layout_onglets_html = "";
        $count = 0;

        foreach ($onglets as $ordre => $onglet) {
            $layout_onglets_html .= '<div id="layout_onglet_' . $onglet['id'] . '" class="div_layout_onglet" ';
            if ($count == 0) {
                $layout_onglets_html .= 'style="display:block;" >';
            } else {
                $layout_onglets_html .= 'style="display:none;" >';
            }
            $layout_onglets_html .= '<table class="table_layout_onglet">';
            $layout_onglets_html .= '<tbody id="tbody_layout_onglet_' . $onglet['id'] . '"> ';
            $layout_onglets_html .= $this->getLignesOnglet($onglet);
            $layout_onglets_html .= '</tbody>';
            $layout_onglets_html .= '</table>';
            $layout_onglets_html .= '<a class="btn_add_new_ligne" onclick="addLigneOnglet(\'' . $onglet['id'] . '\')"><span class="glyphicon glyphicon-plus" style="color: white;"></span></a>';
            $layout_onglets_html .= '</div>';
            $count++;
        }
        return $layout_onglets_html;
    }

    /**
     * @access private
     * @name getLignesOnglet()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array            $onglet: les informations de l'onglet sous forme de tableau
     *  @return string          $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    private function getLignesOnglet($onglet)
    {

        $lignes = '';
        if (is_array($onglet['champs']) && count($onglet['champs']) > 0) {
            foreach ($onglet['champs'] as $num_ligne => $ligne) {
                if (is_array($ligne)) {
                    ksort($ligne);
                }
                $lignes .= '<tr onmouseover="displaySpanDelete(this)" onmouseout="hideSpanDelete(this)">';
                foreach ($ligne as $pos => $champ) {
                    if ($champ['type'] == "vide") {
                        $lignes .= '<td class="td_layout_onglet" ondragover="onDragOver(event)" ondrop="onDrop(event);"></td>';
                    } else {
                        $lignes .= '<td class="td_layout_onglet" ondragover="onDragOver(event)" ondrop="onDrop(event);" >';
                        $lignes .= $this->getInitChamp($champ, true);
                        $lignes .= '</td>';
                    }
                }
                $lignes .= '<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span onclick="deleteLigneOnglet(this)" class="glyphicon glyphicon-trash span_delete_ligne"></span></td>';
                $lignes .= '</tr>';
            }
        } else {
            $lignes .= '<tr onmouseover="displaySpanDelete(this)" onmouseout="hideSpanDelete(this)">';
            $lignes .= '<td class="td_layout_onglet" ondragover="onDragOver(event)" ondrop="onDrop(event);" ></td>';
            $lignes .= '<td class="td_layout_onglet" ondragover="onDragOver(event)" ondrop="onDrop(event);" ></td>';
            $lignes .= '<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span onclick="deleteLigneOnglet(this)" class="glyphicon glyphicon-trash span_delete_ligne"></span></td>';
            $lignes .= '</tr>';
        }

        return $lignes;
    }


    /**
     * @access private
     * @name isValidChamp()
     * Fonction qui vérifie si un champ est valide
     *
     *  @return boolean               - $valid : true si le champ est valide, false si le champ est vide ou incomplet 
     */
    private function isValidChamp($champ)
    {
        return (is_array($champ) && count($champ) > 0 && !empty($champ['type'])) ? true : false;
    }

    /**
     * @access private
     * @name isModifiable()
     * Fonction qui vérifie si un champ est modifiable
     *
     *  @return boolean               - $modifiable : true si le champ est modifiable, false sinon
     */
    private function isModifiable($champ_name)
    {

        $modifiable = true;
        // On récupere les champs du réferentiel
        $champs_referentiel = OPS_generateur_referentiel::getListReferentiel();
        if ($champs_referentiel !== false) {
            foreach ($champs_referentiel as $champ) {
                if (!empty($champ['name']) && $champ['name'] == $champ_name) {
                    if ($champ['modifiable'] != 1) {
                        $modifiable = false;
                    }
                }
            }
        }
        return $modifiable;
    }
}
