<?php
if (!defined('sugarEntry') || !sugarEntry)
    die('Not A Valid Entry Point');

class OPS_guide_instructionViewEdit extends ViewEdit {
    
    public function __construct()
    {
        parent::__construct();
    }
    
    function display()
    {
        // On récupere le statut initial 
        $statut_initial_id = ( !empty($this->bean->ops_statut_id) ) ? $this->bean->ops_statut_id : "" ;
        $obj_statut = ( !empty($statut_initial_id) ) ? BeanFactory::getBean('OPS_statut', $statut_initial_id) : false ;

        // On récupere l'étape associée au statut
        $liste_etapes_statut = ( $obj_statut !== false && !empty($obj_statut->id) ) ? $obj_statut->get_linked_beans("ops_etape_ops_statut","OPS_etape") : array() ;
        $obj_etape = ( is_array($liste_etapes_statut) && count($liste_etapes_statut) > 0 ) ? $liste_etapes_statut[0] : false;
        $etape_initiale_id = ( $obj_etape !== false && !empty($obj_etape->id) ) ? $obj_etape->id : "" ;

        // On récupere la liste des étapes et des statuts du guide d'instruction
        $etapes = array(); 
        $liste_etapes = $this->bean->get_linked_beans("ops_guide_instruction_ops_etape","OPS_etape");
        if ( is_array($liste_etapes) && count($liste_etapes) > 0 ) {
            foreach ( $liste_etapes as $etape ) {
                $etapes[$etape->id] = array(
                   'name' => $etape->name,
                   'statuts' => $etape->getListeStatuts()
                );
            }
        }
        //$GLOBALS['log']->fatal(" OPS_guide_instructionViewEdit :: display => etapes = " .print_r( $etapes , true) );

        // On construit le select etapes
        $select_etape_initiale = '<select id="select_etape_initiale" onchange="onChangeSelectEtape()" style="width: 45%;margin-right: 5%;">';
        $select_etape_initiale .= '<option>Sélectionner une étape</option>';
        if( is_array($etapes) && count($etapes) > 0 ){
            foreach ( $etapes as $etape_id => $etape ) {
                $select_etape_initiale .= ( $etape_id === $etape_initiale_id ) ? '<option selected="selected" ' : '<option ' ;
                $select_etape_initiale .= 'id="' . $etape_id . '" > ' . $etape['name'] . ' </option>';
            }
        }
        $select_etape_initiale .='</select> ';

        // On construit le select statuts
        $select_statut_initial ='<select id="select_statut_initial" onchange="onChangeSelectStatut()" style="width: 45%;">';
        $select_statut_initial .=    '<option>Sélectionner un statut</option>';
        if( !empty( $etape_initiale_id ) ){
            if( array_key_exists($etape_initiale_id , $etapes) ){
                foreach ( $etapes[$etape_initiale_id]['statuts'] as $statut_id => $statut_name ) {
                    $select_statut_initial .= ( $statut_id === $statut_initial_id ) ? '<option selected="selected" ' : '<option ' ;
                    $select_statut_initial .= 'id="' . $statut_id . '" > ' . $statut_name . ' </option>';
                }
            }
        }
        $select_statut_initial .='</select>';
        
        $statut_initial =  $select_etape_initiale . $select_statut_initial;
        $statut_initial .= '<input type="hidden" name="ops_statut_id" id="ops_statut_id" value="' . $statut_initial_id . '">';
        $statut_initial .= '<input type="hidden" id="guide_instruction_etapes" value="' . base64_encode ( json_encode( $etapes ) ). '">';
        $this->ss->assign("statut_initial", $statut_initial);

        // On récupere la liste des étapes et des statuts du guide d'instruction
        $etapes = array(); 
        $liste_etapes = $this->bean->get_linked_beans("ops_guide_instruction_ops_etape","OPS_etape");
        if ( is_array($liste_etapes) && count($liste_etapes) > 0 ) {
            foreach ( $liste_etapes as $etape ) {
                $etapes[$etape->id] = array(
                   'name' => $etape->name,
                   'statuts' => $etape->getListeStatuts()
                );
            }
        }

        // On construit le select etapes
        $select_etape_completude = '<select id="select_etape_completude" onchange="onChangeSelectEtapeCompletude()" style="width: 45%;margin-right: 5%;">';
        $select_etape_completude .= '<option>Sélectionner une étape</option>';
        if( is_array($etapes) && count($etapes) > 0 ){
            foreach ( $etapes as $etape_id => $etape ) {
                $select_etape_completude .= ( $etape_id === $etape_completude_id ) ? '<option selected="selected" ' : '<option ' ;
                $select_etape_completude .= 'id="' . $etape_id . '" > ' . $etape['name'] . ' </option>';
            }
        }
        $select_etape_completude .='</select> ';
        
        parent::display();
    }

}
