<?php

require_once('include/SugarObjects/templates/file/File.php');

class OPS_justificatif extends File
{
    public $new_schema = true;
    public $module_dir = 'OPS_justificatif';
    public $object_name = 'OPS_justificatif';
    public $table_name = 'ops_justificatif';
    public $importable = false;

    public $id;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;
    public $document_name;
    public $filename;
    public $file_ext;
    public $file_mime_type;
    public $uploadfile;
    public $active_date;
    public $exp_date;
    public $category_id;
    public $subcategory_id;
    public $status_id;
    public $status;

    public function bean_implements($interface)
    {
        switch($interface)
        {
            case 'ACL':
                return true;
        }

        return false;
    }

    function get_color_modal($idColor){

        $color = array(
            'valide'        => 'rgb(45, 188, 27)',
            'rejete'        => 'rgb(234, 35, 35)',
            'perime'        => 'rgb(234, 35, 35)',
            'non_fourni'    => 'rgb(150, 150, 150)',
            'etude'         => 'rgb(234, 149, 35)',
            'reetude'       => 'rgb(234, 149, 35)',
            'defaut'        => 'rgb(110, 110, 110)',
        );

        return (!empty($idColor) && array_key_exists($idColor,$color)) ? $color[$idColor] : $color['defaut'];
    }

    static function html_modal()
    {
        $modale_html = '<div id="modal-justificatif" class="modal" tabindex="-1" role="dialog">';
        $modale_html .=     '<div class="modal-dialog" style="max-width: 800px;">';
        $modale_html .=         '<div class="modal-content">';
        $modale_html .=             '<div class="modal-header">';
        $modale_html .=                 '<button type="button" class="close" data-dismiss="modal" aria-hidden="true">x</button>';
        $modale_html .=                 '<h4 class="modal-title" id="titre_modal_justificatif"></h4>';
        $modale_html .=                 '</button>';
        $modale_html .=             '</div>';
        $modale_html .=             '<div id="modal-justificatif-body" class="modal-body">';
        $modale_html .=             '</div>';
        $modale_html .=             '<div id="modal-justificatif-error"></div>';
        $modale_html .=             '<div class="modal-footer">';
        $modale_html .=                 '<button id="envoyer_mail" type="button" class="button button-modal" onclick="envoyer_mail()" >Envoyer</button>';
        $modale_html .=                 '<button id="save_statut" type="button" class="button button-modal" onclick="save_statut()" >Sauvegarder</button>';
        $modale_html .=                 '<button id="supprimer_justificatif" type="button" class="button button-modal" onclick="supprimer_justificatif()" >Ok</button>';
        $modale_html .=                 '<button type="button" class="button button-modal" data-dismiss="modal" id="annuler_modal">Annuler</button>';
        $modale_html .=             '</div>';
        $modale_html .=         '</div>';
        $modale_html .=     '</div>';
        $modale_html .= '</div>';

        return $modale_html;
    }

    static function get_statut_select(){
        global $app_list_strings;

        asort($app_list_strings['ops_statut_j_list']);

        $inputSelect = '<select name="select_statut_justificatif" id="select_statut_justificatif">';

        foreach ($app_list_strings['ops_statut_j_list'] as $key => $value) {
            $inputSelect .= '<option value="'.$key.'">'.$value.'</option>';
        }
        $inputSelect .= '</select>';
        return $inputSelect;
    }

    static function get_mail_radio(){

        global $app_list_strings;

        asort($app_list_strings['ops_mail_j_list']);

        // Construction des options 
        $inputRadio = '';
        foreach($app_list_strings['ops_mail_j_list'] as $key => $value){
            $inputRadio .= '<div>';
            $inputRadio .= '<input type="radio" id="'.$key.'" value="'.$key.'" name="radio_mail_justificatif">';
            $inputRadio .= '<label class="label_mail_radio" for="'.$key.'">'.$value.'</label>';
            $inputRadio .= '</div>';
        }

        return $inputRadio;
    }

    function create_new_list_query($order_by, $where, $filter = array(), $params = array(), $show_deleted = 0, $join_type = '', $return_array = false, $parentbean = null, $singleSelect = false, $ifListForExport = false)
    {
        global $current_user;

        $return_array = parent::create_new_list_query($order_by, $where, $filter, $params, $show_deleted, $join_type, $return_array, $parentbean, true, $ifListForExport);

        if(!is_array($return_array))
        {
            return $return_array;
        }

        if($current_user->isAdmin())
        {
            return $return_array;
        }

        if($_REQUEST['module'] == 'OPS_dossier')
        {
            return $return_array;
        }

        $dossier = new OPS_dossier();

        // On récupère les dispositifs 
        $dossier->create_requete_dossier();

        $return_array['from'] .= ' 
        LEFT JOIN ops_dossier_ops_justificatif ON ops_dossier_ops_justificatif.ops_justificatif_id = ops_justificatif.id 
        LEFT JOIN ops_dossier ON ops_dossier.id = ops_dossier_ops_justificatif.ops_dossier_id AND ops_dossier.name != "TEMP"';

        if(!$current_user->isAdmin() && $_SESSION['ops_requete_dossier'] == false)
        {
            $return_array['where'] .= "  WHERE ops_dossier.id like '0' ";

            return $return_array;
        }

        if($current_user->isAdmin())
        {
            return $return_array;
        }

        // DISPOSITIFS
        $return_array['where'] .= ' AND ( ops_dossier.num_dossier IS NULL OR ( ' . $_SESSION['ops_requete_dossier'];

        // DOSSIER LOCALISE OU NON
        if( !$current_user->isAdmin() && (!empty($_SESSION['habilitation_localisation']) || $current_user->dossiers_non_localises == true) )
        {
            $from = $where_localisation = $where_non_localise = '';

            if( !empty($_SESSION['habilitation_localisation']) )
            {
                $user_localisations = $_SESSION['habilitation_localisation'];
                $localisations = [];
                // Partie TERRITOIRE
                foreach($user_localisations as $localisation)
                {
                    $localisations[] = "'" . $localisation . "'";
                }

                $localisations = implode(',', $localisations);


                if( $current_user->dossiers_non_localises != true )
                {
                    $from = " 
                            INNER JOIN ops_sous_territoire_ops_dossier sous_territoire_dossier ON ops_dossier.id = sous_territoire_dossier.ops_dossier_id AND sous_territoire_dossier.deleted=0
                            INNER JOIN ops_sous_territoire_ops_territoire sous_territoire_territoire ON sous_territoire_dossier.ops_sous_territoire_id = sous_territoire_territoire.ops_sous_territoire_id AND sous_territoire_territoire.deleted=0 ";

                    $where_localisation = " sous_territoire_territoire.ops_territoire_id IN ( $localisations )";
                }
                else
                {
                    $where_localisation = " ops_dossier.id IN ( SELECT ops_dossier.id
                                                                FROM ops_dossier 
                                                                INNER JOIN ops_sous_territoire_ops_dossier sous_territoire_dossier ON ops_dossier.id = sous_territoire_dossier.ops_dossier_id AND sous_territoire_dossier.deleted=0
                                                                INNER JOIN ops_sous_territoire_ops_territoire sous_territoire_territoire ON sous_territoire_dossier.ops_sous_territoire_id = sous_territoire_territoire.ops_sous_territoire_id AND sous_territoire_territoire.deleted=0
                                                                WHERE ops_dossier.deleted = 0 AND sous_territoire_territoire.ops_territoire_id IN ( $localisations ) )";
                }
            }

            if( $current_user->dossiers_non_localises == true )
            {
                $where_non_localise = "  ops_dossier.id NOT IN ( 
                                             SELECT  ops_sous_territoire_ops_dossier.ops_dossier_id
                                             FROM ops_sous_territoire_ops_dossier
                                             WHERE ops_sous_territoire_ops_dossier.deleted = '0'
                                         )";
            }
            
            $return_array['where'] .= ' ) ) ';

            if( !empty($_SESSION['habilitation_localisation']) && $current_user->dossiers_non_localises == true )
            {
                $return_array['where'] .= ' AND (' . $where_localisation . ' OR ' . $where_non_localise . ') ';
            }
            else
            {
                $return_array['where'] .= ' AND ' . ((!empty($where_localisation)) ? $where_localisation : $where_non_localise);
            }

            $return_array['from'] .= $from;
        }
        // END - DOSSIER LOCALISE OU NON

        $return_array['from_min'] = $return_array['from'];

        // ORDER BY
        if (is_array($return_array) && (empty($return_array['order_by']) || $return_array['order_by'] == " ORDER BY ops_dossier.num_dossier")) 
        {
            $return_array['order_by'] = " ORDER BY " . strtoupper('num_dossier') . ' DESC';
        }

        return $return_array;
    }
}
