var selected = 0;

var custom_individu = ['LBL_BENEFICIAIRE', 'LBL_OPS_INDIVIDU_OPS_DOSSIER_FROM_OPS_INDIVIDU_TITLE', 'LBL_PERSONNE_INDIVIDU', 'OPS_individu', 'LBL_MEDECIN_TRAITANT','LBL_PERSONNE_INDIVIDU_FONCTION','LBL_DOSSIER_PERSONNE_INDIVIDU_FONCTION','demandeur'];
var custom_personne_moral = ['LBL_OPS_PERSONNE_MORALE','LBL_PERSONNE_MORALE' , 'LBL_INTERVENANT_MANDATAIRE_MOR', 'OPS_personne_morale'];

function showVariable(fld){

   var regex = /^\$dossier_personne_individu_fonction|^\$personne_individu_fonction/;

   if (regex.test(fld) && $("#fonction_name").val()) {
       fld += '[fonction:'+$("#fonction_name").val()+']';
   }  
   $('#variable_text').val(fld);
}

function setType(type){
    document.getElementById("type").value = type;
    populateModuleVariables(type);
}

function populateVariables(type)
{
   document.getElementById('variable_name').innerHTML = '';
   document.getElementById('variable_text').value = '';

   if(type === 'LBL_OPS_INDIVIDU_OPS_DOSSIER_FROM_OPS_INDIVIDU_TITLE'){
    type = 'demandeur';
   }
   
   var selector = document.getElementById('variable_name');

   if( custom_individu.includes(type) || custom_personne_moral.includes(type) )
   {
       var variable_name = type.replace('LBL_', '');
       variable_name = variable_name.toLowerCase();

       if( custom_individu.includes(type) ) 
       {
           $('#variable_name').append(individu_field_list);
       }
       else
       {
           $('#variable_name').append(personne_morale_field_list);
       }
       
       $('select[name="variable_name"] option').each(function() {
           if ($(this).text().indexOf("LBL") >= 0)
           {
               $(this).hide();
           }
           else
           {
               $(this).val( '$' + variable_name + '_' + $(this).val() );
           }
       });
   }
   else
   {
       var reg_values =  regularOptions[type];

       for (var i in reg_values) 
       {
           var text_option = reg_values[i].replaceAll('&#039;', "'");
           if (!text_option.indexOf("LBL") >= 0)
           {
               selector.options[selector.options.length] = new Option(text_option, i);
           }
       }
   }
}

function populateModuleVariables(type){
    var mod_values =  moduleOptions[type];
    $('#fonction_name').hide();

    document.getElementById('module_name').innerHTML = '';

    var selector = document.getElementById('module_name');
    for (var i in mod_values) {
        selector.options[selector.options.length] = new Option(mod_values[i], i);
    }
    populateVariables(type);
}

function insert_variable(text) {
    if (text != ''){
        var inst = tinyMCE.getInstanceById("description");
        if (inst) inst.getWin().focus();
        inst.execCommand('mceInsertContent', false, text);
        inst.execCommand('mceToggleEditor');
        inst.execCommand('mceToggleEditor');
    }
}

function insertSample(smpl){
    if(smpl != 0){
        var body = tinyMCE.getInstanceById("description");
        var header = tinyMCE.getInstanceById("pdfheader");
        var footer = tinyMCE.getInstanceById("pdffooter");
        var cnf = true;
        if(body.getContent() != '' || header.getContent() != '' || footer.getContent() != ''){
            cnf=confirm(SUGAR.language.get('AOS_PDF_Templates', 'LBL_WARNING_OVERWRITE'));
        }
        if(cnf){
            smpl = JSON.parse(smpl);
            setType(smpl[0]);
            body.setContent(smpl[1]);
            header.setContent(smpl[2]);
            footer.setContent(smpl[3]);
            selected = document.getElementById('sample').options.selectedIndex;
        }
        else{
            document.getElementById('sample').options.selectedIndex =selected;
        }
    }
}
$(document).ready(function() {

    function NASort(a, b) {    
        if (a.innerHTML == 'NA') {
            return 1;   
        }
        else if (b.innerHTML == 'NA') {
            return -1;   
        }       
        return (a.innerHTML > b.innerHTML) ? 1 : -1;
    };

     $('select[name="variable_name"] option').sort(NASort).appendTo('select[name="variable_name"]');
     $('select[name="variable_name"]').prop("selectedIndex", 0);

     $('select[name="variable_module"] option').sort(NASort).appendTo('select[name="variable_module"]');
     $('select[name="variable_module"]').prop("selectedIndex", 0);
     $("input[name='variable_text']").val($('select[name="variable_name"] option:selected').val());

     $('#module_name').on('change', function() {

        function NASort(a, b) {    
            if (a.innerHTML == 'NA') {
                return 1;   
            } 
            else if (b.innerHTML == 'NA') {
                return -1;   
            }       
            return (a.innerHTML > b.innerHTML) ? 1 : -1;
        };

        if( !custom_individu.includes( $(this).val() ) && !custom_personne_moral.includes( $(this).val() ) )
        {
           $('select[name="variable_name"] option').sort(NASort).appendTo('select[name="variable_name"]');
        }

        $('select[name="variable_name"]').prop("selectedIndex", 0);
        $("input[name='variable_text']").val($('select[name="variable_name"] option:selected').val());

        if($(this).val() == 'LBL_DOSSIER_PERSONNE_INDIVIDU_FONCTION' || $(this).val() == 'LBL_PERSONNE_INDIVIDU_FONCTION'){
           $('#fonction_name').val('');
           $('#fonction_name').show();
        }else{
           $('#fonction_name').hide();
        }
    });

    $('#fonction_name').change(function(){
        if($(this).val() != ''){
            $('#variable_text').val($('#variable_name').val() + '[fonction:'+$("#fonction_name").val()+']');
        }
     });
});