<?php

$dictionary['OPS_personne_morale'] = array(
    'table' => 'ops_personne_morale',
    'audited' => true,
    'inline_edit' => true,
    'duplicate_merge' => true,
    'fields' => array(
        'name' => array(
            'name' => 'name',
            'type' => 'name',
            'dbType' => 'varchar',
            'vname' => 'LBL_NAME',
            'len' => '255',
            'comment' => 'Name of the Company',
            'unified_search' => true,
            'full_text_search' => array(
                'boost' => 3
            ),
            'audited' => true,
            'required' => true,
            'importable' => 'required',
            'merge_filter' => 'disabled',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => 'Name of the Company',
            'help' => '',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'inline_edit' => true,
            'reportable' => true,
            'size' => '20'
        ),

        'assigned_user_id' => array(
            'name' => 'assigned_user_id',
            'rname' => 'user_name',
            'id_name' => 'assigned_user_id',
            'vname' => 'LBL_ASSIGNED_TO_ID',
            'group' => 'assigned_user_name',
            'massupdate' => false,
            'type' => 'relate',
            'table' => 'users',
            'module' => 'Users',
            'reportable' => true,
            'isnull' => 'false',
            'dbType' => 'id',
            'audited' => false,
            'comment' => 'User ID assigned to record',
            'duplicate_merge' => 'disabled',
        ),
        'industry' => array(
            'name' => 'industry',
            'vname' => 'LBL_INDUSTRY',
            'type' => 'enum',
            'options' => 'industry_dom',
            'len' => 50,
            'comment' => 'The company belongs in this industry',
            'merge_filter' => 'enabled',
            'massupdate' => false,
        ),
        'ops_personne_morale_type' => array (
            'name' => 'ops_personne_morale_type',
            'vname' => 'LBL_TYPE',
            'type' => 'enum',
            'options' => 'ops_personne_morale_type_dom',
            'len' => 50,
            'comment' => 'The Company is of this type',
            'massupdate' => false,
        ),

        'sigle' => array(
            'required' => false,
            'name' => 'sigle',
            'vname' => 'LBL_SIGLE',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'logo' => array(
            'required' => false,
            'name' => 'logo',
            'vname' => 'LBL_LOGO',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'tiers_appaire' => array(
            'required' => false,
            'name' => 'tiers_appaire',
            'vname' => 'LBL_TIERS_APPAIRE',
            'type' => 'enum',
            'massupdate' => 0,
            'default' => 'N',
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_pm_tiers_appaire_list',
            'studio' => 'visible',
            'dependency' => false
        ),
        'financeur' => array(
            'required' => false,
            'name' => 'financeur',
            'vname' => 'LBL_FINANCEUR',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'num_tahiti' => array(
            'required' => false,
            'name' => 'num_tahiti',
            'vname' => 'LBL_NUM_TAHITI',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => '17',
            'size' => '20'
        ),
        'siret' => array(
            'required' => false,
            'name' => 'siret',
            'vname' => 'LBL_SIRET',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => '17',
            'size' => '20'
        ),
        'reference' => array(
            'required' => false,
            'name' => 'reference',
            'vname' => 'LBL_REFERENCE',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'numero_rna' => array(
            'required' => false,
            'name' => 'numero_rna',
            'vname' => 'LBL_NUMERO_RNA',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'numero_rne' => array(
            'required' => false,
            'name' => 'numero_rne',
            'vname' => 'LBL_NUMERO_RNE',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'date_declaration' => array(
            'required' => false,
            'name' => 'date_declaration',
            'vname' => 'LBL_DATE_DECLARATION',
            'type' => 'date',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'enable_range_search' => false
        ),
        'ops_formule_id' => array(
            'required' => false,
            'name' => 'ops_formule_id',
            'vname' => 'LBL_FORMULE_APPEL_OPS_FORMULE_ID',
            'type' => 'id',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => 0,
            'audited' => false,
            'inline_edit' => true,
            'reportable' => false,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 36,
            'size' => '20'
        ),
        'formule_appel_courrier' => array(
            'required' => false,
            'source' => 'non-db',
            'name' => 'formule_appel_courrier',
            'vname' => 'LBL_FORMULE_APPEL_COURRIER',
            'type' => 'relate',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'id_name' => 'ops_formule_id',
            'ext2' => 'OPS_formule',
            'module' => 'OPS_formule',
            'rname' => 'name',
            'quicksearch' => 'enabled',
            'studio' => 'visible'
        ),
        'ops_formule1_id' => array(
            'required' => false,
            'name' => 'ops_formule1_id',
            'vname' => 'LBL_FORMULE_POLITESSE_OPS_FORMULE_ID',
            'type' => 'id',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => 0,
            'audited' => false,
            'inline_edit' => true,
            'reportable' => false,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 36,
            'size' => '20'
        ),
        'formule_politesse_courrier' => array(
            'required' => false,
            'source' => 'non-db',
            'name' => 'formule_politesse_courrier',
            'vname' => 'LBL_FORMULE_POLITESSE_COURRIER',
            'type' => 'relate',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'id_name' => 'ops_formule1_id',
            'ext2' => 'OPS_formule',
            'module' => 'OPS_formule',
            'rname' => 'name',
            'quicksearch' => 'enabled',
            'studio' => 'visible'
        ),
        'ops_formule2_id' => array(
            'required' => false,
            'name' => 'ops_formule2_id',
            'vname' => 'LBL_FORMULE_APPEL_OPS_FORMULE_ID',
            'type' => 'id',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => 0,
            'audited' => false,
            'inline_edit' => true,
            'reportable' => false,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 36,
            'size' => '20'
        ),
        'formule_appel_email' => array(
            'required' => false,
            'source' => 'non-db',
            'name' => 'formule_appel_email',
            'vname' => 'LBL_FORMULE_APPEL_EMAIL',
            'type' => 'relate',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'id_name' => 'ops_formule2_id',
            'ext2' => 'OPS_formule',
            'module' => 'OPS_formule',
            'rname' => 'name',
            'quicksearch' => 'enabled',
            'studio' => 'visible'
        ),
        'ops_formule3_id' => array(
            'required' => false,
            'name' => 'ops_formule3_id',
            'vname' => 'LBL_FORMULE_POLITESSE_OPS_FORMULE_ID',
            'type' => 'id',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => 0,
            'audited' => false,
            'inline_edit' => true,
            'reportable' => false,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 36,
            'size' => '20'
        ),
        'formule_politesse_email' => array(
            'required' => false,
            'source' => 'non-db',
            'name' => 'formule_politesse_email',
            'vname' => 'LBL_FORMULE_POLITESSE_EMAIL',
            'type' => 'relate',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'id_name' => 'ops_formule3_id',
            'ext2' => 'OPS_formule',
            'module' => 'OPS_formule',
            'rname' => 'name',
            'quicksearch' => 'enabled',
            'studio' => 'visible'
        ),
        'num_tiers' => array(
            'required' => false,
            'name' => 'num_tiers',
            'vname' => 'LBL_NUM_TIERS',
            'type' => 'int',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '5',
            'size' => '20',
            'enable_range_search' => false,
            'disable_num_format' => '',
            'min' => false,
            'max' => false
        ),
        'statut' => array(
            'required' => false,
            'name' => 'statut',
            'vname' => 'LBL_STATUT',
            'type' => 'enum',
            'massupdate' => 0,
            'default' => 'n_bloque',
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_statut_pm_list',
            'studio' => 'visible',
            'dependency' => false
        ),
        'ops_individu_id' => array(
            'required' => false,
            'name' => 'ops_individu_id',
            'vname' => 'LBL_PERSONNE_INDIVIDU_OPS_INDIVIDU_ID',
            'type' => 'id',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => 0,
            'audited' => false,
            'inline_edit' => false,
            'reportable' => false,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 36,
            'size' => '20'
        ),
        'personne_individu' => array(
            'required' => false,
            'source' => 'non-db',
            'name' => 'personne_individu',
            'vname' => 'LBL_PERSONNE_INDIVIDU',
            'type' => 'relate',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'id_name' => 'ops_individu_id',
            'ext2' => 'OPS_individu',
            'module' => 'OPS_individu',
            'rname' => 'name',
            'quicksearch' => 'enabled',
            'studio' => 'visible'
        ),
        'ops_individu1_id' => array(
            'required' => false,
            'name' => 'ops_individu1_id',
            'vname' => 'LBL_INTERVENANT_MANDATAIRE_MOR_OPS_INDIVIDU_ID',
            'type' => 'id',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => 0,
            'audited' => false,
            'inline_edit' => false,
            'reportable' => false,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 36,
            'size' => '20'
        ),
        'intervenant_mandataire_mor' => array(
            'required' => false,
            'source' => 'non-db',
            'name' => 'intervenant_mandataire_mor',
            'vname' => 'LBL_INTERVENANT_MANDATAIRE_MOR',
            'type' => 'relate',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'id_name' => 'ops_individu1_id',
            'ext2' => 'OPS_personne_morale',
            'module' => 'OPS_personne_morale',
            'rname' => 'name',
            'quicksearch' => 'enabled',
            'studio' => 'visible'
        ),
        //bug 42902
        'email' => array(
            'name' => 'email',
            'type' => 'email',
            'query_type' => 'default',
            'source' => 'non-db',
            'operator' => 'subquery',
            'subquery' => 'SELECT eabr.bean_id FROM email_addr_bean_rel eabr JOIN email_addresses ea ON (ea.id = eabr.email_address_id) WHERE eabr.deleted=0 AND ea.email_address LIKE',
            'db_field' => array(
                'id'
            ),
            'vname' => 'LBL_ANY_EMAIL',
            'studio' => array(
                'visible' => false,
                'searchview' => true
            ),
            'importable' => false
        ),
        'email1' => array(
            'name' => 'email1',
            'vname' => 'LBL_EMAIL_ADDRESS',
            'type' => 'varchar',
            'unified_search' => true,
            'function' => array(
                'name' => 'getEmailAddressWidget',
                'returns' => 'html'
            ),
            'merge_filter' => 'enabled',
            'duplicate_merge' => 'enabled',

            'source' => 'non-db',
            'group' => 'email1',
            'full_text_search' => array(
                'boost' => 3,
                'analyzer' => 'whitespace'
            ), //bug 54567
            'audited' => true
        ),
        'shipping_address_number' => array(
            'name' => 'shipping_address_number',
            'vname' => 'LBL_SHIPPING_ADDRESS_NUMBER',
            'type' => 'varchar',
            'len' => '200',
            'merge_filter' => 'enabled',
            'audited' => false
        ),
        'shipping_address_complement' => array(
            'name' => 'shipping_address_complement',
            'vname' => 'LBL_SHIPPING_ADDRESS_COMPLEMENT',
            'type' => 'varchar',
            'len' => '200',
            'merge_filter' => 'enabled',
            'audited' => false
        ),
        'shipping_address_complement_lieu' => array(
            'name' => 'shipping_address_complement_lieu',
            'vname' => 'LBL_SHIPPING_ADDRESS_COMPLEMENT_LIEU',
            'type' => 'varchar',
            'len' => '200',
            'merge_filter' => 'enabled',
            'audited' => false
        ),
        'shipping_address_coordonnees_x' => array(
            'name' => 'shipping_address_coordonnees_x',
            'vname' => 'LBL_SHIPPING_ADDRESS_COORDONNEES_X',
            'type' => 'varchar',
            'len' => '200',
            'merge_filter' => 'enabled',
            'audited' => false
        ),
        'shipping_address_coordonnees_y' => array(
            'name' => 'shipping_address_coordonnees_y',
            'vname' => 'LBL_SHIPPING_ADDRESS_COORDONNEES_Y',
            'type' => 'varchar',
            'len' => '200',
            'merge_filter' => 'enabled',
            'audited' => false
        ),
        'billing_address_number' => array(
            'name' => 'billing_address_number',
            'vname' => 'LBL_BILLING_ADDRESS_NUMBER',
            'type' => 'varchar',
            'len' => '200',
            'group' => 'billing_address',
            'merge_filter' => 'enabled',
            'audited' => true
        ),
        'billing_address_street' => array(
            'name' => 'billing_address_street',
            'vname' => 'LBL_BILLING_ADDRESS_STREET',
            'type' => 'varchar',
            'len' => '200',
            'group' => 'billing_address',
            'merge_filter' => 'enabled',
            'audited' => true
        ),
        'billing_address_street_1' => array(
            'name' => 'billing_address_street_1',
            'vname' => 'LBL_BILLING_ADDRESS_STREET_1',
            'type' => 'varchar',
            'len' => '38',
            'source' => 'non-db'
        ),
        'billing_address_complement' => array(
            'name' => 'billing_address_complement',
            'vname' => 'LBL_BILLING_ADDRESS_COMPLEMENT',
            'type' => 'varchar',
            'len' => '38',
            'merge_filter' => 'enabled',
            'audited' => false
        ),
        'billing_address_complement_lieu' => array(
            'name' => 'billing_address_complement_lieu',
            'vname' => 'LBL_BILLING_ADDRESS_COMPLEMENT_LIEU',
            'type' => 'varchar',
            'len' => '38',
            'merge_filter' => 'enabled',
            'audited' => false
        ),
        'billing_address_city' => array(
            'name' => 'billing_address_city',
            'vname' => 'LBL_BILLING_ADDRESS_CITY',
            'type' => 'varchar',
            'len' => '255',
            'group' => 'billing_address',
            'merge_filter' => 'enabled',
            'audited' => true,
            'massupdate' => true
        ),
        'billing_address_state' => array(
            'name' => 'billing_address_state',
            'vname' => 'LBL_BILLING_ADDRESS_STATE',
            'type' => 'varchar',
            'len' => '100',
            'group' => 'billing_address',
            'merge_filter' => 'enabled'
        ),
        'billing_address_postalcode' => array(
            'name' => 'billing_address_postalcode',
            'vname' => 'LBL_BILLING_ADDRESS_POSTALCODE',
            'type' => 'varchar',
            'len' => '10',
            'group' => 'billing_address',
            'merge_filter' => 'enabled',
            'audited' => true,
            'massupdate' => true
        ),
        'billing_address_country' => array(
            'name' => 'billing_address_country',
            'vname' => 'LBL_BILLING_ADDRESS_COUNTRY',
            'type' => 'varchar',
            'group' => 'billing_address',
            'merge_filter' => 'enabled',
            'audited' => false,
            'len' => '100'
        ),
        'billing_id_adresse' => array(
            'name' => 'billing_id_adresse',
            'vname' => 'LBL_ID_ADRESSE',
            'type' => 'varchar',
            'group' => 'billing_address',
            'merge_filter' => 'enabled',
            'audited' => false,
            'len' => '100'
        ),
        'billing_code_insee' => array(
            'name' => 'billing_code_insee',
            'vname' => 'LBL_CODE_INSEE',
            'type' => 'varchar',
            'group' => 'billing_address',
            'merge_filter' => 'enabled',
            'audited' => false,
            'len' => '100'
        ),
        'billing_coordonnees_y' => array(
            'required' => false,
            'name' => 'billing_coordonnees_y',
            'vname' => 'LBL_COORDONNEES_Y',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'billing_coordonnees_x' => array(
            'required' => false,
            'name' => 'billing_coordonnees_x',
            'vname' => 'LBL_COORDONNEES_X',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'code_ape' => array(
            'required' => false,
            'name' => 'code_ape',
            'vname' => 'LBL_CODE_APE',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'forme_juridique' => array(
            'required' => false,
            'name' => 'forme_juridique',
            'vname' => 'LBL_FORME_JURIDIQUE',
            'type' => 'enum',
            'massupdate' => true,
            'default' => '',
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_forme_juridique_list',
            'studio' => 'visible',
            'dependency' => false
        ),
        'effectif' => array(
            'required' => false,
            'name' => 'effectif',
            'vname' => 'LBL_EFFECTIF',
            'type' => 'enum',
            'massupdate' => true,
            'default' => '',
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_type_profil_effectif_list',
            'studio' => 'visible',
            'dependency' => false
        ),
        'secteur_activite' => array(
            'required' => false,
            'name' => 'secteur_activite',
            'vname' => 'LBL_SECTEUR_ACTIVITE',
            'type' => 'enum',
            'massupdate' => true,
            'default' => '',
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_profil_secteur_activite_list',
            'studio' => 'visible',
            'dependency' => false
        ),
        'objet_social' => array(
            'required' => false,
            'name' => 'objet_social',
            'vname' => 'LBL_OBJET_SOCIAL',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'canal' => array(
            'required' => false,
            'name' => 'canal',
            'vname' => 'LBL_CANAL',
            'type' => 'enum',
            'massupdate' => 0,
            'default' => 'crm',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_canal_list',
            'studio' => 'visible',
            'dependency' => false
        ),
        'numero_fiscale' => array(
            'required' => false,
            'name' => 'numero_fiscale',
            'vname' => 'LBL_NUMERO_FISCALE',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
        ),
        'regime_allocataire' => array(
            'required' => false,
            'name' => 'regime_allocataire',
            'vname' => 'LBL_REGIME_ALLOCATAIRE',
            'type' => 'enum',
            'massupdate' => true,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_regime_allocataire_list',
            'studio' => 'visible',
            'dependency' => false,
        ),
        'numero_allocataire' => array(
            'required' => false,
            'name' => 'numero_allocataire',
            'vname' => 'LBL_NUMERO_ALLOCATAIRE',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
        ),
        'qf_caf_actuel' => array(
            'required' => false,
            'name' => 'qf_caf_actuel',
            'vname' => 'LBL_QF_CAF_ACTUEL',
            'type' => 'decimal',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '18',
            'size' => '20',
            'enable_range_search' => false,
            'precision' => '2',
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => '1',
        ),
        'qf_ville_actuel' => array(
            'required' => false,
            'name' => 'qf_ville_actuel',
            'vname' => 'LBL_QF_VILLE_ACTUEL',
            'type' => 'decimal',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '18',
            'size' => '20',
            'enable_range_search' => false,
            'precision' => '2',
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => '1',
        ),
        'date_application' => array(
            'required' => false,
            'name' => 'date_application',
            'vname' => 'LBL_DATE_APPLICATION',
            'type' => 'date',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'enable_range_search' => false,
        ),
        'situation_handicap' => array(
            'required' => false,
            'name' => 'situation_handicap',
            'vname' => 'LBL_SITUATION_HANDICAP',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
        ),
        'adresse_date_validite' => array(
            'required' => false,
            'name' => 'adresse_date_validite',
            'vname' => 'LBL_ADRESSE_DATE_VALIDITE',
            'type' => 'date',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'enable_range_search' => false,
        ),

        'adresse_hors_commune' => array(
            'required' => false,
            'name' => 'adresse_hors_commune',
            'vname' => 'LBL_ADRESSE_HORS_COMMUNE',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
        ),

        'agrement_administratif' => array(
            'required' => false,
            'name' => 'agrement_administratif',
            'vname' => 'LBL_AGREMENT_ADMINISTRATIF',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
        ),

        'utilite_publique' => array(
            'required' => false,
            'name' => 'utilite_publique',
            'vname' => 'LBL_UTILITE_PUBLIQUE',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
        ),

        'affiliee_reseau' => array(
            'required' => false,
            'name' => 'affiliee_reseau',
            'vname' => 'LBL_AFFILIEE_RESEAU',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
        ),

        'detail_agrement' => array(
            'required' => false,
            'name' => 'detail_agrement',
            'vname' => 'LBL_DETAIL_AGREMENT',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'studio' => 'visible',
            'rows' => '6',
            'cols' => '80',
        ),

        'date_utilite_publique' => array(
            'required' => false,
            'name' => 'date_utilite_publique',
            'vname' => 'LBL_DATE_UTILITE_PUBLIQUE',
            'type' => 'date',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'enable_range_search' => false
        ),

        'detail_affiliation' => array(
            'required' => false,
            'name' => 'detail_affiliation',
            'vname' => 'LBL_DETAIL_AFFILIATION',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'studio' => 'visible',
            'rows' => '6',
            'cols' => '80',
        ),
        //Ajout pour AOS_PDF_Templates
        'ops_individu_template_id' => array(
            'required' => false,
            'name' => 'ops_individu_template_id',
            'vname' => 'LBL_INDIVIDU_TEMLPLATE_ID',
            'type' => 'id',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => 0,
            'audited' => true,
            'inline_edit' => false,
            'reportable' => false,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 36,
            'size' => '20'
        ),
        'dossier_personne_individu_fonction' => array(
            'required' => false,
            'source' => 'non-db',
            'name' => 'dossier_personne_individu_fonction',
            'vname' => 'LBL_DOSSIER_PERSONNE_INDIVIDU_FONCTION',
            'type' => 'relate',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'id_name' => 'ops_individu_template_id',
            'ext2' => 'OPS_individu',
            'module' => 'OPS_individu',
            'rname' => 'name',
            'quicksearch' => 'enabled',
            'studio' => 'visible'
        ),
        'website' => array(
            'name' => 'website',
            'vname' => 'LBL_WEBSITE',
            'type' => 'url',
            'dbType' => 'varchar',
            'len' => 255,
            'comment' => 'URL of website for the company',
            'audited' => true,
        ),
        'flag_partenaire' => array(
            'required' => false,
            'name' => 'flag_partenaire',
            'vname' => 'LBL_FLAG_PARTENAIRE',
            'type' => 'bool',
            'massupdate' => '0',
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'publie' => array(
            'required' => false,
            'name' => 'publie',
            'vname' => 'LBL_PUBLIE',
            'type' => 'bool',
            'massupdate' => '0',
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'thematique' => array(
            'required' => false,
            'name' => 'thematique',
            'vname' => 'LBL_THEMATIQUE',
            'type' => 'multienum',
            'massupdate' => 0,
            'default' => 'N',
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_pm_tiers_thematique_list',
            'studio' => 'visible',
            'dependency' => false
        ),
        'accroche' => array(
            'required' => false,
            'name' => 'accroche',
            'vname' => 'LBL_ACCROCHE',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
        ),
        'description_annuaire' => array(
            'required' => false,
            'name' => 'description_annuaire',
            'vname' => 'LBL_DESCRIPTION_ANNUAIRE',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
        ),
        'activites' => array(
            'required' => false,
            'name' => 'activites',
            'vname' => 'LBL_ACTIVITES',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
        ),
        'tarifs' => array(
            'required' => false,
            'name' => 'tarifs',
            'vname' => 'LBL_TARIFS',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
        ),
        'public_beneficiaire' => array(
            'required' => false,
            'name' => 'public_beneficiaire',
            'vname' => 'LBL_PUBLIC_BENEFICIAIRE',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
        ),
        'image' => array(
            'required' => false,
            'name' => 'image',
            'vname' => 'LBL_IMAGE',
            'type' => 'image',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => false,
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'dbType' => 'varchar',
        ),
        'nature' => array(
            'required' => false,
            'name' => 'nature',
            'vname' => 'LBL_NATURE',
            'type' => 'enum',
            'massupdate' => true,
            'default' => '',
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_type_profil_nature_list',
            'studio' => 'visible',
            'dependency' => false
        ),
    ),
    'relationships' => array(),
    'optimistic_locking' => true,
    'unified_search' => true
);

if (!class_exists('VardefManager')) {
    require_once('include/SugarObjects/VardefManager.php');
}
VardefManager::createVardef('OPS_personne_morale', 'OPS_personne_morale', array(
    'basic',
    'assignable',
    'security_groups',
    'company'
));

$dictionary['OPS_personne_morale']["fields"]["assigned_user_name"]['duplicate_merge'] = "enabled";