<?php

if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

require_once ('include/Dashlets/DashletGeneric.php');
require_once ('modules/OPS_dispositif/OPS_dispositif.php');

class AccesRapideDashlet extends DashletGeneric
{

    var $report;

    public function __construct($id, $def = null)
    {
        require ('modules/OPS_rapport/Dashlets/AccesRapideDashlet/AccesRapideDashlet.data.php');
        parent::__construct($id, $def);

        if (empty($def['title'])) {
            $this->title = translate('LBL_ACCES_RAPIDE_DASHLET', 'OPS_dispositif');
        }

        $this->searchFields = $dashletData['AccesRapideDashlet']['searchFields'];
        $this->columns = $dashletData['AccesRapideDashlet']['columns'];

        $this->seedBean = new OPS_rapport();
    }

    public function process($lvsParams = array(), $id = null)
    {
        global $current_user;

        parent::process($lvsParams, $id);

        // On garde uniquement les rapports reliés au profil métier de l'agent connecté
        $where = 'ops_rapport.id IN (
            SELECT ops_rapport.id 
            FROM ops_rapport 
            INNER JOIN ops_rapport_securitygroups ON ops_rapport.id = ops_rapport_securitygroups.ops_rapport_id
            INNER JOIN securitygroups ON ops_rapport_securitygroups.securitygroups_id = securitygroups.id
            INNER JOIN securitygroups_users ON securitygroups.id = securitygroups_users.securitygroup_id
            INNER JOIN users ON securitygroups_users.user_id = users.id
            WHERE users.id = "' . $current_user->id . '"
            AND ops_rapport.deleted = false AND ops_rapport_securitygroups.deleted = false AND securitygroups.deleted = false AND securitygroups_users.deleted = false
        )';

        $this->lvs->setup($this->seedBean, $this->displayTpl, $where, $lvsParams, 0, $this->displayRows/*, $filterFields*/ , array(), 'id', $id);

    }

    /**
     * Displays the dashlet
     *
     * @return string html to display dashlet
     */
    function display()
    {
        $navStrings = array(
            'next' => $GLOBALS['app_strings']['LNK_LIST_NEXT'],
            'previous' => $GLOBALS['app_strings']['LNK_LIST_PREVIOUS'],
            'end' => $GLOBALS['app_strings']['LNK_LIST_END'],
            'start' => $GLOBALS['app_strings']['LNK_LIST_START'],
            'of' => $GLOBALS['app_strings']['LBL_LIST_OF']
        );

        $this->lvs->data['pageData']['offsets']['lastOffsetOnPage'] = $this->lvs->data['pageData']['offsets']['current'] + count($this->lvs->data['data']);
        
        $this->lvs->ss->assign('navStrings', $navStrings);
        $this->lvs->ss->assign('displayColumns', $this->lvs->displayColumns);
        $this->lvs->ss->assign('pageData', $this->lvs->data['pageData']);
        $this->lvs->ss->assign('data', $this->lvs->data['data']);

        // Dashlet header
        $str = $this->lvs->ss->fetch('modules/OPS_rapport/Dashlets/AccesRapideDashlet/AccesRapideDashlet.tpl');

        // Pour chaque ligne, on va générer le TPL de la ligne dans un fichier dédié au parent_type
        foreach ($this->lvs->data['data'] as $row => $data) {
            require_once ('modules/OPS_rapport/Dashlets/AccesRapideDashlet/types/' . $data['PARENT_TYPE'] . '.php');
            $type = new $data['PARENT_TYPE'];
            $str .= $type->getLine($this, $row, $data);
        }

        return $str; // return parent::display for title and such
    }
}
