<?php

use Configurator;

if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

$configuratorObj = new Configurator();

if(empty($configuratorObj->config['api_r2p']['token'])){
  getToken();
}

getPersonnePhysique($_REQUEST);

function getToken(){

  $key = "0-P7L}~)pd_R)3h7N=Za";
  $configuratorObj = new Configurator();
  $url = $configuratorObj->config['api_r2p']['url'];
  $last_char = substr($url, -1);
  if ($last_char !== "/") {
      // Rajouter un slash à la fin
      $url .= "/";
  }

  $secret = openssl_decrypt($configuratorObj->config['api_r2p']['secret'], "AES-128-ECB" ,$key);
  $autorisation = base64_encode($configuratorObj->config['api_r2p']['clef'].':'.$secret);

  $curl = curl_init();

  curl_setopt_array($curl, array(
    CURLOPT_URL => $url.'token',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => 'grant_type=client_credentials&scope=api_r2p_recherche_personne_physique',
    CURLOPT_HTTPHEADER => array(
      'Authorization: Basic '.$autorisation,
      'Content-Type: application/x-www-form-urlencoded'
    ),
  ));

  $response = curl_exec($curl);
  $response = json_decode($response,true);
  curl_close($curl);

  if(!empty($response['access_token'])){
    $configuratorObj->config['api_r2p']['token'] = $response['access_token'];
    $configuratorObj->saveConfig();
  }
}

function getPersonnePhysique($donnees){
  $configuratorObj = new Configurator();

  $url = $configuratorObj->config['api_r2p']['url'];
  $uuid = create_guid();
  $naisCodePays = '99100';

  $last_char = substr($url, -1);
  if ($last_char !== "/") {
      // Rajouter un slash à la fin
      $url .= "/";
  }
  $param = 'nom='.urlencode($donnees['nom']).'&prenom='.urlencode($donnees['prenom']).'&naisDate='.urlencode($donnees['date_naissance']).'&naisCodePays='.urlencode($naisCodePays).'&naisCodeCommune=000&naisCodeDept=99';
  $url .= 'r2p/v1/personne?'.$param;
  
  $curl = curl_init();

  curl_setopt_array($curl, array(
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    CURLOPT_HTTPHEADER => array(
      'Authorization: Bearer '.$configuratorObj->config['api_r2p']['token'],
      'X-Correlation-ID: '.$uuid
    ),
  ));

  $response = curl_exec($curl);
  curl_close($curl);

  $response = json_decode($response,true);
  if($response['erreur']['code'] == '900901'){
    getToken();
    return getPersonnePhysique($donnees);
  }

  if(!empty($response['personnePhysique'])){
    $response['personnePhysique'] = array_merge($response['personnePhysique']['identifiant'],$response['personnePhysique']['etatCivil'],$response['personnePhysique']['adresse']);
    $response = json_encode($response);
  }

  echo $response;
}