<?php

if (!defined('sugarEntry')) define('sugarEntry', true);


global $db, $beanFiles, $log, $current_user;
require_once ($beanFiles["OPS_connecteur"]);
require_once ($beanFiles["OPS_flux"]);
require_once ($beanFiles["OPS_flux_element"]);

require_once 'modules/OPS_flux/service/arrayToElements.php';

$array_return = array();
$tableau_ids = array();
$array_to_elements = new ArrayToElements();

if(isset($_POST['flux_id']) && !empty($_POST['flux_id'])){

    // Je récupere le flux 
    $flux = new OPS_flux();
    $flux->retrieve($_POST['flux_id']);

    if(!empty($flux->id)){

        if(isset($_POST['stream']) && !empty($_POST['stream'])){

            // Je decode le json 
            $json_formated = base64_decode($_POST['stream']);
            $json_verified = json_to_array($json_formated);


            if($json_verified['statut'] == 'ok'){

                $key_return = "";

                // Le Json est valide 
                $json_array = $json_verified['data'];
                
                $id = ode_suite_id();
                
                $array_return = $array_to_elements->genere_flux($json_array,$id);


                // Avant de crée je delete les elements existants
                $elements = $flux->get_linked_beans('ops_flux_ops_flux_element','OPS_flux_element');
                if(!empty($elements)){
                    foreach ($elements as $key => $element) {
                        $element->mark_deleted($element->id);
                    }
                }

                $ordre = 1;
                foreach ($array_return as $id => $element) {

                    $flux_element = new OPS_flux_element();
                    $flux_element->name = $element['libelle'];
                    $flux_element->name_flux = $element['libelle'];
                    $flux_element->ordre = $ordre;

                    if($element['type'] == "groupe"){
                        $flux_element->type_element = "groupe";
                    }else{
                        $flux_element->champ = $element['value'];
                        $flux_element->type_element = "chaine";
                    }

                    // Relation flux - flux_element
                    if (!empty($element['id_parent'])){
                        $flux_element->flux_element_parent_id = $tableau_ids[$element['id_parent']];
                    }

                    $flux_element->save();
                    $tableau_ids[$id]=$flux_element->id;
                    $flux->load_relationship('ops_flux_ops_flux_element');
                    $flux->ops_flux_ops_flux_element->add($flux_element);
                    $ordre++;
                }

        /**/
                 $array_return['statut'] = "ok";
                 echo json_encode($array_return);




            }else{
                $array_return['statut'] = "erreur";
                $array_return['erreur_json'] = $json_verified['data'];
                echo json_encode($array_return);
            }

        }else{
            $array_return['statut'] = "erreur";
            $array_return['erreur_json'] = 'Erreur Json : le Json est vide';
            echo json_encode($array_return);
        }
    }else{
        $array_return['statut'] = "erreur";
        $array_return['erreur_ajax'] = 'Erreur flux : id non identifié, veuillez contacter votre administrateur';
        echo json_encode($array_return);
    }



}



function uniqidReal($len = 13) {
    // uniqid gives 13 chars, but you could adjust it to your needs.
    if (function_exists("random_bytes")) {
        $bytes = random_bytes(ceil($len / 2));
    } elseif (function_exists("openssl_random_pseudo_bytes")) {
        $bytes = openssl_random_pseudo_bytes(ceil($len / 2));
    } else {
        throw new Exception("no cryptographically secure random function available");
    }
    return substr(bin2hex($bytes), 0, $len);
}


// ID conforme aux ID suiteCrm
function ode_suite_id() {
    return uniqidReal(8)."-".uniqidReal(4)."-".uniqidReal(4)."-".uniqidReal(4)."-".uniqidReal(12);
}

// L'idée de cette fonction c'est de traiter dans le futur les erreurs de json_decode() avec try catch 
function verif_json($json){
    $retour_verif['statut'] = true;
    $retour_verif['libelle_erreur'] = "libelle_erreur JSON";
    // Traitement
    return $retour_verif;

}


/**
* json_to_array()
* Fonction qui prend en param un json, retourne un tableau si ok sinon l'erreur Json
* 
*  @param Json/String $flux        - Json
*  @return Array  $array_return    - ['statut' => '', 'data' => '']
*/
function json_to_array($flux){

    $statut = false;
    $libelle_erreur = "";
    $donnees = json_decode($flux);

    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            $statut = true;
            break;
        case JSON_ERROR_DEPTH:
            $libelle_erreur = ' - Profondeur maximale atteinte';
            break;
        case JSON_ERROR_STATE_MISMATCH:
            $libelle_erreur = ' - Inadéquation des modes ou underflow';
            break;
        case JSON_ERROR_CTRL_CHAR:
            $libelle_erreur = ' - Erreur lors du contrôle des caractères';
            break;
        case JSON_ERROR_SYNTAX:
            $libelle_erreur = ' - Erreur de syntaxe ; JSON malformé';
            break;
        case JSON_ERROR_UTF8:
            $libelle_erreur = ' - Caractères UTF-8 malformés, probablement une erreur d\'encodage';
            break;
        default:
            $libelle_erreur = ' - Erreur inconnue';
            break;
    }

    if($statut == true){
        $array_return = [ 'statut' => 'ok', 'data' => $donnees];
    }else{
        $array_return = [ 'statut' => 'err', 'data' => $libelle_erreur];
    }

    return $array_return;

}