<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class AjouterEnfantAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Ajouter un enfant "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'individu';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Ajouter un enfant "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Ajouter un enfant";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Ajouter un enfant "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Ajouter un enfant";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        global $app_list_strings;

        $data = [];

        $objReferentiel = BeanFactory::newbean('OPS_generateur_referentiel');
        $listReferentiel = $objReferentiel->get_full_list('libelle');

        $tabReferentiel = array( '' =>  '- aucun -') ;

        foreach ($listReferentiel as $id => $ref) 
        {
            if(!empty($ref->name))
            {
                $tabReferentiel[$ref->id] = $ref->libelle . " (". $ref->name . ")" ;
            }
        }

        $liste_referentiel = get_select_options_with_id($tabReferentiel, $this->action->ext_valeur_3);

        $liste_champ  = $this->getChamps();

        $data['hidden'] = " <input type='hidden'  id='ext_valeur_5' name='ext_valeur_5' value=".base64_encode(json_encode($liste_referentiel)).">
                            <input type='hidden'  id='ext_valeur_3' name='ext_valeur_3' value=".base64_encode(json_encode($liste_champ)).">
                            <input type='hidden'  id='ext_valeur_text' name='ext_valeur_text' value=".$this->action->ext_valeur_text.">";
   

        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        global $app_list_strings, $beanFiles;
        require_once($beanFiles['User']);

        $data = [];

        $data['ext_valeur_1']['label'] = 'Nom des champs';
        $data['ext_valeur_1']['type'] = 'enum';

        $liste_champ = $this->getChamps();

        $tabReferentielChamps = explode("|", $this->action->ext_valeur_text);

        $choix = 'false';
        foreach($tabReferentielChamps as $ReferentielChamp){
            if("" != str_replace(" ","",$ReferentielChamp)){

                $tabReferentielChamp = explode(";",$ReferentielChamp);
                $nomChamp = $tabReferentielChamp[0];
                $champRefetentiel = $tabReferentielChamp[1];

                if("" != str_replace(" ","", $nomChamp)){
                    $choix='true';
                    $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel',$champRefetentiel);
                    $data['ext_valeur_1']['valeur'] .= "<p><span style='float:left;width:50%;' >" . $liste_champ[$nomChamp] . " : </span> <span style ='float:right;'>" . $objReferentiel->libelle . "</span></p><br>";
                }
            }
        }
        if($choix == 'false'){
            $data['ext_valeur_1']['valeur'] = "<p><span style='float:left;width:70%;' > Aucune assignation n'a été faite </span></p><br>";
        }

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        if(!empty($this->dossier) && !empty($this->action->ext_valeur_text)){

            $objIndividu = BeanFactory::newBean('OPS_individu');

            $objPersonneMoraleIndividu = BeanFactory::newBean('OPS_personne_morale_individu');

            $listeChamps = explode('|',$this->action->ext_valeur_text);
            $customChamp = json_decode( base64_decode( $this->dossier->champs_custom) );

            $personne_morale_individu_field = [
                'role',
                'autorite_parentale',
                'mode_garde',
                'referent_tarifaire',
                'presence',
                'payeur',
                'assurance_compagnie',
                'assurance_numero',
                'date_debut_validite',
                'date_fin_validite',
                'responsable',
                'acces_usager',
            ];

            foreach ($listeChamps as $champs) 
            {
                $champ = explode(';', $champs);
                $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel', $champ[1]);

                // Récupération valeur du champ dans le dossier
                if(!empty($this->dossier->{$objReferentiel->name}))
                {
                    $value = $this->dossier->{$objReferentiel->name};
                }
                else
                {
                    $value = $customChamp->{$objReferentiel->name};
                }

                if($objReferentiel->type == 'liste')
                {
                    $value = str_replace('^', '', $value);
                }

                // Adresse domiciliation
                if($champ[0] == 'adresse_domiciliation')
                {
                    $value = html_entity_decode($value,ENT_NOQUOTES);

                    // Vérifie si la valeur est encodé en base 64
                    if (base64_encode(base64_decode($value, true)) === $value)
                    {
                        $value = json_decode(base64_decode($value));
                        
                        $objIndividu->primary_address_number              = $value->numero;
                        $objIndividu->primary_address_street              = $value->rue;
                        $objIndividu->primary_address_complement_batiment = $value->complement_batiment;
                        $objIndividu->primary_address_complement_lieu     = $value->complement_lieu;
                        $objIndividu->primary_address_postalcode          = $value->postcode;
                        $objIndividu->primary_address_city                = $value->city;
                    }
                }
                // Pour alimenter la relation du profil avec l'individu
                else if (in_array($champ[0], $personne_morale_individu_field))
                {
                    $objPersonneMoraleIndividu->{$champ[0]} = $value; 
                }
                // Autre champs
                else
                {
                    $objIndividu->{$champ[0]} = $value;
                }
            }

            // Check si l'individu existe déjà
            global $db;

            $query = "SELECT ops_individu.id
                FROM ops_individu
                INNER JOIN ops_individu_ops_personne_morale_individu ON ops_individu_ops_personne_morale_individu.ops_individu_id = ops_individu.id AND ops_individu_ops_personne_morale_individu.deleted = 0
                INNER JOIN ops_personne_morale_individu ON ops_personne_morale_individu.id = ops_individu_ops_personne_morale_individu.ops_personne_morale_individu_id AND ops_personne_morale_individu.deleted = 0 
                INNER JOIN ops_personne_morale_ops_personne_morale_individu ON ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id AND ops_personne_morale_ops_personne_morale_individu.deleted = 0 
                INNER JOIN ops_personne_morale ON ops_personne_morale.id = ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_id AND ops_personne_morale.deleted = 0
                WHERE ops_personne_morale.id ='" . $this->dossier->ops_personne_morale . "' AND ops_individu.deleted = 0 AND " . $this->getSqlClauseLikeFormated('ops_individu.first_name', $objIndividu->first_name) . "
                       AND  ".$this->getSqlClauseLikeFormated('ops_individu.last_name', $objIndividu->last_name) . "
                LIMIT 1";

            $requete = $db->query($query);

            $id = '';
            while ($row = $db->fetchRow($requete)) {
                $id = $row['id'];
            }

            if(empty($id))
            {
                $objIndividu->type_individu = 'enfant';
                $objIndividu->save();

                $objPersonneMorale = BeanFactory::getBean('OPS_personne_morale', $this->dossier->ops_personne_morale);
                if(isset($objPersonneMorale) && !empty($objPersonneMorale->id))
                {
                    $objPersonneMoraleIndividu->save();

                    $objPersonneMoraleIndividu->load_relationship('ops_individu_ops_personne_morale_individu');
                    $objPersonneMoraleIndividu->ops_individu_ops_personne_morale_individu->add($objIndividu);

                    $objPersonneMoraleIndividu->load_relationship('ops_personne_morale_ops_personne_morale_individu');
                    $objPersonneMoraleIndividu->ops_personne_morale_ops_personne_morale_individu->add($objPersonneMorale);
                }
            }
            else
            {
                $GLOBALS['log']->fatal('AjouterEnfantAction::execute() => L\'individu existe déjà');
            }
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne le nom du fichier javascript
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "AjouterEnfantAction";
    }

    private function getChamps(){
        return array(
            'sexe' => 'Sexe',
            'last_name' => 'Nom de famille',
            'nom_usage' => 'Nom d\'usage',
            'first_name' => 'Prénom',
            'etat' => 'Etat',
            'nationalite' => 'Nationalité',
            'date_naissance' => 'Date de naissance',
            'lieu_naissance' => 'Ville de naissance',
            'pays_naissance' => 'Pays de naissance',
            'production_diffusion_image' => 'Production et diffusion publique de l’image de l’enfant',
            'diffusion_caf' => 'Diffusion des données à l’organisme d’allocation familiale',
            'attestation_assurance' => 'Attestation de souscription d’une assurance responsabilité civile en cours de validité',
            'handicap' => 'En situation de handicap',
            'aide_handicap' => 'Bénéficiaire de l\'AEEH',
            'vaccin_a_jour' => 'Vaccination à jour',
            'medecin_traitant' => 'Médecin traitant',
            'presence_trouble_consigne' => 'Présence de troubles de la santé ou de consignes particulières',
            'email1' => 'E-mail',
            'phone_mobile' => 'Tél. portable',
            'phone_home' => 'Tél. fixe',
            'phone_work' => 'Tél. professionnel',
            'phone_other' => 'Autre tél.',
            'accepte_mail' => 'Accepte mails',
            'accepte_sms' => 'Accepte SMS',
            'adresse_domiciliation' => 'Adresse de domiciliation',
            'menu_autorise' => 'Type de menu autorisé',
            'fai' => 'PAI',
            'role' => 'Fonction',
            'autorite_parentale' => 'Autorité parentale',
            'mode_garde' => 'Mode de garde',
            'referent_tarifaire' => 'Référent tarifaire',
            'presence' => 'Présence',
            'payeur' => 'Payeur',
            'assurance_compagnie' => 'Compagnie d\'assurance',
            'assurance_numero' => 'N° assurance',
            'date_debut_validite' => 'Date début de validité',
            'date_fin_validite' => 'Date fin de validité',
            'responsable' => 'Responsable',
            'acces_usager' => 'Accès internet',
        );
    }

    /**
     * @access private
     * @name getSqlClauseLikeFormated()
     * Fonction qui retourne la condition SQL Like formaté : On enleve l'ensemble des caracteres spéciaux  
     * @param string       $field_name
     * @param string       $field_value
     * 
     * @return string       $sql_clause
     */
    private function getSqlClauseLikeFormated($field_name = "", $field_value = "")
    {
        # On intialise l'object de condition
        $sql_clause = (object) [
            'start_clause_name' => 'UPPER(TRIM(',
            'clause_name' => $field_name,
            'end_clause_name' => '))',
            'start_clause_value' => 'UPPER(TRIM(',
            'clause_value' => '"'.html_entity_decode($field_value,ENT_QUOTES,'UTF-8').'"',
            'end_clause_value' => '))'
        ];

        # On récupere la liste des caracteres spéciaux à remplacer et on boucle sur la liste pour les remplacer dans les deux parties de la condition LIKE 
        $caractere_speciaux = $this->getSpecialCharListe();
        foreach ($caractere_speciaux as $char_to_replace => $char_replace_by) {
            $sql_clause->clause_name = 'REPLACE('.$sql_clause->clause_name.', "'.$char_to_replace.'", "'.$char_replace_by.'")';
            $sql_clause->clause_value = 'REPLACE('.$sql_clause->clause_value.', "'.$char_to_replace.'", "'.$char_replace_by.'")';
        }

        # On concatene les elements de l'object pour construire notre condition
        return $sql_clause->start_clause_name . $sql_clause->clause_name . $sql_clause->end_clause_name . ' LIKE ' . $sql_clause->start_clause_value . $sql_clause->clause_value . $sql_clause->end_clause_value;
    }
    
    /**
     * @access private
     * @name getSqlClauseLikeFormated()
     * Fonction qui retourne la liste des caracteres spéciaux ainsi que les valeurs de remplacement 
     * 
     * @return array       $caractere_speciaux
     */
    private function getSpecialCharListe()
    {
        return [
            'à' => 'a',
            'á' => 'a',
            'â' => 'a',
            'ã' => 'a',
            'ä' => 'a',
            'ç' => 'c',
            'è' => 'e',
            'é' => 'e',
            'ê' => 'e',
            'ë' => 'e',
            'ì' => 'i',
            'í' => 'i',
            'î' => 'i',
            'ï' => 'i',
            'ñ' => 'n',
            'ò' => 'o',
            'ó' => 'o',
            'ô' => 'o',
            'õ' => 'o',
            'ö' => 'o',
            'ù' => 'u',
            'ú' => 'u',
            'û' => 'u',
            'ü' => 'u',
            'ý' => 'y',
            'ÿ' => 'y',
            'À' => 'A',
            'Á' => 'A',
            'Â' => 'A',
            'Ã' => 'A',
            'Ä' => 'A',
            'Ç' => 'C',
            'È' => 'E',
            'É' => 'E',
            'Ê' => 'E',
            'Ë' => 'E',
            'Ì' => 'I',
            'Í' => 'I',
            'Î' => 'I',
            'Ï' => 'I',
            'Ñ' => 'N',
            'Ò' => 'O',
            'Ó' => 'O',
            'Ô' => 'O',
            'Õ' => 'O',
            'Ö' => 'O',
            'Ù' => 'U',
            'Ú' => 'U',
            'Û' => 'U',
            'Ü' => 'U',
            'Ý' => 'Y',
            'Å' => 'A',
            'Ø' => 'O',
            'Ÿ' => 'Y',
            '_' => '',
            '(' => '',
            ')' => '',
            '/' => '',
            '-' => '',
            '+' => '',
            '!' => '',
            ',' => '',
            ':' => '',
            '\''=> '',
            ' '  => '',
        ];
    }
}