<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class ChangerStatutThematiqueAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Changer le statut en fonction d'une thématique "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'instruction';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Changer le statut en fonction d'une thématique "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Modifier le statut selon la thématique";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Changer le statut en fonction d'une thématique "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Modifier le statut selon la thématique";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        global $app_list_strings;

        $data = [];

        $etape_liste = [];

        $objEtape = BeanFactory::getBean('OPS_etape');
        $listEtape = $objEtape->get_full_list();

        foreach ($listEtape as $etape) 
        {

            $etape->load_relationship('ops_guide_instruction_ops_etape');
            $guide = $etape->ops_guide_instruction_ops_etape->get();

            $etape->load_relationship('ops_etape_ops_statut');
            $listeStatut = $etape->ops_etape_ops_statut->get();

            $etape_liste[ $guide[0] ][$etape->id]['name'] = $etape->name;

            $statut_liste = [];
            foreach ($listeStatut as $statut) 
            {

                $objStatut = BeanFactory::getBean('OPS_statut', $statut);
                $statut_liste[$objStatut->id] .= $objStatut->name;
            }
            asort($statut_liste);
            $etape_liste[ $guide[0] ][$etape->id]['statut'] = $statut_liste;
        }


        asort($etape_liste);

        $liste_thematique  = $app_list_strings['ops_thematique_list'];

        unset($liste_thematique[""]);
        ksort($liste_thematique);

        $data['hidden'] = " <input type='hidden'  id='ext_valeur_5' name='ext_valeur_5' value=".base64_encode(json_encode($etape_liste)).">
                            <input type='hidden'  id='ext_valeur_3' name='ext_valeur_3' value=".base64_encode(json_encode($liste_thematique)).">
                            <input type='hidden'  id='ext_valeur_text' name='ext_valeur_text' value=".$this->action->ext_valeur_text.">";
   

        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        global $app_list_strings, $beanFiles;
        require_once($beanFiles['User']);

        $data = [];

        $data['ext_valeur_1']['label'] = 'Statut selon la thématique';
        $data['ext_valeur_1']['type'] = 'enum';

        //$listName = $this->action->ext_valeur_1;
        $listName = 'ops_thematique_list';

        $tabThematiqueStatut = explode("|", $this->action->ext_valeur_text);

        $choix = 'false';
        foreach($tabThematiqueStatut as $thematiqueStatut){
            if("" != str_replace(" ","",$thematiqueStatut)){

                $tabthematiqueStatut = explode(";",$thematiqueStatut);
                $nomThematique = $tabthematiqueStatut[0];
                $idStatut = $tabthematiqueStatut[1];

                if("" != str_replace(" ","", $nomThematique)){
                    if("" != $app_list_strings[$listName][$nomThematique]){
                        $choix='true';
                        $statut = BeanFactory::getBean('OPS_statut', $idStatut);
                        $nomStatut = $statut->name;
                        $data['ext_valeur_1']['valeur'] .= "<p><span style='float:left;width:70%;' >" . $app_list_strings[$listName][$nomThematique] . " : </span> <span style ='float:right;'>" . $nomStatut . "</span></p><br>";
                    }
                }
            }
        }
        if($choix == 'false'){
            $data['ext_valeur_1']['valeur'] = "<p><span style='float:left;width:70%;' > Aucune assignation n'a été faite </span></p><br>";
        }

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        if(!empty($this->dossier) && !empty($this->action->ext_valeur_text)){

            $thematiqueDossier = $this->dossier->thematique;

            $tabThematiqueStatut = explode("|", $this->action->ext_valeur_text);

            foreach($tabThematiqueStatut as $thematiqueStatut)
            {
                $thematiqueStatut = explode(";", $thematiqueStatut);

                $nomThematique = $thematiqueStatut[0];
                $idStatut = $thematiqueStatut[1];

                if($this->dossier->thematique == $nomThematique)
                {
                    $objDossier = BeanFactory::getBean('OPS_dossier',$this->dossier->id);
                    $objDossier->updateStatut( $idStatut );
                }
            }
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne le nom du fichier javascript
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "ChangerStatutThematiqueAction";
    }
}