<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;
use SugarEmailAddress;

use ODE\Sms\OdeSms;

if (!defined('sugarEntry')) define('sugarEntry', true);

class EnvoyerSmsAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
        
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Envoyer un SMS "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'notification';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Envoyer un SMS "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Envoyer un SMS";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Envoyer un SMS "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Envoyer un SMS";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        $liste_cible = array(
            'beneficiaire' => 'Bénéficiaire (tél. portable de l\'individu)',
            'demandeur' => 'Demandeur (tél. portable de l\'individu)',
            'dossier' => 'Tél. portable du dossier',
            'autre' => 'Autre'
        );
        $listeCibleOptions = get_select_options_with_id($liste_cible, $this->action->ext_valeur_1);

        $selectDestinataire  = '<select name="ext_valeur_1" id="ext_valeur_1">';
        $selectDestinataire .= $listeCibleOptions;
        $selectDestinataire .= '</select>';

        $data = array(
            'ext_valeur_1' => array(
                'type' => 'enum',
                'label' => 'A',
                'form' => $selectDestinataire
            )
        );


        $inputTO = '<input type="text" id="ext_valeur_2" name="ext_valeur_2" value="'.$this->action->ext_valeur_2.'" >';
        $data += array(
            'ext_valeur_2' => array(
                'type' => 'text',
                'label' => 'Préciser',
                'form' => $inputTO
            )
        );

        // modeles de courriels
        $listCourriel   = get_bean_select_array(true, 'OPS_template_sms', 'name', '', 'name');
        $courrielOption = get_select_options_with_id($listCourriel, $this->action->ext_valeur_3);

        $selectSms  = '<select name="ext_valeur_3" id="ext_valeur_3" required=required>';
        $selectSms .= $courrielOption;
        $selectSms .= '</select>';

        $data += array(
            'ext_valeur_3' => array(
                'type' => 'enum',
                'label' => 'Modèle de SMS',
                'form' => $selectSms
            )
        );

        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {

        $template_sms = "" ; 
        $data = array();

        $liste_cible = array(
            'beneficiaire' => 'Bénéficiaire (tél. portable de l\'individu)',
            'demandeur' => 'Demandeur (tél. portable de l\'individu)',
            'dossier' => 'Tél. portable du dossier',
            'autre' => 'Autre'
        );

        if (!empty($this->action->ext_valeur_3)) {

            $obj_template = BeanFactory::getBean('OPS_template_sms',$this->action->ext_valeur_3);
            $template_sms = $obj_template->name;
        }
        
        $data = array(
            'ext_valeur_1' => array(
                'type' => 'enum',
                'label' => 'A',
                'valeur' => $liste_cible[$this->action->ext_valeur_1]
            )
        );

        if( $this->action->ext_valeur_1 == "autre" ||$this->action->ext_valeur_1 == "dossier" ){
            $data += array(
                'ext_valeur_2' => array(
                    'type' => 'text',
                    'label' => 'Préciser',
                    'valeur' => $this->action->ext_valeur_2
                ),
            );
        }

        $data += array(
            'ext_valeur_3' => array(
                'type' => 'enum',
                'label' => 'Modèle de SMS',
                'valeur' => $template_sms
            ),
        );
        
        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        # On vérifie qu'on a bien récupéré le dossier et que l'action statut est configurée  
        if ( empty($this->dossier) || empty($this->action->ext_valeur_1) || empty($this->action->ext_valeur_3) ) return;

        # On récupére le numéro de téléphone du destinataire
        $numero = $this->getNumero();
        
        # On initialise le SMS
        $sms = new OdeSms($this->dossier);
        
        # On formate le numéro du destinataire
        $numero = $sms->format_numero($numero);

        # On récupère le template de SMS
        $obj_template_sms = BeanFactory::getBean('OPS_template_sms', $this->action->ext_valeur_3);

        $statut = $description = '';

        # On vérifie que le template récupéré existe et actif & que le numéro de téléphone a été formaté
        if(!empty($obj_template_sms->id) && $obj_template_sms->actif == 1 && $numero)
        {
            $text = $obj_template_sms->description;

            try {
                $response = $sms->send_sms($numero, $text);
                
                if (true) 
                {
                    $statut = 'Succès';
                    $description = $text;
                } 
                else 
                {
                    $statut = 'Echec';
                    $description = 'Erreur : ' . "\n" . $text;
                }
            } catch (\Exception $e) {
                $GLOBALS['log']->fatal('EnvoyerSmsAction::execute() => Impossible d\'envoyer le SMS de confirmation - Erreur : : ' . $e);
            }
        }
        else
        {
            # En cas d'échec dans le paramétrage ou dans la valeur du champ numéro de téléphone récupéré
            $contexte = '';
            if(empty($obj_template_sms->id) || $obj_template_sms->actif != 1)
            {
                $contexte = 'Template de SMS non valide';
            }

            if(!$numero)
            {
                $contexte = 'Numéro de téléphone non renseigné ou mal formaté';
            }

            $statut      = 'Echec';
            $description = 'Erreur : ' . "\n" . $contexte;
        }

        # On créé une note afin de garder une trace
        $this->createNotes($statut, $description);
    }

    /**
     * @access private
     * @name getNumero()
     * Fonction qui récupère le numéro de téléphone du destinataire
     *
     *  @return void
     */
    private function getNumero()
    {
        $numero = '';
        switch ($this->action->ext_valeur_1) 
        {
            case 'demandeur':
                $demandeur = BeanFactory::getBean('OPS_individu',$this->dossier->ops_individu_id );
                $numero = $demandeur->phone_mobile;
                break;
            case 'beneficiaire':
                $beneficiaire = BeanFactory::getBean('OPS_individu',$this->dossier->beneficiaire_id);
                $numero = $beneficiaire->phone_mobile;
                break;
            case 'dossier': // Récupération de l'adresse mail sur les champs email/email_cc/email_cci
                $customChamp = json_decode( base64_decode( $this->dossier->champs_custom) );

                if(!empty($this->dossier->{$objReferentiel->name}))
                {
                    $numero = $this->dossier->{$this->action->ext_valeur_2};
                }
                else
                {
                    $numero = $customChamp->{$this->action->ext_valeur_2};
                }
                break;
            default:
                $numero = $this->action->ext_valeur_2;
                break;
        }
            
        return $numero ; 
    }

    /**
     * @access private
     * @name getNumero()
     * Fonction qui récupère le numéro de téléphone du destinataire
     *
     *  @return void
     */
    private function createNotes($statut, $description)
    {
        $obj_notes = BeanFactory::newBean('Notes');

        $obj_notes->name = 'SMS (' . $statut . ')';
        $obj_notes->description = $description;

        switch ($this->action->ext_valeur_1) 
        {
            case 'demandeur':
                $obj_notes->parent_type = 'OPS_individu';
                $obj_notes->parent_id   = $this->dossier->ops_individu_id;
                break;
            case 'beneficiaire':
                $obj_notes->parent_type = 'OPS_individu';
                $obj_notes->parent_id   = $this->dossier->beneficiaire_id;
                break;
            default:
                $obj_notes->parent_type = 'OPS_dossier';
                $obj_notes->parent_id   = $this->dossier->id;
                $obj_notes->ops_dossier_id = $this->dossier->id;
                break;
        }

        $obj_notes->save();
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne le nom du fichier javascript
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "EnvoyerSmsAction";
    }
}
