<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class ModifierAdulteAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Modifier un adulte "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'individu';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Modifier un adulte "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Modifier un adulte";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Modifier un adulte "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Modifier un adulte";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        global $app_list_strings;

        $data = [];

        $objReferentiel = BeanFactory::newbean('OPS_generateur_referentiel');
        $listReferentiel = $objReferentiel->get_full_list('libelle');

        $tabReferentiel = array( '' =>  '- aucun -') ;

        foreach ($listReferentiel as $id => $ref) 
        {
            if(!empty($ref->name))
            {
                $tabReferentiel[$ref->id] = $ref->libelle . " (". $ref->name . ")" ;
            }
        }

        $liste_referentiel = get_select_options_with_id($tabReferentiel, $this->action->ext_valeur_3);

        $liste_champ  = $this->getChamps();

        $data['hidden'] = " <input type='hidden'  id='ext_valeur_5' name='ext_valeur_5' value=".base64_encode(json_encode($liste_referentiel)).">
                            <input type='hidden'  id='ext_valeur_3' name='ext_valeur_3' value=".base64_encode(json_encode($liste_champ)).">
                            <input type='hidden'  id='ext_valeur_text' name='ext_valeur_text' value=".$this->action->ext_valeur_text.">";

        $list_radio = [
            'beneficiaire' => 'Bénéficiaire', 
            'demandeur' => 'Demandeur',
        ];

        $champRadio = '';
        foreach( $list_radio as $key => $value ){
            if($key == $this->action->ext_valeur_2 || ( empty($this->action->ext_valeur_2) && $key == 'champs_standards' ) ){
                $champRadio .=  '<input type="radio" id="'.$key.'" name="ext_valeur_2" value="'.$key.'" checked style="margin-left: 6px;">
                                <label for="'.$key.'">'.$value.'</label>';
            }else{
                $champRadio .=  '<input type="radio" id="'.$key.'" name="ext_valeur_2" value="'.$key.'" style="margin-left: 6px;">
                                <label for="'.$key.'">'.$value.'</label>';
            }
        }

        $data['ext_valeur_2']['type']  = 'radio';
        $data['ext_valeur_2']['label'] = 'Individu désigné';
        $data['ext_valeur_2']['form']  = $champRadio;

        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        global $app_list_strings, $beanFiles;
        require_once($beanFiles['User']);

        $data = [];

        $list_radio = [
            'beneficiaire' => 'Bénéficiaire', 
            'demandeur' => 'Demandeur',
        ];

        $data['ext_valeur_1']['type']  = 'text';
        $data['ext_valeur_1']['label'] = 'Individu désigné';
        $data['ext_valeur_1']['valeur']  = ((!empty($this->action->ext_valeur_2)) ? $list_radio[$this->action->ext_valeur_2] . '<br>' : '<p><span style="float:left;width:70%;"> Aucune assignation n\'a été faite </span></p><br>');

        $data['ext_valeur_2']['label'] = 'Nom des champs';
        $data['ext_valeur_2']['type'] = 'enum';

        $liste_champ = $this->getChamps();

        $tabReferentielChamps = explode("|", $this->action->ext_valeur_text);

        $choix = 'false';
        foreach($tabReferentielChamps as $ReferentielChamp){
            if("" != str_replace(" ","",$ReferentielChamp)){

                $tabReferentielChamp = explode(";",$ReferentielChamp);
                $nomChamp = $tabReferentielChamp[0];
                $champRefetentiel = $tabReferentielChamp[1];

                if("" != str_replace(" ","", $nomChamp)){
                    $choix='true';
                    $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel',$champRefetentiel);
                    $data['ext_valeur_2']['valeur'] .= "<p><span style='float:left;width:50%;' >" . $liste_champ[$nomChamp] . " : </span> <span style ='float:right;'>" . $objReferentiel->libelle . "</span></p><br>";
                }
            }
        }
        if($choix == 'false'){
            $data['ext_valeur_2']['valeur'] = "<p><span style='float:left;width:70%;' > Aucune assignation n'a été faite </span></p><br>";
        }

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        if(!empty($this->dossier) && !empty($this->action->ext_valeur_text))
        {
            $id = '';
            if($this->action->ext_valeur_2 == 'beneficiaire' )
            {
                $id = (!empty($this->dossier->beneficiaire_id) ? $this->dossier->beneficiaire_id : $this->dossier->ops_individu_id);
            }
            elseif($this->action->ext_valeur_2 == 'demandeur')
            {
                $id = (!empty($this->dossier->ops_individu_id) ? $this->dossier->ops_individu_id : '');
            }
            else
            {
                $GLOBALS['log']->fatal('ModifierAdulteAction::execute() => L\'individu désigné est incorrect');
                return;
            }

            if(empty($id))
            {
                $GLOBALS['log']->fatal('ModifierAdulteAction::execute() => Aucun id trouvé pour l\'individu à modifier');
                return;
            }

            $objIndividu = BeanFactory::getBean('OPS_individu', $id);

            $personne_morale_individu_field = [
                'role',
                'autorite_parentale',
                'mode_garde',
                'referent_tarifaire',
                'presence',
                'payeur',
                'assurance_compagnie',
                'assurance_numero',
                'date_debut_validite',
                'date_fin_validite',
                'responsable',
                'acces_usager',
            ];

            $phone_fields = [
                'phone_mobile',
                'phone_work',
                'phone_home',
                'phone_other',
            ];

            if( !empty($objIndividu->type_individu) && $objIndividu->type_individu == 'adulte' )
            {
                $linkedBeans = $objIndividu->get_linked_beans('ops_individu_ops_personne_morale_individu', 'OPS_personne_morale_individu');

                foreach ($linkedBeans as $linkedBeanPersonneMoraleIndividu) 
                {
                    if ($linkedBeanPersonneMoraleIndividu->ops_personne_morale_id == $this->dossier->ops_personne_morale) 
                    {
                        $objPersonneMoraleIndividu = $linkedBeanPersonneMoraleIndividu;
                        break;
                    }
                }

                $listeChamps = explode('|',$this->action->ext_valeur_text);
                $customChamp = json_decode( base64_decode( $this->dossier->champs_custom) );

                foreach ($listeChamps as $champs) 
                {
                    $champ = explode(';', $champs);
                    $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel', $champ[1]);

                    // Récupération valeur du champ dans le dossier
                    if(!empty($this->dossier->{$objReferentiel->name}))
                    {
                        $value = $this->dossier->{$objReferentiel->name};
                    }
                    else
                    {
                        $value = $customChamp->{$objReferentiel->name};
                    }

                    if($objReferentiel->type == 'liste')
                    {
                        $value = str_replace('^', '', $value);
                    }

                    // Adresse domiciliation
                    if($champ[0] == 'adresse_domiciliation')
                    {
                        $value = html_entity_decode($value,ENT_NOQUOTES);

                        // Vérifie si la valeur est encodé en base 64
                        if (!empty($value) && base64_encode(base64_decode($value, true)) === $value)
                        {
                            $value = json_decode(base64_decode($value));
                            
                            $objIndividu->primary_address_number              = $value->numero;
                            $objIndividu->primary_address_street              = $value->rue;
                            $objIndividu->primary_address_complement_batiment = $value->complement_batiment;
                            $objIndividu->primary_address_complement_lieu     = $value->complement_lieu;
                            $objIndividu->primary_address_postalcode          = $value->postcode;
                            $objIndividu->primary_address_city                = $value->city;
                        }
                        else if (empty($value))
                        {
                            $objIndividu->primary_address_number              = '';
                            $objIndividu->primary_address_street              = '';
                            $objIndividu->primary_address_complement_batiment = '';
                            $objIndividu->primary_address_complement_lieu     = '';
                            $objIndividu->primary_address_postalcode          = '';
                            $objIndividu->primary_address_city                = '';
                        }
                    }
                    // Adresse employeur
                    else if($champ[0] == 'adresse_employeur')
                    {
                        $value = html_entity_decode($value,ENT_NOQUOTES);

                        // Vérifie si la valeur est encodé en base 64
                        if (!empty($value) && base64_encode(base64_decode($value, true)) === $value)
                        {
                            $value = json_decode(base64_decode($value));
                            
                            $objIndividu->adresse_num                 = $value->numero;
                            $objIndividu->adresse_voie                = $value->rue;
                            $objIndividu->adresse_complement_batiment = $value->complement_batiment;
                            $objIndividu->adresse_complement_lieu     = $value->complement_lieu;
                            $objIndividu->address_postalcode          = $value->postcode;
                            $objIndividu->address_city                = $value->city;
                        }
                        else if (empty($value))
                        {
                            $objIndividu->adresse_num                 = '';
                            $objIndividu->adresse_voie                = '';
                            $objIndividu->adresse_complement_batiment = '';
                            $objIndividu->adresse_complement_lieu     = '';
                            $objIndividu->address_postalcode          = '';
                            $objIndividu->address_city                = '';
                        }
                    }
                    // Pour alimenter la relation du profil avec l'individu
                    else if (in_array($champ[0], $personne_morale_individu_field) && !empty($objPersonneMoraleIndividu))
                    {
                        $objPersonneMoraleIndividu->{$champ[0]} = $value; 
                    }
                    else if(in_array($champ[0], $phone_fields))
                    {
                        $objIndividu->{$champ[0]} = preg_replace("/[^0-9]/", " ", html_entity_decode($value));
                    }
                    // Autre champs
                    else
                    {
                        $objIndividu->{$champ[0]} = $value;
                    }
                }

                $objIndividu->save();

                if (!empty($objPersonneMoraleIndividu)) 
                {
                    $objPersonneMoraleIndividu->save();
                }
                
                if ($objIndividu->load_relationship('email_addresses')) 
                {
                    $relatedBeans = $objIndividu->get_linked_beans('email_addresses');
                    if(count($relatedBeans) > 0)
                    {
                        $relatedBeans[0]->email_address = $objIndividu->email1;
                        $relatedBeans[0]->save();
                    }
                }
            }
            else
            {
                $GLOBALS['log']->fatal('ModifierAdulteAction::execute() => L\'individu n\'est pas un adulte');
            }
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne le nom du fichier javascript
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "ModifierAdulteAction";
    }

    private function getChamps(){
        return array(
            'salutation' => 'Civilité',
            'last_name' => 'Nom de famille',
            'nom_usage' => 'Nom d\'usage',
            'first_name' => 'Prénom',
            'situation_familiale' => 'Situation matrimoniale',
            'etat' => 'Etat',
            'nationalite' => 'Nationalité',
            'date_naissance' => 'Date de naissance',
            'lieu_naissance' => 'Ville de naissance',
            'pays_naissance' => 'Pays de naissance',
            'representant_parent' => 'Représentant parents d\'élèves',
            'email1' => 'E-mail',
            'phone_mobile' => 'Tél. portable',
            'phone_home' => 'Tél. fixe',
            'phone_work' => 'Tél. professionnel',
            'phone_other' => 'Autre tél.',
            'accepte_mail' => 'Accepte mails',
            'accepte_sms' => 'Accepte SMS',
            'adresse_domiciliation' => 'Adresse de domiciliation',
            'profession_pcs' => 'Catégorie socio-professionnelle',
            'nom_employeur' => 'Nom de l\'employeur',
            'adresse_employeur' => 'Adresse de l\'employeur',
            'autorite_parentale' => 'Autorité parentale',
            'role' => 'Fonction',
            'mode_garde' => 'Mode de garde',
            'referent_tarifaire' => 'Référent tarifaire',
            'presence' => 'Présence',
            'payeur' => 'Payeur',
            'assurance_compagnie' => 'Compagnie d\'assurance',
            'assurance_numero' => 'N° assurance',
            'date_debut_validite' => 'Date début de validité',
            'date_fin_validite' => 'Date fin de validité',
            'responsable' => 'Responsable',
            'acces_usager' => 'Accès internet',
        );
    }
}