/**
 * Point d'entrée du générateur de formulaire
 * @param $ JQuery
 * @param router Router
 * @param champs Champs
 * 
*/
 
String.prototype.isEmpty = function() {
    return (this.length === 0 || !this.trim() );
};

String.prototype.b64ToUtf8 = function() {
    return decodeURIComponent(escape(window.atob( this )));
};

String.prototype.utf8ToB64 = function() {
    return window.btoa(unescape(encodeURIComponent( this )));
};

if (!String.prototype.includes) {
    String.prototype.includes = function() {
        'use strict';
        return String.prototype.indexOf.apply(this, arguments) !== -1;
    };
}

Object.getLength = function(obj) {
    var size = 0,key;
    for (key in obj) {
        if (obj.hasOwnProperty(key)) size++;
    }
    return size;
};
 
if (!Object.prototype.forEach) {
    Object.defineProperty(Object.prototype, 'forEach', {
        value: function (callback, thisArg) {
            if (this == null) {
                throw new TypeError('Not an object');
            }
            thisArg = thisArg || window;
            for (var key in this) {
                if (this.hasOwnProperty(key)) {
                    callback.call(thisArg, this[key], key, this);
                }
            }
        }
    });
}


var Generateur = (function($,odeQueries,odeAjax,onglet,champ,formulaireChamp,formulaireOnglet,searchBar,setting,router,formulaireSection) {

    return {
        
        /**
         * Fonction qui 
         * 
         * @param {string} xxx xxx 
         * @return {void} 
         */
        start: function() {

            // Initialisation des dimensions du main container
            this.setHeightContainer();
            this.initTrash();
 
            // Initilisation de la sauvegarde du formulaire
            this.setSaveFormulaire();
 
            // Initilisation des onglets 
            onglet.setSortableBoutons();
            onglet.setDroppableSortableContainers();
            onglet.setDeleteOnglets();
            onglet.addLigne();
            onglet.addSection();

            // Initialisation des layouts 
            Ligne.setDraggable();
            Section.setDraggable();
            Section.setEditableOnClick();

            // On affiche les icones " nombre conditions " sur les champs qui disposent d'icone
            formulaireChamp.setIconeConditions();
            formulaireSection.setIconeConditions();
            // Initialisation des champs
            champ.setDraggable();
            champ.setDroppableContainers();

            // On initialise la barre de recherche dans la vue Liste Champs
            searchBar.start();

            // Initialisation des champs ( draggable )
            router.start();

            setting.setSyncAgentUsager();
            setting.setSyncUsagerAgent();
        },

        initTrash: function(){

            $("#trash-page").hide();
            $("#trash-page").droppable({
                activeClass: "active",
                hoverClass: "hover",
                accept: function (draggable) {
                    return ( $(draggable).attr("role") === "list-champ" || $(draggable).attr("role") === "onglet-ligne" ) ? true : false;
                },
                drop: function(event, ui) {
                    Champ.flagModification($(ui.draggable).attr('id'));
                    $(ui.draggable).remove();
                    console.log("initTrash droppable drop element ");
                }
            });
        },

        setHeightContainer: function(){
            let document_height = $(window).height();
            let app_container_height = document_height * 0.75;
            $("#app-container").css("height", app_container_height);
        },

        setSaveFormulaire: function(){
            const self = this;

            var select_version_save = atob($('#version_options').val());
            select_version_save = select_version_save.replace(/\\/g, '');
            
            var confirm_content = '<div style="overflow: hidden;" >';

            confirm_content +=          '<div class="row" style="padding-bottom: 5%;">' ;
            confirm_content +=              '<div class="col-md-10" >Voulez-vous réellement sauvegarder la vue ?</div>';
            confirm_content +=          '</div>';

            confirm_content +=          '<div class="row" id="div_version_choice" style="display: none;">';

            confirm_content +=          '<div class="row" style="padding-bottom: 1%;">' ;
            confirm_content +=              '<div class="col-md-2" ></div>';
            confirm_content +=              '<div class="col-md-3" style="margin-top: 1%;" >Version :</div>';
            confirm_content +=              '<div class="col-md-6" >';
            confirm_content +=                  '<select id="select_version_save" style="width: 100%;">';
            confirm_content +=                      select_version_save;
            confirm_content +=                  '</select>';
            confirm_content +=              '</div>';
            confirm_content +=          '</div>';

            confirm_content +=          '<div class="row" style="padding-bottom: 3%;">' ;
            confirm_content +=              '<div class="col-md-2" ></div>';
            confirm_content +=              '<div class="col-md-3" style="margin-top: 1%;" >Commentaire :</div>';
            confirm_content +=              '<div class="col-md-6" >';
            confirm_content +=                  '<input id="commentaire_version_save" placeholder="Ajoutez un commentaire (optionnel)" style="width: 100%;" type="text" >';
            confirm_content +=              '</div>';
            confirm_content +=          '</div>';

            confirm_content +=          '</div>';

            confirm_content += '</div>';

            $( "#generateur-save-btn" ).click(function() {
                $.confirm({
                    title: false,
                    content: confirm_content,
                    closeIcon: true,
                    confirmButton: false,
                    columnClass: 'col-md-6 col-md-offset-3',
                    buttons: {
                        save: {
                            text: 'Oui',
                            btnClass: 'g-page-btn-back',
                            keys: ['enter', 'shift'],
                            action: function(){
                                this.buttons.save.setText('En cours...'); 
                                this.buttons.save.disable();
                                self.saveFormulaire(this);

                                return false;
                            },
                        },
                        fermer: {
                            text: 'Non',
                            btnClass: 'g-page-btn-back',
                            action: function(){}
                        },
                    },
                });
            });

        },

        saveFormulaire: function(confirm){

            var vue = $('#app-container [role="presentation"].active a').attr('aria-controls');

            $('#'+vue).attr('data-modified','false');

            this.saveOnglets(vue);
            this.deleteOnglets(vue);

            var data = this.getDataFormulaire(vue);
            OdeLog.log( OdeLog.asSuccess("saveFormulaire"), data);
      
            var query = OdeQueries.getAjaxActionQuery();
            query.setModule('OPS_generateur_formulaire');
            query.setAction("sauvegarder");
            query.setPostData(data);

            loading = function(){};
    
            callBack = function(){
                console.log("callBack::this = ",this)
                if ( Object.getLength(this.result) > 0 ){
                    var version_modified = true;
                    if ( version_modified === true ){
                        var message_version = "La vue a été sauvegardé";
                        $('#app-container [role="presentation"].active a').css('color', '');
                        $("#confirm_message_version").text(message_version);
                    }
                    confirm.buttons.save.hide();
                    confirm.buttons.fermer.setText('Ok')
                } else {
                    confirm.buttons.save.setText('Erreur'); 
                }
            };

            odeAjax.getByAction( query, loading, callBack );
            
        },

        saveOnglets: function(vue){

            loading = function(){};

            callBack = function(){
                if(this.result.fake === "true"){
                    $('#'+this.result.id_tab).removeAttr("data-fake");
                }
            };

            $("#"+vue).find($("[role=tabpanel]")).each(function() {

                var id_vue = $(this).closest('div[role="vue"]')[0].id;
                var data_onglet = {};
                data_onglet["vue_id"] = $('#'+id_vue).data("id");
                data_onglet["id"] = $(this).attr("data-id");
                data_onglet["nom"] = $(this).attr("data-nom");
                data_onglet["libelle"] = $(this).attr("data-libelle");
                data_onglet["ordre"] = $(this).attr("data-ordre");
                data_onglet["cle"] = $(this).attr("data-cle");
                data_onglet["fake"] = ($(this).attr("data-fake"))?$(this).attr("data-fake"):0;
                data_onglet["id_tab"] = $(this).attr("id");
                data_onglet["conditions"] = $(this).attr("data-conditions");
                data_onglet["description"] = $(this).attr("data-description");
                data_onglet["visible"] = ( $(this).attr("data-visible") !== undefined ) ? $(this).attr("data-visible") : 1;
                data_onglet["modifiable"] = ( $(this).attr("data-modifiable") !== undefined ) ? $(this).attr("data-modifiable") : 1;

                var query = OdeQueries.getAjaxActionQuery();
                query.setModule('OPS_generateur_onglet');
                query.setAction("sauvegarder");
                query.setPostData(data_onglet);

                odeAjax.getByAction( query, loading, callBack );
            });
        },

        deleteOnglets: function(vue){
            loading = function(){};

            callBack = function(){
                //Remove l'onglet qui vient d'arriver.
                $('[data-id="'+this.result.id+'"]').remove();
            };

            $("#"+vue).find($('[data-delete="true"]')).each(function() {
                console.log($(this).attr('data-id'));
                var query = OdeQueries.getAjaxActionQuery();
                query.setModule('OPS_generateur_onglet');
                query.setAction("deleteOnglet");
                    query.setPostData({id: $(this).attr('data-id')});
                OdeAjax.getByAction( query, loading, callBack );
            });
        },

        getDataFormulaire: function(vue){

            const self = this;
            var data_formulaire = {};
            var data_vue = {};
            $("#"+vue).find($("[role=tabpanel]")).each(function() {
                var data_onglet = {};
                data_onglet["nom"] = $(this).attr("data-nom");
                data_onglet["libelle"] = $(this).attr("data-libelle");
                data_onglet["ordre"] = $(this).attr("data-ordre");
                data_onglet["cle"] = $(this).attr("data-cle");
                data_onglet["lignes"] = [];
                $(this).find($("[role=onglet-ligne]")).each(function() {
                        
                    if ( $(this).attr("data-layout") === "section" ) {
                        var data_ligne = {
                            type: "section",
                            title: $(this).find("input").val(),
                            conditions: $(this).find("[role=section-title]").attr('data-conditions')
                        };
                    } else {

                        if ( $(this).attr("data-layout") === "ligne_simple_champ" ) {
                            var data_ligne = {
                                type: "ligne_simple_champ",
                                champs: []
                            };
                        } else {
                            var data_ligne = {
                                type: "ligne_double_champ",
                                champs: []
                            };
                        }
                        $(this).find($("[role=champ-container]")).each(function() {
                            if ( $(this).find($("[role=list-champ]")).length > 0 ){
                                const regex = /^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)?$/;
                                var aide = $(this).find($("[role=list-champ]")).attr("data-aide");
                                if(!aide.match(regex) && ![undefined, null,""].includes(aide)){
                                    aide = window.btoa(unescape(encodeURIComponent( aide )));
                                }
                                var data_champ = {
                                    nom: $(this).find($("[role=list-champ]")).attr("data-nom"),
                                    libelle: $(this).find($("[role=list-champ]")).attr("data-libelle"),
                                    type: $(this).find($("[role=list-champ]")).attr("data-type"),
                                    obligatoire: $(this).find($("[role=list-champ]")).attr("data-obligatoire"),
                                    ineditable: $(this).find($("[role=list-champ]")).attr("data-ineditable"),
                                    aide: aide,
                                    defaut: $(this).find($("[role=list-champ]")).attr("data-defaut"),
                                    description: $(this).find($("[role=list-champ]")).attr("data-description"),
                                    params: $(this).find($("[role=list-champ]")).attr("data-params"),
                                    conditions: $(this).find($("[role=list-champ]")).attr("data-conditions"),
                                    modifiable: $(this).find($("[role=list-champ]")).attr("data-modifiable")
                                };
                                console.log("----data_champ = ", data_champ);
                            }else{
                                var data_champ = {};
                            }
                            data_ligne.champs.push(data_champ);
                        });
                    }

                    data_onglet["lignes"].push(data_ligne);
                });
                data_vue[$(this).attr("data-id")] = data_onglet;
            });
            data_formulaire[$("#"+vue).attr("data-id")] = data_vue;

            if( $('#radio_avec_historique').prop('checked') ){
                const queryString = window.location.search;
                const urlParams = new URLSearchParams(queryString);

                data_formulaire['historique_version'] = $('#select_version_save').val();
                data_formulaire['historique_commentaire'] = $('#commentaire_version_save').val();
                data_formulaire['generateur_formulaire_id'] = urlParams.get('generateur_formulaire_id');
            }
            
            return data_formulaire;
        },        
    }
})(jQuery,OdeQueries,OdeAjax,Onglet,Champ,FormulaireChamp,FormulaireOnglet,SearchBar,Setting,Router,FormulaireSection);

$(document).ready(function() {
    Generateur.start();
});

function changeChoiceSave(radio){
    if( $("#div_version_choice") ){
        if(radio.value == "oui"){
            radio.setAttribute("checked",'true');
            $("#div_version_choice").show();
            $('#radio_sans_historique').removeAttr("checked");
        }
        if(radio.value == "non"){
            radio.setAttribute("checked",'true');
            $("#div_version_choice").hide();
            $('#radio_avec_historique').removeAttr("checked");
        }
    } 
}