var FormulaireChampConditionListe = (function($,formulaireChamp) {

    return {

        display: function( type ){

            OdeLog.log( OdeLog.asAlert("display type"), type );
            
            // Initilisation du  bouton sauvegarde du formulaire
            this.setSaveBouton();

            // Si c'est la liste de conditions d'un onglet on cache le param visibilité
            ( type === "onglet" ) ? $(`#g-condition-form-liste-visible`).hide() : $(`#g-condition-form-liste-visible`).show();

            // On initilise le titre du formulaire
            ( type === "onglet" ) ? $(`#g-condition-form-liste-title`).text("Liste des conditions de l'onglet") : $(`#g-condition-form-liste-title`).text("Liste des conditions du champ");
            
            // On ajoute le type au formulaire ( utile pour la sauvegarde )
            $(`#g-condition-form-liste-type`).val(type);

            ( type === "onglet" ) ? $(`#btn-back-formulaire`).attr("data-route", "back-formulaire-onglet") : $(`#btn-back-formulaire`).attr("data-route", "back-formulaire-champ");
          
            var liste_element_html = this.getEmptyListElement();

            var formulaire_data = ( type === "onglet" ) ? FormulaireOnglet.getData() : formulaireChamp.getData() ;

            OdeLog.log( OdeLog.asSuccess("formulaire_data"), formulaire_data );

            $(`#g-condition-form-liste-message`).hide();

            if ( Object.getLength(formulaire_data) > 0 ) {

                if ( typeof formulaire_data.id === "string" && formulaire_data.id !== "" ) {
                    $("#g-condition-form-add-btn").attr("data-route",`/conditions/champ?id=${formulaire_data.id}`); 
                }else{
                    $("#g-condition-form-add-btn").attr("data-route",`/conditions/champ?id=`);
                }

                if ( typeof formulaire_data.libelle === "string" && formulaire_data.libelle !== "" ) {
                    $(`#g-condition-form-liste-title-champ-libelle`).text(formulaire_data.libelle);
                }

                var field_conditions = ( formulaire_data.conditions !== undefined && !formulaire_data.conditions.isEmpty() ) ? JSON.parse( formulaire_data.conditions.b64ToUtf8() ) : { verified: "all",  visible: 1, modifiable: 1, conditions: [] };
                                    
                if ( Object.getLength(field_conditions.conditions ) > 0){
                    liste_element_html = this.getListElement( field_conditions.conditions );
                    OdeLog.log( OdeLog.asSuccess("formulaire_data"), formulaire_data );
                }

                if ( field_conditions.visible === 1 ) {
                    $('#g-condition-form-liste-visible-oui').prop('checked', true);
                } else {
                    $('#g-condition-form-liste-visible-non').prop('checked', true);
                }

                if ( field_conditions.modifiable === 1 ) {
                    $('#g-condition-form-liste-modifiable-oui').prop('checked', true);
                } else {
                    $('#g-condition-form-liste-modifiable-non').prop('checked', true);
                }

                $(`#g-condition-form-liste-condition option[value="${field_conditions.verified }"]`).prop('selected', true);

                $("#g-condition-form-liste").empty();
                $("#g-condition-form-liste").append(liste_element_html);

                this.setClickRoutes();
                this.setClickDeleteBtn();
            }
        },


        /**
         * Fonction qui sauvegarde le paramerage des conditions dans l'input hidden du formulaire onglet
         *
         * @return {void}
         */
        setSaveBouton: function() { 

            $( "#g-condition-form-liste-save-btn" ).off().click(function() {

                // On récupere le prametrage
                var _verified = $("#g-condition-form-liste-condition option:selected").val();
                var _visible = ( $('#g-condition-form-liste-visible-oui').prop('checked') === true ) ? 1 : 0;
                var _modifiable = ( $('#g-condition-form-liste-modifiable-oui').prop('checked') === true ) ? 1 : 0;
          
                // On récupere les données du formulaire champ ou onglet 
                var formulaire_data = ( $(`#g-condition-form-liste-type`).val() === "onglet" ) ? FormulaireOnglet.getData() : formulaireChamp.getData() ;
               
                // On modifie le parametrage existant et on l'ajoute à l'input hidden 
                if ( Object.getLength(formulaire_data) > 0 ) {
                    if ( $(`#g-condition-form-liste-type`).val() === "onglet" ) {
                        var field_conditions = ( !formulaire_data.conditions.isEmpty() ) ? JSON.parse(formulaire_data.conditions.b64ToUtf8()) : { verified: "all",  modifiable: 1, conditions: [] };
                        field_conditions.verified = _verified;
                        field_conditions.modifiable = _modifiable;
                        $("#g-onglet-form-conditions").val(JSON.stringify(field_conditions).utf8ToB64());
                    } else {
                        var field_conditions = ( !formulaire_data.conditions.isEmpty() ) ? JSON.parse(formulaire_data.conditions.b64ToUtf8()) : { verified: "all",  visible: 1, modifiable: 1, conditions: [] };
                        field_conditions.verified = _verified;
                        field_conditions.visible = _visible;
                        field_conditions.modifiable = _modifiable;
                        $("#g-champ-form-conditions").val(JSON.stringify(field_conditions).utf8ToB64());
                    }
                }

                // On affiche le loading menu
                OdeLoadingHelper.addSpinnerMenu();

                // Apres une petite seconde
                setTimeout(function(){ 

                    // on cache le loading
                    OdeLoadingHelper.removeSpinnerMenu();

                    // on retourne au formulaire onglet ou champ 
                    $("#btn-back-formulaire").click();

                    // On affiche le message 
                    var element_id = ( $(`#g-condition-form-liste-type`).val() === "onglet" ) ? "g-onglet-form-message" : "g-champ-form-message";
                    var message = ( $(`#g-condition-form-liste-type`).val() === "onglet" ) ? "à l'onglet" : "au champ";
                    OdeAlertHelper.set( $(`#${element_id}`) , "success",`Conditions ajoutées ${message}`);
              
                }, 1000);

            });

        },

        setClickRoutes: function() {
            $("#g-condition-form-liste").find($("[role=navigation]")).each(function() {
                $("body").off( "click", $(this) );
                $(this).click(function(){ Router.navigate($( this ).attr( "data-route" )); });
            });
        },

        setClickDeleteBtn: function(){ 
            const self = this;
            $("[role=delete-condition]").each(function() {
                $(this).click(function(){ 
                    var condition = {
                        champ: $( this ).attr( "data-champ" ),
                        operator: $( this ).attr( "data-operator" ),
                        value: $( this ).attr( "data-value" ),
                    };
                    var deleted = ( $(`#g-condition-form-liste-type`).val() === "onglet" ) ? FormulaireOnglet.deleteCondition(condition) : formulaireChamp.deleteCondition(condition);
                    if ( deleted ) self.removeConditionItem( $(this).parent().parent().parent() )
                });
            });
        },

        removeConditionItem: function( item ){

            item.remove();
            OdeAlertHelper.set( $(`#g-condition-form-liste-message`) , "success", `La condition a bien été supprimée`);

            var data = ( $(`#g-condition-form-liste-type`).val() === "onglet" ) ? FormulaireOnglet.getConditions() :formulaireChamp.getConditions();
            if ( Object.getLength(data.conditions) === 0 ) {
                var empty_liste_html = this.getEmptyListElement();
                $("#g-condition-form-liste").append(empty_liste_html);
            }
            
        },

        getEmptyListElement: function(){
            return '<li class="list-group-item d-flex justify-content-between align-items-center"> Aucune condition </li>';
        },

        getListElement: function( conditions ){
            var conditions_html = "";
            conditions.forEach(function(condition) {

                conditions_html += `<li class="list-group-item d-flex justify-content-between align-items-center">`;
                conditions_html +=      `<div class="row">`;
                conditions_html +=          `<div class="col-md-9">`;
                conditions_html +=              `<p> <strong>Si</strong> ${condition.champ} <strong> ${condition.operator} </strong> ${condition.value} </p>`;
                conditions_html +=          `</div>`;
                conditions_html +=          `<div class="col-md-3">`;
                conditions_html +=              `<button role="delete-condition" type="button" data-champ="${condition.champ}" data-operator="${condition.operator}" data-value="${condition.value}" data-visible="${condition.visible}" data-modifiable="${condition.modifiable}"  type="button" title="Supprimer la condition" class="badge" style=" background-color: #dc3545; padding: 5px 6px;border: none;">`;
                conditions_html +=                  `<i class="fas fa-trash-alt"></i>`;
                conditions_html +=              `</button>`;
                conditions_html +=              `<button role="navigation" data-route="/conditions/champ?champ=${condition.champ}&operator=${condition.operator}&value=${condition.value}" title="Modifier la condition" class="badge" style="background-color:#28a745;padding: 5px 6px;border: none;">`;
                conditions_html +=                  `<i class="fas fa-edit"></i>`;
                conditions_html +=              `</button>`;
                conditions_html +=          `</div>`;
                conditions_html +=      `</div>`;
                conditions_html += `</li>`;
            });
            return conditions_html;
        },

        
        
    }

})(jQuery,FormulaireChamp);


/*
                conditions_html +=          `<div class="col-md-2">`;
                conditions_html +=              ( condition.visible == "1" ) ? `<i class="fas fa-eye" style="color: #28a745;"></i>` : `<i class="fas fa-eye-slash" style="color: #dc3545;"></i>`;
                conditions_html +=              ( condition.modifiable == "1" ) ? `<i class="fas fa-pen" style="color: #28a745;"></i>` : `<i class="fas fa-pen" style="color: #dc3545;"></i>`;
                conditions_html +=          `</div>`;

*/

