var FormulaireChampListe = (function($,formulaireChamp) {

    return {

        initAddBouton: function(){
            const self = this;
            $("#g-formulaire-liste-add-btn").off().click(function(){ 
                let ligne = self.getLigne( null, null);
                if ( $(`#g-formulaire-liste`).find($("[role=formulaire-liste-ligne]")).length > 0 ){
                    $(`#g-formulaire-liste`).append($(ligne));
                } else {
                    $(`#g-formulaire-liste`).empty();
                    $(`#g-formulaire-liste`).append($(ligne));
                }
                self.initDeleteBoutons();
            });
        },

        initDeleteBoutons: function(){
            $("[role=formulaire-liste-delete]").each(function() {
                $(this).off().click(function(){ 
                    $(this).parent().parent().parent().remove();
                });
            });
        },

        initSaveBouton: function(){
            const self = this;
            $("#g-formulaire-liste-save-btn").off().click(function(){ 
                var elements = {};
                var lignes = $(`#g-formulaire-liste`).find($("[role=formulaire-liste-ligne]"));
                if ( lignes !== undefined && lignes.length > 0 ){
                    lignes.each(function() {
                        var input_cle = $(this).find($("[role=formulaire-liste-cle]"));
                        var input_value = $(this).find($("[role=formulaire-liste-value]"));
                        if ( input_cle !== undefined && input_value !== undefined ){
                            if ( !input_cle.val().isEmpty() ){
                                elements[input_cle.val()] = input_value.val();
                            }
                        }
                    });
                }
                
                formulaireChamp.setListe(elements);
                formulaireChamp.setChampListe();

                var default_value = formulaireChamp.getChampDefaut();
                formulaireChamp.setChampDefaut( default_value );

                OdeAlertHelper.set( $("#g-champ-form-message"), "success",`La liste a bien été modifiée`);

                $("#g-formulaire-liste-back-btn").click();
                
            });
        },

        display: function(){

            const self = this;
            var params = formulaireChamp.getChampParams();
            var liste = ( params.hasOwnProperty("liste") ) ? params["liste"] : {};

            $(`#g-formulaire-liste-message`).hide();
            $("#g-formulaire-liste").empty();
            if ( Object.getLength(liste) > 0 ) {
                var lignes = "";
                liste.forEach(function(option_libelle,option_value) {
                    if ( !option_value.isEmpty() ){
                        lignes += self.getLigne( option_value, option_libelle );
                    }
                });
                $("#g-formulaire-liste").append($(lignes));
                this.initDeleteBoutons();
            } else {
                var ligne_vide = this.getLigneEmpty();
                $("#g-formulaire-liste").append($(ligne_vide))
            }

            this.initAddBouton();
            this.initSaveBouton();

        },

        getLigne: function( cle, value ){

            var _cle = ( cle !== null && cle !== undefined ) ? cle : "";
            var _value = ( value !== null && value !== undefined ) ? value : "";

            var ligne =`<li class="list-group-item d-flex justify-content-between align-items-center">`;
            ligne    +=     `<div role="formulaire-liste-ligne" class="row">`;
            ligne    +=         `<div class="col-md-4">`;
            ligne    +=             `<input role="formulaire-liste-cle" type="text" placeholder="Clé" value="${_cle}" style="width: 100%;" >`;
            ligne    +=         `</div>`;
            ligne    +=         `<div class="col-md-7">`;
            ligne    +=             `<input role="formulaire-liste-value" type="text" placeholder="Value" value="${_value}"style="width: 95%;" >`;
            ligne    +=         `</div>`;
            ligne    +=         `<div class="col-md-1">`;
            ligne    +=             `<button role="formulaire-liste-delete" title="Supprimer la ligne" class="badge" style=" float: right;margin-top: 4px;background-color: #dc3545; padding: 5px 6px;border: none;">`;
            ligne    +=                 `<i class="fas fa-trash-alt"></i>`;
            ligne    +=             `</button>`;
            ligne    +=         `</div>`;
            ligne    +=     `</div>`;
            ligne    += `</li>`;   

            return ligne;    

        },

        getLigneEmpty: function() {
           return '<li class="list-group-item d-flex justify-content-between align-items-center"> Aucun élement </li>';
        },

        setClickRoutes: function() {
            $("#g-formulaire-liste").find($("[role=navigation]")).each(function() {
                $("body").off( "click", $(this) );
                $(this).click(function(){ Router.navigate($( this ).attr( "data-route" )); });
            });
        },
        
    }
})(jQuery,FormulaireChamp);


