var Ligne = (function($) {
 
    return {

        /**
         * Fonction qui retourne une ligne vide en Html 
         * 
         * @return {string} 
         */
         getHtml: function(){
            var ligne_html = '<div role="onglet-ligne" class="row g-tab-onglet-ligne ligne-dropped">';
            ligne_html +=       '<div role="ligne-move-handle">';
            ligne_html +=           '<i class="fas fa-arrows-alt ligne-move-handle" title="Déplacer la ligne"></i>';
            ligne_html +=       '</div>';
            ligne_html +=       '<div role="champ-container" class="champ-container-full"></div>';
            ligne_html +=       '<div role="champ-container" class="champ-container-full"></div>';
            ligne_html +=       '<div role="ligne-delete-handle" onclick="suppLigne(this)">';
            ligne_html +=           '<i class="fas fa-trash-alt" title="Supprimer la ligne" ></i>';
            ligne_html +=       '</div>';
            ligne_html +=   '</div>';
            return ligne_html;
        },

        /**
         * Fonction qui retourne une ligne vide en Html 
         * 
         * @return {string} 
         */
         getHtmlOneColumn: function(){
            var ligne_html = '<div role="onglet-ligne" class="row g-tab-onglet-ligne ligne-dropped" data-layout="ligne_simple_champ">';
            ligne_html +=       '<div role="ligne-move-handle">';
            ligne_html +=           '<i class="fas fa-arrows-alt ligne-move-handle" title="Déplacer la ligne"></i>';
            ligne_html +=       '</div>';
            ligne_html +=       '<div role="champ-container" class="champ-container-full one-field"></div>';
            ligne_html +=       '<div role="ligne-delete-handle" onclick="suppLigne(this)">';
            ligne_html +=           '<i class="fas fa-trash-alt" title="Supprimer la ligne" ></i>';
            ligne_html +=       '</div>';
            ligne_html +=   '</div>';
            return ligne_html;
        },

        /**
         * Fonction qui initialise l'event draggable des lignes.  
         * Selector [ class = ligne-draggable ]
         * 
         * @return {void} 
         */
        setDraggable: function() {
            $(".ligne-draggable").draggable({
                  cursor: 'move',
                  revert: 'invalid',
                  appendTo: "body",
                  helper: function () { 
                      var cloned = $(this).clone();
                      cloned.addClass("ligne-in-drag");
                      return cloned;
                  },
                  distance: 20
              });
        },

    }
})(jQuery);

 
