<?php

namespace ODE\Generateur\Field;
use Sugar_Smarty;
use Configurator;

class OdeAdresse_Geoloc extends OdeField
{

    /**
     * @access public
     * @name __construct de la classe OdePourcentage
     * @param bean              $bean: Bean du module OPS_dossier
     * @param boolean           $editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value_bdd)
    {
        global $sugar_config;

        // Implémente la gestionnaire de configuration.
        $configuratorObj = new Configurator();

        // On s'appuie proprement sur des paramètres par défaut...
        $disable_api_ban = '0';
        if( isset( $configuratorObj->config['opensocle'] )
         && isset( $configuratorObj->config['opensocle']['disable_api_ban'] )
        )
        {
            $disable_api_ban = trim(intval( $configuratorObj->config['opensocle']['disable_api_ban'] ));
        }

        // On récupere la valeur à afficher
        $value = $this->getFieldValue($value_bdd);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $disabled = ' disabled="disabled" ';
        $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
        $data_required = ( $required != '' ) ? ' data-required="true" ' : '';

        $smarty = new Sugar_Smarty();
        $smarty->assign("id", $this->getUniqueId());
        $smarty->assign("adresse_geoloc", "adresse_geoloc");
        $smarty->assign("name", $name);
        $smarty->assign("required", $required);
        $smarty->assign("data_required", $data_required);
        $smarty->assign("disabled", $disabled);

        if(isset($value["value"]))
        {
            $smarty->assign("value", $value["value"]);
        }
        $smarty->assign("conditions", $champ['conditions']);

/* » GeoLocAny2.5*/
        $smarty->assign("name_adresse_libre", "name_adresse_libre");
/*GeoLocAny2.5 « */

        $smarty->assign("name_numero", "name_numero");
        $smarty->assign("name_rue", "name_rue");
        $smarty->assign("name_complement_batiment", "name_complement_batiment");
        $smarty->assign("name_complement_lieu", "name_complement_lieu");
        $smarty->assign("name_code_postal", "name_code_postal");
        $smarty->assign("name_ville", "name_ville");
        $smarty->assign("name_latitude", "name_latitude");
        $smarty->assign("name_longitude", "name_longitude");

/* » GeoLocAny2.5*/
        if(isset($value["adresse_libre"]))
        {
            $smarty->assign("value_adresse_libre", $value["adresse_libre"]);
        }
/*GeoLocAny2.5 « */

        if(isset($value["numero"]))
        {
            $smarty->assign("value_numero", $value["numero"]);
        }

        if(isset($value["rue"]))
        {
            $smarty->assign("value_rue", $value["rue"]);
        }

        if(isset($value["complement_batiment"]))
        {
            $smarty->assign("value_complement_batiment", $value["complement_batiment"]);
        }

        if(isset($value["complement_lieu"]))
        {
            $smarty->assign("value_complement_lieu", $value["complement_lieu"]);
        }

        if(isset($value["postcode"]))
        {
            $smarty->assign("value_code_postal", $value["postcode"]);
        }

        if(isset($value["city"]))
        {
            $smarty->assign("value_ville", $value["city"]);
        }

        if(isset($value["coordonnees_x"]))
        {
            $smarty->assign("value_latitude", $value["coordonnees_x"]);
        }

        if(isset($value["coordonnees_y"]))
        {
            $smarty->assign("value_longitude", $value["coordonnees_y"]);
        }

        $latitude = '48.86';
        if(isset($value["coordonnees_x"]) && !empty($value["coordonnees_x"]))
        {
            $latitude = $value["coordonnees_x"];
        }
        else if (isset($configuratorObj->config['geoloc_leaflet']['latitude']) && !empty($configuratorObj->config['geoloc_leaflet']['latitude']))
        {
            $latitude = $configuratorObj->config['geoloc_leaflet']['latitude'];
        } 

        $longitude = '2.33';
        if(isset($value["coordonnees_y"]) && !empty($value["coordonnees_y"]))
        {
            $longitude = $value["coordonnees_y"];
        }
        else if (isset($configuratorObj->config['geoloc_leaflet']['longitude']) && !empty($configuratorObj->config['geoloc_leaflet']['longitude']))
        {
            $longitude = $configuratorObj->config['geoloc_leaflet']['longitude'];
        }

        $smarty->assign("latitude",  $latitude); 
        $smarty->assign("longitude", $longitude);
        $smarty->assign("hauteur", (!empty($configuratorObj->config['geoloc_leaflet']['hauteur']))?$configuratorObj->config['geoloc_leaflet']['hauteur']:'400');
        $smarty->assign("zoom", (!empty($configuratorObj->config['geoloc_leaflet']['zoom']))?$configuratorObj->config['geoloc_leaflet']['zoom']:'7');
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);

        // Assignation des libellés de chaque champ (Dynamique selon la config client)
        $smarty->assign("label_num_rue", isset($sugar_config['opensocle']['adresse_libelles']['libelle_num_rue']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_num_rue']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_num_rue'] : 'N°');
        $smarty->assign("label_rue", isset($sugar_config['opensocle']['adresse_libelles']['libelle_rue']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_rue']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_rue'] : 'Rue');
        $smarty->assign("label_lieu_dit", isset($sugar_config['opensocle']['adresse_libelles']['libelle_lieu_dit']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_lieu_dit']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_lieu_dit'] : 'Lieu dit');
        $smarty->assign("label_bat_etage", isset($sugar_config['opensocle']['adresse_libelles']['libelle_bat_etage']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_bat_etage']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_bat_etage'] : 'Bât. / Étage');
        $smarty->assign("label_code_postal", isset($sugar_config['opensocle']['adresse_libelles']['libelle_code_postal']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_code_postal']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_code_postal'] : 'Code postal');
        $smarty->assign("label_ville", isset($sugar_config['opensocle']['adresse_libelles']['libelle_ville']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_ville']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_ville'] : 'Ville');

        // Défini quel rendu du template utilisé selon la config du l'usage de l'API
        $smarty->assign("disable_api_ban", $disable_api_ban);

        if( !empty($this->donnees["vue"]["type"]) && $this->donnees["vue"]["type"] === "usager"){
            $smarty->assign("leaflet_view", 'static');

            $disabled = ' disabled="disabled" ';
            $smarty->assign("disabled", $disabled);

            $smarty->assign("required", "");

            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/adresse_geoloc_front.tpl");
        }else{
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/adresse_geoloc.tpl");
        }

        return $field_html;
    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        global $sugar_config;

        // Implémente la gestionnaire de configuration.
        $configuratorObj = new Configurator();

        // On s'appuie proprement sur des paramètres par défaut...
        $disable_api_ban = '0';
        if( isset( $configuratorObj->config['opensocle'] )
         && isset( $configuratorObj->config['opensocle']['disable_api_ban'] )
        )
        {
            $disable_api_ban = trim(intval( $configuratorObj->config['opensocle']['disable_api_ban'] ));
        }


        // On récupere la valeur à afficher
        if (empty($value_bdd)) {
            $value = $this->getFieldDefautValue($champ["defaut"]);
        } else {
            $value = $this->getFieldValue($value_bdd);
        }

        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
        $disabled = ( isset($champ['ineditable']) && $champ['ineditable'] == 1 ) ? ' disabled="disabled" ' : '';
        $data_required = ( $required != '' ) ? ' data-required="true" ' : '';
        $id = $this->getUniqueId();

        $smarty = new Sugar_Smarty();
        $smarty->assign("id", $id);
        $smarty->assign("adresse_geoloc", "adresse_geoloc");
        $smarty->assign("name", $name);
        $smarty->assign("required", $required);
        $smarty->assign("disabled", $disabled);

        if(isset($value["value"]))
        {
            $smarty->assign("value", $value["value"]);
        }
        $smarty->assign("data_required", $data_required);
        $smarty->assign("conditions", $champ['conditions']);

/* » GeoLocAny2.5*/
        $smarty->assign("name_adresse_libre", "name_adresse_libre");
/*GeoLocAny2.5 « */

        $smarty->assign("name_numero", "name_numero");
        $smarty->assign("name_rue", "name_rue");
        $smarty->assign("name_complement_batiment", "name_complement_batiment");
        $smarty->assign("name_complement_lieu", "name_complement_lieu");
        $smarty->assign("name_code_postal", "name_code_postal");
        $smarty->assign("name_ville", "name_ville");
        $smarty->assign("name_latitude", "name_latitude");
        $smarty->assign("name_longitude", "name_longitude");
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);

/* » GeoLocAny2.5*/
        if(isset($value["adresse_libre"]))
        {
            $smarty->assign("value_adresse_libre", $value["adresse_libre"]);
        }
/*GeoLocAny2.5 « */

        if(isset($value["numero"]))
        {
            $smarty->assign("value_numero", $value["numero"]);
        }

        if(isset($value["rue"]))
        {
            $smarty->assign("value_rue", $value["rue"]);
        }

        if(isset($value["complement_batiment"]))
        {
            $smarty->assign("value_complement_batiment", $value["complement_batiment"]);
        }

        if(isset($value["complement_lieu"]))
        {
            $smarty->assign("value_complement_lieu", $value["complement_lieu"]);
        }

        if(isset($value["postcode"]))
        {
            $smarty->assign("value_code_postal", $value["postcode"]);
        }

        if(isset($value["city"]))
        {
            $smarty->assign("value_ville", $value["city"]);
        }

        if(isset($value["coordonnees_x"]))
        {
            $smarty->assign("value_latitude", $value["coordonnees_x"]);
        }

        if(isset($value["coordonnees_y"]))
        {
            $smarty->assign("value_longitude", $value["coordonnees_y"]);
        }

        $latitude = '48.86';
        if(isset($value["coordonnees_x"]) && !empty($value["coordonnees_x"]))
        {
            $latitude = $value["coordonnees_x"];
        }
        else if (isset($configuratorObj->config['geoloc_leaflet']['latitude']) && !empty($configuratorObj->config['geoloc_leaflet']['latitude']))
        {
            $latitude = $configuratorObj->config['geoloc_leaflet']['latitude'];
        } 

        $longitude = '2.33';
        if(isset($value["coordonnees_y"]) && !empty($value["coordonnees_y"]))
        {
            $longitude = $value["coordonnees_y"];
        }
        else if (isset($configuratorObj->config['geoloc_leaflet']['longitude']) && !empty($configuratorObj->config['geoloc_leaflet']['longitude']))
        {
            $longitude = $configuratorObj->config['geoloc_leaflet']['longitude'];
        }

        $smarty->assign("latitude",  $latitude); 
        $smarty->assign("longitude", $longitude);

        $hauteur = '400';
        if(isset( $configuratorObj->config['geoloc_leaflet']['hauteur'] ))
        {
            $hauteur = $configuratorObj->config['geoloc_leaflet']['hauteur'];
        }

        $zoom = '4';
        if(isset( $configuratorObj->config['geoloc_leaflet']['zoom'] ))
        {
            $zoom = $configuratorObj->config['geoloc_leaflet']['zoom'];
        }
        $smarty->assign("hauteur", $hauteur);
        $smarty->assign("zoom", $zoom);

        // Assignation des libellés de chaque champ (Dynamique selon la config client)
        $smarty->assign("label_num_rue", isset($sugar_config['opensocle']['adresse_libelles']['libelle_num_rue']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_num_rue']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_num_rue'] : 'N°');
        $smarty->assign("label_rue", isset($sugar_config['opensocle']['adresse_libelles']['libelle_rue']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_rue']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_rue'] : 'Rue');
        $smarty->assign("label_lieu_dit", isset($sugar_config['opensocle']['adresse_libelles']['libelle_lieu_dit']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_lieu_dit']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_lieu_dit'] : 'Lieu dit');
        $smarty->assign("label_bat_etage", isset($sugar_config['opensocle']['adresse_libelles']['libelle_bat_etage']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_bat_etage']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_bat_etage'] : 'Bât. / Étage');
        $smarty->assign("label_code_postal", isset($sugar_config['opensocle']['adresse_libelles']['libelle_code_postal']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_code_postal']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_code_postal'] : 'Code postal');
        $smarty->assign("label_ville", isset($sugar_config['opensocle']['adresse_libelles']['libelle_ville']) && !empty($sugar_config['opensocle']['adresse_libelles']['libelle_ville']) ? $sugar_config['opensocle']['adresse_libelles']['libelle_ville'] : 'Ville');



        // Défini quel rendu du template utilisé selon la config du l'usage de l'API
        $smarty->assign("disable_api_ban", $disable_api_ban);

        if( !empty($this->donnees["vue"]["type"]) && $this->donnees["vue"]["type"] === "usager"){
            $smarty->assign("leaflet_view", 'dynamic');
            $bouton_position = ' <div class="col-md-12 align-items-center d-flex">
                                    <div class="col-md-8 align-items-center d-flex">
                                        <!--?xml version="1.0" encoding="UTF-8"?--><svg alt="Icône retrouver ma position GPS" version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 752 752" width="20pt" height="20pt" style="fill: var( --main_color_primary );transform: translateX(-25%);"><g><path d="m446.48 376c0 38.926-31.559 70.484-70.484 70.484s-70.48-31.559-70.48-70.484 31.555-70.48 70.48-70.48 70.484 31.555 70.484 70.48"></path><path d="m601.51 352.51h-39.219c-10.637-84.82-77.973-152.16-162.79-162.79v-39.219c0-5.1797-4.1641-9.4336-9.4336-9.4336h-28.211c-5.1797 0-9.4336 4.1641-9.4336 9.4336v39.219c-84.82 10.637-152.16 77.973-162.79 162.79h-39.129c-5.1797 0-9.4336 4.1641-9.4336 9.4336v28.211c0 5.1797 4.1641 9.4336 9.4336 9.4336h39.219c10.637 84.82 77.973 152.16 162.79 162.79v39.219c0 5.1797 4.1641 9.4336 9.4336 9.4336h28.211c5.1797 0 9.4336-4.1641 9.4336-9.4336v-39.219c84.82-10.637 152.16-77.973 162.79-162.79h39.219c5.1797 0 9.4336-4.1641 9.4336-9.4336v-28.211c-0.089844-5.2734-4.25-9.4336-9.5234-9.4336zm-225.51 164.46c-77.695 0-140.96-63.266-140.96-140.96 0-77.695 63.27-140.96 140.96-140.96 77.699 0 140.96 63.27 140.96 140.96 0 77.699-63.266 140.96-140.96 140.96z"></path></g></svg>
                                        <a id="'.$id.'-position" rel="geoloc" class="avia-button" style="padding: 5px 10px;" title="Retrouver ma position GPS">Ma position</a>
                                        <small role="message-champ" style="display: none;">La position n\'a pas pu être trouvée.</small>
                                    </div>
                                </div>';
            $smarty->assign("bouton_position", $bouton_position);
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/adresse_geoloc_front.tpl");
        }else{
            $bouton_position = ' <div class="col-md-12 align-items-center d-flex">
                                    <div class="col-md-8">
                                        <!--?xml version="1.0" encoding="UTF-8"?--><svg alt="Icône retrouver ma position GPS" version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 752 752" width="20pt" height="20pt" style="fill: #f08377;transform: translate(-25%, 25%);"><g><path d="m446.48 376c0 38.926-31.559 70.484-70.484 70.484s-70.48-31.559-70.48-70.484 31.555-70.48 70.48-70.48 70.484 31.555 70.484 70.48"></path><path d="m601.51 352.51h-39.219c-10.637-84.82-77.973-152.16-162.79-162.79v-39.219c0-5.1797-4.1641-9.4336-9.4336-9.4336h-28.211c-5.1797 0-9.4336 4.1641-9.4336 9.4336v39.219c-84.82 10.637-152.16 77.973-162.79 162.79h-39.129c-5.1797 0-9.4336 4.1641-9.4336 9.4336v28.211c0 5.1797 4.1641 9.4336 9.4336 9.4336h39.219c10.637 84.82 77.973 152.16 162.79 162.79v39.219c0 5.1797 4.1641 9.4336 9.4336 9.4336h28.211c5.1797 0 9.4336-4.1641 9.4336-9.4336v-39.219c84.82-10.637 152.16-77.973 162.79-162.79h39.219c5.1797 0 9.4336-4.1641 9.4336-9.4336v-28.211c-0.089844-5.2734-4.25-9.4336-9.5234-9.4336zm-225.51 164.46c-77.695 0-140.96-63.266-140.96-140.96 0-77.695 63.27-140.96 140.96-140.96 77.699 0 140.96 63.27 140.96 140.96 0 77.699-63.266 140.96-140.96 140.96z"></path></g></svg>
                                        <input id="'.$id.'-position" title="Ma position" class="button" type="button" value="Ma position" style="text-transform: none;">
                                        <small role="message-champ" style="display: none;">La position n\'a pas pu être trouvé.</small>
                                    </div>
                                </div>';
            $smarty->assign("bouton_position", $bouton_position);
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/adresse_geoloc.tpl");
        }
        return $field_html;
    }

    public function getFieldValue($value_bdd)
    {   
        if(!empty($value_bdd)){
            $value_bdd = str_replace('&amp;#x3D;','=',$value_bdd);
            $value = ($this->isUTF8(base64_decode($value_bdd)))?json_decode( base64_decode($value_bdd),true):json_decode( mb_convert_encoding(base64_decode($value_bdd), "UTF-8", "auto"),true );
            $value['value'] = $value_bdd;
        }
        return (!empty($value)) ? $value : "";
    }

    public function getFieldDefautValue($value_defaut)
    {
        return (!empty($value_defaut)) ? str_replace('"', '&quot;',  html_entity_decode($value_defaut) ) : "";
    }
    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {
        global $sugar_config;

        if(!empty($value)){
            $value = $this->getFieldValue($value);


            // Implémente la gestionnaire de configuration.
            $configuratorObj = new Configurator();

            // On s'appuie proprement sur des paramètres par défaut...
            $disable_api_ban = '0';
            if( isset( $configuratorObj->config['opensocle'] )
             && isset( $configuratorObj->config['opensocle']['disable_api_ban'] )
            )
            {
                $disable_api_ban = intval( $configuratorObj->config['opensocle']['disable_api_ban'] );
            }

            if( $disable_api_ban == 1 ) {
                if( isset($value["adresse_libre"]) ){
                    // Adresse libre saisie (sans API BAN).
                    $value = $value["adresse_libre"];
                }elseif ( isset($value["rue"]) && !empty($value["rue"]) ) {
                    // On pourrait tenter de récupérer l'adresse normalisée si elle existe et la repasser en mode libre saisie.
                    $value = implode(' ' , explode("\n", $value["adresse_libre"]) );
                }else{
                    $value = "";
                }

            }else{
                
                // Adresse normailée par les champs name...
                $value = $value["numero"] .' '. $value["rue"] .' '.  $value["complement_batiment"] .' '. $value["complement_lieu"] .' '. $value["postcode"] .' '. $value["city"];

            }

        }
        return (!empty($value)) ? html_entity_decode($value) : "";
    }

    public function getUniqueId()
    {
        return strtoupper(hash("sha256", time() . rand()));
    }

    public function isUTF8($string) { 
        return (utf8_encode(utf8_decode($string)) == $string); 
    }

    public static function getLibelle()
    {
        return "Adresse géolocalisée";
    }

    public static function getCreateButton()
    {
        return (object) [
            'libelle' => OdeAdresse_Geoloc::getLibelle(),
            'icon' => 'fas fa-map-marked-alt',
            'route' => '/champs/?type=adresse_geoloc',
            'attributes' => '',
        ];
    }
}
