<?php

namespace ODE\Generateur\Field;

use ODE\Helper\OdeDateHelper;
use Sugar_Smarty;

class OdeDate extends OdeField
{

    /**
     * @access public
     * @name __construct de la classe OdePourcentage
     * @param bean              $bean: Bean du module OPS_dossier
     * @param boolean           $editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value_bdd)
    {

        // On récupere la valeur à afficher
        $value = $this->getFieldValue($value_bdd);

        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $disabled = ' disabled="disabled" ';

        $smarty = new Sugar_Smarty();

        $smarty->assign("name", $name);
        $smarty->assign("required", $required);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("value", $value);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/input_date_back.tpl");

        return $field_label . $field_html;
    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        global $app_list_strings;
        
        $isDefaut = '';
        // On récupere la valeur à afficher
        if (empty($value_bdd)) {
            $value = $this->getFieldDefautValue($champ["defaut"],$isDefaut);
        } else {
            $value = $this->getFieldValue($value_bdd);
        }

        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
        //  $value = $value_bdd;
        }

        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
        $disabled = ( isset($champ['ineditable']) && $champ['ineditable'] == 1 ) ? ' disabled="disabled" ' : '';

        $smarty = new Sugar_Smarty();
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            $smarty->assign("name", $name);
            $smarty->assign("required", $required);
            $smarty->assign("disabled", $disabled);
            $smarty->assign("value", $value);
            $smarty->assign("conditions", $champ['conditions']);
            $smarty->assign("isDefaut", $isDefaut);

            // Defines a group of custom attributes... #2752 | This method must be used to simplify efficiently the field templates generating.
            $attributes = array(
                'data-context' => "constraint_date",
                'min' => "1900-01-01",
                'max' => "2100-12-31"
            );
            $attrs = array_combine( array_keys($attributes), array_values($attributes) );
            $custom = implode( ' ', array_map( function($v,$k){ return sprintf('%s="%s"', $k, $v); }, $attrs, array_keys($attrs) ) );

            $smarty->assign("autre", $custom );
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/input_date.tpl");
        }else{
            $smarty->assign("name", $name);
            $smarty->assign("required", $required);
            $smarty->assign("disabled", $disabled);
            $smarty->assign("value", $value);
            $smarty->assign("conditions", $champ['conditions']);
            $smarty->assign("isDefaut", $isDefaut);
            
            // Defines a group of custom attributes... #2752 | This method must be used to simplify efficiently the field templates generating.
            $attributes = array(
                'rel' => "datepicker",

                'min' => "1900-01-01",
                'max' => "2100-12-31"
            );
            $attrs = array_combine( array_keys($attributes), array_values($attributes) );
            $custom = implode( ' ', array_map( function($v,$k){ return sprintf('%s="%s"', $k, $v); }, $attrs, array_keys($attrs) ) );

            $smarty->assign("autre", $custom );
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/input_date_back.tpl");
        }

        return $field_label . $field_html;

    }

    public function getFieldValue($value_bdd)
    {
        // On récupère la valeur de la date stockée en base de données
        $value = (!empty($value_bdd)) ? html_entity_decode($value_bdd) : "";
        // Si non vide, on formate la date au format HTML sinon vide
        return (!empty($value)) ? OdeDateHelper::toHTML($value) : "";
    }

    public function getFieldDefautValue($value_defaut,&$isDefaut = null)
    {
        $defautTab = json_decode( base64_decode($value_defaut), true);

        if(!empty($defautTab) && is_array($defautTab) && !empty($defautTab['defaut'])){
            if($defautTab['defaut'] == 'autre'){
                $value_defaut = html_entity_decode($defautTab['defaut_value']); 
                $value = (!empty($value_defaut)) ? date('Y-m-d', strtotime(html_entity_decode($value_defaut)))  : "";
            }
            elseif($defautTab['defaut'] == 'url'){
                $value_defaut = '';
                $isDefaut = 'data-defaut="url" data-url-attr="'.$defautTab['defaut_value'].'"';
            }
            else{
                $value_defaut =  html_entity_decode($this->getDefautValue($defautTab));
                if(!empty($defautTab['defaut']) && isset($isDefaut)){
                    $isDefaut = 'data-defaut="defaut"';
                }
                if(!empty($value_defaut)){
                    $date = \DateTime::createFromFormat('d/m/Y', $value_defaut);
                    $value = $date->format('Y-m-d');
                }else{
                    $value = '';
                }
            }
        }else if(!isset($defautTab['defaut'])){
            $value = (!empty($value_defaut)) ? date('Y-m-d', strtotime(html_entity_decode($value_defaut)))  : "";
        }
        return (!empty($value)) ? OdeDateHelper::toHTML($value) : "";
    }

    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {
        // On récupère la valeur de la date stockée en base de données
        $value_display = (!empty($value)) ? html_entity_decode($value) : "";
        // Si non vide, on formate la date au format HTML sinon vide
        return (!empty($value_display)) ? OdeDateHelper::toHTML($value_display) : "";
    }

    public static function getLibelle()
    {
        return "Date";
    }

    public static function getCreateButton()
    {
        return (object) [
            'libelle' => OdeDate::getLibelle(),
            'icon' => 'far fa-calendar-alt',
            'route' => '/champs/?type=date',
            'attributes' => '',
        ];
    }
}
