<?php

namespace ODE\Generateur\Field;

use ODE\Model\DossierModel;
use Sugar_Smarty;
use BeanFactory;

class OdeField
{
    var $bean;
    var $editable;
    var $donnees;
    var $DossierModel;

    /**
     * @access public
     * @name __construct de la classe OdeField
     * @param bean              $bean: Bean du module OPS_dossier
     * @param boolean           $editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    function __construct($editable = false, $bean = null, $donnees = [])
    {
        $this->bean = $bean;
        $this->editable = $editable;
        $this->donnees = $donnees;
        $this->DossierModel = ($bean !== null) ? new DossierModel($this->bean->id) : false;
    }

    /**
     * @access public
     * @name getHtml()
     * Fonction qui renvoie le code HTML à afficher 
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getHtml($champ, $value)
    {
        return ($this->editable === false) ? $this->getIneditableField($champ, $value) : $this->getEditableField($champ, $value);
    }

    /**
     * @access public
     * @name getHtml()
     * Fonction qui renvoie le code HTML à afficher 
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value)
    {
        return "";
    }

    /**
     * @access public
     * @name getHtml()
     * Fonction qui renvoie le code HTML à afficher 
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value)
    {
        return "";
    }

    /**
     * @access private
     * @name getErreurField()
     *
     *  @param string           $message: Le message d'erreur
     *  @return string          $html: champ de type input avec le message d'erreur
     */
    public function getErreurField($message = "")
    {
        $html = '<input type="text" value="' . $message . '" style="display: block;color: #f08377;background: #f8f8f8 !important;border: 1px solid red;" class="ode_input_hidden col-md-8">';
        return $html;
    }
 
    /**
     * @access private
     * @name getErreurField()
     *
     *  @param string           $message: Le message d'erreur
     *  @return string          $html: champ de type input avec le message d'erreur
     */
    public function getLabelField($name = "", $libelle = "", $aide = "", $obligatoire = 0, $multi = '')
    {
        $regex = '/^([A-Za-z0-9+\/]{4})*([A-Za-z0-9+\/]{3}=|[A-Za-z0-9+\/]{2}==)?$/';
        if( !empty($aide) && preg_match($regex,$aide)){
            $aide = base64_decode($aide);
        }
        $required = ( $obligatoire == "1" ) ? ' data-required="true" ' : '';
        $smarty = new Sugar_Smarty();
        $smarty->assign("required", $required);
        $smarty->assign("aide", $aide);
        $smarty->assign("label", $libelle);
        $smarty->assign("multi", $multi);
        return $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/label.tpl");
    }

    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui renvoie le code HTML à afficher 
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getPdfValue($champ, $value)
    {
        return "";
    }

    public static function getLibelle()
    {
        return "undefined";
    }

    public static function getCreateButton()
    {
        return false;
    }

    public function getBDDValue($value)
    {
        return false;
    }

    public function getDefautValue($value, $type = ''){        
        $defautValue = '';
        if($value['defaut'] == 'demandeur'){
            $individuObj = BeanFactory::getBean('OPS_individu',$this->donnees['demandeur']['id']);
            $defautValue = $individuObj->{$value['defaut_value']};
            if($type == 'text' && isset($individuObj->field_defs[$value['defaut_value']]) && $individuObj->field_defs[$value['defaut_value']]['type'] == 'enum')
            {
                global $app_list_strings;

                $defautValue = $app_list_strings[ $individuObj->field_defs[$value['defaut_value']]['options']][$individuObj->{$value['defaut_value']}];
            }
        }
        else if($value['defaut'] == 'beneficiaire' && !empty($this->donnees['beneficiaire_id'])){
            $individuObj = BeanFactory::getBean('OPS_individu',$this->donnees['beneficiaire_id']);
            $defautValue = $individuObj->{$value['defaut_value']};
            if($type == 'text' && isset($individuObj->field_defs[$value['defaut_value']]) && $individuObj->field_defs[$value['defaut_value']]['type'] == 'enum')
            {
                global $app_list_strings;

                $defautValue = $app_list_strings[ $individuObj->field_defs[$value['defaut_value']]['options']][$individuObj->{$value['defaut_value']}];
            }
        }
        else if($value['defaut'] == 'profil' && (!empty($this->donnees['personne_morale']) || !empty($this->donnees['ops_personne_morale']))){
            $personneMoraleId = $this->donnees['personne_morale'];
            
            global $app_list_strings;

            if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
                $personneMoraleId = $this->donnees['ops_personne_morale'];
            }
            $profilObj = BeanFactory::getBean('OPS_personne_morale',$personneMoraleId);

            $defautValue = $profilObj->{$value['defaut_value']};
            if($type == 'text' && isset($profilObj->field_defs[$value['defaut_value']]) && $profilObj->field_defs[$value['defaut_value']]['type'] == 'enum')
            {
                global $app_list_strings;

                $defautValue = $app_list_strings[ $profilObj->field_defs[$value['defaut_value']]['options']][$profilObj->{$value['defaut_value']}];
            }
        }
        return $defautValue;
    }
}
