<?php

namespace ODE\Helper\ReplaceVariable;

use ODE\Helper\ReplaceVariable;

if (!defined('sugarEntry')) define('sugarEntry', true);

class DocumentsReplaceVariable
{
    private $bean;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($bean)
    {
        $this->bean = $bean;
    }

    /**
     * Fonction qui remplace les variables du text avec le module Users comme source
     *
     * @param object $bean : Bean SuiteCRM
     * @param string $text : Le texte ou il faut remplacer les variables
     * 
     * @return string
     */
    public function remplaceChamps($text = '')
    {
        if (empty($this->bean->object_name) || $this->bean->object_name !== 'Document') return $text;
        # boucle de remplacement des champs de l'individu dans le mail
        $fields = ReplaceVariable::getBeanFields($this->bean);

        foreach ($fields as $field_name) {

            switch (true) {
                case preg_match("#^date_\w*#", $field_name):
                    $field_value = ReplaceVariable::formatDate($this->bean->$field_name);
                    $text = str_replace('$documents_' . $field_name, $field_value, $text);
                    break;
            }
            $text = str_replace('$documents_' . $field_name, $this->bean->$field_name, $text);
        }
        
        return $text;
    }
}