<?php

namespace ODE\Helper\ReplaceVariable;

use ODE\Helper\ReplaceVariable;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class OPS_personne_moraleReplaceVariable
{
    private $bean;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($bean)
    {
        $this->bean = $bean;
    }

    /**
     * Fonction qui remplace les variables du text avec le module OPS_personne_morale comme source
     *
     * @param object $bean : Bean SuiteCRM
     * @param string $text : Le texte ou il faut remplacer les variables
     * 
     * @return string
     */
    public function remplaceChamps($text = '',$document_id = '')
    {
        if (empty($this->bean->object_name) || $this->bean->object_name !== 'OPS_personne_morale') return $text;

        # boucle de remplacement des champs du profil dans le mail
        $fields = ReplaceVariable::getBeanFields($this->bean);

        foreach ($fields as $field_name) {
            $fieldDef  = $this->bean->getFieldDefinition($field_name);
            switch (true) {
                case preg_match("#^date_\w*#", $field_name):
                    $field_value = ReplaceVariable::formatDate($this->bean->$field_name);
                    break;
                case $fieldDef['type'] == 'enum':
                    $field_value = ReplaceVariable::getValueFromListe($fieldDef['options'],$this->bean->$field_name);
                    break;
                case $fieldDef['type'] == 'bool':
                    if(!empty($this->bean->$field_name)){
                        $field_value = 'Oui';
                    }else{
                        $field_value = 'Non';
                    }
                    break;
                default:
                    $field_value = $this->bean->$field_name;
                    break;
            }
            $text = str_replace('$ops_personne_morale_' . $field_name, $field_value, $text);
        }

        $this->bean->load_relationship('ops_type_personne_ops_personne_morale');
        $typeTier = $this->bean->ops_type_personne_ops_personne_morale->get();

        if(!empty($typeTier)){
            $objTypeTier = BeanFactory::getBean('OPS_type_personne',$typeTier[0]);
            if(!empty($objTypeTier->id)){
                $text = str_replace('$ops_personne_morale_type_tier', $objTypeTier->name, $text);
            }
        }

        # Remplacement des champs individu ayant un role
        if(stripos($text, '$personne_individu_fonction') !== false || stripos($text, '$dossier_personne_individu_fonction') !== false){
            $pattern = '/\[fonction:(.*?)\]/';
            if(preg_match_all($pattern, $text, $match)){
                if(!empty($match[1])){
                    $fonctions = array_unique($match[1]);
                    foreach ($fonctions as $fonction){
                        $where = "role = '".$fonction."'";
                        $personneMoraleIndividu = $this->bean->get_linked_beans('ops_personne_morale_ops_personne_morale_individu','OPS_personne_morale_individu ','',0,-1, 0,$where);
                        $individu = BeanFactory::getBean('OPS_individu', $personneMoraleIndividu[0]->ops_individu_id);
                        if (!empty($individu->id)) {
                            $individu_replace_variable = new OPS_individuReplaceVariable($individu);
                            $text = $individu_replace_variable->remplaceChamps($text,$fonction);
                        }
                    }
                }
            }
            $regex = '/(\$personne_individu_fonction|\$dossier_personne_individu_fonction)[^[]*\[fonction:([^]]+)\]/';
            $text = preg_replace($regex, '', $text);
        }

        # Remplacement des champs document
        if(!empty($document_id)){
            $document = BeanFactory::getBean('Documents',$document_id);
            if(!empty($document->id)){
                $document_replace_variable = new DocumentsReplaceVariable($document);
                $text = $document_replace_variable->remplaceChamps($text);
            }
        }

        return $text;
    }
}