<?php

namespace ODE\Mailer;

use SugarPHPMailer;
use DBManagerFactory;
use Email;
use Note;
use ODE\Mailer\OdeEmail;

/**
 * Class OdeMailer
 *
 * @package Ode\Mailer
 */
class OdeMailer
{

    /**
     * Fonction pour envoyer un mail 
     * @param OdeEmail     $email  
     * @return boolean
     */
    public function send(OdeEmail $email)
    {
    
        // On vérifie qu'on a bien une instance de OdeEmail
        if (!$email instanceof OdeEmail) return false;

        // On vérifie que l'object $email est initialisé
        if ($email->statut === false) {
            $GLOBALS['log']->fatal("OdeMailer::send => L'email ne peut etre envoyer, vérifier les données d'initialisation " . print_r($email, true));
            return false;
        }

        // On récupére les parametres par défaut d'envoie
        $defaults = $this->getSystemDefault();
        if ($defaults === false) {
            $GLOBALS['log']->fatal("OdeMailer::send => Erreur de récupération des parametres par defaut l'email ne sera pas envoyer" . print_r($email, true));
            return false;
        }

        // On initialise la classe SugarPHPMailer extend de PHPMailer
        $mailer = new SugarPHPMailer();
        $mailer->setMailerForSystem();
        $mailer->From     = $defaults->email;
        $mailer->FromName = $defaults->name;
        $mailer->Subject  = $email->subject;
        $mailer->IsHTML(true);
        $mailer->Body    = $email->body_html;
        $mailer->AltBody = $email->body;

        // On ajoute les pieces jointes 
        foreach ($email->attachments as $attachment) {
            $mailer->AddAttachment($attachment->file_path,$attachment->file_name);
        }

        // On prépare le mail avant l'envoie : formatage des variables
        $mailer->prepForOutbound();

        // On ajoute les destinataires
        foreach ($email->dest_to as $adresse_to) { $mailer->AddAddress($adresse_to); }
        foreach ($email->dest_cc as $adresse_cc) { $mailer->AddCC($adresse_cc); }
        foreach ($email->dest_cci as $adresse_cci) { $mailer->AddBCC($adresse_cci); }

        // On envoie le mail
        $email_sended = @$mailer->Send();
        if (!$email_sended) {
            $GLOBALS['log']->fatal("OdeMailer::send => Erreur lors de l'envoie du l'email " . print_r($email, true));
            return false;
        }
 
        // Si l'historisation est activé
        if ($email->log) {
            $this->createEmailLog($mailer, $email);
            return true;
        }
    }

    /**
     * Fonction qui retourne les valeurs par défaut, parametré dans l'admin
     * 
     * @return object|bool
     */
    protected function getSystemDefault()
    {
        $emailObj = new Email();
        $defaults = $emailObj->getSystemDefaultEmail();
        return !empty($defaults['email']) && !empty($defaults['email']) ? (object) $defaults : false;
    }

    /**
     * Fonction qui retourne les valeurs par défaut, parametré dans l'admin
     * @param SugarPHPMailer    $mailer  
     * @param OdeEmail          $email  
     * 
     * @return void
     */
    protected function createEmailLog(SugarPHPMailer $mailer, OdeEmail $email)
    {
        global $timedate;

        $obj_email                   = new Email();
        $obj_email->team_id          = 1;
        $obj_email->type             = 'archived';
        $obj_email->name             = $mailer->Subject;
        $obj_email->description      = $mailer->AltBody;
        $obj_email->description_html = $mailer->Body;
        $obj_email->from_addr        = $mailer->From;
        $obj_email->to_addrs         = implode(",", $email->dest_to);
        $obj_email->parent_type      = $email->bean_historisation_name;
        $obj_email->parent_id        = $email->bean_historisation_id;
        $obj_email->date_sent        = $timedate->now();
        $obj_email->status           = 'sent';
        $email_id                    = $obj_email->save();

        // On ajoute les pieces jointes envoyé dans le mail
        foreach ($email->attachments as $attachment) {
            $obj_note                   = new Note();
            $obj_note->type             = 'archived';
            $obj_note->filename         = $attachment->file_name;
            $obj_note->name             = $attachment->file_name;
            $obj_note->file_mime_type   = "application/pdf";
            // $obj_note->assigned_user_id = $bean->assigned_user_id;
            $obj_note->parent_id        =  $email_id;
            $obj_note->parent_type      = "Emails";
            $obj_note->save();
        }
        
    }

    /**
     * Fonction qui retourne les emails historisés à partir de l'id et le type d'un module
     * @param string     $parent_id  
     * @param string     $parent_type  
     * 
     * @return array
     */
    public static function getEmailsByParent($parent_id = '', $parent_type = '')
    {
        if ( empty($parent_id) || empty($parent_type) ) return [];
        $emails = [];
        $db = DBManagerFactory::getInstance();
        $sql = "SELECT * FROM `emails` WHERE `parent_id` = '" . $parent_id . "' AND `parent_type` = '" . $parent_type . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($email = $db->fetchByAssoc($result)) {
            $emails[] = (object) $email;
        }
        return $emails;
    }

    /**
     * Fonction qui retourne le dernier email envoyé à l'utilisateur
     * @param string     $parent_id  
     * @param string     $parent_type  
     * 
     * @return object|bool
     */
    public static function getLastEmailByParent($parent_id = '', $parent_type = '')
    {
        // On récupere l'historique des logs mails rattachés à l'objet 
        $emails = OdeMailer::getEmailsByParent($parent_id, $parent_type);
        if (!is_array($emails) || count($emails) === 0) return false;

        // On trie le tableau
        usort($emails, function($email_1, $email_2) {
            return strtotime($email_1->date_entered) - strtotime($email_2->date_entered);
        });

        return end($emails); 
    }
}
