<?php

namespace ODE\Model;

use ODE\Model\DossierModel;


if (!defined('sugarEntry')) define('sugarEntry', true);

class IndividuModel
{

    private $time_start;
    private $time_end;
    private $id;

    /**
     * Constructeur de la classe IndividuModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($id)
    {

        $this->time_start = microtime(true);
        $this->time_end = microtime(true);
        $this->id = $id;
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données du individu en tableau
     *
     *  @return array               - $individu: individu
     */
    public function getBean()
    {

        global $db;
        $individus = array();

        $sql = "SELECT * FROM `ops_individu` WHERE `id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $individus[] = $row;
        }
        return (!empty($individus) && count($individus) === 1) ? $individus[0] : array();
    }

    /**
     * @access public
     * @name getName()
     * Fonction qui retourne le nom de la commission
     *
     *  @return array               - $commission_name: le nom de la commission
     */
    public function getName()
    {
        $individu = $this->getBean();
        return (is_array($individu) && count($individu) > 0 && !empty($individu["first_name"]) && !empty($individu["last_name"])) ? $individu['salutation'] . " " . $individu['first_name'] . " " . $individu['last_name'] : "";
    }

}
