<?php

namespace ODE\Model;

use ODE\Helper\OdeDateHelper;
use ODE\Helper\OdeStringHelper;

if (!defined('sugarEntry')) define('sugarEntry', true);

class ReunionModel
{

    private $time_start;
    private $time_end;
    private $id;

    /**
     * Constructeur de la classe ReunionModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($id)
    {
        $this->time_start = microtime(true);
        $this->time_end = microtime(true);
        $this->id = $id;
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données du reunion en tableau
     *
     *  @return array               - $reunion: reunion
     */
    public function getBean()
    {

        global $db;
        $reunions = array();

        $sql = "SELECT * FROM `ops_reunion` WHERE `id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $reunions[] = $row;
        }
        return (!empty($reunions) && count($reunions) === 1) ? $reunions[0] : array();
    }

    /**
     * @access public
     * @name getName()
     * Fonction qui retourne le nom de la reunion
     *
     *  @return array               - $reunion_name: le nom de la reunion
     */
    public function getName()
    {
        $reunion = $this->getBean();
        return (is_array($reunion) && count($reunion) > 0 && !empty($reunion["name"])) ? $reunion["name"] : "";
    }

    /**
     * @access public
     * @name addRelationDossier()
     * Fonction qui retourne les données du reunion en tableau
     *
     *  @return array               - $reunion: reunion
     */
    public static function addRelationDossier($dossier_id, $reunion_id)
    {
        global $db;
        if (!empty($dossier_id) && !empty($reunion_id)) {
            $date_modified = OdeDateHelper::getDateTimeNow();
            $relation_id = OdeStringHelper::getUuid();
            $sql = "INSERT INTO `ops_reunion_ops_dossier` (`id`, `date_modified`, `deleted`, `ops_reunion_id`, `ops_dossier_id`)";
            $sql .= "VALUES ('" . $relation_id . "', '" . $date_modified . "', '0', '" . $reunion_id . "', '" . $dossier_id . "')";
            $db->query($sql);
        }
    }

    /**
     * @access public
     * @name addRelationDossier()
     * Fonction qui retourne les données du reunion en tableau
     *
     *  @return array               - $reunion: reunion
     */
    public static function deleteRelations($dossier_id)
    {
        global $db;
        if (!empty($dossier_id)) {
            $date_modified = OdeDateHelper::getDateTimeNow();
            $sql = "UPDATE `ops_reunion_ops_dossier` SET `deleted`='1',`date_modified`= '" . $date_modified . "' WHERE `ops_dossier_id`='" . $dossier_id . "'";
            $db->query($sql);
        }
    }
}
